/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WmiFormatMathSpaceCommand
extends WmiFormatMathModelAttributeCommand {
    private static final WmiDimensionUnit ZERO_UNIT = WmiDimensionUnit.createDimension("0.0em", null);

    public WmiFormatMathSpaceCommand() {
        super("format.mspace.dimension", WmiMathSpaceModel.class);
    }

    public WmiAttributeSet modifyAttribute(WmiAttributeSet wmiAttributeSet) {
        WmiDimensionUnit wmiDimensionUnit = (WmiDimensionUnit)wmiAttributeSet.getAttribute("width");
        WmiDimensionUnit wmiDimensionUnit2 = (WmiDimensionUnit)wmiAttributeSet.getAttribute("height");
        WmiDimensionUnit wmiDimensionUnit3 = (WmiDimensionUnit)wmiAttributeSet.getAttribute("depth");
        WmiSpaceDialog wmiSpaceDialog = new WmiSpaceDialog(null, wmiDimensionUnit, wmiDimensionUnit2, wmiDimensionUnit3);
        wmiSpaceDialog.show();
        if (wmiSpaceDialog.wasChangeApproved()) {
            wmiDimensionUnit = wmiSpaceDialog.getWidthAttr();
            wmiDimensionUnit2 = wmiSpaceDialog.getHeightAttr();
            wmiDimensionUnit3 = wmiSpaceDialog.getDepthAttr();
            wmiAttributeSet.addAttribute("width", wmiDimensionUnit);
            wmiAttributeSet.addAttribute("height", wmiDimensionUnit2);
            wmiAttributeSet.addAttribute("depth", wmiDimensionUnit3);
        }
        return wmiAttributeSet;
    }

    public class WmiSpaceDialog
    extends WmiFormatMathCommand.WmiFormatDialog {
        private static final String TITLE_KEY = "format.space.title";
        private static final String SPACE_WIDTH_LABEL = "format.space.width.label";
        private static final String SPACE_HEIGHT_LABEL = "format.space.height.label";
        private static final String SPACE_DEPTH_LABEL = "format.space.depth.label";
        private static final String UNIT_NAMES = "format.space.unit.names";
        private WmiDimensionUnit widthattr;
        private WmiDimensionUnit heightattr;
        private WmiDimensionUnit depthattr;
        private JTextField tfWidthValue;
        private JTextField tfHeightValue;
        private JTextField tfDepthValue;
        private WmiComboBox cbWidthUnit;
        private WmiComboBox cbHeightUnit;
        private WmiComboBox cbDepthUnit;
        private String[] unitSuggestions;

        public WmiSpaceDialog(JFrame jFrame, WmiDimensionUnit wmiDimensionUnit, WmiDimensionUnit wmiDimensionUnit2, WmiDimensionUnit wmiDimensionUnit3) {
            super(jFrame);
            this.widthattr = wmiDimensionUnit;
            this.heightattr = wmiDimensionUnit2;
            this.depthattr = wmiDimensionUnit3;
            this.setTitle(TITLE_KEY, null);
            this.layoutDialog();
        }

        public void addComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.unitSuggestions = this.mapItemList(UNIT_NAMES, null);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_WIDTH_LABEL)), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.tfWidthValue = this.createUnitTextField(this.widthattr);
            this.getContentPane().add((Component)this.tfWidthValue, gridBagConstraints);
            this.cbWidthUnit = this.createUnitComboBox(this.unitSuggestions, this.widthattr);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)this.cbWidthUnit, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_HEIGHT_LABEL)), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.tfHeightValue = this.createUnitTextField(this.heightattr);
            this.getContentPane().add((Component)this.tfHeightValue, gridBagConstraints);
            this.cbHeightUnit = this.createUnitComboBox(this.unitSuggestions, this.heightattr);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            this.getContentPane().add((Component)this.cbHeightUnit, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_DEPTH_LABEL)), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            this.tfDepthValue = this.createUnitTextField(this.depthattr);
            this.getContentPane().add((Component)this.tfDepthValue, gridBagConstraints);
            this.cbDepthUnit = this.createUnitComboBox(this.unitSuggestions, this.depthattr);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            this.getContentPane().add((Component)this.cbDepthUnit, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 3;
            this.getContentPane().add((Component)this.createDefaultButtonsPanel(), gridBagConstraints);
        }

        private JTextField createUnitTextField(WmiDimensionUnit wmiDimensionUnit) {
            JTextField jTextField = new JTextField(10);
            if (wmiDimensionUnit != null) {
                String string = Float.toString(wmiDimensionUnit.getUnitsValue());
                jTextField.setText(string);
            }
            return jTextField;
        }

        private WmiComboBox createUnitComboBox(String[] stringArray, WmiDimensionUnit wmiDimensionUnit) {
            WmiComboBox wmiComboBox = this.createFormatComboBox(stringArray);
            if (wmiDimensionUnit != null) {
                wmiComboBox.setSelectedItem(wmiDimensionUnit.getUnit());
            }
            return wmiComboBox;
        }

        public WmiDimensionUnit getWidthAttr() {
            return this.produceValue(this.tfWidthValue, this.cbWidthUnit);
        }

        public WmiDimensionUnit getHeightAttr() {
            return this.produceValue(this.tfHeightValue, this.cbHeightUnit);
        }

        public WmiDimensionUnit getDepthAttr() {
            return this.produceValue(this.tfDepthValue, this.cbDepthUnit);
        }

        private WmiDimensionUnit produceValue(JTextField jTextField, WmiComboBox wmiComboBox) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (jTextField.getText() != null && jTextField.getText().length() > 0) {
                object = jTextField.getText();
                stringBuffer.append((String)object);
            }
            if (wmiComboBox.getSelectedItem() != null) {
                object = wmiComboBox.getSelectedItem();
                String string = object instanceof String ? (String)object : "";
                stringBuffer.append(string);
            }
            return WmiDimensionUnit.createDimension(stringBuffer.toString(), ZERO_UNIT);
        }
    }
}

