/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.WmiSimpleMathInsertCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.util.WmiMathEntityNameMapper;

public class WmiInsertEntityCommand
extends WmiSimpleMathInsertCommand {
    public static final WmiInsertEntityCommand DEFAULT_ENTITY_INSERTER = new WmiInsertEntityCommand("Insert.Entity");

    public WmiInsertEntityCommand(String string) {
        super(string);
    }

    protected String getInsertedText() {
        return "";
    }

    public WmiMathModel createInsertedModel(String string, WmiModel wmiModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiModelTag wmiModelTag = WmiModelTag.MATH_IDENTIFIER;
        if (WmiMathOperatorDictionary.isNameForOperator(string)) {
            wmiModelTag = WmiModelTag.MATH_OPERATOR;
        } else if (string != null && string.length() > 1 && string.charAt(0) == '&' && string.charAt(string.length() - 1) == ';') {
            char c = '\u0000';
            if (string.charAt(1) == '#') {
                try {
                    String string2 = string.substring(2, string.length() - 1);
                    c = (char)Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                c = WmiMathEntityNameMapper.getUnicodeCharacter(string.substring(1, string.length() - 1));
            }
            if (c != '\u0000' && MathTokenizer.isOperator(c)) {
                wmiModelTag = WmiModelTag.MATH_OPERATOR;
                string = Character.toString(c);
            }
        }
        return WmiMathFactory.createMathToken(wmiMathDocumentModel, wmiModelTag, string, wmiMathContext);
    }
}

