/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.client.BlockingEvaluation;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.Color;

public class WmiInsertMatrixCommand
extends WmiInsertMathMLCommand {
    public static final WmiInsertMatrixCommand DEFAULT_MATRIX_INSERTER = new WmiInsertMatrixCommand("Insert.Matrix");
    private String command = null;
    private int kernelId = -1;
    private KernelListener parentListener = null;
    private boolean updateSelection = false;
    private boolean treatOnesAsPlaceholders = false;

    public WmiInsertMatrixCommand(String string) {
        super(string);
    }

    protected String getInsertedText() {
        return "";
    }

    public WmiMathModel createInsertedModel(String string, WmiModel wmiModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        if (this.kernelId == -1) {
            throw new IllegalStateException("Invalid kernel id. Specify a kernel id to use via the insert( WmiMathDocumentView, String, int, KernelListener ) method.");
        }
        WmiMathModel wmiMathModel = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiMatrixPaletteEvaluator wmiMatrixPaletteEvaluator = new WmiMatrixPaletteEvaluator();
        wmiMatrixPaletteEvaluator.process();
        Object object = wmiMatrixPaletteEvaluator.getResult();
        if (object instanceof Dag) {
            Dag dag = (Dag)object;
            try {
                dag = DagBuilder.normalize(dag);
                Dag dag2 = DagUtil.getSemanticDataFromPrintslash(dag);
                wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
                this.modifyPlaceHolders(wmiMathModel);
                if (wmiMathModel != null) {
                    WmiMathModel wmiMathModel2 = (WmiMathModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)wmiMathModel, WmiModelTag.MATH_ACTION);
                    if (wmiMathModel2 == null) {
                        wmiMathModel2 = wmiMathModel;
                    }
                    EnteredMatrixSemantics enteredMatrixSemantics = new EnteredMatrixSemantics(dag2);
                    wmiMathModel2.setSemantics(enteredMatrixSemantics);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
        return wmiMathModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(WmiMathDocumentView wmiMathDocumentView, String string, boolean bl, int n, KernelListener kernelListener) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl2 = false;
        WmiModel wmiModel = wmiMathDocumentView.getModel();
        if (WmiModelLock.ownsWriteLock(wmiModel)) {
            this.command = string;
            this.kernelId = n;
            this.parentListener = kernelListener;
            try {
                this.treatOnesAsPlaceholders = bl;
                bl2 = super.doInsertionCommand(wmiMathDocumentView, string);
            }
            finally {
                this.command = null;
                this.kernelId = -1;
                this.parentListener = null;
                this.treatOnesAsPlaceholders = false;
            }
        } else {
            throw new WmiNoWriteAccessException(wmiModel);
        }
        this.updateSelection = false;
        return bl2;
    }

    private void processMatch(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = this.isPlaceholder(wmiModel);
        if (bl) {
            Color color = Color.decode(WmiMathAttributeSet.getColour("ph_purple"));
            wmiModel.addAttribute("placeholder", "true");
            if (wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                WmiModel wmiModel2 = wmiCompositeModel.getChild(0);
                wmiModel2.addAttribute("foreground", color);
                if (wmiCompositeModel.getChild(1) instanceof WmiInlineMathModel) {
                    WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiCompositeModel.getChild(1);
                    for (int i = 0; i < wmiInlineMathModel.getChildCount(); ++i) {
                        WmiModel wmiModel3 = wmiInlineMathModel.getChild(i);
                        wmiModel3.addAttribute("foreground", color);
                    }
                }
            } else {
                wmiModel.addAttribute("foreground", color);
            }
        }
    }

    private boolean isPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.treatOnesAsPlaceholders) {
            if (wmiModel instanceof WmiNumericModel) {
                bl = ((WmiNumericModel)wmiModel).getText().equals("1");
            }
        } else if (wmiModel instanceof WmiSubscriptModel) {
            WmiIdentifierModel wmiIdentifierModel;
            WmiSubscriptModel wmiSubscriptModel = (WmiSubscriptModel)wmiModel;
            if (wmiSubscriptModel.getChild(0) instanceof WmiIdentifierModel && (wmiIdentifierModel = (WmiIdentifierModel)wmiSubscriptModel.getChild(0)).getText().equals("m")) {
                bl = wmiSubscriptModel.getChild(1) instanceof WmiInlineMathModel;
            }
        } else if (wmiModel instanceof WmiInlineMathModel) {
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiModel;
            for (int i = 0; i < wmiInlineMathModel.getChildCount() && !bl; ++i) {
                WmiModel wmiModel2 = wmiInlineMathModel.getChild(i);
                WmiAttributeSet wmiAttributeSet = wmiModel2.getAttributesForRead();
                Object object = wmiAttributeSet.getAttribute("placeholder");
                if (object == null) continue;
                bl |= object.equals("true");
            }
        }
        return bl;
    }

    private void modifyPlaceHolders(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                this.modifyPlaceHolders(wmiCompositeModel.getChild(i));
            }
        }
        this.processMatch(wmiModel);
    }

    public static class EnteredMatrixSemantics
    extends WmiAssignedSemantics {
        public EnteredMatrixSemantics(Dag dag) {
            super(EnteredMatrixSemantics.configureDag(dag));
        }

        private static Dag configureDag(Dag dag) {
            Dag dag2 = DagUtil.getDisplayDataFromPrintslash(dag);
            return dag2;
        }
    }

    private class WmiMatrixPaletteEvaluator
    extends BlockingEvaluation {
        public WmiMatrixPaletteEvaluator() {
            super(WmiInsertMatrixCommand.this.kernelId, WmiInsertMatrixCommand.this.parentListener);
        }

        protected String getCommand() {
            return WmiInsertMatrixCommand.this.command;
        }

        protected void update() {
        }
    }
}

