/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class WmiMetadataManager {
    public static final int VISIBILITY_OFF = 0;
    public static final int VISIBILITY_ROLLOVER = 1;
    public static final int VISIBILITY_ON = 2;
    public static final String DOC_ATTRIBUTE_TAG = "0";
    private WmiMathDocumentModel myModel = null;
    private HashMap categoryMap = new HashMap();
    protected HashMap tagMap = new HashMap();
    private long nextTagId = 1L;
    private boolean defaultCategorySetModified;
    private int decoratorVisibility = 0;
    private boolean popupVisibility = false;

    public WmiMetadataManager(WmiMathDocumentModel wmiMathDocumentModel) {
        this.myModel = wmiMathDocumentModel;
        this.createCategory("<default>");
        this.defaultCategorySetModified = false;
    }

    public void clearAllTables() {
        this.categoryMap.clear();
        this.tagMap.clear();
        this.nextTagId = 1L;
        this.defaultCategorySetModified = false;
    }

    public synchronized String getNextTagId() {
        String string;
        while (this.tagMap.containsKey(string = Long.toString(++this.nextTagId))) {
        }
        return string;
    }

    public synchronized void resetNextTagId() {
        this.nextTagId = 1L;
    }

    public WmiMetatag createMetatag(String string, String string2, String string3) {
        String string4;
        WmiMetatag wmiMetatag = null;
        String string5 = string4 = string == null ? this.getNextTagId() : string;
        if (!this.tagMap.containsKey(string4)) {
            wmiMetatag = new WmiMetatag(string4, string2, string3);
            this.tagMap.put(string4, wmiMetatag);
            try {
                this.nextTagId = Math.max((long)Integer.parseInt(string4), this.nextTagId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return wmiMetatag;
    }

    public WmiMetatag createMetatag(String string, String string2) {
        return this.createMetatag(null, string, string2);
    }

    public WmiMetatag createMetatag() {
        return this.createMetatag(null, "<default>", "<default>");
    }

    public WmiMetatag duplicateMetatag(String string) {
        WmiMetatag wmiMetatag = null;
        WmiMetatag wmiMetatag2 = this.findMetatag(string);
        if (wmiMetatag2 != null) {
            wmiMetatag = this.duplicateMetatag(wmiMetatag2);
        }
        return wmiMetatag;
    }

    public WmiMetatag duplicateMetatag(WmiMetatag wmiMetatag) {
        WmiMetatag wmiMetatag2 = null;
        if (wmiMetatag != null) {
            wmiMetatag2 = wmiMetatag.copyTag();
            wmiMetatag2.setId(this.getNextTagId());
            this.tagMap.put(wmiMetatag2.getId(), wmiMetatag2);
        }
        return wmiMetatag2;
    }

    public WmiMetatag findMetatag(String string) {
        WmiMetatag wmiMetatag = null;
        if (string != null) {
            wmiMetatag = (WmiMetatag)this.tagMap.get(string);
        }
        return wmiMetatag;
    }

    public void deleteMetatag(WmiMetatag wmiMetatag) {
        if (this.tagMap.containsKey(wmiMetatag.getId())) {
            this.tagMap.remove(wmiMetatag.getId());
        }
    }

    public void deleteAllMetatags() {
        this.tagMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeUnusedTags() {
        Object object;
        Object object2;
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        boolean bl = WmiModelLock.readLock(this.myModel, true);
        if (bl) {
            try {
                WmiModelUtil.collectModels((WmiModel)this.myModel, WmiModelTag.METATAG_WRAPPER, vector);
                if (vector.size() > 0) {
                    object2 = vector.iterator();
                    while (object2.hasNext()) {
                        object = (WmiMetatagWrapperModel)object2.next();
                        vector2.add(((WmiMetatagWrapperModel)object).getMetatagId());
                    }
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this.myModel);
            }
        }
        if (vector2.size() > 0) {
            Object object3;
            object2 = this.tagMap.keySet();
            object = object2.iterator();
            Vector<Object> vector3 = new Vector<Object>();
            while (object.hasNext()) {
                object3 = (String)object.next();
                if (DOC_ATTRIBUTE_TAG.equals(object3) || vector2.contains(object3)) continue;
                vector3.add(object3);
            }
            if (vector3.size() > 0) {
                object3 = vector3.iterator();
                while (object3.hasNext()) {
                    this.deleteMetatag(this.findMetatag(object3.next().toString()));
                }
            }
        } else if (!this.tagMap.containsKey(DOC_ATTRIBUTE_TAG)) {
            this.tagMap.clear();
        }
    }

    public WmiMetatagCategory createCategory(String string) {
        WmiMetatagCategory wmiMetatagCategory = null;
        if (!this.categoryMap.containsKey(string)) {
            wmiMetatagCategory = new WmiMetatagCategory(string);
            this.categoryMap.put(string, wmiMetatagCategory);
        }
        this.defaultCategorySetModified = true;
        return wmiMetatagCategory;
    }

    public boolean addMetatagCategory(WmiMetatagCategory wmiMetatagCategory) {
        boolean bl = false;
        if (!this.categoryMap.containsKey(wmiMetatagCategory.getName())) {
            this.categoryMap.put(wmiMetatagCategory.getName(), wmiMetatagCategory);
            bl = true;
        }
        this.defaultCategorySetModified = true;
        return bl;
    }

    public WmiMetatagCategory findCategory(String string) {
        return (WmiMetatagCategory)this.categoryMap.get(string);
    }

    public Set getCategoryList() {
        return new TreeSet(this.categoryMap.keySet());
    }

    public void replaceCategoryList(HashMap hashMap) {
        this.categoryMap = hashMap;
        this.defaultCategorySetModified = true;
    }

    public HashMap getCategoryListCopy() {
        HashMap<String, WmiMetatagCategory> hashMap = new HashMap<String, WmiMetatagCategory>();
        Iterator iterator = this.categoryMap.values().iterator();
        while (iterator.hasNext()) {
            WmiMetatagCategory wmiMetatagCategory = new WmiMetatagCategory((WmiMetatagCategory)iterator.next());
            hashMap.put(wmiMetatagCategory.getName(), wmiMetatagCategory);
        }
        return hashMap;
    }

    public Set getMetatagIdList() {
        return new TreeSet(this.tagMap.keySet());
    }

    public boolean metadataWasModified() {
        return this.defaultCategorySetModified || !this.tagMap.isEmpty();
    }

    public int getDecoratorVisibility() {
        return this.decoratorVisibility;
    }

    public void setDecoratorVisibility(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid decorator visibility specified: " + n);
        }
        this.decoratorVisibility = n;
    }

    public boolean getPopupVisibility() {
        return this.popupVisibility;
    }

    public void setPopupVisibility(boolean bl) {
        this.popupVisibility = bl;
    }

    public WmiMathDocumentModel getModel() {
        return this.myModel;
    }
}

