/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiTable;
import com.maplesoft.mathdoc.dialog.WmiMessageDialog;
import com.maplesoft.mathdoc.model.WmiMetadataContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;

class WmiMetatagAttributeTable
extends WmiTable {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    private static final int TABLE_COLUMNS = 2;
    private static final String[] COLUMN_HEADINGS = new String[]{"Attribute Name", "Value"};
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String NEW_ATTRIBUTE_NAME = "New Attribute";
    private WmiMetatagAttributeTableModel myModel = (WmiMetatagAttributeTableModel)this.getModel();
    private WmiMetadataContainer myData;
    private int nextUnamedCounter;
    private JButton addButton = null;
    private JButton deleteButton = null;

    public WmiMetatagAttributeTable(WmiMetadataContainer wmiMetadataContainer, JButton jButton, JButton jButton2) {
        super(new WmiMetatagAttributeTableModel());
        this.getColumnModel().getColumn(0).setCellEditor(new WmiMetatagAttributeNameCellEditor());
        this.setRowSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAddButton(jButton);
        this.setDeleteButton(jButton2);
        this.nextUnamedCounter = 0;
        this.myData = wmiMetadataContainer;
        this.reloadTable();
    }

    public WmiMetatagAttributeTable(WmiMetadataContainer wmiMetadataContainer) {
        this(wmiMetadataContainer, null, null);
    }

    public WmiMetatagAttributeTable() {
        this((WmiMetadataContainer)null, (JButton)null, (JButton)null);
    }

    public void setAddButton(JButton jButton) {
        if (jButton != null) {
            this.addButton = jButton;
            if (this.addButton.getActionListeners().length == 0) {
                this.addButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        WmiMetatagAttributeTable.this.addAttribute();
                    }
                });
            }
        }
    }

    public void setDeleteButton(JButton jButton) {
        if (jButton != null) {
            this.deleteButton = jButton;
            if (this.deleteButton.getActionListeners().length == 0) {
                this.deleteButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        WmiMetatagAttributeTable.this.deleteSelectedAttribute();
                    }
                });
            }
            this.deleteButton.setEnabled(false);
        }
    }

    public void addAttribute(String string, String string2) {
        String string3 = WmiMetadataContainer.getMetadataSafeString(string);
        String string4 = WmiMetadataContainer.getMetadataSafeString(string2);
        this.myModel.insertRow(this.myModel.getRowCount(), new Object[]{string3, string4});
    }

    public void addAttribute() {
        String string = NEW_ATTRIBUTE_NAME;
        boolean bl = false;
        block0: while (!bl) {
            string = this.nextUnamedCounter == 0 ? NEW_ATTRIBUTE_NAME : "New Attribute " + this.nextUnamedCounter;
            ++this.nextUnamedCounter;
            bl = true;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = this.getValueAt(i, 0).toString();
                if (!string2.equals(string)) continue;
                bl = false;
                continue block0;
            }
        }
        this.addAttribute(string, null);
    }

    public void deleteSelectedAttribute() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            this.myModel.removeRow(n);
            if (this.myModel.getRowCount() > 0) {
                int n2 = n < this.myModel.getRowCount() ? n : this.myModel.getRowCount() - 1;
                this.setRowSelectionInterval(n2, n2);
            }
        }
    }

    public void reloadTable() {
        int n = this.myModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.myModel.removeRow(0);
        }
        if (this.myData != null) {
            Iterator iterator = new TreeSet(this.myData.getAttributeKeySet()).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.myData.getAttribute(string);
                this.addAttribute(string, string2);
            }
        }
    }

    public void unloadTable() {
        if (this.myData != null) {
            this.myData.removeAllAttributes();
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = (String)this.getValueAt(i, 0);
                String string2 = (String)this.getValueAt(i, 1);
                this.myData.addAttribute(string, string2);
            }
        }
    }

    public WmiMetadataContainer getMetadata() {
        return this.myData;
    }

    public void setMetadata(WmiMetadataContainer wmiMetadataContainer) {
        if (this.myData != wmiMetadataContainer) {
            this.myData = wmiMetadataContainer;
            this.reloadTable();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        int n3 = tableModelEvent.getType();
        if (n3 == 0 && n >= 0 && n2 >= 0) {
            String string = this.getValueAt(n, 0).toString();
            String string2 = this.getValueAt(n, 1).toString();
            if (string != null) {
                this.myData.changeAttribute(string, string2);
            }
        }
        super.tableChanged(tableModelEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(this.getSelectedRow() >= 0);
        }
        super.valueChanged(listSelectionEvent);
    }

    private WmiMessageDialog getDuplicateAttributeWarning() {
        WmiMessageDialog wmiMessageDialog = new WmiMessageDialog(RESOURCE_PATH);
        wmiMessageDialog.setModal(true);
        wmiMessageDialog.setMessageType(102);
        wmiMessageDialog.setOptionType(0);
        wmiMessageDialog.setMessage("MTTE_Warn_Duplicate_Attr_Name");
        return wmiMessageDialog;
    }

    private WmiMessageDialog getEmptyAttributeNameWarning() {
        WmiMessageDialog wmiMessageDialog = new WmiMessageDialog(RESOURCE_PATH);
        wmiMessageDialog.setModal(true);
        wmiMessageDialog.setMessageType(102);
        wmiMessageDialog.setOptionType(0);
        wmiMessageDialog.setMessage("MTTE_Warn_Empty_Attr_Name");
        return wmiMessageDialog;
    }

    protected class WmiMetatagAttributeNameCellEditor
    extends DefaultCellEditor {
        public WmiMetatagAttributeNameCellEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            int n;
            String string = (String)this.getCellEditorValue();
            boolean bl = string == null ? true : string.length() == 0;
            boolean bl2 = false;
            if (!bl) {
                for (n = 0; n < WmiMetatagAttributeTable.this.getRowCount(); ++n) {
                    String string2;
                    if (n == WmiMetatagAttributeTable.this.getSelectedRow() || !(string2 = WmiMetatagAttributeTable.this.getValueAt(n, 0).toString()).equals(string)) continue;
                    bl2 = true;
                }
            }
            if (bl) {
                WmiMetatagAttributeTable.this.getEmptyAttributeNameWarning().showDialog();
                n = 0;
            } else if (bl2) {
                WmiMetatagAttributeTable.this.getDuplicateAttributeWarning().showDialog();
                n = 0;
            } else {
                n = super.stopCellEditing() ? 1 : 0;
            }
            return n != 0;
        }
    }

    protected static class WmiMetatagAttributeTableModel
    extends DefaultTableModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n < 2) {
                return COLUMN_HEADINGS[n];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

