/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;

public abstract class WmiNavigationCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.navigation.resources.Navigation";
    private boolean justRepeated = false;

    protected WmiNavigationCommand(String string) {
        super(string);
    }

    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException {
        WmiPositionMarker wmiPositionMarker;
        WmiMathDocumentView wmiMathDocumentView = WmiNavigationCommand.getDocumentView(actionEvent);
        int n = -1;
        boolean bl = false;
        WmiPositionedView wmiPositionedView = null;
        int n2 = 0;
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null) {
            wmiPositionedView = wmiPositionMarker.getView();
            n2 = wmiPositionMarker.getOffset();
        }
        if (wmiPositionedView != null) {
            wmiPositionMarker = wmiPositionedView;
            n = n2;
            WmiViewNavigator wmiViewNavigator = new WmiViewNavigator(wmiPositionedView, n2, this.isSelectionCommand());
            if (this.updatePosition(wmiViewNavigator)) {
                Object object;
                bl = true;
                Rectangle rectangle = null;
                boolean bl2 = false;
                if (this.isSelectionCommand()) {
                    object = wmiMathDocumentView.getSelection();
                    if (object != null) {
                        rectangle = object.getSelectionHighlighter().getBounds();
                        bl2 = object.isValid();
                    }
                } else {
                    object = wmiMathDocumentView.getCaret();
                    rectangle = object != null ? ((WmiCaret)object).getBounds() : null;
                }
                wmiViewNavigator.updateMarker();
                object = wmiMathDocumentView.getPositionMarker();
                WmiPositionedView wmiPositionedView2 = object.getView();
                int n3 = object.getOffset();
                if (!this.justRepeated) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Rectangle rectangle2 = null;
                    if (this.isSelectionCommand()) {
                        boolean bl5 = false;
                        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                        if (wmiSelection != null) {
                            rectangle2 = wmiSelection.getSelectionHighlighter().getBounds();
                            bl5 = wmiSelection.isValid();
                        }
                        if (bl2 != bl5 && rectangle == null && rectangle2 != null || rectangle2 == null && rectangle != null) {
                            bl3 = true;
                        } else if (!bl2 && !bl5) {
                            bl4 = true;
                        }
                    } else {
                        WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                        Rectangle rectangle3 = rectangle2 = wmiCaret != null ? wmiCaret.getBounds() : null;
                    }
                    if (!bl3 && (bl4 || this.isRepeatNecessary(wmiViewNavigator, rectangle, rectangle2, (WmiView)((Object)wmiPositionMarker), wmiPositionedView2, n, n3, this.isSelectionCommand()))) {
                        this.justRepeated = true;
                        this.addQueueableCommand(this.getName());
                        this.actionPerformed(new ActionEvent(wmiViewNavigator.getReferenceView(), actionEvent.getID(), actionEvent.getActionCommand()));
                    }
                } else {
                    this.justRepeated = false;
                }
            }
        }
        if (bl) {
            if (this.shouldSaveHorizontalPosition()) {
                wmiMathDocumentView.saveLastHorizontalPosition();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean shouldSaveHorizontalPosition() {
        return true;
    }

    private boolean isRepeatNecessary(WmiViewNavigator wmiViewNavigator, Rectangle rectangle, Rectangle rectangle2, WmiView wmiView, WmiView wmiView2, int n, int n2, boolean bl) throws WmiNoReadAccessException {
        boolean bl2 = wmiViewNavigator.viewRepeatable();
        bl2 = (bl2 &= rectangle != null && rectangle2 != null) && rectangle2.equals(rectangle);
        return bl2;
    }

    public boolean isEnabled(WmiView wmiView) {
        return wmiView != null;
    }

    protected boolean baselineMatch(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) {
        boolean bl = false;
        while (wmiPositionedView instanceof WmiCompositeView) {
            wmiPositionedView = (WmiPositionedView)((WmiCompositeView)((Object)wmiPositionedView)).getChild(((WmiCompositeView)((Object)wmiPositionedView)).getChildCount() - 1);
        }
        while (wmiPositionedView2 instanceof WmiCompositeView) {
            wmiPositionedView2 = (WmiPositionedView)((WmiCompositeView)((Object)wmiPositionedView2)).getChild(0);
        }
        if (wmiPositionedView instanceof WmiTextView && wmiPositionedView2 instanceof WmiTextView) {
            if (this.isSelectionCommand()) {
                bl = true;
            } else {
                Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                Point point2 = WmiViewUtil.getAbsoluteOffset(wmiPositionedView2);
                if (point != null && point2 != null) {
                    int n;
                    int n2 = point.y + ((WmiTextView)wmiPositionedView).getAdjustedBaseline();
                    bl = n2 == (n = point2.y + ((WmiTextView)wmiPositionedView2).getAdjustedBaseline());
                }
            }
        }
        return bl;
    }

    public abstract boolean updatePosition(WmiViewNavigator var1) throws WmiNoReadAccessException;

    public boolean isSelectionCommand() {
        return false;
    }
}

