/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.event.ActionEvent;

public abstract class WmiSearchAndSelect
extends WmiNavigationCommand {
    protected WmiSearchAndSelect(String string) {
        super(string);
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException {
        WmiView wmiView = WmiSearchAndSelect.getView(actionEvent);
        if (wmiView != null) {
            this.updatePosition(wmiView);
        }
    }

    public boolean updatePosition(WmiViewNavigator wmiViewNavigator) throws WmiNoReadAccessException {
        return this.updatePosition(wmiViewNavigator.getReferenceView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePosition(WmiView wmiView) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        WmiModel wmiModel = null;
        WmiView wmiView2 = null;
        int n = 0;
        WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
        if (wmiCaret != null) {
            wmiView2 = wmiCaret.getView();
            n = wmiCaret.getOffset();
        } else {
            wmiView2 = wmiView;
            n = 0;
        }
        try {
            WmiModelLock.readLock(wmiMathDocumentView.getModel(), true);
            int[] nArray = new int[2];
            wmiModel = this.searchForSelection(wmiView2, n, nArray);
            if (wmiModel instanceof WmiTextModel) {
                WmiSearchAndSelect.selectTextModel(wmiMathDocumentView, (WmiTextModel)wmiModel, nArray[0], nArray[1]);
                bl = true;
            } else if (wmiModel instanceof WmiCompositeModel) {
                WmiSearchAndSelect.selectCompositeModel(wmiMathDocumentView, (WmiCompositeModel)wmiModel);
                bl = true;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            WmiModelLock.readUnlock(wmiMathDocumentView.getModel());
        }
        return bl;
    }

    protected abstract WmiModel searchForSelection(WmiView var1, int var2, int[] var3) throws WmiNoReadAccessException;

    public static void selectTextModel(WmiMathDocumentView wmiMathDocumentView, WmiTextModel wmiTextModel) throws WmiNoReadAccessException {
        WmiSearchAndSelect.selectTextModel(wmiMathDocumentView, wmiTextModel, 0, wmiTextModel.getText().length());
    }

    public static void selectCompositeModel(WmiMathDocumentView wmiMathDocumentView, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        Object object;
        int n;
        WmiCompositeView wmiCompositeView = (WmiCompositeView)WmiViewUtil.modelToView(wmiMathDocumentView, wmiCompositeModel, 0);
        if (wmiCompositeView == null) {
            return;
        }
        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
        WmiSelectionBuilder wmiSelectionBuilder = wmiViewFactory.getSelectionBuilder();
        WmiSelection wmiSelection = wmiSelectionBuilder.selectModel(wmiCompositeView.getModel());
        wmiMathDocumentView.setSelection(wmiSelection);
        WmiView wmiView = wmiCompositeView;
        while (wmiView instanceof WmiCompositeView && (n = (object = wmiView).getChildCount()) > 0) {
            wmiView = object.getChild(n - 1);
        }
        object = new WmiModelPosition(wmiView.getModel(), -1);
        wmiMathDocumentView.updatePosition((WmiModelPosition)object, 1);
        wmiMathDocumentView.repaint();
    }

    public static void selectTextModel(WmiMathDocumentView wmiMathDocumentView, WmiTextModel wmiTextModel, int n, int n2) throws WmiNoReadAccessException {
        WmiView wmiView = WmiViewUtil.modelToView(wmiMathDocumentView, wmiTextModel, n);
        WmiView wmiView2 = WmiViewUtil.modelToView(wmiMathDocumentView, wmiTextModel, n + n2);
        if (wmiView != null && wmiView2 != null) {
            int n3;
            WmiViewPath wmiViewPath = new WmiViewPath(wmiView);
            WmiViewPath wmiViewPath2 = new WmiViewPath(wmiView2);
            if (wmiView instanceof WmiTextView) {
                n3 = n - ((WmiTextView)wmiView).getStartOffset();
                wmiViewPath.push(n3);
            }
            if (wmiView2 instanceof WmiTextView) {
                n3 = n + n2 - ((WmiTextView)wmiView2).getStartOffset();
                wmiViewPath2.push(n3);
            }
            WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
            WmiSelection wmiSelection = wmiViewFactory.createSelection(wmiViewPath, wmiViewPath2);
            wmiMathDocumentView.setSelection(wmiSelection);
            try {
                WmiModelPosition wmiModelPosition = wmiViewPath2.createModelPosition(wmiMathDocumentView);
                wmiMathDocumentView.updatePosition(wmiModelPosition, 1);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            wmiMathDocumentView.repaint();
        }
    }

    public boolean isSelectionCommand() {
        return true;
    }
}

