/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.view.palettes;

import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

public class WmiPaletteButtonDnDManager {
    public static final String PALETTE_BUTTON_MIME_TYPE = "application/x-java-serialized-object;class=java.io.Serializable";
    public static final Transferable PALETTE_BUTTON_TRANSFERABLE = new PaletteButtonTransferable();
    public static final DataFlavor PALETTE_BUTTON_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=java.io.Serializable", "Maple Palette Button");
    public static AbstractButton dragButton = null;
    public static WmiMathDocumentView dragSourceView = null;
    public PaletteButtonDragListener dragListener = null;

    public WmiPaletteButtonDnDManager() {
        this.dragListener = new PaletteButtonDragListener();
    }

    public WmiPaletteButtonDnDManager(PaletteButtonDragListener paletteButtonDragListener) {
        this.dragListener = paletteButtonDragListener;
    }

    public void installDragGestureListener(AbstractButton abstractButton) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(abstractButton, 1, this.dragListener);
        dragSource.addDragSourceListener(this.dragListener);
    }

    public boolean handleButtonDrop(WmiMathDocumentView wmiMathDocumentView) {
        boolean bl = false;
        if (wmiMathDocumentView == dragSourceView && dragButton != null) {
            ButtonModel buttonModel = dragButton.getModel();
            boolean bl2 = buttonModel.isEnabled();
            buttonModel.setEnabled(true);
            this.selectPlaceHolder(wmiMathDocumentView);
            dragButton.doClick(0);
            buttonModel.setEnabled(bl2);
            bl = true;
        }
        dragButton = null;
        dragSourceView = null;
        return bl;
    }

    public void handleDragOver(WmiMathDocumentView wmiMathDocumentView) {
        this.selectPlaceHolder(wmiMathDocumentView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectPlaceHolder(WmiMathDocumentView wmiMathDocumentView) {
        WmiModel wmiModel = wmiMathDocumentView.getModel();
        boolean bl = false;
        try {
            WmiModel wmiModel2;
            if (!WmiModelLock.ownsWriteLock(wmiModel)) {
                bl = WmiModelLock.readLock(wmiModel, true);
            }
            if ((wmiModel2 = this.getPlaceholderModel(wmiMathDocumentView)) instanceof WmiTextModel) {
                WmiSearchAndSelect.selectTextModel(wmiMathDocumentView, (WmiTextModel)wmiModel2);
            } else if (wmiModel2 instanceof WmiCompositeModel) {
                WmiSearchAndSelect.selectCompositeModel(wmiMathDocumentView, (WmiCompositeModel)wmiModel2);
            } else {
                wmiMathDocumentView.setSelection(null);
                wmiMathDocumentView.repaint();
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            if (bl) {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
    }

    private WmiModel getPlaceholderModel(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
        WmiModel wmiModel = null;
        for (WmiModel wmiModel2 = wmiPositionedView.getModel(); wmiModel2 != null && wmiModel2 != wmiMathDocumentView.getModel(); wmiModel2 = wmiModel2.getParent()) {
            WmiAttributeSet wmiAttributeSet = wmiModel2.getAttributes();
            if (!"true".equals(wmiAttributeSet.getAttribute("placeholder"))) continue;
            wmiModel = wmiModel2;
            break;
        }
        return wmiModel;
    }

    public static AbstractButton getDragButton() {
        return dragButton;
    }

    private static class PaletteButtonTransferable
    implements Transferable {
        private PaletteButtonTransferable() {
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return dataFlavor == PALETTE_BUTTON_FLAVOR && dragButton != null ? "Palette Button" : null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PALETTE_BUTTON_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == PALETTE_BUTTON_FLAVOR;
        }
    }

    public static class PaletteButtonDragListener
    implements DragGestureListener,
    DragSourceListener {
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            Component component = dragSourceDropEvent.getDragSourceContext().getComponent();
            if (component instanceof AbstractButton) {
                ButtonModel buttonModel = ((AbstractButton)component).getModel();
                boolean bl = buttonModel.isEnabled();
                buttonModel.setEnabled(false);
                buttonModel.setSelected(false);
                buttonModel.setArmed(false);
                buttonModel.setPressed(false);
                buttonModel.setEnabled(bl);
                buttonModel.setRollover(false);
                component.repaint();
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

