/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.html;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.dialog.WmiMessageDialog;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.WmiGenericGraphicExportAction;
import com.maplesoft.mathdoc.io.WmiGenericMathExportAction;
import com.maplesoft.mathdoc.io.WmiGenericTextExportAction;
import com.maplesoft.mathdoc.io.WmiGraphicExportFormatter;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.io.html.WmiHTMLDocumentElementExportAction;
import com.maplesoft.mathdoc.io.html.WmiHTMLParagraphExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLTransferExportAction;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMathExportParagraphView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;
import javax.media.jai.JAI;

public class WmiHTMLFormatter
extends WmiExportFormatter
implements WmiGraphicExportFormatter {
    public static final int EXPRESSION_GIF = 0;
    public static final int EXPRESSION_MATHML_PRESENTATION = 1;
    public static final int EXPRESSION_MATHML_CONTENT = 2;
    public static final int EXPRESSION_DOTM = 3;
    private static final String HTML_LINE_BREAK = "\n<br>";
    public static final String DLG_RESOURCES = "com.maplesoft.mathdoc.io.html.resources.HTMLFormatter";
    public static final String EXISTING_MESSAGE_KEY = "REPLACE_EXISTING_FILE_MESSAGE";
    public static final String EXISTING_TITLE_KEY = "REPLACE_EXISTING_FILE_TITLE";
    private static final Object[] HTML_FONT_KEYS = new Object[]{"family", "size", "bold", "italic", "underline", "foreground", "background", "subscript", "superscript"};
    private static final String ESCAPE_SEQUENCE_START = "&#";
    private static final String ESCAPE_SEQUENCE_END = ";";
    protected static final int ALT_TEXT_MAX_LENGTH = 200;
    protected static final int IMAGE_GIF = 0;
    protected static final int IMAGE_JPG = 1;
    private static HashMap htmlActionTable = new HashMap();
    protected WmiMathDocumentView docView = null;
    protected Stack fontStack = new Stack();
    protected int gifCounter = 0;
    protected int jpgCounter = 0;
    protected static int maxWidth;
    private boolean replaceAllImages = false;
    private boolean exportCancelled = false;
    private String directory = null;
    private String imageDirectory = null;

    public WmiHTMLFormatter(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
    }

    public static void makeHTMLSafe(String string, StringBuffer stringBuffer) {
        if (string != null && stringBuffer != null) {
            int n = 0;
            StringBuffer stringBuffer2 = new StringBuffer(string);
            boolean bl = false;
            block6: while (n < stringBuffer2.length()) {
                char c = stringBuffer2.charAt(n);
                switch (c) {
                    case '\n': {
                        stringBuffer2.deleteCharAt(n);
                        stringBuffer2.insert(n, HTML_LINE_BREAK);
                        n += HTML_LINE_BREAK.length();
                        bl = false;
                        continue block6;
                    }
                    case '>': {
                        stringBuffer2.deleteCharAt(n);
                        stringBuffer2.insert(n, "&gt;");
                        n += "&gt;".length();
                        bl = false;
                        continue block6;
                    }
                    case '<': {
                        stringBuffer2.deleteCharAt(n);
                        stringBuffer2.insert(n, "&lt;");
                        n += "&lt;".length();
                        bl = false;
                        continue block6;
                    }
                    case ' ': {
                        if (bl) {
                            stringBuffer2.deleteCharAt(n);
                            stringBuffer2.insert(n, "&nbsp;");
                            n += "&nbsp;".length();
                        } else {
                            ++n;
                        }
                        bl = true;
                        continue block6;
                    }
                }
                ++n;
                bl = false;
            }
            stringBuffer.append(stringBuffer2.toString());
        }
    }

    public static int scaleFontSize(int n) {
        int n2 = n;
        n2 = n < 4 ? 0 : (n - 3) / 3;
        return n2;
    }

    public static String translateAttribute(Object object) {
        String string = null;
        if (object instanceof Color) {
            string = "#" + WmiColorAttributeKey.createRGBHexStringFromColor((Color)object);
        } else if (object != null) {
            if (object.toString().matches(".[0-9]+,[0-9]+,[0-9]+.")) {
                String[] stringArray = object.toString().split("[^0-9]");
                int[] nArray = new int[]{Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])};
                string = "#" + WmiColorAttributeKey.createRGBHexStringFromColorTriplet(nArray[0], nArray[1], nArray[2]);
            } else {
                string = object.toString();
            }
        }
        return string;
    }

    public static WmiGenericAttributeSet translateFontAttributes(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiGenericAttributeSet wmiGenericAttributeSet = new WmiGenericAttributeSet();
        if (wmiModel != null && (wmiAttributeSet = wmiModel.getAttributesForRead()) != null) {
            Object object;
            for (int i = 0; i < HTML_FONT_KEYS.length; ++i) {
                object = HTML_FONT_KEYS[i];
                Object object2 = wmiAttributeSet.getAttribute(object);
                if (object2 == null) continue;
                wmiGenericAttributeSet.addAttribute(object, object2);
            }
            Object object3 = wmiAttributeSet.getAttribute("opaque");
            if (object3 == null || !object3.equals("true")) {
                wmiGenericAttributeSet.removeAttribute("background");
                WmiHTMLFormatter.transformColor("foreground", wmiGenericAttributeSet);
            } else {
                WmiHTMLFormatter.transformColor("foreground", wmiGenericAttributeSet);
                WmiHTMLFormatter.transformColor("background", wmiGenericAttributeSet);
            }
            object = wmiGenericAttributeSet.getAttribute("size");
            if (object instanceof Integer) {
                int n = WmiHTMLFormatter.scaleFontSize((Integer)object);
                wmiGenericAttributeSet.addAttribute("size", new Integer(n));
            }
        }
        return wmiGenericAttributeSet;
    }

    private static void transformColor(String string, WmiAttributeSet wmiAttributeSet) {
        Object object = wmiAttributeSet.getAttribute(string);
        if (object instanceof String) {
            int n = WmiColorAttributeKey.createColorIndexFromRGBString(object.toString());
            object = WmiColorAttributeKey.createRGBHexStringFromColorIndex(n);
            wmiAttributeSet.addAttribute(string, "#" + object);
        }
    }

    public static int getMaxWidth() {
        return maxWidth;
    }

    public static void setMaxWidth(int n) {
        maxWidth = n;
    }

    protected void closeCharacterTags(WmiGenericAttributeSet wmiGenericAttributeSet) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = wmiGenericAttributeSet.getAttribute("subscript");
        if (object5 != null && object5.equals("true")) {
            this.writeBinary("</sub>");
        }
        if ((object4 = wmiGenericAttributeSet.getAttribute("superscript")) != null && object4.equals("true")) {
            this.writeBinary("</sup>");
        }
        if ((object3 = wmiGenericAttributeSet.getAttribute("underline")) != null && object3.equals("true")) {
            this.writeBinary("</u>");
        }
        if ((object2 = wmiGenericAttributeSet.getAttribute("italic")) != null && object2.equals("true")) {
            this.writeBinary("</em>");
        }
        if ((object = wmiGenericAttributeSet.getAttribute("bold")) != null && object.equals("true")) {
            this.writeBinary("</strong>");
        }
        Object object6 = wmiGenericAttributeSet.getAttribute("family");
        Object object7 = wmiGenericAttributeSet.getAttribute("size");
        Object object8 = wmiGenericAttributeSet.getAttribute("foreground");
        Object object9 = wmiGenericAttributeSet.getAttribute("background");
        if (object6 != null || object7 != null || object8 != null || object9 != null) {
            this.writeBinary("</font>");
        }
    }

    protected boolean createImageFile(BufferedImage bufferedImage, String string) throws WmiCancelException, IOException {
        File file = this.getNextImageFile(0);
        boolean bl = WmiImageUtilities.exportToGIF((BufferedImage)bufferedImage, (String)file.getAbsolutePath());
        if (!bl) {
            file = this.getNextImageFile(1);
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                JAI.create((String)"filestore", (RenderedImage)bufferedImage2, (Object)file.getPath(), (Object)"JPEG");
                bl = true;
            }
            catch (Exception exception) {
                WmiErrorLog.log(exception);
            }
        }
        if (bl) {
            bl = this.writeImage(file.getName(), string, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return bl;
    }

    protected void formatLinebrokenMathView(WmiParagraphView wmiParagraphView, String string) throws WmiCancelException, WmiNoReadAccessException, IOException {
        int n = wmiParagraphView.getChildCount();
        WmiRenderPath wmiRenderPath = new WmiRenderPath(this.docView);
        if (n > 0) {
            int n2 = 0;
            do {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiParagraphView.getChild(n2);
                wmiRenderPath.push(-wmiPositionedView.getHorizontalOffset(), -wmiPositionedView.getVerticalOffset());
                this.exportPositionedView(wmiPositionedView, wmiRenderPath, string);
                wmiRenderPath.pop();
                if (++n2 >= n) continue;
                this.writeBinary("<br>");
            } while (n2 < n);
        }
    }

    protected void exportPositionedView(WmiPositionedView wmiPositionedView, WmiRenderPath wmiRenderPath, String string) throws WmiCancelException, WmiNoReadAccessException, IOException {
        if (wmiPositionedView.getHeight() < wmiPositionedView.getBaseline() * 2) {
            wmiPositionedView.setHeight(wmiPositionedView.getBaseline() * 2);
        } else {
            float f = wmiPositionedView.getBaseline();
            float f2 = wmiPositionedView.getHeight();
            int n = Math.round(2.0f * (f2 - f));
            wmiPositionedView.setHeight(n);
            int n2 = Math.round((float)n - f2);
            wmiPositionedView.setVerticalOffset(wmiPositionedView.getVerticalOffset() - n2);
            wmiRenderPath.translateOrigin(0, n2);
        }
        wmiPositionedView.markInvalid(1);
        wmiPositionedView.layoutView();
        BufferedImage bufferedImage = WmiViewUtil.drawViewToImage(wmiPositionedView, wmiRenderPath, WmiHTMLFormatter.getMaxWidth());
        this.createImageFile(bufferedImage, string);
    }

    protected String getAltText(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Dag dag = wmiMathModel.toDag();
            stringBuffer.append(DagBuilder.lPrint(dag));
            if (stringBuffer.length() > 200) {
                stringBuffer.setLength(200);
                stringBuffer.append("...");
            }
        }
        catch (NullPointerException nullPointerException) {
            WmiErrorLog.log(nullPointerException);
        }
        return stringBuffer.toString();
    }

    protected String getDirectory() {
        if (this.directory == null) {
            File file = new File(this.getFilename());
            this.directory = file.getAbsolutePath();
            int n = this.directory.lastIndexOf(File.separatorChar);
            if (n > -1) {
                this.directory = this.directory.substring(0, n);
            }
        }
        return this.directory;
    }

    protected WmiExportAction getFormatAction(WmiModelTag wmiModelTag) {
        return (WmiExportAction)htmlActionTable.get(wmiModelTag);
    }

    protected String getImageDirectory() {
        return "";
    }

    protected String getNextImageFilename(int n) {
        String string = this.getShortFilename();
        int n2 = string.lastIndexOf(".");
        if (n2 < 1) {
            n2 = string.length();
        }
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(string.substring(0, n2));
        if (n == 0) {
            ++this.gifCounter;
            stringBuffer.append("_" + this.gifCounter);
            stringBuffer.append(".gif");
        } else {
            ++this.jpgCounter;
            stringBuffer.append("_" + this.jpgCounter);
            stringBuffer.append(".jpg");
        }
        return stringBuffer.toString();
    }

    protected File getNextImageFile(int n) throws WmiCancelException {
        if (this.imageDirectory == null) {
            this.imageDirectory = this.getDirectory() + File.separatorChar + this.getImageDirectory();
        }
        File file = new File(this.imageDirectory);
        file.mkdirs();
        File file2 = null;
        boolean bl = this.replaceAllImages;
        do {
            String string;
            if (!(file2 = new File(string = this.imageDirectory + this.getNextImageFilename(n))).exists() || this.replaceAllImages) continue;
            WmiMessageDialog wmiMessageDialog = new WmiMessageDialog(DLG_RESOURCES);
            wmiMessageDialog.setOptionType(4);
            wmiMessageDialog.setMessage(EXISTING_MESSAGE_KEY, (Object)string);
            wmiMessageDialog.setTitle(EXISTING_TITLE_KEY);
            int n2 = wmiMessageDialog.showDialog();
            switch (n2) {
                case 2: {
                    bl = true;
                    break;
                }
                case 4: {
                    bl = true;
                    this.replaceAllImages = true;
                    break;
                }
                case 3: {
                    bl = false;
                    break;
                }
                case 1: {
                    throw new WmiCancelException();
                }
            }
        } while (!bl && file2.exists());
        return file2;
    }

    protected String getShortFilename() {
        File file = new File(this.getFilename());
        return file.getName();
    }

    protected void nestFontTags(WmiTextModel wmiTextModel) throws WmiNoReadAccessException, IOException {
        WmiGenericAttributeSet wmiGenericAttributeSet = WmiHTMLFormatter.translateFontAttributes(wmiTextModel);
        WmiAttributeSet wmiAttributeSet = null;
        WmiGenericAttributeSet wmiGenericAttributeSet2 = new WmiGenericAttributeSet();
        while (!this.fontStack.empty()) {
            if (WmiAttributeComparator.subtract((WmiAttributeSet)this.fontStack.peek(), wmiGenericAttributeSet) == null) {
                wmiAttributeSet = (WmiAttributeSet)this.fontStack.peek();
                wmiGenericAttributeSet2.addAttributes(wmiAttributeSet);
                break;
            }
            this.endFontDefinition();
        }
        if ((wmiGenericAttributeSet = WmiAttributeComparator.subtract(wmiGenericAttributeSet, wmiAttributeSet)) != null && wmiGenericAttributeSet.getAttributeCount() > 0) {
            wmiGenericAttributeSet2.addAttributes(wmiGenericAttributeSet);
            this.fontStack.add(wmiGenericAttributeSet2);
            this.openCharacterTags(wmiGenericAttributeSet);
        }
        if (wmiTextModel.getLength() > 0) {
            this.writeText(wmiTextModel.getText());
        }
    }

    protected void openCharacterTags(WmiGenericAttributeSet wmiGenericAttributeSet) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6 = wmiGenericAttributeSet.getAttribute("family");
        Object object7 = wmiGenericAttributeSet.getAttribute("size");
        Object object8 = wmiGenericAttributeSet.getAttribute("foreground");
        Object object9 = wmiGenericAttributeSet.getAttribute("background");
        if (object6 != null || object7 != null || object8 != null || object9 != null) {
            this.writeBinary("<font");
            if (object8 != null) {
                this.writeAttribute("color", object8);
            }
            if (object7 != null) {
                this.writeAttribute("size", object7);
            }
            if (object6 != null) {
                if (object6.equals("Monospaced")) {
                    object6 = "monospace";
                }
                this.writeAttribute("face", object6);
            }
            if (object9 != null) {
                object5 = "background-color: " + object9.toString();
                this.writeAttribute("style", object5);
            }
            this.writeBinary(">");
        }
        if ((object5 = wmiGenericAttributeSet.getAttribute("bold")) != null && object5.equals("true")) {
            this.writeBinary("<strong>");
        }
        if ((object4 = wmiGenericAttributeSet.getAttribute("italic")) != null && object4.equals("true")) {
            this.writeBinary("<em>");
        }
        if ((object3 = wmiGenericAttributeSet.getAttribute("underline")) != null && object3.equals("true")) {
            this.writeBinary("<u>");
        }
        if ((object2 = wmiGenericAttributeSet.getAttribute("superscript")) != null && object2.equals("true")) {
            this.writeBinary("<sup>");
        }
        if ((object = wmiGenericAttributeSet.getAttribute("subscript")) != null && object.equals("true")) {
            this.writeBinary("<sub>");
        }
    }

    protected void postFormat() throws IOException {
        this.writeFooterInfo();
    }

    protected void preFormat() throws IOException, WmiNoReadAccessException {
        this.writeHeaderInfo();
    }

    public void processModel(WmiModel wmiModel) throws IOException, WmiNoReadAccessException {
        if (!wmiModel.isVisible() && this.ignoreHiddenModels()) {
            return;
        }
        WmiModelTag wmiModelTag = wmiModel.getTag();
        if (wmiModelTag != null) {
            boolean bl = false;
            WmiExportAction wmiExportAction = wmiModel instanceof WmiTransferModel ? new WmiMathMLTransferExportAction() : this.getFormatAction(wmiModelTag);
            if (wmiExportAction != null) {
                wmiExportAction.openModel(this, wmiModel);
                bl = wmiExportAction.processChildModels();
            }
            if (bl && !this.exportCancelled && wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                    this.processModel(wmiCompositeModel.getChild(i));
                }
            }
            if (wmiExportAction != null) {
                wmiExportAction.closeModel(this, wmiModel);
            }
        }
    }

    protected void writeFooterInfo() throws IOException {
        this.writeBinary("\n</html>");
    }

    protected void writeHeaderInfo() throws IOException {
        this.writeBinary("<html>\n<head>\n");
        this.writeBinary("<meta http-equiv=\"content-type\" content=\"text/html; charset=");
        AbstractStringEncoder abstractStringEncoder = this.getEncoder();
        if (abstractStringEncoder instanceof UTF8Encoder) {
            this.writeBinary("utf-8");
        } else if (abstractStringEncoder instanceof ShiftJISEncoder) {
            this.writeBinary("Shift_JIS");
        } else {
            this.writeBinary(abstractStringEncoder.getName());
        }
        this.writeBinary("\">\n");
        this.writeBinary("<title>");
        File file = new File(this.getFilename());
        this.writeText(file.getName());
        this.writeBinary("</title>\n");
        this.writeBinary("<!-- Created by Maple 11.0");
        String string = System.getProperty("os.name");
        if (string != null) {
            this.writeBinary(", " + string);
        }
        this.writeBinary(" -->\n");
        this.writeBinary("</head>\n");
    }

    protected boolean writeImage(String string, String string2, int n, int n2) throws IOException {
        boolean bl = true;
        this.writeBinary("<img src=\"");
        int n3 = WmiHTMLFormatter.getMaxWidth();
        if (n > n3) {
            n2 = (int)Math.round((double)n2 / ((double)n * 1.0) * (double)n3);
            n = n3;
        }
        String string3 = this.getImageDirectory();
        String string4 = this.getDirectory() + string3;
        File file = new File(string4);
        file.mkdirs();
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.writeText(string3 + string);
        this.writeBinary("\"");
        this.writeBinary(" width=\"" + n + "\"");
        this.writeBinary(" height=\"" + n2 + "\"");
        this.writeBinary(" alt=\"" + string2 + "\"");
        this.writeBinary(" align=\"center\" border=\"0\">");
        return bl;
    }

    protected void cancelExport() {
        this.exportCancelled = true;
    }

    public void clearFontStack() throws IOException {
        while (!this.fontStack.empty()) {
            this.endFontDefinition();
        }
        this.fontStack.clear();
    }

    public void endFontDefinition() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.closeCharacterTags((WmiGenericAttributeSet)this.fontStack.pop());
        }
    }

    public void startFontDefinition(WmiGenericAttributeSet wmiGenericAttributeSet) throws IOException {
        this.openCharacterTags(wmiGenericAttributeSet);
        this.fontStack.push(wmiGenericAttributeSet);
    }

    public boolean ignoreHiddenModels() {
        return true;
    }

    public boolean canSetEncoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int format() throws WmiFormatException, WmiNoReadAccessException {
        int n = 100;
        WmiModel wmiModel = this.getRootModel();
        if (this.docView != null) {
            n = this.docView.getZoomFactor();
            this.docView.setTemporaryZoomFactor(133);
        }
        int n2 = -1;
        try {
            this.preFormat();
            this.processModel(wmiModel);
            this.postFormat();
            this.flushBuffer();
            n2 = 0;
        }
        catch (IOException iOException) {
            this.throwFormatException(iOException);
        }
        finally {
            if (this.docView != null) {
                this.docView.setTemporaryZoomFactor(n);
            }
        }
        return n2;
    }

    protected void beginFormat(Writer writer, WmiModel wmiModel) throws WmiNoReadAccessException, WmiFormatException {
        if (this.docView != null && this.docView.getModel().getDocument() != wmiModel.getDocument()) {
            throw new IllegalArgumentException("Model must be part ofthe same hierarchy as the MathDocumentView used forformatter initialization.");
        }
        super.beginFormat(writer, wmiModel);
    }

    protected String transformForTextOutput(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractStringEncoder abstractStringEncoder = this.getEncoder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (abstractStringEncoder.canEncodeCharacter(c)) {
                String string2 = abstractStringEncoder.fromUnicode(Character.toString(c));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(ESCAPE_SEQUENCE_START);
            stringBuffer.append((int)c);
            stringBuffer.append(ESCAPE_SEQUENCE_END);
        }
        String string3 = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        WmiHTMLFormatter.makeHTMLSafe(string3, stringBuffer);
        return stringBuffer.toString();
    }

    public void writeAttribute(Object object, Object object2) throws IOException {
        if (object != null && object2 != null) {
            this.writeBinary(" ");
            this.writeText(object.toString());
            this.writeBinary("=\"");
            this.writeText(WmiHTMLFormatter.translateAttribute(object2));
            this.writeBinary("\"");
        }
    }

    public void writeMathModel(WmiMathModel wmiMathModel) throws WmiNoReadAccessException, IOException {
        try {
            if (this.docView != null) {
                WmiView wmiView = this.modelToView(wmiMathModel, this.docView);
                if (wmiView instanceof WmiPositionedView) {
                    WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
                    int n = wmiPositionedView.getWidth();
                    if (n > WmiHTMLFormatter.getMaxWidth()) {
                        WmiCompositeModel wmiCompositeModel = wmiMathModel.getParent();
                        WmiMathExportParagraphView wmiMathExportParagraphView = new WmiMathExportParagraphView((WmiModel)wmiCompositeModel, this.docView, WmiHTMLFormatter.getMaxWidth());
                        this.formatLinebrokenMathView(wmiMathExportParagraphView, this.getAltText(wmiMathModel));
                        wmiMathExportParagraphView.release();
                    } else {
                        this.exportPositionedView(wmiPositionedView, new WmiRenderPath(this.docView), this.getAltText(wmiMathModel));
                    }
                }
                if (wmiView != null) {
                    wmiView.release();
                }
            }
        }
        catch (WmiCancelException wmiCancelException) {
            this.cancelExport();
        }
    }

    public void writeTextModel(WmiTextModel wmiTextModel) throws WmiNoReadAccessException, IOException {
        if (wmiTextModel.getLength() > 0) {
            this.nestFontTags(wmiTextModel);
        }
    }

    public void writeGraphic(WmiModel wmiModel) throws WmiNoReadAccessException, IOException {
        try {
            if (this.docView != null) {
                WmiView wmiView = this.modelToView(wmiModel, this.docView);
                if (wmiView instanceof WmiResizableContainerView) {
                    this.exportPositionedView((WmiResizableContainerView)wmiView, new WmiRenderPath(this.docView), wmiModel.getTag().toString());
                }
                if (wmiView != null) {
                    wmiView.release();
                }
            }
        }
        catch (WmiCancelException wmiCancelException) {
            this.cancelExport();
        }
    }

    static {
        htmlActionTable.put(WmiModelTag.DOCUMENT, new WmiHTMLDocumentElementExportAction());
        htmlActionTable.put(WmiModelTag.MATH, new WmiGenericMathExportAction());
        htmlActionTable.put(WmiModelTag.PARAGRAPH, new WmiHTMLParagraphExportAction());
        htmlActionTable.put(WmiModelTag.PLOT, new WmiGenericGraphicExportAction());
        htmlActionTable.put(WmiModelTag.TEXT, new WmiGenericTextExportAction());
        maxWidth = -1;
    }

    public static class WmiCancelException
    extends Exception {
    }
}

