/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLTokenImportAction;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Color;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMstyleImportAction
extends WmiMathMLTokenImportAction {
    private static String[] dimensionAttributes = new String[7];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel) {
        WmiMathStyleModel wmiMathStyleModel = null;
        try {
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            wmiMathStyleModel = new WmiMathStyleModel(wmiMathDocumentModel, new WmiModel[0], new WmiMathStyleModel.WmiMathStyleAttributeSet());
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiMathDocumentModel);
        }
        return wmiMathStyleModel;
    }

    public void endAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiImportParser != null) {
            ((WmiMathMLImportParser)wmiImportParser).updateStyleModel();
            super.endAction(wmiImportParser, object);
        }
    }

    public void processAttributes(WmiImportParser wmiImportParser, Attributes attributes, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        super.processAttributes(wmiImportParser, attributes, wmiModel);
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
        WmiMathStyleModel.WmiMathStyleAttributeSet wmiMathStyleAttributeSet = null;
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            wmiMathStyleAttributeSet = (WmiMathStyleModel.WmiMathStyleAttributeSet)wmiAttributeSet;
        }
        if ((string4 = attributes.getValue("background")) != null) {
            string4 = string4.toLowerCase();
            Color color = WmiMathMLPresentationMstyleImportAction.parseColor(string4, Color.WHITE);
            wmiMathStyleAttributeSet.setBackground(color.getRGB());
            wmiMathStyleAttributeSet.setExtendedStyle(32);
        }
        for (int i = 0; i < dimensionAttributes.length; ++i) {
            string3 = dimensionAttributes[i];
            String string5 = attributes.getValue(string3);
            if (string5 == null) continue;
            string5 = string5.toLowerCase();
            if (string3.equals("veryverythinmathspace")) {
                wmiMathStyleAttributeSet.setVeryVeryThinMathSpace(string5);
            } else if (string3.equals("verythinmathspace")) {
                wmiMathStyleAttributeSet.setVeryThinMathSpace(string5);
            } else if (string3.equals("thinmathspace")) {
                wmiMathStyleAttributeSet.setThinMathSpace(string5);
            } else if (string3.equals("mediummathspace")) {
                wmiMathStyleAttributeSet.setMediumMathSpace(string5);
            } else if (string3.equals("thickmathspace")) {
                wmiMathStyleAttributeSet.setThickMathSpace(string5);
            } else if (string3.equals("verythickmathspace")) {
                wmiMathStyleAttributeSet.setVeryThickMathSpace(string5);
            } else if (string3.equals("veryverythickmathspace")) {
                wmiMathStyleAttributeSet.setVeryVeryThickMathSpace(string5);
            }
            WmiMathOperatorView.updateOperatorSpaceDimension(string3, string5);
        }
        String string6 = attributes.getValue("scriptlevel");
        if (string6 != null) {
            string6 = string6.toLowerCase();
            wmiMathStyleAttributeSet.setScriptLevel(string6);
        }
        if ((string3 = attributes.getValue("scriptsizemultiplier")) != null) {
            float f = Float.parseFloat(string3);
            wmiMathStyleAttributeSet.setScriptSizeMultiplier(f);
        }
        if ((string2 = attributes.getValue("scriptminsize")) != null) {
            string2 = string2.toLowerCase();
            wmiMathStyleAttributeSet.setScriptMinSize(string2);
        }
        if ((string = attributes.getValue("mathcolor")) != null) {
            string = string.toLowerCase();
            object = WmiMathMLPresentationMstyleImportAction.parseColor(string, Color.BLACK);
            wmiMathStyleAttributeSet.setForeground(((Color)object).getRGB());
        }
        if ((object = attributes.getValue("mathbackground")) != null) {
            object = ((String)object).toLowerCase();
            Color color = WmiMathMLPresentationMstyleImportAction.parseColor((String)object, Color.WHITE);
            wmiMathStyleAttributeSet.setBackground(color.getRGB());
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string7 = attributes.getQName(i);
            String string8 = attributes.getValue(string7);
            if (string8 == null) continue;
            if (!string7.equals("fontfamily")) {
                string8 = string8.toLowerCase();
            }
            wmiMathStyleAttributeSet.addAttribute(string7, string8);
        }
        wmiModel.setAttributes(wmiMathStyleAttributeSet);
    }

    static {
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[0] = "veryverythinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[1] = "verythinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[2] = "thinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[3] = "mediummathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[4] = "thickmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[5] = "verythickmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[6] = "veryverythickmathspace";
    }
}

