/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.io.IOException;

public class WmiMathMLMathExportAction
extends WmiMathMLExportAction {
    public static final String NAME_SPACE = "http://www.w3.org/1998/Math/MathML";
    private static final String OUTPUT_STYLE = "2D Output";

    public void openModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        wmiExportFormatter.writeBinary("<math xmlns='http://www.w3.org/1998/Math/MathML'>");
        try {
            boolean bl;
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            boolean bl2 = bl = ((WmiFontAttributeSet)wmiCompositeModel.getAttributes()).getStyleName() != null && ((WmiFontAttributeSet)wmiCompositeModel.getAttributes()).getStyleName().equals(OUTPUT_STYLE);
            if (!bl && wmiCompositeModel.getChildCount() == 1 && wmiCompositeModel.getChild(0).getTag() == WmiModelTag.MATH_ROW) {
                wmiExportFormatter.writeBinary(WmiMathMLMathExportAction.exportAttributesAsMStyle(WmiFontAttributeSet.ATTRIBUTE_KEYS, wmiCompositeModel.getChild(0)));
            } else {
                wmiExportFormatter.writeBinary(WmiMathMLMathExportAction.exportAttributesAsMStyle(WmiFontAttributeSet.ATTRIBUTE_KEYS, wmiCompositeModel));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void closeModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        wmiExportFormatter.writeBinary("</mstyle>");
        wmiExportFormatter.writeBinary("</math>");
    }

    public static String exportAttributesAsMStyle(WmiAttributeKey[] wmiAttributeKeyArray, WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiModel.getAttributesForRead();
        if (wmiFontAttributeSet instanceof WmiMathStyleModel.WmiMathStyleAttributeSet) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mstyle ");
        for (int i = 0; i < wmiAttributeKeyArray.length; ++i) {
            WmiAttributeKey wmiAttributeKey = wmiAttributeKeyArray[i];
            boolean bl = false;
            boolean bl2 = false;
            if (wmiAttributeKey.equals(WmiFontAttributeSet.FAMILY_KEY)) {
                stringBuffer.append("fontfamily='" + wmiFontAttributeSet.getAttribute(wmiAttributeKey) + "' ");
            } else if (wmiAttributeKey.equals(WmiFontAttributeSet.SIZE_KEY)) {
                stringBuffer.append("mathsize='" + wmiFontAttributeSet.getAttribute(wmiAttributeKey) + "' ");
            } else if (wmiAttributeKey.equals(WmiFontAttributeSet.BOLD_KEY)) {
                if (wmiAttributeKey.getBooleanValue(wmiFontAttributeSet)) {
                    bl = true;
                }
            } else if (wmiAttributeKey.equals(WmiFontAttributeSet.ITALIC_KEY)) {
                if (wmiAttributeKey.getBooleanValue(wmiFontAttributeSet)) {
                    bl2 = true;
                }
            } else if (wmiAttributeKey.equals(WmiFontAttributeSet.FOREGROUND_KEY)) {
                stringBuffer.append("mathcolor='" + WmiHTMLFormatter.translateAttribute(wmiFontAttributeSet.getAttribute(wmiAttributeKey)) + "' ");
            }
            if (bl && bl2) {
                stringBuffer.append("mathvariant='bold-italic' ");
                continue;
            }
            if (bl) {
                stringBuffer.append("mathvariant='bold' ");
                continue;
            }
            if (!bl2) continue;
            stringBuffer.append("mathvariant='italic' ");
        }
        if (!(wmiModel instanceof WmiMathWrapperModel && ((WmiMathWrapperModel)wmiModel).getChild(0) instanceof WmiMathStyleModel || wmiModel instanceof WmiMathStyleModel)) {
            stringBuffer.append("veryverythinmathspace='0.0555556em' ");
            stringBuffer.append("verythinmathspace='0.111111em' ");
            stringBuffer.append("thinmathspace='0.166667em' ");
            stringBuffer.append("mediummathspace='0.222222em' ");
            stringBuffer.append("thickmathspace='0.277778em' ");
            stringBuffer.append("verythickmathspace='0.333333em' ");
            stringBuffer.append("veryverythickmathspace='0.388889em' ");
            stringBuffer.append("scriptlevel='0' ");
            stringBuffer.append("scriptsizemultiplier='0.71' ");
            stringBuffer.append("scriptminsize='" + WmiMathStyleModel.WmiMathStyleAttributeSet.DEFAULT_SCRIPTMINSIZE + "'");
        }
        if (!(wmiModel instanceof WmiMathWrapperModel) || !(((WmiMathWrapperModel)wmiModel).getChild(0) instanceof WmiMathStyleModel)) {
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }
}

