/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.tests;

import com.maplesoft.client.JavaCallbackListener;
import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeAdapter;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.MapleServerSocket;
import com.maplesoft.client.SetGetHandler;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class WmiMathMLParserTestApp
extends KernelAdapter
implements KernelConnectionListener {
    private static ArrayList skipFiles = new ArrayList();
    private WmiMathDocumentModel doc = new WmiMathDocumentModel();
    private WmiMathMLDocumentView view;
    private static ArrayList presentationInputFiles;
    private static ArrayList contentInputFiles;
    private static ArrayList currentInputFiles;
    private static ArrayList incorrectFiles;
    private static int currentFileCounter;
    private static ViewTestFrame testFrame;
    private SetGetHandler setGetHandler;
    private KernelConnection kernelConnection = null;
    private int kernelID = -999;

    public KernelConnection getConnection() {
        return this.kernelConnection;
    }

    public int getKernelID() {
        return this.kernelID;
    }

    public void restart() {
        KernelProxy kernelProxy = KernelProxy.getInstance();
        kernelProxy.evaluate(this.getKernelID(), new KernelAdapter(), "restart;");
    }

    public void processConnection(KernelConnectionEvent kernelConnectionEvent) {
        if (kernelConnectionEvent.getKernelState() == 1) {
            KernelProxy kernelProxy = KernelProxy.getInstance();
            kernelProxy.evaluate(this.getKernelID(), this, "gc();");
        }
    }

    public void processDisconnection(KernelConnectionEvent kernelConnectionEvent) {
    }

    public void setConnection(KernelConnection kernelConnection) {
        this.kernelConnection = kernelConnection;
        this.kernelConnection.getInterfaceProperties().addChangeListener(new KernelInterfacePropertiesChangeAdapter());
    }

    public boolean processError(KernelEvent kernelEvent) {
        testFrame.getMathMLArea().setForeground(Color.RED);
        testFrame.getMathMLArea().append(kernelEvent.getText());
        return true;
    }

    public boolean processJava(KernelEvent kernelEvent) {
        return JavaCallbackListener.processJava(kernelEvent);
    }

    public boolean processChar(KernelEvent kernelEvent) {
        testFrame.getMathMLArea().setForeground(Color.BLACK);
        testFrame.getMathMLArea().append(kernelEvent.getDag().getChild(0).getData());
        return true;
    }

    public boolean processSet(KernelEvent kernelEvent) {
        this.setGetHandler.processSetHandler(kernelEvent);
        return true;
    }

    public boolean processGet(KernelEvent kernelEvent) {
        this.setGetHandler.processGetHandler(kernelEvent);
        return true;
    }

    public WmiMathMLParserTestApp() {
        this.doc.setReadOnly(true);
        WmiIndexedViewFactory wmiIndexedViewFactory = new WmiIndexedViewFactory();
        this.view = new WmiMathMLDocumentView(this.doc, wmiIndexedViewFactory);
        this.setGetHandler = new SetGetHandler(this);
        presentationInputFiles = this.findTestFiles(TestSuiteDirHandler.testSuiteDir + "\\Presentation");
        contentInputFiles = this.findTestFiles(TestSuiteDirHandler.testSuiteDir + "\\Content");
        incorrectFiles = new ArrayList();
    }

    private ArrayList findTestFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    arrayList.addAll(this.findTestFiles(fileArray[i].getAbsolutePath()));
                    continue;
                }
                String string2 = fileArray[i].getName();
                if (!string2.endsWith(".mml") || skipFiles.contains(string2)) continue;
                arrayList.add(fileArray[i]);
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = MapleServerSocket.getCommandOptionParser();
            ((CommandOptionParser)object).addHandler(new TestSuiteDirHandler("testsuitedir"));
            ((CommandOptionParser)object).process(stringArray);
        }
        catch (CommandOptionException commandOptionException) {
            WmiErrorLog.log(commandOptionException);
            System.exit(-1);
        }
        object = new WmiMathMLParserTestApp();
        testFrame = new ViewTestFrame(((WmiMathMLParserTestApp)object).view, new Dimension(750, 600), (WmiMathMLParserTestApp)object);
        testFrame.initialize();
    }

    private void parseMathML(String string) {
        Object var2_2 = null;
        try {
            WmiModelLock.writeLock(this.doc, false);
            this.doc.removeChildren(0, this.doc.getChildCount());
            WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
            string = "<?xml version=\"1.0\" standalone=\"no\" ?>" + string.replaceAll("\\n", "");
            wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)this.doc, 0);
            WmiModelLock.writeUnlock(this.doc);
            WmiModelLock.readLock(this.doc, false);
            this.view.updateView();
            WmiModelLock.readUnlock(this.doc);
            testFrame.getFrame().update(testFrame.getFrame().getGraphics());
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            JOptionPane.showMessageDialog(this.view, wmiNoReadAccessException.getMessage(), "Parse Error", 0);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            JOptionPane.showMessageDialog(this.view, wmiNoWriteAccessException.getMessage(), "Parse Error", 0);
        }
        catch (WmiParseException wmiParseException) {
            JOptionPane.showMessageDialog(this.view, wmiParseException.getMessage(), "Parse Error", 0);
            wmiParseException.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            JOptionPane.showMessageDialog(this.view, wmiModelIndexOutOfBoundsException.getMessage(), "Parse Error", 0);
        }
    }

    static {
        skipFiles.add("mpadded12.mml");
        skipFiles.add("mfracZComp1.mml");
        skipFiles.add("table1.mml");
    }

    protected static class ViewTestFrame {
        protected static final int DEFAULT_WIDTH = 750;
        protected static final int DEFAULT_HEIGHT = 600;
        private static final int TOP_MARGIN = 50;
        private static final int LEFT_MARGIN = 100;
        private WmiMathDocumentModel doc;
        private WmiMathMLParserTestApp parser;
        private JFrame frame = null;
        private JRadioButton presentationRadio;
        private JRadioButton contentRadio;
        private JTextField currentFileCounterField;
        private JLabel fileCounterLabel;
        private JLabel expectedLabel;
        private JLabel expectedImageLabel;
        private JLabel actualLabel;
        private WmiMathMLDocumentView actualView;
        private JButton previousButton;
        private JButton nextButton;
        private JButton incorrectButton;
        private JLabel currentFileLabel;
        private JTextField currentFileNameField;
        private JLabel mathmlLabel;
        private JTextArea mathmlTextArea;
        IterateButtonListener iterateListener;

        protected ViewTestFrame(WmiMathMLDocumentView wmiMathMLDocumentView, Dimension dimension, WmiMathMLParserTestApp wmiMathMLParserTestApp) {
            this.actualView = wmiMathMLDocumentView;
            this.doc = (WmiMathDocumentModel)wmiMathMLDocumentView.getModel();
            this.parser = wmiMathMLParserTestApp;
            this.createFrame(dimension);
        }

        protected ViewTestFrame(Dimension dimension, WmiMathMLParserTestApp wmiMathMLParserTestApp) {
            this(new WmiMathMLDocumentView(), dimension, wmiMathMLParserTestApp);
        }

        public JFrame getFrame() {
            return this.frame;
        }

        public JTextArea getMathMLArea() {
            return this.mathmlTextArea;
        }

        public WmiMathDocumentModel getDocumentModel() {
            return this.doc;
        }

        public WmiMathMLDocumentView getDocumentView() {
            return this.actualView;
        }

        public void initialize() {
            this.presentationRadio.doClick();
        }

        protected void createFrame(Dimension dimension) {
            this.frame = new JFrame("MathML Parser Test");
            this.frame.addWindowListener(new ViewTestFrameWindowListener());
            JComponent jComponent = (JComponent)this.frame.getContentPane();
            JScrollPane jScrollPane = new JScrollPane(22, 31);
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = new JPanel();
            FormatButtonListener formatButtonListener = new FormatButtonListener();
            this.presentationRadio = new JRadioButton("Presentation");
            this.presentationRadio.setActionCommand("Presentation");
            this.presentationRadio.addActionListener(formatButtonListener);
            this.contentRadio = new JRadioButton("Content");
            this.contentRadio.setActionCommand("Content");
            this.contentRadio.addActionListener(formatButtonListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.presentationRadio);
            buttonGroup.add(this.contentRadio);
            jPanel.add(this.presentationRadio);
            jPanel.add(this.contentRadio);
            JPanel jPanel2 = new JPanel();
            this.currentFileCounterField = new JTextField(3);
            this.currentFileCounterField.addKeyListener(new FileCounterFieldListener());
            this.fileCounterLabel = new JLabel("");
            jPanel2.add(this.currentFileCounterField);
            jPanel2.add(this.fileCounterLabel);
            JPanel jPanel3 = new JPanel();
            jPanel3.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel4 = new JPanel();
            jPanel4.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            JPanel jPanel6 = new JPanel();
            jPanel6.setMinimumSize(new Dimension(400, 60));
            jPanel5.setMaximumSize(new Dimension(750, 200));
            this.expectedLabel = new JLabel("Expected:");
            this.expectedImageLabel = new JLabel("");
            jPanel5.add(jPanel3);
            jPanel5.add(this.expectedLabel);
            jPanel5.add(jPanel4);
            jPanel5.add(this.expectedImageLabel);
            jPanel5.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel8 = new JPanel();
            jPanel8.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BoxLayout(jPanel9, 2));
            jPanel9.setPreferredSize(new Dimension(60, 100));
            this.actualLabel = new JLabel("Actual:");
            jPanel9.add(jPanel7);
            jPanel9.add(this.actualLabel);
            jPanel9.add(jPanel8);
            jPanel9.add(jScrollPane);
            jViewport.add(this.actualView);
            jViewport.setBackground(Color.white);
            JPanel jPanel10 = new JPanel();
            this.iterateListener = new IterateButtonListener();
            this.previousButton = new JButton("<< Previous");
            this.previousButton.setActionCommand("Previous");
            this.previousButton.addActionListener(this.iterateListener);
            this.nextButton = new JButton("Next >>");
            this.nextButton.setActionCommand("Next");
            this.nextButton.addActionListener(this.iterateListener);
            this.incorrectButton = new JButton("Incorrect");
            this.incorrectButton.addActionListener(new IncorrectButtonListener());
            JPanel jPanel11 = new JPanel();
            jPanel11.setMaximumSize(new Dimension(10, 10));
            jPanel10.add(this.previousButton);
            jPanel10.add(this.nextButton);
            jPanel10.add(jPanel11);
            jPanel10.add(this.incorrectButton);
            JPanel jPanel12 = new JPanel();
            jPanel12.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel13 = new JPanel();
            jPanel13.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel14 = new JPanel();
            jPanel14.setLayout(new BoxLayout(jPanel14, 2));
            JPanel jPanel15 = new JPanel();
            jPanel15.setMinimumSize(new Dimension(400, 60));
            jPanel14.setMaximumSize(new Dimension(750, 60));
            this.currentFileLabel = new JLabel("Current File:");
            this.currentFileNameField = new JTextField(80);
            jPanel14.add(jPanel12);
            jPanel14.add(this.currentFileLabel);
            jPanel14.add(jPanel13);
            jPanel14.add(this.currentFileNameField);
            jPanel14.add(jPanel15);
            JPanel jPanel16 = new JPanel();
            jPanel16.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel17 = new JPanel();
            jPanel17.setMaximumSize(new Dimension(10, 10));
            JPanel jPanel18 = new JPanel();
            this.mathmlLabel = new JLabel("MathML:");
            this.mathmlTextArea = new JTextArea(10, 80);
            jPanel18.setLayout(new BoxLayout(jPanel18, 2));
            JScrollPane jScrollPane2 = new JScrollPane(22, 32);
            JViewport jViewport2 = jScrollPane2.getViewport();
            jViewport2.add(this.mathmlTextArea);
            jPanel18.add(jPanel16);
            jPanel18.add(this.mathmlLabel);
            jPanel18.add(jPanel17);
            jPanel18.add(jScrollPane2);
            jComponent.setLayout(new BoxLayout(jComponent, 3));
            jComponent.add(jPanel);
            JPanel jPanel19 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel19);
            jComponent.add(jPanel2);
            JPanel jPanel20 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel20);
            jComponent.add(jPanel5);
            JPanel jPanel21 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel21);
            jComponent.add(jPanel9);
            JPanel jPanel22 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel22);
            jComponent.add(jPanel10);
            JPanel jPanel23 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel23);
            jComponent.add(jPanel14);
            JPanel jPanel24 = new JPanel();
            jPanel19.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.add(jPanel24);
            jComponent.add(jPanel18);
            this.frame.setDefaultCloseOperation(2);
            this.frame.setBounds(100, 50, dimension.width, dimension.height);
            this.frame.show();
        }

        protected static ImageIcon createImageIcon(String string, String string2) {
            return new ImageIcon(string, string2);
        }

        private void updateFile() {
            File file = (File)currentInputFiles.get(currentFileCounter);
            String string = file.getPath();
            String string2 = string.substring(TestSuiteDirHandler.testSuiteDir.length());
            this.currentFileNameField.setText(string2);
            String string3 = string.replaceAll(".mml", ".png");
            ImageIcon imageIcon = ViewTestFrame.createImageIcon(string3, "");
            this.expectedImageLabel.setIcon(imageIcon);
            String string4 = "";
            try {
                FileReader fileReader = new FileReader(string);
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = fileReader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                string4 = stringBuffer.toString();
                this.mathmlTextArea.setText(string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                WmiErrorLog.log(fileNotFoundException);
            }
            catch (IOException iOException) {
                WmiErrorLog.log(iOException);
            }
            this.parser.parseMathML(string4);
        }

        private void updateFileCounterLabel() {
            this.currentFileCounterField.setText(String.valueOf(currentFileCounter + 1));
            this.fileCounterLabel.setText(" of " + currentInputFiles.size() + " files");
        }

        public class FileCounterFieldListener
        implements KeyListener {
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    try {
                        String string = ViewTestFrame.this.currentFileCounterField.getText();
                        if (string != null) {
                            currentFileCounter = Integer.parseInt(string) - 1;
                            ViewTestFrame.this.updateFileCounterLabel();
                            ViewTestFrame.this.updateFile();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }

        public class IterateButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Previous")) {
                    if (currentFileCounter > 0) {
                        currentFileCounter--;
                    }
                } else if (currentFileCounter < currentInputFiles.size() - 1) {
                    currentFileCounter++;
                }
                ViewTestFrame.this.updateFileCounterLabel();
                ViewTestFrame.this.updateFile();
            }
        }

        public class IncorrectButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (!incorrectFiles.contains(ViewTestFrame.this.currentFileNameField.getText())) {
                    incorrectFiles.add(ViewTestFrame.this.currentFileNameField.getText());
                    System.out.println(currentFileCounter + 1 + "  " + ViewTestFrame.this.currentFileNameField.getText());
                }
            }
        }

        public class FormatButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Presentation")) {
                    currentInputFiles = presentationInputFiles;
                } else {
                    currentInputFiles = contentInputFiles;
                }
                currentFileCounter = -1;
                ViewTestFrame.this.iterateListener.actionPerformed(new ActionEvent(ViewTestFrame.this.nextButton, 0, "Next"));
            }
        }

        private class ViewTestFrameWindowListener
        extends WindowAdapter {
            private ViewTestFrameWindowListener() {
            }

            public void windowActivated(WindowEvent windowEvent) {
                WmiMathMLDocumentView.setActiveDocumentView(ViewTestFrame.this.actualView);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        }
    }

    protected static class TestSuiteDirHandler
    extends AbstractOptionHandler {
        protected static String testSuiteDir;
        protected static String testSuiteFile;

        protected TestSuiteDirHandler(String string) {
            this.addOptionNames(new String[]{string});
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            testSuiteDir = stringArray[1];
        }

        public int numArgs() {
            return 1;
        }

        static {
            testSuiteFile = "";
        }
    }
}

