/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiHashedImportParser;
import com.maplesoft.mathdoc.io.xml.WmiXMLModelBuilder;
import com.maplesoft.mathdoc.io.xml.WmiXMLParseException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.util.WmiXMLParserImplementation;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.SAXException;

public abstract class WmiXMLImportParser
extends WmiHashedImportParser {
    protected WmiXMLModelBuilder xmlContentHandler = new WmiXMLModelBuilder(this);
    protected WmiXMLParserImplementation parser = new WmiXMLParserImplementation(this.xmlContentHandler);

    protected WmiXMLImportParser() {
    }

    public void reportUnrecognizedTag(String string, Object object) {
        this.reportUnrecognizedObject(string, object);
    }

    public boolean parse(Reader reader, WmiCompositeModel wmiCompositeModel, int n) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (wmiCompositeModel == null) {
            throw new WmiParseException("Bad parameter", reader);
        }
        if (!WmiModelLock.hasLock(wmiCompositeModel, 1)) {
            throw new WmiNoWriteAccessException(wmiCompositeModel);
        }
        if (n < 0) {
            throw new WmiModelIndexOutOfBoundsException(wmiCompositeModel, n);
        }
        if (n > wmiCompositeModel.getChildCount()) {
            throw new WmiModelIndexOutOfBoundsException(wmiCompositeModel, n);
        }
        this.parserInitialization(wmiCompositeModel, n);
        boolean bl = false;
        try {
            this.parser.parse(reader);
            bl = true;
        }
        catch (SAXException sAXException) {
            throw new WmiXMLParseException(reader, sAXException);
        }
        catch (IOException iOException) {
            throw new WmiParseException(iOException.toString(), reader);
        }
        finally {
            this.flush();
        }
        return bl;
    }
}

