/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import java.util.Arrays;

public abstract class WmiAbstractArrayCompositeModel
extends WmiAbstractModel
implements WmiCompositeModel {
    protected static final float DEFAULT_ARRAY_GROWTH_FACTOR = 1.5f;
    protected WmiModel[] children = null;
    protected int length = 0;

    protected WmiAbstractArrayCompositeModel() {
    }

    protected WmiAbstractArrayCompositeModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    protected WmiAbstractArrayCompositeModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel);
        this.children = wmiModelArray;
        this.length = wmiModelArray.length;
        try {
            for (int i = 0; i < this.length; ++i) {
                wmiModelArray[i].setParent(this);
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            throw new WmiInvalidModelInitializationException(this);
        }
    }

    public boolean hasChildren() throws WmiNoReadAccessException {
        return this.getChildCount() > 0;
    }

    public int getChildCount() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.usePending() && this.pending instanceof WmiAbstractArrayCompositeModel ? ((WmiAbstractArrayCompositeModel)this.pending).length : this.length;
    }

    public void addChild(WmiModel wmiModel, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
        this.replaceChildren(wmiModelArray, n, 0);
    }

    public void addChildren(WmiModel[] wmiModelArray, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(wmiModelArray, n, 0);
    }

    public void appendChild(WmiModel wmiModel) throws WmiNoWriteAccessException {
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
        try {
            int n = this.getChildCount();
            this.replaceChildren(wmiModelArray, n, 0);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            wmiNoReadAccessException.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            wmiModelIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void appendChildren(WmiModel[] wmiModelArray) throws WmiNoWriteAccessException {
        try {
            int n = this.getChildCount();
            this.replaceChildren(wmiModelArray, n, 0);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            wmiNoReadAccessException.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            wmiModelIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void removeChild(WmiModel wmiModel) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n = -1;
        try {
            n = this.indexOf(wmiModel);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            throw new WmiNoWriteAccessException(this);
        }
        if (n >= 0) {
            this.replaceChildren(null, n, 1);
        }
    }

    public void removeChild(int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(null, n, 1);
    }

    public void removeChildren(int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(null, n, n2);
    }

    public void replaceChild(WmiModel wmiModel, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
        this.replaceChildren(wmiModelArray, n, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceChildren(WmiModel[] wmiModelArray, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (!(this.pending instanceof WmiAbstractArrayCompositeModel)) throw new WmiNoWriteAccessException(this);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = (WmiAbstractArrayCompositeModel)this.pending;
        if (n < 0 || n > wmiAbstractArrayCompositeModel.length) {
            throw new WmiModelIndexOutOfBoundsException(this, n);
        }
        if (n2 < 0) {
            throw new WmiModelIndexOutOfBoundsException(this, n2);
        }
        int n3 = wmiAbstractArrayCompositeModel.length;
        if (n + n2 > n3) {
            throw new WmiModelIndexOutOfBoundsException(this, n + n2);
        }
        int n4 = wmiAbstractArrayCompositeModel.length - n2;
        int n5 = -n2;
        if (wmiModelArray != null) {
            n4 += wmiModelArray.length;
            n5 += wmiModelArray.length;
        }
        if (n4 < 0) throw new WmiModelIndexOutOfBoundsException(this, n4);
        wmiAbstractArrayCompositeModel.ensureCapacity(n4, this);
        if (n5 > 0) {
            System.arraycopy(wmiAbstractArrayCompositeModel.children, n, wmiAbstractArrayCompositeModel.children, n + n5, wmiAbstractArrayCompositeModel.length - n);
        } else if (n5 < 0) {
            System.arraycopy(wmiAbstractArrayCompositeModel.children, n - n5, wmiAbstractArrayCompositeModel.children, n, wmiAbstractArrayCompositeModel.length - n + n5);
            Arrays.fill(wmiAbstractArrayCompositeModel.children, wmiAbstractArrayCompositeModel.length + n5, wmiAbstractArrayCompositeModel.length, null);
        }
        if (wmiModelArray != null) {
            System.arraycopy(wmiModelArray, 0, wmiAbstractArrayCompositeModel.children, n, wmiModelArray.length);
            if (this.isTree()) {
                for (int i = 0; i < wmiModelArray.length; ++i) {
                    if (wmiModelArray[i] == null) continue;
                    wmiModelArray[i].setParent(this);
                }
            }
        }
        wmiAbstractArrayCompositeModel.length = n4;
    }

    public void replaceChildren(WmiModel[] wmiModelArray) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        try {
            this.replaceChildren(wmiModelArray, 0, this.getChildCount());
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void groupChildren(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        WmiModel[] wmiModelArray;
        this.verifyWriteLock();
        if (n < 0 || n > this.length) {
            throw new WmiModelIndexOutOfBoundsException(this, n);
        }
        if (n2 < 0 || n2 + n > this.length) {
            throw new WmiModelIndexOutOfBoundsException(this, n2);
        }
        if (n2 > 0) {
            wmiModelArray = new WmiModel[n2];
            try {
                for (int i = n; i < n + n2; ++i) {
                    wmiModelArray[i - n] = this.getChild(i);
                }
                wmiCompositeModel.addChildren(wmiModelArray, wmiCompositeModel.getChildCount());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                // empty catch block
            }
        }
        wmiModelArray = new WmiModel[]{wmiCompositeModel};
        this.replaceChildren(wmiModelArray, n, n2);
    }

    public void splitChild(int n, int n2) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
    }

    public void splitModel(int n) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        int n2;
        WmiCompositeModel wmiCompositeModel = this.getParent();
        if (wmiCompositeModel != null && (n2 = wmiCompositeModel.indexOf(this)) >= 0) {
            try {
                WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = (WmiAbstractArrayCompositeModel)this.clone();
                wmiAbstractArrayCompositeModel.children = null;
                wmiAbstractArrayCompositeModel.length = 0;
                wmiAbstractArrayCompositeModel.pending = wmiAbstractArrayCompositeModel;
                wmiAbstractArrayCompositeModel.attributes = this.getAttributes();
                int n3 = this.getChildCount();
                int n4 = n3 - n;
                if (n4 > 0) {
                    WmiModel[] wmiModelArray = new WmiModel[n4];
                    for (int i = 0; i < n4; ++i) {
                        wmiModelArray[i] = this.getChild(n + i);
                    }
                    this.removeChildren(n, n4);
                    wmiAbstractArrayCompositeModel.addChildren(wmiModelArray, 0);
                }
                wmiCompositeModel.addChild(wmiAbstractArrayCompositeModel, n2 + 1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                WmiErrorLog.log(cloneNotSupportedException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
    }

    public void promoteChild(int n) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
    }

    public int indexOf(WmiModel wmiModel) throws WmiNoReadAccessException {
        int n = -1;
        WmiModel[] wmiModelArray = this.getChildren();
        if (wmiModelArray != null) {
            int n2 = wmiModelArray.length;
            for (int i = 0; i < n2; ++i) {
                if (wmiModelArray[i] != wmiModel) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public int indexOfInTraversalOrder(WmiModel wmiModel) throws WmiNoReadAccessException {
        return this.indexOf(wmiModel);
    }

    public WmiModel getChild(int n) throws WmiNoReadAccessException {
        WmiModel wmiModel = null;
        WmiModel[] wmiModelArray = this.getChildren();
        if (wmiModelArray != null && n >= 0 && n < wmiModelArray.length) {
            wmiModel = wmiModelArray[n];
        }
        return wmiModel;
    }

    public WmiModel getChildInTraversalOrder(int n) throws WmiNoReadAccessException {
        return this.getChild(n);
    }

    public WmiModel getFirstChildWithTag(WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiModel[] wmiModelArray = this.getChildren();
        if (wmiModelArray != null) {
            for (int i = 0; i < wmiModelArray.length; ++i) {
                if (wmiModelArray[i].getTag() != wmiModelTag) continue;
                return wmiModelArray[i];
            }
        }
        return null;
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        if (this.pending instanceof WmiAbstractArrayCompositeModel) {
            WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = (WmiAbstractArrayCompositeModel)this.pending;
            WmiUndoableCompositeModelEdit wmiUndoableCompositeModelEdit = null;
            if (string != null) {
                wmiUndoableCompositeModelEdit = (WmiUndoableCompositeModelEdit)this.createUndoableEdit();
                wmiUndoableCompositeModelEdit.setPreupdateProperties();
            }
            if (this.children != wmiAbstractArrayCompositeModel.children) {
                if (wmiAbstractArrayCompositeModel.children != null && wmiAbstractArrayCompositeModel.children.length > wmiAbstractArrayCompositeModel.length) {
                    this.children = new WmiModel[wmiAbstractArrayCompositeModel.length];
                    System.arraycopy(wmiAbstractArrayCompositeModel.children, 0, this.children, 0, wmiAbstractArrayCompositeModel.length);
                } else {
                    this.children = wmiAbstractArrayCompositeModel.children;
                }
            }
            this.length = wmiAbstractArrayCompositeModel.length;
            if (this.pending.parent != this.parent) {
                this.parent = this.pending.parent;
            }
            if (this.pending.attributes != this.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.prepareForEditCommit();
            if (wmiUndoableCompositeModelEdit != null) {
                wmiUndoableCompositeModelEdit.setPostupdateProperties();
                WmiUndoManager wmiUndoManager = this.getDocument().getUndoManager();
                wmiUndoManager.addEdit(wmiUndoableCompositeModelEdit);
            }
            for (int i = 0; i < this.length; ++i) {
                WmiModel wmiModel = this.children[i];
                if (wmiModel == null) continue;
                wmiModel.update(string);
            }
        }
        this.pending = null;
    }

    public void prepareForEditCommit() throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
    }

    public WmiUndoableEdit createUndoableEdit() {
        return new WmiUndoableCompositeModelEdit(this);
    }

    public void release() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].release();
                this.children[i] = null;
            }
            this.children = null;
        }
        this.length = 0;
    }

    public boolean isTree() {
        return true;
    }

    public boolean isComposite() {
        return true;
    }

    protected WmiModel[] getChildren() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiModel[] wmiModelArray = this.usePending() && this.pending instanceof WmiAbstractArrayCompositeModel ? ((WmiAbstractArrayCompositeModel)this.pending).children : this.children;
        return wmiModelArray;
    }

    protected void ensureCapacity(int n, WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel) {
        if (this.children != null) {
            if (wmiAbstractArrayCompositeModel != null && wmiAbstractArrayCompositeModel.children == this.children) {
                WmiModel[] wmiModelArray = new WmiModel[this.children.length];
                System.arraycopy(this.children, 0, wmiModelArray, 0, this.children.length);
                this.children = wmiModelArray;
            }
            if (n > this.children.length) {
                int n2 = (int)((float)this.children.length * this.growthFactor()) + 1;
                if (n2 < n) {
                    n2 = n;
                }
                WmiModel[] wmiModelArray = new WmiModel[n2];
                System.arraycopy(this.children, 0, wmiModelArray, 0, this.children.length);
                this.children = wmiModelArray;
            }
        } else {
            this.children = new WmiModel[n];
        }
    }

    protected float growthFactor() {
        return 1.5f;
    }

    public WmiDeleteHandler getDeleteHandler() {
        return null;
    }

    protected static class WmiUndoableCompositeModelEdit
    implements WmiUndoableEdit {
        protected WmiAbstractArrayCompositeModel model;
        protected WmiModel[] oldChildren = null;
        private WmiModel[] newChildren = null;
        private int oldLength = 0;
        private int newLength = 0;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;

        protected WmiUndoableCompositeModelEdit(WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel) {
            this.model = wmiAbstractArrayCompositeModel;
        }

        protected void setPreupdateProperties() {
            this.oldChildren = this.model.children;
            this.oldLength = this.model.length;
            this.oldParent = this.model.parent;
            this.oldAttributes = this.model.attributes;
        }

        protected void setPostupdateProperties() {
            this.newChildren = this.model.children;
            this.newLength = this.model.length;
            this.newParent = this.model.parent;
            this.newAttributes = this.model.attributes;
        }

        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            if (this.model.pending != null) {
                WmiErrorLog.log(new Exception("undo on a model with a pending edit: model =  " + this.model));
            }
            this.applyPreupdateValues();
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        protected void applyPreupdateValues() throws WmiNoUpdateAccessException {
            this.model.length = this.oldLength;
            this.model.children = this.oldChildren;
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.pending = null;
        }

        protected void applyPostupdateValues() throws WmiNoUpdateAccessException {
            this.model.length = this.newLength;
            this.model.children = this.newChildren;
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.pending = null;
        }

        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            if (this.model.pending != null) {
                WmiErrorLog.log(new Exception("redo on a model with a pending edit: model =  " + this.model));
            }
            this.applyPostupdateValues();
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public WmiAbstractArrayCompositeModel getModel() {
            return this.model;
        }

        public boolean containsAttributeEdit() {
            return this.oldAttributes != this.newAttributes;
        }
    }
}

