/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class WmiAbstractMappedAttributeSet
implements WmiAttributeSet {
    public void addAttribute(Object object, Object object2) {
        HashMap hashMap = this.getAttributeMapperMap();
        if (hashMap != null) {
            WmiAttributeMapper wmiAttributeMapper = (WmiAttributeMapper)hashMap.get(object);
            if (wmiAttributeMapper != null) {
                wmiAttributeMapper.addAttribute(this, object2);
            } else if (object != null && !(object instanceof String) && (wmiAttributeMapper = (WmiAttributeMapper)hashMap.get(object.toString())) != null) {
                wmiAttributeMapper.addAttribute(this, object2);
            }
        }
    }

    public void addAttributes(WmiAttributeSet wmiAttributeSet) {
        if (wmiAttributeSet != null) {
            Enumeration enumeration = wmiAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.addAttribute(e, wmiAttributeSet.getAttribute(e));
            }
        }
    }

    public void addAttributes(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (objectArray.length == objectArray2.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.addAttribute(objectArray[i], objectArray2[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object getAttribute(Object object) {
        WmiAttributeMapper wmiAttributeMapper;
        Object object2 = null;
        HashMap hashMap = this.getAttributeMapperMap();
        if (hashMap != null && (wmiAttributeMapper = (WmiAttributeMapper)hashMap.get(object)) != null) {
            object2 = wmiAttributeMapper.getAttribute(this);
        }
        return object2;
    }

    protected abstract HashMap getAttributeMapperMap();

    protected static abstract class WmiStringBoolAttributeMapper
    extends WmiStringAttributeMapper {
        protected WmiStringBoolAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            String string;
            String string2 = null;
            if (object instanceof Boolean) {
                string2 = ((Boolean)object).toString();
            } else if (object != null && ((string = object.toString()).equalsIgnoreCase(Boolean.TRUE.toString()) || string.equalsIgnoreCase(Boolean.FALSE.toString()))) {
                string2 = string.toLowerCase();
            }
            if (string2 != null) {
                this.store(wmiAttributeSet, string2);
            }
        }
    }

    protected static abstract class WmiStringAttributeMapper
    implements WmiAttributeMapper {
        protected WmiStringAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            if (object != null) {
                this.store(wmiAttributeSet, object.toString());
            }
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            return this.fetch(wmiAttributeSet);
        }

        public abstract String fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, String var2);
    }

    protected static abstract class WmiIntAttributeMapper
    implements WmiAttributeMapper {
        protected WmiIntAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            int n = 0;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object != null) {
                try {
                    n = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        float f = new Float(object.toString()).floatValue();
                        n = (int)Math.ceil(f);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        WmiErrorLog.log(numberFormatException2);
                    }
                }
            }
            this.store(wmiAttributeSet, n);
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            return new Integer(this.fetch(wmiAttributeSet));
        }

        public abstract int fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, int var2);
    }

    protected static abstract class WmiDoubleAttributeMapper
    implements WmiAttributeMapper {
        protected WmiDoubleAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            double d = 0.0;
            if (object instanceof Double) {
                d = (Double)object;
            } else if (object != null) {
                try {
                    d = Double.parseDouble(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    WmiErrorLog.log(numberFormatException);
                }
            }
            this.store(wmiAttributeSet, d);
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            return new Double(this.fetch(wmiAttributeSet));
        }

        public abstract double fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, double var2);
    }

    protected static abstract class WmiDagAttributeMapper
    implements WmiAttributeMapper {
        protected WmiDagAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            Dag dag = null;
            if (object instanceof byte[]) {
                try {
                    dag = DagBuilder.createDag((byte[])object);
                }
                catch (IOException iOException) {
                    WmiErrorLog.log(iOException);
                }
            } else if (object instanceof Dag) {
                dag = (Dag)object;
            } else if (object != null) {
                try {
                    dag = DagBuilder.createDag(object.toString().getBytes());
                }
                catch (IOException iOException) {
                    WmiErrorLog.log(iOException);
                }
            }
            if (dag != null) {
                this.store(wmiAttributeSet, dag);
            }
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            return this.fetch(wmiAttributeSet);
        }

        public abstract Dag fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, Dag var2);
    }

    protected static abstract class WmiColorAttributeMapper
    implements WmiAttributeMapper {
        protected WmiColorAttributeMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            int[] nArray;
            Color color = null;
            if (object instanceof Color) {
                color = (Color)object;
            } else if (object instanceof String) {
                color = new Color(WmiColorAttributeKey.createColorIndexFromRGBString((String)object));
            } else if (object instanceof int[] && (nArray = (int[])object).length == 3) {
                color = new Color(nArray[0], nArray[1], nArray[2]);
            }
            if (color != null) {
                this.store(wmiAttributeSet, color);
            }
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            return this.fetch(wmiAttributeSet);
        }

        public abstract Color fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, Color var2);
    }

    protected static interface WmiAttributeMapper {
        public void addAttribute(WmiAttributeSet var1, Object var2);

        public Object getAttribute(WmiAttributeSet var1);
    }
}

