/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.controller.edit.WmiCustomDeleteHandler;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelListener;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelWriter;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class WmiMathDocumentModel
extends WmiAbstractArrayCompositeModel {
    public static final int UPDATE_NOTIFY = 0;
    public static final int UPDATE_NOTIFY_COMPLETE = 1;
    public static final int UPDATE_NOTIFY_BEGIN = 2;
    public static final int CREATE_EDIT_NOTIFY = 3;
    public static final int END_EDIT_NOTIFY = 4;
    public static final int RELEASE_EDIT_NOTIFY = 5;
    public static final int UNDO_NOTIFY = 6;
    public static final int REDO_NOTIFY = 7;
    public static final int POSITION_NOTIFY = 8;
    public static final int DEFAULT_ZOOM = 133;
    public static final int FONT_STYLE = 0;
    public static final int LAYOUT_STYLE = 1;
    public static final int DRAWING_STYLE = 2;
    public static final int STYLE_COUNT = 3;
    private static final WmiMathDocumentHierarchyValidator DEFAULT_HIERARCHY_VALIDATOR = new WmiMathDocumentHierarchyValidator();
    private WmiFontAttributeSet activeEditAttributes = new WmiActiveEditAtttributeSet();
    private boolean readOnly = false;
    private HashSet dirtyModels = new HashSet();
    private ArrayList listeners = new ArrayList();
    private HashMap[] styles = null;
    private WmiUndoManager undoManager = new WmiUndoManager(this);
    private WmiModelLock modelLock = null;
    private WmiInputLock inputLock = null;
    private boolean documentChangedSinceSave = false;
    private boolean documentChangedSinceAutosave = false;
    private WmiMetadataManager metadataManager = new WmiMetadataManager(this);
    private boolean processMath = true;
    private String lastExcelFile = null;

    public static void copyStyles(WmiMathDocumentModel wmiMathDocumentModel, WmiMathDocumentModel wmiMathDocumentModel2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n = wmiMathDocumentModel.getStyleFamilyCount();
        for (int i = 0; i < n; ++i) {
            Iterator iterator = wmiMathDocumentModel.getStyleNames(i);
            while (iterator.hasNext()) {
                wmiMathDocumentModel2.setStyle(i, wmiMathDocumentModel.getStyle(i, (String)iterator.next()));
            }
        }
    }

    public WmiMathDocumentModel() {
        this.modelLock = new WmiModelLock(this);
        this.inputLock = new WmiInputLock(this);
        int n = this.getStyleFamilyCount();
        this.styles = new HashMap[n];
        for (int i = 0; i < n; ++i) {
            this.styles[i] = new HashMap();
        }
    }

    public void release() throws WmiNoWriteAccessException {
        super.release();
        this.activeEditAttributes = null;
        if (this.dirtyModels != null) {
            this.dirtyModels.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.styles != null) {
            for (int i = 0; i < this.styles.length; ++i) {
                this.styles[i].clear();
            }
            this.styles = null;
        }
        this.undoManager = null;
        this.metadataManager = null;
        this.modelLock.disable();
        this.inputLock.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugPrintLight(WmiModelPathInterval wmiModelPathInterval) {
        if (WmiModelLock.readLock(this, true)) {
            try {
                WmiModelWriter wmiModelWriter = new WmiModelWriter(System.out);
                wmiModelWriter.setProcessStyleTable(false);
                wmiModelWriter.report(this, false, wmiModelPathInterval);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugPrintVerbose(WmiModelPathInterval wmiModelPathInterval) {
        if (WmiModelLock.readLock(this, true)) {
            try {
                WmiModelWriter wmiModelWriter = new WmiModelWriter(System.out);
                wmiModelWriter.setProcessStyleTable(false);
                wmiModelWriter.setMaximumAttributeLength(100);
                wmiModelWriter.report(this, true, wmiModelPathInterval);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
        }
    }

    protected int getStyleFamilyCount() {
        return 3;
    }

    public WmiFontAttributeSet getActiveEditAttributes() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.activeEditAttributes;
    }

    public WmiStyleAttributeSet getStyle(int n, String string) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        this.verifyReadLock();
        WmiStyleAttributeSet wmiStyleAttributeSet = null;
        if (string != null && (wmiAttributeSet = (WmiAttributeSet)this.styles[n].get(string)) != null) {
            wmiStyleAttributeSet = (WmiStyleAttributeSet)wmiAttributeSet.copyAttributes();
        }
        return wmiStyleAttributeSet;
    }

    public Iterator getStyleNames(int n) throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.styles[n].keySet().iterator();
    }

    public WmiFontAttributeSet getFontStyle(String string) throws WmiNoReadAccessException {
        return (WmiFontAttributeSet)this.getStyle(0, string);
    }

    public Iterator getFontStyleNames() throws WmiNoReadAccessException {
        return this.getStyleNames(0);
    }

    public WmiLayoutAttributeSet getLayoutStyle(String string) throws WmiNoReadAccessException {
        return (WmiLayoutAttributeSet)this.getStyle(1, string);
    }

    public Iterator getLayoutStyleNames() throws WmiNoReadAccessException {
        return this.getStyleNames(1);
    }

    public int getZoomFactor() throws WmiNoReadAccessException {
        return 133;
    }

    public boolean isHidden(String string) throws WmiNoReadAccessException {
        return false;
    }

    public boolean isHidden(WmiModel wmiModel) throws WmiNoReadAccessException {
        return this.isHidden(wmiModel, true);
    }

    public boolean isHidden(WmiModel wmiModel, boolean bl) throws WmiNoReadAccessException {
        return false;
    }

    public boolean isMutableModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = true;
        if (wmiModel.getDocument() != this) {
            throw new IllegalArgumentException("Model not a child of this model.");
        }
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
        if (wmiAttributeSet != null) {
            boolean bl2 = bl = !"true".equals(wmiAttributeSet.getAttribute("readonly"));
        }
        if (bl) {
            bl = !this.isReadOnly();
        }
        return bl;
    }

    public WmiCustomDeleteHandler getCustomDeleteHandler() {
        return null;
    }

    public boolean documentHasChangedSinceSave() {
        return this.documentChangedSinceSave;
    }

    public boolean documentHasChangedSinceAutosave() {
        return this.documentChangedSinceAutosave;
    }

    public void setDocumentChanged() {
        this.documentChangedSinceSave = true;
        this.documentChangedSinceAutosave = true;
    }

    public void documentSaved() {
        this.documentChangedSinceSave = false;
    }

    public void documentAutosaved() {
        this.documentChangedSinceAutosave = false;
    }

    public String getLastExcelFile() {
        return this.lastExcelFile;
    }

    public void setLastExcelFile(String string) {
        this.lastExcelFile = string;
    }

    public void resetStyleFamily(int n) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.styles[n].clear();
    }

    public void removeStyle(int n, Object object) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (object != null) {
            this.styles[n].remove(object);
        }
    }

    public void setStyle(int n, WmiStyleAttributeSet wmiStyleAttributeSet) throws WmiNoWriteAccessException {
        String string;
        this.verifyWriteLock();
        if (wmiStyleAttributeSet != null && (string = wmiStyleAttributeSet.getStyleName()) != null) {
            this.styles[n].put(string, wmiStyleAttributeSet);
        }
    }

    public void setFontStyle(WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoWriteAccessException {
        this.setStyle(0, wmiFontAttributeSet);
    }

    public void setLayoutStyle(WmiLayoutAttributeSet wmiLayoutAttributeSet) throws WmiNoWriteAccessException {
        this.setStyle(1, wmiLayoutAttributeSet);
    }

    public WmiModelLock getLock() {
        return this.modelLock;
    }

    public WmiInputLock getInputLock() {
        return this.inputLock;
    }

    public WmiMathDocumentHierarchyValidator getModelHierarchyValidator() {
        return DEFAULT_HIERARCHY_VALIDATOR;
    }

    public void setProcessMathForDotm(boolean bl) {
        this.processMath = bl;
    }

    public boolean getProcessMathforDotm() {
        return this.processMath;
    }

    public WmiMathDocumentModel getDocument() {
        return this;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.DOCUMENT;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    public boolean isDeletionBoundary() {
        return true;
    }

    public void markDirty(WmiModel wmiModel) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.dirtyModels.add(wmiModel);
    }

    public void markClean(WmiModel wmiModel) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.dirtyModels.remove(wmiModel);
    }

    public boolean isDirty() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return !this.dirtyModels.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String string) throws WmiNoUpdateAccessException {
        boolean bl = false;
        try {
            this.verifyWriteLock();
            boolean bl2 = false;
            WmiCompositeUndoableEdit wmiCompositeUndoableEdit = null;
            if (this.undoManager != null) {
                wmiCompositeUndoableEdit = this.undoManager.getActiveEdit();
                if (string == null) {
                    if (wmiCompositeUndoableEdit != null) {
                        string = wmiCompositeUndoableEdit.getName();
                    }
                } else if (wmiCompositeUndoableEdit == null) {
                    wmiCompositeUndoableEdit = this.undoManager.beginEdit(string);
                    bl2 = true;
                }
            }
            this.notifyModelListeners(this, 2);
            if (WmiModelLock.updateLock(this, true)) {
                Object[] objectArray = this.dirtyModels.toArray();
                int n = objectArray.length;
                if (n > 0) {
                    this.setDocumentChanged();
                    if (wmiCompositeUndoableEdit == null) {
                        this.undoManager.flush();
                    }
                }
                for (int i = 0; i < n; ++i) {
                    WmiModel wmiModel = (WmiModel)objectArray[i];
                    if (wmiModel != this && wmiModel != null) {
                        wmiModel.update(string);
                        this.notifyModelListeners(wmiModel, 0);
                        continue;
                    }
                    bl = true;
                }
                this.dirtyModels.clear();
                if (bl) {
                    super.update(string);
                    this.notifyModelListeners(this, 0);
                }
                if (bl2) {
                    this.undoManager.endEdit();
                }
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (NullPointerException nullPointerException) {
            WmiErrorLog.log(nullPointerException);
        }
        finally {
            WmiModelLock.updateUnlock(this);
        }
        try {
            this.notifyModelListeners(this, 1);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void revertPendingUpdates() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (this.dirtyModels.size() > 0) {
            Iterator iterator = this.dirtyModels.iterator();
            while (iterator.hasNext()) {
                WmiModel wmiModel = (WmiModel)iterator.next();
                wmiModel.revert();
            }
            this.dirtyModels.clear();
        }
    }

    public void addModelListener(WmiModelListener wmiModelListener) {
        this.listeners.add(wmiModelListener);
    }

    public void removeModelListener(WmiModelListener wmiModelListener) {
        this.listeners.remove(wmiModelListener);
    }

    public void positionUpdateNotification(WmiModel wmiModel, int n, boolean bl) throws WmiNoReadAccessException {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WmiModelListener wmiModelListener = (WmiModelListener)iterator.next();
            wmiModelListener.positionUpdateNotify(wmiModel, n, bl);
        }
    }

    public void notifyModelListeners(Object object, int n) throws WmiNoReadAccessException {
        Iterator iterator = this.listeners.iterator();
        block10: while (iterator.hasNext()) {
            WmiModelListener wmiModelListener = (WmiModelListener)iterator.next();
            switch (n) {
                case 0: {
                    wmiModelListener.updateNotify((WmiModel)object);
                    continue block10;
                }
                case 1: {
                    wmiModelListener.updateCompleteNotify((WmiModel)object);
                    continue block10;
                }
                case 2: {
                    wmiModelListener.updateBeginNotify((WmiModel)object);
                    continue block10;
                }
                case 3: {
                    wmiModelListener.createEditNotify((WmiUndoableEdit)object);
                    continue block10;
                }
                case 4: {
                    wmiModelListener.endEditNotify((WmiUndoableEdit)object);
                    continue block10;
                }
                case 5: {
                    wmiModelListener.releaseEditNotify((WmiUndoableEdit)object);
                    continue block10;
                }
                case 6: {
                    wmiModelListener.undoNotify((WmiUndoableEdit)object);
                    continue block10;
                }
                case 7: {
                    wmiModelListener.redoNotify((WmiUndoableEdit)object);
                    continue block10;
                }
            }
            WmiErrorLog.log(new Exception("Invalid notification"));
        }
    }

    public WmiUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void startUndoableEdit(String string) {
        this.undoManager.beginEdit(string);
    }

    public void endUndoableEdit() {
        this.undoManager.endEdit();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isExecutable() {
        return !this.isReadOnly();
    }

    public void setExecutable(boolean bl) {
        throw new UnsupportedOperationException("Cannot set executability status for an instance of WmiMathDocumentModel.  Default implmentation of isExecutable returns !isReadOnly.  To set executable on WmiMathDocumentModel, call setReadOnly(!newIsExecutable).  If executable property and read-only property need to be divergent, you need to work with a subclass of WmiMathDocumentModel.");
    }

    public WmiMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public void refreshSemantics(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = wmiModel;
        if (!(wmiModel2 instanceof WmiMathModel) && wmiModel2.getParent() != null && wmiModel2.getParent() instanceof WmiMathModel) {
            wmiModel2 = wmiModel2.getParent();
        }
        while (wmiModel2 instanceof WmiMathModel) {
            ((WmiMathModel)wmiModel2).setSemantics(null);
            wmiModel2 = wmiModel2.getParent();
        }
    }

    public class WmiActiveEditAtttributeSet
    extends WmiMathAttributeSet {
        public HashMap getCache() {
            return null;
        }

        public WmiAbstractArrayAttributeSet pack() {
            return this;
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            this.setSemantics(null);
        }
    }
}

