/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.util.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class WmiModelWriter {
    private static final int DEFAULT_INDENT = 2;
    private static final String LAYOUT_TABLE = "Layout Styles";
    private static final String FONT_TABLE = "Font Styles";
    private static final String ELLIPSIS = "...";
    private int maxAttributeLength = -1;
    private HashSet ignoreAttributes = new HashSet();
    private boolean zlTagIgnore = false;
    private HashSet ignoreZeroLength = new HashSet();
    private PrintStream out = null;
    private boolean processStyles = true;

    public WmiModelWriter(PrintStream printStream) {
        this.out = printStream;
    }

    public static boolean compareResults(String string, String string2) throws FileNotFoundException, IOException {
        return WmiModelWriter.compareResults(string, string2, true);
    }

    public static boolean compareResults(String string, String string2, boolean bl) throws FileNotFoundException, IOException {
        InputStream inputStream = ResourceLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        boolean bl2 = true;
        int n = inputStream.read();
        char c = string2.charAt(0);
        int n2 = 1;
        while (n2 != string2.length()) {
            if (bl && c <= ' ') {
                c = string2.charAt(n2++);
                continue;
            }
            if (n < 0) break;
            if (bl && n <= 32 || n == 13) {
                n = inputStream.read();
                continue;
            }
            if (Character.toLowerCase((char)n) != Character.toLowerCase(c)) {
                bl2 = false;
                break;
            }
            c = string2.charAt(n2++);
            n = inputStream.read();
        }
        return bl2;
    }

    private void report(WmiModel wmiModel, boolean bl, int n, WeakHashMap weakHashMap) throws WmiNoReadAccessException {
        try {
            boolean bl2;
            int n2 = 2;
            if (weakHashMap != null) {
                n2 = 0;
                Boolean bl3 = (Boolean)weakHashMap.get(wmiModel);
                if (bl3 != null) {
                    int n3 = n2 = bl3 != false ? 2 : 1;
                }
            }
            if (wmiModel instanceof WmiMathDocumentModel && this.processStyles) {
                this.reportStyleTable((WmiMathDocumentModel)wmiModel, bl, n);
            }
            boolean bl4 = bl2 = !this.zlTagIgnore || !this.ignoreZeroLength.contains(wmiModel.getTag()) || !(wmiModel instanceof WmiTextModel) || ((WmiTextModel)wmiModel).getLength() != 0;
            if (n2 != 0 && bl2) {
                this.writeIndent(n);
                this.out.print(bl ? "<" : ">");
                this.out.print(wmiModel);
                if (bl) {
                    if (n2 == 2 && this.writeVerboseAttributes(wmiModel.getAttributesForRead(), n + 1)) {
                        this.writeIndent(n);
                    }
                    this.out.print(">");
                }
                this.out.println();
            }
            if (wmiModel instanceof WmiCompositeModel && n2 != 0) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                int n4 = wmiCompositeModel.getChildCount();
                for (int i = 0; i < n4; ++i) {
                    this.report(wmiCompositeModel.getChild(i), bl, n + 2, weakHashMap);
                }
            } else if (wmiModel instanceof WmiTextModel && n2 != 0 && bl2) {
                this.writeIndent(n + 1);
                WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                this.out.println("[" + wmiTextModel.getText() + "]");
            }
            if (n2 != 0 && bl2) {
                this.writeIndent(n);
                this.out.print(bl ? "</" : "<");
                this.out.print(wmiModel);
                if (bl) {
                    this.out.print(">");
                }
                this.out.println();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void writeDag(Object object, Dag dag) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = dag.getType();
        stringBuffer.append(DagBuilder.CLASS_NAMES[n] + "#" + n);
        stringBuffer.append(" {" + System.identityHashCode(dag) + "} '");
        stringBuffer.append(dag.getData() + "' - ");
        int n2 = dag.getLength();
        if (n2 > 0) {
            stringBuffer.append(" (" + n2 + ")");
        }
        this.out.println(object + "=" + stringBuffer);
    }

    private void writeIndent(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.print(" ");
        }
    }

    private boolean writeVerboseAttributes(WmiAttributeSet wmiAttributeSet, int n) {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            Enumeration enumeration;
            Iterator iterator = null;
            if (wmiAttributeSet != null && wmiAttributeSet.getAttributeCount() > 0 && (enumeration = wmiAttributeSet.getAttributeNames()) != null) {
                object2 = new TreeSet();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (object == null) continue;
                    ((TreeSet)object2).add(object.toString());
                }
                if (!((TreeSet)object2).isEmpty()) {
                    bl = true;
                    this.out.println();
                }
                iterator = ((TreeSet)object2).iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    enumeration = iterator.next();
                    if (this.ignoreAttributes.contains(enumeration)) continue;
                    this.writeIndent(n);
                    object2 = wmiAttributeSet.getAttribute(enumeration);
                    if (object2 instanceof Dag) {
                        this.writeDag(enumeration, (Dag)object2);
                        continue;
                    }
                    if (object2 != null && this.maxAttributeLength >= 0 && ((StringBuffer)(object = new StringBuffer(object2.toString()))).length() > this.maxAttributeLength) {
                        ((StringBuffer)object).setLength(this.maxAttributeLength);
                        ((StringBuffer)object).append(ELLIPSIS);
                        object2 = ((StringBuffer)object).toString();
                    }
                    this.out.println(enumeration + "=" + object2);
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
        return bl;
    }

    public void ignoreAttribute(Object object) {
        this.ignoreAttributes.add(object);
    }

    public void ignoreZeroLengthModel(WmiModelTag wmiModelTag) {
        this.zlTagIgnore = true;
        this.ignoreZeroLength.add(wmiModelTag);
    }

    public void report(WmiModel wmiModel, boolean bl) throws WmiNoReadAccessException {
        this.report(wmiModel, bl, 2);
    }

    public void report(WmiModel wmiModel, boolean bl, int n) throws WmiNoReadAccessException {
        this.report(wmiModel, bl, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(WmiMathDocumentModel wmiMathDocumentModel, boolean bl, WmiModelPathInterval wmiModelPathInterval) throws WmiNoReadAccessException {
        WeakHashMap weakHashMap = null;
        try {
            WmiModel wmiModel = wmiMathDocumentModel;
            if (wmiModelPathInterval != null) {
                weakHashMap = new WeakHashMap();
                WmiModelSelectionWriter wmiModelSelectionWriter = new WmiModelSelectionWriter(weakHashMap);
                wmiModelPathInterval.walkInterval(wmiMathDocumentModel, wmiModelSelectionWriter);
                WmiModelPath wmiModelPath = WmiModelPath.commonParent(wmiModelPathInterval.getLowerBound(), wmiModelPathInterval.getUpperBound());
                wmiModel = wmiModelPath.getModelPosition(wmiMathDocumentModel).getModel();
            }
            this.report(wmiModel, bl, 2, weakHashMap);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            if (weakHashMap != null) {
                weakHashMap.clear();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    public void reportStyleTable(WmiMathDocumentModel wmiMathDocumentModel, boolean bl, int n) throws WmiNoReadAccessException {
        try {
            Object object;
            Object object2;
            Iterator iterator;
            Iterator iterator2 = wmiMathDocumentModel.getFontStyleNames();
            if (iterator2.hasNext()) {
                this.writeIndent(n);
                this.out.print(bl ? "<" : ">");
                this.out.print(FONT_TABLE);
                if (bl) {
                    this.out.print(">");
                }
                this.out.println();
                iterator = new TreeSet();
                while (iterator2.hasNext()) {
                    ((TreeSet)((Object)iterator)).add(iterator2.next());
                }
                iterator2 = ((TreeSet)((Object)iterator)).iterator();
                while (iterator2.hasNext()) {
                    this.writeIndent(n + 2);
                    object2 = (String)iterator2.next();
                    object = wmiMathDocumentModel.getFontStyle((String)object2);
                    this.out.print((String)object2);
                    if (bl) {
                        this.writeVerboseAttributes((WmiAttributeSet)object, n + 2 + 1);
                        continue;
                    }
                    this.out.println();
                }
                this.writeIndent(n);
                this.out.print(bl ? "</" : "<");
                this.out.print(FONT_TABLE);
                if (bl) {
                    this.out.print(">");
                }
                this.out.println();
            }
            if ((iterator = wmiMathDocumentModel.getLayoutStyleNames()).hasNext()) {
                this.writeIndent(n);
                this.out.print(bl ? "<" : ">");
                this.out.print(LAYOUT_TABLE);
                if (bl) {
                    this.out.print(">");
                }
                this.out.println();
                object2 = new TreeSet();
                while (iterator.hasNext()) {
                    ((TreeSet)object2).add(iterator.next());
                }
                iterator = ((TreeSet)object2).iterator();
                while (iterator.hasNext()) {
                    this.writeIndent(n + 2);
                    object = (String)iterator.next();
                    WmiLayoutAttributeSet wmiLayoutAttributeSet = wmiMathDocumentModel.getLayoutStyle((String)object);
                    this.out.print((String)object);
                    if (bl) {
                        this.writeVerboseAttributes(wmiLayoutAttributeSet, n + 2 + 1);
                        continue;
                    }
                    this.out.println();
                }
                this.writeIndent(n);
                this.out.print(bl ? "</" : "<");
                this.out.print(LAYOUT_TABLE);
                if (bl) {
                    this.out.print(">");
                }
                this.out.println();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void resetIgnoreAttributes() {
        this.ignoreAttributes.clear();
    }

    public void setMaximumAttributeLength(int n) {
        this.maxAttributeLength = n;
    }

    public void setProcessStyleTable(boolean bl) {
        this.processStyles = bl;
    }

    protected static class WmiModelSelectionWriter
    implements WmiModelPathInterval.WmiModelPathWalker {
        private WeakHashMap modelsMap;

        protected WmiModelSelectionWriter(WeakHashMap weakHashMap) {
            this.modelsMap = weakHashMap;
        }

        public void visitModel(WmiModel wmiModel, boolean bl) {
            this.modelsMap.put(wmiModel, new Boolean(bl |= wmiModel instanceof WmiTextModel));
        }
    }
}

