/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public abstract class WmiSnapshotUndoableEdit
extends WmiCompositeUndoableEdit {
    private WmiModel[] originals;
    private WmiUndoableEdit[] snapshotEdits;

    protected WmiSnapshotUndoableEdit(String string, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this(string, new WmiModel[]{wmiModel});
    }

    protected WmiSnapshotUndoableEdit(String string, WmiModel[] wmiModelArray) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super(string);
        this.originals = new WmiModel[wmiModelArray.length];
        this.snapshotEdits = new WmiUndoableEdit[wmiModelArray.length];
        for (int i = 0; i < this.originals.length; ++i) {
            this.originals[i] = wmiModelArray[i];
            this.snapshotEdits[i] = this.createUndoableEdit(this.originals[i]);
        }
    }

    protected abstract WmiUndoableEdit createUndoableEdit(WmiModel var1) throws WmiNoReadAccessException;

    public void redo() throws WmiNoUpdateAccessException {
        this.swapCurrentWithSnapshot();
    }

    public void undo() throws WmiNoUpdateAccessException {
        this.swapCurrentWithSnapshot();
    }

    private void swapCurrentWithSnapshot() throws WmiNoUpdateAccessException {
        for (int i = 0; i < this.originals.length; ++i) {
            WmiUndoableEdit wmiUndoableEdit = this.snapshotEdits[i];
            if (this.originals[i] instanceof WmiAbstractModel) {
                try {
                    this.snapshotEdits[i] = this.createUndoableEdit(this.originals[i]);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            if (wmiUndoableEdit == null) continue;
            wmiUndoableEdit.undo();
        }
    }

    protected void addEdit(WmiUndoableEdit wmiUndoableEdit) {
    }
}

