/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiUndoManager {
    private static final int UNDO_BUFFER_LENGTH = 20;
    private WmiCompositeUndoableEdit[] edits = new WmiCompositeUndoableEdit[20];
    private WmiMathDocumentModel doc = null;
    private int active = -1;
    private int tail = 0;
    private WmiCompositeUndoableEdit currentEdit = null;
    private boolean duringUndoOrRedo = false;

    public WmiUndoManager(WmiMathDocumentModel wmiMathDocumentModel) {
        this.doc = wmiMathDocumentModel;
    }

    public WmiCompositeUndoableEdit beginEdit(String string) {
        return this.beginEdit(string, null);
    }

    public WmiCompositeUndoableEdit beginEdit(String string, WmiCompositeUndoableEdit wmiCompositeUndoableEdit) {
        int n = this.active + 1;
        if (n >= 20) {
            n = 0;
        }
        while (this.tail != n) {
            if (--this.tail >= 0) continue;
            this.tail = 19;
        }
        this.flush(this.tail);
        this.edits[this.tail] = wmiCompositeUndoableEdit != null ? wmiCompositeUndoableEdit : new WmiCompositeUndoableEdit(string);
        this.currentEdit = this.edits[this.tail];
        try {
            this.doc.notifyModelListeners(this.currentEdit, 3);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return this.currentEdit;
    }

    public boolean endEdit() {
        boolean bl = false;
        if (this.currentEdit != null) {
            bl = true;
            try {
                this.doc.notifyModelListeners(this.currentEdit, 4);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            this.currentEdit = null;
            if (++this.tail == 20) {
                this.tail = 0;
            }
            if (this.edits[this.tail] != null) {
                try {
                    this.doc.notifyModelListeners(this.edits[this.tail], 5);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            this.edits[this.tail] = null;
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
        return bl;
    }

    public boolean addEdit(WmiUndoableEdit wmiUndoableEdit) {
        boolean bl = false;
        if (this.currentEdit != null) {
            this.currentEdit.addEdit(wmiUndoableEdit);
            bl = true;
        } else {
            WmiErrorLog.log(new Exception("Cannot add edit"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.currentEdit != null) {
            this.endEdit();
        }
        try {
            this.duringUndoOrRedo = true;
            this.doc.notifyModelListeners(this.doc, 2);
            WmiModelLock.updateLock(this.doc, true);
            WmiCompositeUndoableEdit wmiCompositeUndoableEdit = this.getEdit(this.active);
            if (wmiCompositeUndoableEdit != null) {
                wmiCompositeUndoableEdit.undo();
            }
            this.doc.notifyModelListeners(wmiCompositeUndoableEdit, 6);
            this.doc.notifyModelListeners(this.doc, 1);
            if (--this.active < 0) {
                this.active = 19;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        finally {
            WmiModelLock.updateUnlock(this.doc);
            this.duringUndoOrRedo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.duringUndoOrRedo = true;
            this.doc.notifyModelListeners(this.doc, 2);
            WmiModelLock.updateLock(this.doc, true);
            WmiCompositeUndoableEdit wmiCompositeUndoableEdit = this.getEdit(this.active + 1);
            if (wmiCompositeUndoableEdit != null) {
                wmiCompositeUndoableEdit.redo();
            }
            this.doc.notifyModelListeners(wmiCompositeUndoableEdit, 7);
            this.doc.notifyModelListeners(this.doc, 1);
            if (++this.active == 20) {
                this.active = 0;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        finally {
            WmiModelLock.updateUnlock(this.doc);
            this.duringUndoOrRedo = false;
        }
    }

    public boolean isUndoingOrRedoing() {
        return this.duringUndoOrRedo;
    }

    public void flush() {
        for (int i = 0; i < 20; ++i) {
            this.flush(i);
        }
        this.active = -1;
        this.tail = 0;
    }

    private void flush(int n) {
        if (this.edits[n] != null) {
            try {
                this.doc.notifyModelListeners(this.edits[n], 5);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            this.edits[n] = null;
        }
    }

    public String getUndoName() {
        String string = null;
        WmiCompositeUndoableEdit wmiCompositeUndoableEdit = this.getEdit(this.active);
        if (wmiCompositeUndoableEdit != null) {
            string = wmiCompositeUndoableEdit.getName();
        }
        return string;
    }

    public String getRedoName() {
        String string = null;
        WmiCompositeUndoableEdit wmiCompositeUndoableEdit = this.getEdit(this.active + 1);
        if (wmiCompositeUndoableEdit != null) {
            string = wmiCompositeUndoableEdit.getName();
        }
        return string;
    }

    public boolean canUndo() {
        return this.getEdit(this.active) != null;
    }

    public boolean canRedo() {
        return this.getEdit(this.active + 1) != null;
    }

    public WmiCompositeUndoableEdit getEdit(int n) {
        if (n >= 20) {
            n -= 20;
        }
        WmiCompositeUndoableEdit wmiCompositeUndoableEdit = null;
        if (n >= 0 && n < 20 && n != this.tail) {
            wmiCompositeUndoableEdit = this.edits[n];
        }
        return wmiCompositeUndoableEdit;
    }

    public WmiCompositeUndoableEdit getActiveEdit() {
        return this.currentEdit;
    }

    public void coalesceLastEdits() {
        int n = this.tail - 1;
        if (n < 0) {
            n = 19;
        }
        if (this.edits[n] != null && this.edits[n].isCoalescable()) {
            while (true) {
                int n2;
                if ((n2 = n - 1) < 0) {
                    n2 = 19;
                }
                if (this.edits[n2] == null || !this.edits[n2].isCoalescable()) break;
                this.edits[n2].combineWith(this.edits[n]);
                this.flush(n);
                if (--n >= 0) continue;
                n = 19;
            }
            this.tail = n + 1;
            if (this.tail >= 20) {
                this.tail = 0;
            }
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
    }

    public void removeCoalescableEdits() {
        int n = this.tail - 1;
        if (n < 0) {
            n = 19;
        }
        if (this.edits[n] != null && this.edits[n].isCoalescable()) {
            while (this.edits[n] != null && this.edits[n].isCoalescable()) {
                this.flush(n);
                if (--n >= 0) continue;
                n = 19;
            }
            this.tail = n + 1;
            if (this.tail >= 20) {
                this.tail = 0;
            }
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
    }

    public void makeLastEditCoalescable(boolean bl) {
        int n = this.tail - 1;
        if (n < 0) {
            n = 19;
        }
        if (this.edits[n] != null) {
            this.edits[n].setCoalescable(bl);
        }
    }

    public void clearRedo() {
        int n = this.active + 1;
        if (n >= 20) {
            n = 0;
        }
        while (this.tail != n) {
            if (--this.tail >= 0) continue;
            this.tail = 19;
        }
    }
}

