/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiSearchVisitor;
import com.maplesoft.util.WmiUnicodeMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class BracketMatcher {
    private static final int OPEN_BRACKET = 1;
    private static final int CLOSE_BRACKET = 2;
    private static final int RELATIONAL_OPERATOR = 4;
    private static final int EVAL_OPERATOR = 8;
    private static final int CONCATENATE_OPERATOR = 16;
    private static final int COLUMN_SEP_OPERATOR = 32;
    private static final int BRACKET_INDEX = 0;
    private static final int STRONG_MATCH_INDEX = 1;
    private static final int WEAK_MATCH_INDEX = 2;
    private static final int FLAGS_INDEX = 3;
    private static final int INCOMPATIBLE_BRACKETS = 0;
    private static final int STRONG_MATCH_BRACKETS = 1;
    private static final int WEAK_MATCH_BRACKETS = 2;
    private static final int NOOP_MATCH_BRACKETS = 3;
    private static final int LEFT_BIAS = 0;
    private static final int RIGHT_BIAS = 1;
    private static int[][] BRACKET_CANDIDATES = new int[][]{{123, 125, 0, 1}, {125, 123, 0, 2}, {40, 41, 93, 1}, {41, 40, 91, 2}, {91, 93, 41, 1}, {93, 91, 40, 2}, {60, 62, 9002, 5}, {62, 60, 9001, 6}, {124, 124, 9122, 43}, {9122, 9125, 124, 43}, {9001, 9002, 62, 1}, {9002, 9001, 60, 2}, {12298, 12299, 0, 1}, {12299, 12298, 0, 2}, {8968, 8969, 8971, 1}, {8969, 8968, 8970, 2}, {8970, 8971, 8969, 1}, {8971, 8970, 8968, 2}, {10214, 10215, 0, 1}, {10215, 10214, 0, 2}, {8741, 8741, 8214, 19}, {8214, 8214, 8741, 19}};
    private static WmiUnicodeMapper candidateMap = null;

    private static void initializeCandidateMap() {
        if (candidateMap == null) {
            candidateMap = new WmiUnicodeMapper();
            for (int i = 0; i < BRACKET_CANDIDATES.length; ++i) {
                candidateMap.put((char)BRACKET_CANDIDATES[i][0], BRACKET_CANDIDATES[i]);
            }
        }
    }

    public static boolean isCandidateBracket(WmiModel wmiModel) throws WmiNoReadAccessException {
        String string;
        boolean bl = false;
        BracketMatcher.initializeCandidateMap();
        if (wmiModel instanceof WmiMathOperatorModel && (string = ((WmiMathOperatorModel)wmiModel).getText()).length() == 1) {
            char c = string.charAt(0);
            bl = candidateMap.get(c) != null;
        }
        return bl;
    }

    public static WmiModelPosition matchBrackets(WmiMathModel wmiMathModel, ArrayList arrayList, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ArrayList arrayList2 = new ArrayList();
        BracketCollectionVisitor bracketCollectionVisitor = new BracketCollectionVisitor(arrayList2);
        WmiModelUtil.visitModels(wmiMathModel, bracketCollectionVisitor);
        BracketMatcher.disambiguateCandidates(arrayList2);
        if (BracketMatcher.matchCandidates(arrayList2, arrayList, wmiModelPosition)) {
            wmiModelPosition = BracketMatcher.createFenceModels(arrayList2, wmiModelPosition);
        }
        return wmiModelPosition;
    }

    private static boolean matchCandidates(ArrayList arrayList, ArrayList arrayList2, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Stack<BracketCandidate> stack = new Stack<BracketCandidate>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            BracketCandidate bracketCandidate = (BracketCandidate)arrayList.get(i);
            if (bracketCandidate.bracketType == 1) {
                stack.push(bracketCandidate);
                continue;
            }
            if (bracketCandidate.bracketType != 2) continue;
            BracketCandidate bracketCandidate2 = !stack.isEmpty() ? (BracketCandidate)stack.peek() : null;
            int n3 = n2 = bracketCandidate2 != null ? BracketMatcher.areCompatible(bracketCandidate2, bracketCandidate, arrayList2, wmiModelPosition) : 0;
            if (n2 != 0) {
                if (n2 == 1) {
                    bl2 = true;
                } else if (n2 == 2) {
                    bl3 = true;
                }
                BracketMatcher.matchBrackets(bracketCandidate2, bracketCandidate, n2);
                stack.pop();
                continue;
            }
            stack.clear();
            bl4 = true;
        }
        if (!stack.isEmpty()) {
            bl4 = true;
        }
        bl = !bl4 && (bl2 || bl3) || bl2 && !bl3;
        return bl;
    }

    public static int areCompatible(BracketCandidate bracketCandidate, BracketCandidate bracketCandidate2, ArrayList arrayList, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n = 0;
        if (bracketCandidate == null || bracketCandidate2 == null) {
            return n;
        }
        if (bracketCandidate.record[1] == bracketCandidate2.record[0]) {
            if (bracketCandidate.parentFence == bracketCandidate2.parentFence) {
                n = 1;
                if (bracketCandidate.fenceBoundary && bracketCandidate2.fenceBoundary) {
                    n = 3;
                } else if (bracketCandidate.fenceBoundary || bracketCandidate2.fenceBoundary) {
                    n = 2;
                }
            } else {
                n = 2;
            }
        } else if (bracketCandidate.record[2] == bracketCandidate2.record[0]) {
            n = 2;
        }
        if (!(n != 1 && n != 2 || BracketMatcher.checkStructuralCompatibility(bracketCandidate, bracketCandidate2, arrayList, wmiModelPosition))) {
            n = 0;
        }
        return n;
    }

    private static boolean checkStructuralCompatibility(BracketCandidate bracketCandidate, BracketCandidate bracketCandidate2, ArrayList arrayList, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        WmiModel wmiModel;
        boolean bl = true;
        Stack<WmiCompositeModel> stack = new Stack<WmiCompositeModel>();
        Stack<WmiCompositeModel> stack2 = new Stack<WmiCompositeModel>();
        WmiModel wmiModel2 = wmiModel = bracketCandidate.fenceBoundary ? bracketCandidate.parentFence : bracketCandidate.model.getParent();
        while (wmiModel != null && wmiModel.getTag() != WmiModelTag.MATH) {
            stack.push((WmiCompositeModel)wmiModel);
            wmiModel = wmiModel.getParent();
        }
        WmiModel wmiModel3 = wmiModel = bracketCandidate2.fenceBoundary ? bracketCandidate2.parentFence : bracketCandidate2.model.getParent();
        while (wmiModel != null && wmiModel.getTag() != WmiModelTag.MATH) {
            stack2.push((WmiCompositeModel)wmiModel);
            wmiModel = wmiModel.getParent();
        }
        WmiModel wmiModel4 = null;
        while (!stack.isEmpty() && !stack2.isEmpty() && stack.peek() == stack2.peek()) {
            wmiModel4 = (WmiModel)stack.peek();
            stack.pop();
            stack2.pop();
        }
        while (!stack.isEmpty()) {
            wmiModel = (WmiModel)stack.pop();
            WmiModelTag wmiModelTag = wmiModel.getTag();
            if (wmiModelTag == WmiModelTag.MATH_SUBSCRIPT || wmiModelTag == WmiModelTag.MATH_SUPERSCRIPT || wmiModelTag == WmiModelTag.MATH_SUB_SUP) {
                boolean bl2 = false;
                if (!stack.isEmpty()) {
                    object = (WmiModel)stack.peek();
                    if (((WmiCompositeModel)wmiModel).getChild(0) == object && arrayList != null) {
                        MathTokenizer.doScriptDetachment((WmiCompositeModel)wmiModel);
                        arrayList.add(wmiModel);
                        bl2 = true;
                    }
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (wmiModel.getTag() == WmiModelTag.MATH_ROW || wmiModel.getTag() == WmiModelTag.MATH_FENCED) continue;
            bl = false;
            break;
        }
        if (bl) {
            WmiCompositeModel wmiCompositeModel;
            wmiModel = bracketCandidate2.model;
            boolean bl3 = wmiModelPosition.getModel() == wmiModel;
            WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel = bracketCandidate2.fenceBoundary ? bracketCandidate2.parentFence : bracketCandidate2.model.getParent();
            while (wmiModel != wmiModel4) {
                Object object2 = object = wmiCompositeModel != null ? wmiCompositeModel.getTag() : null;
                if (object == WmiModelTag.MATH_FENCED) {
                    bl3 = false;
                } else if (object == WmiModelTag.MATH_ROW) {
                    if (bl3) {
                        bl3 = wmiCompositeModel.getChild(wmiCompositeModel.getChildCount() - 1) == wmiModel;
                    }
                } else if (bl3) {
                    if (object == WmiModelTag.MATH_SUBSCRIPT || object == WmiModelTag.MATH_SUPERSCRIPT || object == WmiModelTag.MATH_SUB_SUP) {
                        if (wmiCompositeModel.getChild(0) == wmiModel) {
                            bl = false;
                            break;
                        }
                    } else if (object == WmiModelTag.MATH_SQUARE_ROOT || object == WmiModelTag.MATH_NROOT) {
                        if (wmiCompositeModel.getChild(0) != wmiModel) {
                            bl = false;
                            break;
                        }
                    } else if (object != WmiModelTag.MATH_FRAC && object != WmiModelTag.MATH_OVER && object != WmiModelTag.MATH_UNDER && object != WmiModelTag.MATH_UNDER_OVER) {
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                    break;
                }
                wmiModel = wmiCompositeModel;
                wmiCompositeModel = wmiModel.getParent();
            }
        }
        return bl;
    }

    public static void matchBrackets(BracketCandidate bracketCandidate, BracketCandidate bracketCandidate2, int n) throws WmiNoReadAccessException {
        bracketCandidate.match = bracketCandidate2;
        bracketCandidate2.match = bracketCandidate;
        bracketCandidate.matchType = (bracketCandidate2.matchType = n);
    }

    private static WmiModelPosition createFenceModels(ArrayList arrayList, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        BracketCandidate bracketCandidate;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            bracketCandidate = (BracketCandidate)arrayList.get(i);
            if (bracketCandidate.matchType == 3) continue;
            BracketMatcher.expandFence(bracketCandidate, arrayList);
        }
        while (!arrayList.isEmpty()) {
            BracketCandidate bracketCandidate2 = (BracketCandidate)arrayList.get(0);
            bracketCandidate = bracketCandidate2.match;
            if (bracketCandidate != null) {
                arrayList.remove(bracketCandidate);
                if (bracketCandidate.matchType != 3) {
                    wmiModelPosition = BracketMatcher.createFence(bracketCandidate2, bracketCandidate, wmiModelPosition);
                }
            }
            arrayList.remove(0);
        }
        return wmiModelPosition;
    }

    private static void expandFence(BracketCandidate bracketCandidate, ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel wmiMathFencedModel;
        if (bracketCandidate.fenceBoundary && (wmiMathFencedModel = bracketCandidate.parentFence) != null) {
            WmiModelPosition wmiModelPosition;
            WmiModel wmiModel;
            int n = 2 * wmiMathFencedModel.getChildCount() - 1;
            if (wmiMathFencedModel.getChildCount() == 1 && (wmiModel = wmiMathFencedModel.getChild(0)) != null && wmiModel.getTag() == WmiModelTag.MATH_ROW) {
                n = ((WmiCompositeModel)wmiModel).getChildCount();
            }
            wmiModel = wmiMathFencedModel.getModelForLeft();
            WmiMathModel wmiMathModel = wmiMathFencedModel.getModelForRight();
            if (wmiModel != null) {
                ++n;
            }
            if (wmiMathModel != null) {
                ++n;
            }
            WmiModel wmiModel2 = (wmiModelPosition = wmiMathFencedModel.convertToInlineMath(0)) != null ? wmiModelPosition.getModel() : null;
            WmiModel wmiModel3 = null;
            if (wmiMathModel != null && wmiModel2 != null) {
                WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
                int n2 = wmiCompositeModel.indexOf(wmiModel2);
                wmiModel3 = wmiCompositeModel.getChild(n2 + n - 1);
            }
            if (wmiModel == null) {
                wmiModel2 = null;
            }
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                BracketCandidate bracketCandidate2 = (BracketCandidate)arrayList.get(i);
                if (bracketCandidate2.model == wmiModel) {
                    bracketCandidate2.model = (WmiMathOperatorModel)wmiModel2;
                    bracketCandidate2.parentFence = null;
                    bracketCandidate2.fenceBoundary = false;
                    continue;
                }
                if (bracketCandidate2.model != wmiMathModel) continue;
                bracketCandidate2.model = (WmiMathOperatorModel)wmiModel3;
                bracketCandidate2.parentFence = null;
                bracketCandidate2.fenceBoundary = false;
            }
        }
    }

    private static WmiModelPosition createFence(BracketCandidate bracketCandidate, BracketCandidate bracketCandidate2, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiCompositeModel wmiCompositeModel;
            int n;
            int n2;
            WmiModelPosition wmiModelPosition2;
            WmiModelPosition wmiModelPosition3;
            WmiModelPosition wmiModelPosition4;
            WmiMathOperatorModel wmiMathOperatorModel = bracketCandidate.model;
            WmiMathOperatorModel wmiMathOperatorModel2 = bracketCandidate2.model;
            char c = (char)bracketCandidate.record[0];
            char c2 = (char)bracketCandidate2.record[0];
            if (c == '<' || c2 == '>') {
                BracketMatcher.updateBracket(bracketCandidate, '\u2329');
                BracketMatcher.updateBracket(bracketCandidate2, '\u232a');
            }
            WmiModel wmiModel = (wmiModelPosition4 = MathInsertUtil.wrapSelection(wmiModelPosition3 = new WmiModelPosition(wmiMathOperatorModel, 0), wmiModelPosition2 = new WmiModelPosition(wmiMathOperatorModel2, -1))) != null ? wmiModelPosition4.getModel() : null;
            WmiCompositeModel wmiCompositeModel2 = wmiModel != null ? wmiModel.getParent() : null;
            int n3 = wmiCompositeModel2 != null ? wmiCompositeModel2.indexOf(wmiModel) : -1;
            WmiMathContext wmiMathContext = WmiMathWrapperModel.createContext(wmiMathOperatorModel.getAttributesForRead());
            WmiCompositeModel wmiCompositeModel3 = wmiMathOperatorModel.getParent();
            int n4 = n2 = wmiCompositeModel3 != null ? wmiCompositeModel3.indexOf(wmiMathOperatorModel) : -1;
            if (n2 >= 0) {
                wmiCompositeModel3.removeChild(n2);
            }
            int n5 = n = (wmiCompositeModel = wmiMathOperatorModel2.getParent()) != null ? wmiCompositeModel.indexOf(wmiMathOperatorModel2) : -1;
            if (n >= 0) {
                wmiCompositeModel.removeChild(n);
            }
            WmiMathDocumentModel wmiMathDocumentModel = wmiMathOperatorModel.getDocument();
            WmiModel[] wmiModelArray = new WmiMathModel[]{};
            WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
            String string = BracketMatcher.getBracketText(wmiMathOperatorModel);
            String string2 = BracketMatcher.getBracketText(wmiMathOperatorModel2);
            wmiMathFencedModel.addAttribute("open", string);
            wmiMathFencedModel.addAttribute("close", string2);
            if (n3 >= 0) {
                wmiCompositeModel2.replaceChild(wmiMathFencedModel, n3);
                if (wmiModel != null) {
                    wmiMathFencedModel.addChild(wmiModel, 0);
                } else {
                    wmiMathFencedModel.addChild(WmiMathFactory.createMathIdentifierToken(wmiMathFencedModel.getDocument(), "", wmiMathContext), 0);
                }
            }
            if (wmiModelPosition.getModel() == wmiMathOperatorModel) {
                wmiModelPosition = new WmiModelPosition(wmiMathFencedModel.getChild(0), 0);
            } else if (wmiModelPosition.getModel() == wmiMathOperatorModel2) {
                wmiModelPosition = new WmiModelPosition(wmiMathFencedModel, -1);
            }
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiModelPosition;
    }

    private static String getBracketText(WmiTextModel wmiTextModel) throws WmiNoReadAccessException {
        String string;
        char c;
        String string2 = wmiTextModel.getText();
        if (string2 != null && string2.length() == 1 && (c = string2.charAt(0)) > '\u007f' && (string = WmiMathEntityNameMapper.getEntityName(c)) != null) {
            string2 = "&" + string + ";";
        }
        return string2;
    }

    private static void disambiguateCandidates(ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = arrayList.size();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block6: for (n2 = 0; n2 < n6; ++n2) {
            object = (BracketCandidate)arrayList.get(n2);
            n = ((BracketCandidate)object).record[0];
            BracketCandidate bracketCandidate = BracketMatcher.findMathingFenceBoundary(arrayList, (BracketCandidate)object);
            switch (n) {
                case 60: 
                case 9001: {
                    if (bracketCandidate != null) {
                        if (BracketMatcher.isBoundingOperator((BracketCandidate)object, 0) || BracketMatcher.isBoundingOperator(bracketCandidate, 1)) {
                            ++n3;
                            ((BracketCandidate)object).bracketType = 1;
                            bracketCandidate.bracketType = 2;
                            continue block6;
                        }
                        ((BracketCandidate)object).bracketType = 4;
                        bracketCandidate.bracketType = 4;
                        BracketMatcher.updateBracket((BracketCandidate)object, '<');
                        BracketMatcher.updateBracket(bracketCandidate, '>');
                        arrayList2.add(object);
                        continue block6;
                    }
                    if (BracketMatcher.isBoundingOperator((BracketCandidate)object, 0)) {
                        ++n3;
                        ((BracketCandidate)object).bracketType = 1;
                        continue block6;
                    }
                    ((BracketCandidate)object).bracketType = 4;
                    BracketMatcher.updateBracket((BracketCandidate)object, '<');
                    continue block6;
                }
                case 62: 
                case 9002: {
                    if (((BracketCandidate)object).bracketType == 2) {
                        --n3;
                    }
                    if (((BracketCandidate)object).bracketType == 4 || bracketCandidate != null) continue block6;
                    if (BracketMatcher.isBoundingOperator((BracketCandidate)object, 1)) {
                        --n3;
                        ((BracketCandidate)object).bracketType = 2;
                        continue block6;
                    }
                    ((BracketCandidate)object).bracketType = 4;
                    if (n != 9002) continue block6;
                    BracketMatcher.updateBracket((BracketCandidate)object, '>');
                    continue block6;
                }
                case 124: {
                    if (n3 != 0) continue block6;
                    if (BracketMatcher.evalTest((BracketCandidate)object)) {
                        ((BracketCandidate)object).bracketType = 8;
                        arrayList2.add(object);
                        continue block6;
                    }
                    if (n4 == 0 || BracketMatcher.isBoundingOperator((BracketCandidate)object, 0)) {
                        ++n4;
                        ((BracketCandidate)object).bracketType = 1;
                        continue block6;
                    }
                    --n4;
                    ((BracketCandidate)object).bracketType = 2;
                    continue block6;
                }
                case 8214: 
                case 8741: {
                    if (BracketMatcher.isConcatOperator((BracketCandidate)object)) {
                        ((BracketCandidate)object).bracketType = 16;
                        arrayList2.add(object);
                        continue block6;
                    }
                    if (n5 == 0 || BracketMatcher.isBoundingOperator((BracketCandidate)object, 0)) {
                        ++n5;
                        ((BracketCandidate)object).bracketType = 1;
                        continue block6;
                    }
                    --n5;
                    ((BracketCandidate)object).bracketType = 2;
                    continue block6;
                }
            }
        }
        while (arrayList2.size() > 0) {
            BracketCandidate bracketCandidate = (BracketCandidate)arrayList2.get(0);
            arrayList2.remove(0);
            if (!bracketCandidate.fenceBoundary) continue;
            object = bracketCandidate.parentFence;
            ((WmiMathFencedModel)object).convertToInlineMath(0);
            n6 = arrayList2.size();
            for (n = n6 - 1; n >= 0; --n) {
                bracketCandidate = (BracketCandidate)arrayList2.get(n);
                if (!bracketCandidate.fenceBoundary || bracketCandidate.parentFence != object) continue;
                arrayList2.remove(n);
            }
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            object = (BracketCandidate)arrayList.get(n2);
            if (((BracketCandidate)object).bracketType != 1 && ((BracketCandidate)object).bracketType != 2) {
                arrayList.remove(n2);
                continue;
            }
            ++n2;
        }
    }

    private static BracketCandidate findMathingFenceBoundary(ArrayList arrayList, BracketCandidate bracketCandidate) throws WmiNoReadAccessException {
        WmiMathModel wmiMathModel = null;
        BracketCandidate bracketCandidate2 = null;
        if (bracketCandidate.fenceBoundary) {
            WmiMathFencedModel wmiMathFencedModel = bracketCandidate.parentFence;
            WmiMathModel wmiMathModel2 = wmiMathFencedModel.getModelForLeft();
            WmiMathModel wmiMathModel3 = wmiMathFencedModel.getModelForRight();
            if (wmiMathModel2 == bracketCandidate.model) {
                wmiMathModel = wmiMathModel3;
            } else if (wmiMathModel3 == bracketCandidate.model) {
                wmiMathModel = wmiMathModel2;
            }
        }
        if (wmiMathModel != null) {
            int n = arrayList.size();
            for (int i = 0; i < n && (bracketCandidate2 = (BracketCandidate)arrayList.get(i)).model != wmiMathModel; ++i) {
            }
        }
        return bracketCandidate2;
    }

    private static void updateBracket(BracketCandidate bracketCandidate, char c) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (c != (char)bracketCandidate.record[0]) {
            WmiMathOperatorModel wmiMathOperatorModel = bracketCandidate.model;
            int n = wmiMathOperatorModel.getLength();
            try {
                ((WmiTextModel)wmiMathOperatorModel).replaceText(Character.toString(c), 0, n);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
    }

    private static boolean isBoundingOperator(BracketCandidate bracketCandidate, int n) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        boolean bl = true;
        WmiModel wmiModel = bracketCandidate.model;
        if (bracketCandidate.fenceBoundary && (wmiCompositeModel = bracketCandidate.parentFence) != null) {
            if (((WmiMathFencedModel)wmiCompositeModel).getModelForLeft() == wmiModel && n == 0) {
                wmiModel = wmiModel.getParent();
            } else if (((WmiMathFencedModel)wmiCompositeModel).getModelForRight() == wmiModel && n == 1) {
                wmiModel = wmiModel.getParent();
            }
        }
        if ((wmiCompositeModel = wmiModel.getParent()) != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            int n2 = wmiCompositeModel.indexOf(wmiModel);
            int n3 = wmiCompositeModel.getChildCount();
            int n4 = 1;
            if (n == 0) {
                n4 = -1;
                n3 = -1;
            }
            for (int i = n2 + n4; i != n3; i += n4) {
                String string;
                WmiModelTag wmiModelTag;
                WmiModel wmiModel2 = wmiCompositeModel.getChild(i);
                WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel2 != null ? wmiModel2.getTag() : null;
                if (wmiModelTag == WmiModelTag.MATH_SPACE) continue;
                if (wmiModelTag == WmiModelTag.MATH_OPERATOR) {
                    string = ((WmiTextModel)wmiModel2).getText();
                    if (!string.equals(" ") && !string.equals("&InvisibleTimes;")) break;
                    continue;
                }
                if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
                    string = ((WmiTextModel)wmiModel2).getText();
                    if (string.equals("")) continue;
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static boolean evalTest(BracketCandidate bracketCandidate) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathOperatorModel wmiMathOperatorModel = bracketCandidate.model;
        WmiCompositeModel wmiCompositeModel = wmiMathOperatorModel.getParent();
        if (wmiCompositeModel != null) {
            if (wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
                int n = wmiCompositeModel.indexOf(wmiMathOperatorModel);
                if (n > 0 && n < wmiCompositeModel.getChildCount() - 2) {
                    WmiModel wmiModel = wmiCompositeModel.getChild(n - 1);
                    WmiModel wmiModel2 = wmiCompositeModel.getChild(n + 1);
                    if (WmiModelUtil.findFirstDescendantOfTag(wmiModel, WmiModelTag.MATH_PHANTOM) != null && WmiModelUtil.findFirstDescendantOfTag(wmiModel2, WmiModelTag.MATH_PHANTOM) != null) {
                        bl = true;
                    }
                }
            } else if (wmiCompositeModel.getTag() == WmiModelTag.MATH_SUBSCRIPT) {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean isConcatOperator(BracketCandidate bracketCandidate) throws WmiNoReadAccessException {
        int n;
        boolean bl = false;
        WmiMathOperatorModel wmiMathOperatorModel = bracketCandidate.model;
        WmiCompositeModel wmiCompositeModel = wmiMathOperatorModel.getParent();
        if (wmiCompositeModel != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW && (n = wmiCompositeModel.indexOf(wmiMathOperatorModel)) > 0 && n < wmiCompositeModel.getChildCount() - 2) {
            WmiModel wmiModel = wmiCompositeModel.getChild(n - 1);
            WmiModel wmiModel2 = wmiCompositeModel.getChild(n + 1);
            if (wmiModel.getTag() == WmiModelTag.MATH_IDENTIFIER && (wmiModel2.getTag() == WmiModelTag.MATH_IDENTIFIER || wmiModel2.getTag() == WmiModelTag.MATH_NUMERIC)) {
                bl = true;
            }
        }
        return bl;
    }

    private static class BracketCollectionVisitor
    implements WmiSearchVisitor {
        private ArrayList list;
        private WmiMathFencedModel parentFence;

        private BracketCollectionVisitor(ArrayList arrayList) {
            this(arrayList, (WmiMathFencedModel)null);
        }

        private BracketCollectionVisitor(ArrayList arrayList, WmiMathFencedModel wmiMathFencedModel) {
            this.list = arrayList;
            this.parentFence = wmiMathFencedModel;
            BracketMatcher.initializeCandidateMap();
        }

        public int visitMatch(Object object) {
            int n = 0;
            try {
                if (object instanceof WmiMathModel) {
                    WmiModelTag wmiModelTag = ((WmiMathModel)object).getTag();
                    if (wmiModelTag == WmiModelTag.MATH_OPERATOR) {
                        this.addCandidate((WmiMathOperatorModel)object, null);
                    } else if (wmiModelTag == WmiModelTag.MATH_FENCED) {
                        WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)object;
                        WmiMathModel wmiMathModel = wmiMathFencedModel.getModelForLeft();
                        WmiMathModel wmiMathModel2 = wmiMathFencedModel.getModelForRight();
                        n = 1;
                        this.addCandidate(wmiMathModel, wmiMathFencedModel);
                        BracketCollectionVisitor bracketCollectionVisitor = new BracketCollectionVisitor(this.list, wmiMathFencedModel);
                        int n2 = wmiMathFencedModel.getChildCount();
                        for (int i = 0; i < n2; ++i) {
                            WmiModelUtil.visitModels(wmiMathFencedModel.getChild(i), bracketCollectionVisitor);
                        }
                        this.addCandidate(wmiMathModel2, wmiMathFencedModel);
                    }
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                n = 2;
            }
            return n;
        }

        private void addCandidate(WmiMathModel wmiMathModel, WmiMathFencedModel wmiMathFencedModel) throws WmiNoReadAccessException {
            if (wmiMathModel instanceof WmiMathOperatorModel) {
                WmiMathDocumentModel wmiMathDocumentModel;
                Object object;
                if (wmiMathFencedModel == null) {
                    wmiMathFencedModel = this.parentFence;
                }
                String string = ((WmiMathOperatorModel)wmiMathModel).getText();
                int n = string.length();
                char c = '\u0000';
                if (n > 1) {
                    c = string.charAt(0);
                    if (c == '&') {
                        object = MathMLEntityMap.getInstance();
                        wmiMathDocumentModel = ((HashMap)object).get(string);
                        c = wmiMathDocumentModel != null ? ((Object)wmiMathDocumentModel).toString().charAt(0) : (char)'\u0000';
                    }
                } else if (n == 1) {
                    c = string.charAt(0);
                }
                if (c != '\u0000') {
                    object = candidateMap.get(c);
                    wmiMathDocumentModel = wmiMathModel.getDocument();
                    if (object != null && wmiMathDocumentModel.isMutableModel(wmiMathModel)) {
                        int[] nArray = (int[])object;
                        this.list.add(new BracketCandidate((WmiMathOperatorModel)wmiMathModel, nArray, wmiMathFencedModel));
                    }
                }
            }
        }
    }

    private static class BracketCandidate {
        private WmiMathOperatorModel model;
        private WmiMathFencedModel parentFence;
        private boolean fenceBoundary;
        private int[] record;
        private BracketCandidate match;
        private int matchType;
        private int bracketType;

        private BracketCandidate(WmiMathOperatorModel wmiMathOperatorModel, int[] nArray, WmiMathFencedModel wmiMathFencedModel) throws WmiNoReadAccessException {
            this.model = wmiMathOperatorModel;
            this.record = nArray;
            this.parentFence = wmiMathFencedModel;
            this.fenceBoundary = false;
            this.bracketType = this.record[3];
            if (this.parentFence != null && (wmiMathFencedModel.getModelForLeft() == wmiMathOperatorModel || wmiMathFencedModel.getModelForRight() == wmiMathOperatorModel)) {
                this.fenceBoundary = true;
            }
        }
    }
}

