/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import java.util.HashMap;

public class WmiFractionModel
extends WmiTwoArgumentMathModel
implements WmiMathModel {
    private static final WmiImpliedSemantics IMPLIED_FRACTION_SEMANTICS = new WmiImpliedSemantics();
    public static final int NUMERATOR_INDEX = 0;
    public static final int DENOMINATOR_INDEX = 1;

    private WmiFractionModel(WmiFractionModel wmiFractionModel) throws WmiNoReadAccessException {
        super(wmiFractionModel.getDocument());
        this.children[1] = wmiFractionModel.getChild(1);
        WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionAttributeSet)wmiFractionModel.getAttributes().copyAttributes();
        wmiFractionAttributeSet.setStyle(128, true);
        this.attributes = wmiFractionAttributeSet;
        this.children[0] = new WmiNumericModel(wmiFractionModel.getDocument(), "1", "1", new WmiMathContext((WmiFractionAttributeSet)wmiFractionAttributeSet.copyAttributes()));
        this.parent = wmiFractionModel;
    }

    public WmiFractionModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel, WmiModel wmiModel2, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        super(wmiMathDocumentModel, wmiModel, wmiModel2);
        this.setAttributes(wmiMathContext.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public WmiFractionModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel[] wmiMathModelArray, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel);
        this.children = wmiMathModelArray;
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(wmiMathContext.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public WmiFractionModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(wmiMathContext.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public static WmiFractionModel createDenominatorModel(WmiFractionModel wmiFractionModel) throws WmiNoReadAccessException {
        return new WmiFractionModel(wmiFractionModel);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_FRAC;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFractionAttributeSet();
    }

    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics wmiMathSemantics = this.getSemantics();
        return wmiMathSemantics != null ? wmiMathSemantics.toDag(this) : null;
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiFractionDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    public class WmiFractionDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        WmiFractionDeleteHandler(WmiFractionModel wmiFractionModel2) {
            this.model = wmiFractionModel2;
        }

        protected void processRestructure(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel wmiModel = null;
                WmiCompositeModel wmiCompositeModel = WmiFractionModel.this.getParent();
                int n = wmiCompositeModel.indexOf(this.model);
                if (WmiFractionModel.this.getChild(0) instanceof WmiDeletePlaceholderModel) {
                    wmiModel = WmiFractionModel.this.getChild(1);
                    wmiCompositeModel.replaceChild(wmiModel, n);
                    if (wmiModel instanceof WmiCompositeModel) {
                        WmiModelPath wmiModelPath = WmiModelUtil.mapBeginningOfCompositeModel((WmiCompositeModel)wmiModel);
                        WmiModelPosition wmiModelPosition = wmiModelPath.getModelPosition(wmiModel.getDocument());
                        wmiDeleteManager.setModelToReposition(wmiModelPosition);
                    } else if (wmiModel instanceof WmiTextModel) {
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModel, 0));
                    }
                } else if (WmiFractionModel.this.getChild(1) instanceof WmiDeletePlaceholderModel) {
                    wmiModel = WmiFractionModel.this.getChild(0);
                    wmiCompositeModel.replaceChild(wmiModel, n);
                    if (wmiModel instanceof WmiCompositeModel) {
                        WmiModelPath wmiModelPath = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)wmiModel);
                        WmiModelPosition wmiModelPosition = wmiModelPath.getModelPosition(wmiModel.getDocument());
                        wmiDeleteManager.setModelToReposition(wmiModelPosition);
                    } else if (wmiModel instanceof WmiTextModel) {
                        WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                        int n2 = wmiTextModel.getLength();
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModel, n2));
                    }
                }
            }
        }
    }

    public static class WmiFractionAttributeSet
    extends WmiMathAttributeSet {
        public static final String LINE_THICKNESS = "linethickness";
        public static final String DENOMINATOR_ALIGNMENT = "denomalign";
        public static final String NUMERATOR_ALIGNMENT = "numalign";
        public static final String BEVELLED = "bevelled";
        public static final String[] ATTR_NAMES = new String[]{"linethickness", "denomalign", "numalign", "bevelled", "foreground", "background"};
        public static final String ALIGN_LEFT = "left";
        public static final String ALIGN_CENTER = "center";
        public static final String ALIGN_RIGHT = "right";
        public static final String[] ALIGNMENT_OPTIONS = new String[]{"left", "center", "right"};
        public static final int DEFAULT_ALIGNMENT = 1;
        public static final String LINE_THICKNESS_THIN = "thin";
        public static final String LINE_THICKNESS_MEDIUM = "medium";
        public static final String LINE_THICKNESS_THICK = "thick";
        private static final int DEFAULT_LINE_THICKNESS = 1;
        private static final boolean DEFAULT_BEVEL = false;
        public static final WmiAttributeKey[] FRACTION_KEYS = new WmiAttributeKey[]{new NumeratorAlignmentKey(), new DenominatorAlignmentKey(), new BevelKey(), new ThicknessKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_FRAC = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), FRACTION_KEYS);
        private static final int BEVEL_HASH_BIT = 128;
        private static HashMap keyMap;
        private static HashMap cache;
        private int linethickness = 1;
        private int denomalign = 1;
        private int numalign = 1;
        private boolean isBevelled = false;

        public WmiFractionAttributeSet() {
        }

        public WmiFractionAttributeSet(WmiFractionAttributeSet wmiFractionAttributeSet) {
            super(wmiFractionAttributeSet);
            this.denomalign = wmiFractionAttributeSet.denomalign;
            this.numalign = wmiFractionAttributeSet.numalign;
            this.linethickness = wmiFractionAttributeSet.linethickness;
            this.isBevelled = wmiFractionAttributeSet.isBevelled;
        }

        public WmiFractionAttributeSet(String string) {
            super.setFontStyleName(string);
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiFractionAttributeSet) {
                WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionAttributeSet)wmiAttributeSet;
                this.denomalign = wmiFractionAttributeSet.denomalign;
                this.numalign = wmiFractionAttributeSet.numalign;
                this.linethickness = wmiFractionAttributeSet.linethickness;
                this.isBevelled = wmiFractionAttributeSet.isBevelled;
            }
        }

        public boolean isBevelled() {
            return this.isBevelled;
        }

        public int getLineThickness() {
            return this.linethickness;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiFractionAttributeSet(this);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiFractionAttributeSet) {
                WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionAttributeSet)object;
                bl = wmiFractionAttributeSet.linethickness == this.linethickness && wmiFractionAttributeSet.isBevelled == this.isBevelled && wmiFractionAttributeSet.numalign == this.numalign && wmiFractionAttributeSet.denomalign == this.denomalign;
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= this.numalign;
            n ^= this.denomalign;
            n ^= this.linethickness;
            if (this.isBevelled) {
                n ^= 0x80;
            }
            return n;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_FRAC;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class ThicknessKey
        extends WmiIntAttributeKey {
            protected ThicknessKey() {
                super(WmiFractionAttributeSet.LINE_THICKNESS, 1);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiFractionAttributeSet)wmiAttributeSet).linethickness;
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiFractionAttributeSet)wmiAttributeSet).linethickness = n;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                int n = 1;
                if (string != null) {
                    if (string.equals(WmiFractionAttributeSet.LINE_THICKNESS_THIN)) {
                        n = 1;
                    } else if (string.equals(WmiFractionAttributeSet.LINE_THICKNESS_MEDIUM)) {
                        n = 2;
                    } else if (string.equals(WmiFractionAttributeSet.LINE_THICKNESS_THICK)) {
                        n = 3;
                    } else {
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                this.setIntValue(wmiAttributeSet, n);
            }
        }

        public static class BevelKey
        extends WmiBooleanAttributeKey {
            public BevelKey() {
                super(WmiFractionAttributeSet.BEVELLED, false);
            }

            public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiFractionAttributeSet)wmiAttributeSet).isBevelled;
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
                ((WmiFractionAttributeSet)wmiAttributeSet).isBevelled = bl;
            }
        }

        public static class DenominatorAlignmentKey
        extends WmiEnumeratedAttributeKey {
            public DenominatorAlignmentKey() {
                super(WmiFractionAttributeSet.DENOMINATOR_ALIGNMENT, ALIGNMENT_OPTIONS, 1);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiFractionAttributeSet)wmiAttributeSet).denomalign;
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiFractionAttributeSet)wmiAttributeSet).denomalign = n;
            }
        }

        public static class NumeratorAlignmentKey
        extends WmiEnumeratedAttributeKey {
            public NumeratorAlignmentKey() {
                super(WmiFractionAttributeSet.NUMERATOR_ALIGNMENT, ALIGNMENT_OPTIONS, 1);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiFractionAttributeSet)wmiAttributeSet).numalign;
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiFractionAttributeSet)wmiAttributeSet).numalign = n;
            }
        }
    }
}

