/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiCollectionBuilder;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPowerBuilder;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbsBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiCentralGlyphBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiCompositionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiConjugateBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiDiffBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiEvalBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiExpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFactorialBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFloatFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFunctionSeriesBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiInfixNotationBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiIntegralBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiLimitBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiLowerCaseBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiModpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiNeutralOpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiPiecewiseBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiRtableBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTableBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTypesettingBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiUnitBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiVectorBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiVectorDerivativesBuilder;
import java.util.HashMap;
import java.util.HashSet;

public class WmiFunctionBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String APPLY_FUNCTION = "&ApplyFunction;";
    protected static final int NAME_INDEX = 0;
    protected static final int ARGUMENT_INDEX = 1;
    protected static final String NEUTRAL_OP_START = "&";
    protected static final int NUMBER_NEUTRAL_OP_ARGS = 2;
    protected static final int NEUTRAL_OP_LEFT_ARG = 0;
    protected static final int NEUTRAL_OP_RIGHT_ARG = 1;
    private static HashMap specialFunctionMap = new HashMap();
    private static HashSet elisionSet = new HashSet();
    private WmiNeutralOpBuilder neutralOpBuilder = new WmiNeutralOpBuilder();
    private WmiNeutralOpBuilder.WmiNeutralProdOpBuilder neutralProdOpBuilder = new WmiNeutralOpBuilder.WmiNeutralProdOpBuilder();
    private static final String[] functionsNeedingQuotes = new String[]{"-", "+", "/", "*", "^"};

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        String string = null;
        if (DagUtil.isName(dag2)) {
            if (dag2 != null) {
                string = dag2.getData();
            }
        } else if (DagUtil.isMember(dag2)) {
            string = DagBuilder.lPrint(dag2);
        }
        WmiSpecialFunctionBuilder wmiSpecialFunctionBuilder = null;
        if (!wmiMathContext.useProcRules()) {
            wmiSpecialFunctionBuilder = (WmiSpecialFunctionBuilder)specialFunctionMap.get(string);
        }
        if (wmiSpecialFunctionBuilder == null && string != null && string.startsWith(NEUTRAL_OP_START) && dag3.getLength() == 2) {
            WmiNeutralOpBuilder wmiNeutralOpBuilder = string.equals("&*") ? this.neutralProdOpBuilder : this.neutralOpBuilder;
            wmiMathModel = wmiNeutralOpBuilder.createModel(dag, dag3.getChild(0), dag3.getChild(1), " " + string + " ", wmiMathDocumentModel, wmiMathContext);
        }
        if (wmiSpecialFunctionBuilder != null && wmiSpecialFunctionBuilder.shouldBeUsed(dag, wmiMathContext)) {
            try {
                wmiMathModel = wmiSpecialFunctionBuilder.createSpecialFunctionModel(wmiMathDocumentModel, string, dag3, wmiMathContext);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
        }
        if (wmiMathModel == null) {
            wmiMathModel = this.createGenericFunctionModel(wmiMathDocumentModel, string, dag2, dag3, wmiMathContext);
        }
        return wmiMathModel;
    }

    private boolean requiresQuotes(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < functionsNeedingQuotes.length && !bl; ++i) {
                if (!string.equals(functionsNeedingQuotes[i])) continue;
                bl = true;
            }
        }
        return bl;
    }

    public WmiMathModel createGenericFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, Dag dag2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
        if (this.requiresQuotes(string)) {
            string = "`" + string + "`";
            dag = Dag.createDag(8, null, string, false);
        }
        if (string != null && string.startsWith("INTERFACE_PLOT")) {
            dag = Dag.createDag(8, null, string.substring(10), false);
        }
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        if (DagBuilder.getPrecedence(dag) >= 4) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        if (elisionSet.contains(string)) {
            dag2 = DagUtil.createNameDag("...");
        }
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        wmiMathModel2 = WmiMathFactory.addBrackets(wmiMathModel2, wmiMathContext);
        wmiMathModel2.setSemantics(new WmiCollectionBuilder.WmiArgsModelBuilder());
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, APPLY_FUNCTION, wmiMathContext);
        wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
        wmiAbstractArrayCompositeModel.appendChild(wmiMathTokenModel);
        wmiAbstractArrayCompositeModel.appendChild(wmiMathModel2);
        wmiInlineMathModel.setSemantics(this);
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
        WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
        WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(2);
        Dag[] dagArray = new Dag[]{wmiMathModel2 != null ? wmiMathModel2.toDag() : null, wmiMathModel3 != null ? wmiMathModel3.toDag() : null};
        WmiSemanticDagUtil.fillNullDags(dagArray);
        return Dag.createDag(18, dagArray, null, false);
    }

    static {
        specialFunctionMap.put("abs", new WmiAbsBuilder());
        specialFunctionMap.put("conjugate", new WmiConjugateBuilder());
        specialFunctionMap.put("diff", new WmiDiffBuilder());
        specialFunctionMap.put("Diff", new WmiDiffBuilder(true));
        specialFunctionMap.put("exp", new WmiExpBuilder());
        specialFunctionMap.put("factorial", new WmiFactorialBuilder());
        specialFunctionMap.put("Float", new WmiFloatFunctionBuilder());
        specialFunctionMap.put("int", new WmiIntegralBuilder());
        specialFunctionMap.put("Int", new WmiIntegralBuilder(true));
        specialFunctionMap.put("matrix", new WmiTableBuilder());
        specialFunctionMap.put("Matrix", new WmiTableBuilder());
        specialFunctionMap.put("MATRIX", new WmiTableBuilder());
        specialFunctionMap.put("VECTOR", new WmiTableBuilder());
        specialFunctionMap.put("vector", new WmiTableBuilder());
        specialFunctionMap.put("product", new WmiCentralGlyphBuilder.ProductBuilder());
        specialFunctionMap.put("Product", new WmiCentralGlyphBuilder.ProductBuilder(true));
        specialFunctionMap.put("sqrt", new WmiPowerBuilder());
        specialFunctionMap.put("surd", new WmiPowerBuilder());
        specialFunctionMap.put("sum", new WmiCentralGlyphBuilder.SumBuilder());
        specialFunctionMap.put("Sum", new WmiCentralGlyphBuilder.SumBuilder(true));
        specialFunctionMap.put("RTABLE", new WmiRtableBuilder());
        specialFunctionMap.put("TABLE", new WmiLowerCaseBuilder());
        specialFunctionMap.put("<,>", new WmiVectorBuilder());
        specialFunctionMap.put("<|>", new WmiVectorBuilder());
        specialFunctionMap.put("`<,>`", new WmiVectorBuilder());
        specialFunctionMap.put("`<|>`", new WmiVectorBuilder());
        specialFunctionMap.put("Curl", new WmiVectorDerivativesBuilder("\u00d7"));
        specialFunctionMap.put("Gradient", new WmiVectorDerivativesBuilder(" "));
        specialFunctionMap.put("Divergence", new WmiVectorDerivativesBuilder("\u00b7"));
        specialFunctionMap.put("eval", new WmiEvalBuilder());
        specialFunctionMap.put("Eval", new WmiEvalBuilder(true));
        specialFunctionMap.put("$", new WmiInfixNotationBuilder("$", 13, 2, 2, false, 1));
        specialFunctionMap.put("@", new WmiInfixNotationBuilder("@", 4, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put(".", new WmiInfixNotationBuilder(".", 4, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put("mod", new WmiInfixNotationBuilder("mod", 7, 2, 2, true, 1));
        specialFunctionMap.put("in", new WmiInfixNotationBuilder("\u2208", 12, 2, 2, true, 1));
        specialFunctionMap.put("intersect", new WmiInfixNotationBuilder("\u2229", 4, 2, 2, true, 1));
        specialFunctionMap.put("union", new WmiInfixNotationBuilder("\u222a", 6, 2, 2, true, 1));
        specialFunctionMap.put("&+-", new WmiInfixNotationBuilder("\u00b1", 6, 2, 2, true, 1));
        specialFunctionMap.put("subset", new WmiInfixNotationBuilder("\u2286", 8, 2, 2, false, 1));
        specialFunctionMap.put("minus", new WmiInfixNotationBuilder("\u2216", 6, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put("limit", new WmiLimitBuilder());
        specialFunctionMap.put("Limit", new WmiLimitBuilder(true));
        specialFunctionMap.put("PIECEWISE", new WmiPiecewiseBuilder());
        specialFunctionMap.put("@@", new WmiCompositionBuilder());
        specialFunctionMap.put("Unit", new WmiUnitBuilder());
        specialFunctionMap.put("_SERIES", new WmiFunctionSeriesBuilder());
        specialFunctionMap.put("modp1", new WmiModpBuilder());
        specialFunctionMap.put("modp2", new WmiModpBuilder());
        WmiTypesettingBuilder wmiTypesettingBuilder = new WmiTypesettingBuilder();
        specialFunctionMap.put("Typesetting:-math", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-maligngroup", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-malignmark", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mambiguous", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-menclose", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-merror", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mfail", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mfenced", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mfrac", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mglyph", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mi", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mlabeledtr", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mscripts", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mmultiscripts", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mn", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mo", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mover", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mpadded", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mparsed", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mphantom", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mprescripts", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mprintslash", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mroot", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mrow", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-msemantics", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mspace", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-msqrt", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mstyle", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-ms", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-msub", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-msubsup", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-msup", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mtable", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mtd", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mtext", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-mtr", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-munder", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-munderover", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-none", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-unknown", wmiTypesettingBuilder);
        specialFunctionMap.put("Typesetting:-maction", wmiTypesettingBuilder);
        elisionSet.add("INTERFACE_PLOT");
        elisionSet.add("INTERFACE_PLOT3D");
    }
}

