/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import java.util.HashSet;

public class WmiInlineMathModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    public static final int FUNCTION_SIZE = 3;
    public static final int APPLY_FUNCTION_INDEX = 1;
    public static final int FENCED_MODEL_INDEX = 2;
    public static final int FUNCTION_NAME_INDEX = 0;
    protected WmiDeleteHandler deleteHandler = null;
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private static WmiModelTag[] PLACEHOLDER_SKIP = new WmiModelTag[]{WmiModelTag.MATH_FENCED, WmiModelTag.MATH_FRAC, WmiModelTag.MATH_IDENTIFIER, WmiModelTag.MATH_MULTISCRIPTS, WmiModelTag.MATH_NUMERIC, WmiModelTag.MATH_OPERATOR, WmiModelTag.MATH_OVER, WmiModelTag.MATH_SQUARE_ROOT, WmiModelTag.MATH_SUB_SUP, WmiModelTag.MATH_SUBSCRIPT, WmiModelTag.MATH_SUPERSCRIPT, WmiModelTag.MATH_UNDER, WmiModelTag.MATH_UNDER_OVER};
    static /* synthetic */ Class class$com$maplesoft$mathdoc$model$math$WmiInlineMathModel;

    public WmiInlineMathModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiInlineMathModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiInlineMathModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel);
        this.children = wmiModelArray;
        this.length = wmiModelArray.length;
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public static WmiInlineMathModel createLinebreakingMathRow(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, WmiMathContext wmiMathContext) {
        return new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : IMPLIED_SEMANTICS.toDag(this);
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        boolean bl = false;
        this.verifyUpdateLock();
        try {
            bl = this.getDocument().isMutableModel(this);
            if (bl && !this.isAFunction()) {
                this.guaranteeInsertPoints();
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        super.update(string);
    }

    private boolean isInputMethodText(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        boolean bl = false;
        if (wmiModel != null && (wmiAttributeSet = wmiModel.getAttributesForRead()) instanceof WmiFontAttributeSet && ((WmiFontAttributeSet)wmiAttributeSet).isInputMethodText()) {
            bl = true;
        }
        return bl;
    }

    private boolean requiresInputPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl;
        block2: {
            WmiModelTag wmiModelTag;
            block1: {
                boolean bl2;
                bl = true;
                wmiModelTag = wmiModel.getTag();
                if (wmiModelTag != WmiModelTag.MATH_SPACE) break block1;
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                boolean bl3 = wmiCompositeModel != null && wmiCompositeModel.getChildCount() > 0 ? wmiCompositeModel.getChild(0) == wmiModel : (bl2 = false);
                if (!bl2 || !MathTokenizer.isLinebreakingMSpace(wmiModel)) break block2;
                bl = true;
                break block2;
            }
            for (int i = 0; i < PLACEHOLDER_SKIP.length; ++i) {
                if (PLACEHOLDER_SKIP[i] != wmiModelTag) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel wmiModel;
        int n;
        String string;
        if (this.attributes != null && (string = (String)this.attributes.getAttribute("Typesetting:-msemantics")) != null && string.length() > 0) {
            return;
        }
        boolean bl = false;
        for (n = 0; n < this.getChildCount(); ++n) {
            wmiModel = this.getChild(n);
            if (!this.isInputMethodText(wmiModel)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < this.getChildCount(); ++n) {
                wmiModel = this.getChild(n);
                if (!this.requiresInputPlaceholder(wmiModel)) continue;
                if (n > 0) {
                    if (this.getChild(n - 1) instanceof WmiAbstractMathTokenModel) continue;
                    this.addChild(this.getPlaceHolder(n), n);
                    continue;
                }
                this.addChild(this.getPlaceHolder(0), 0);
            }
            if (this.getChildCount() == 0 || this.requiresInputPlaceholder(this.getChild(this.getChildCount() - 1))) {
                this.appendChild(this.getPlaceHolder(0));
            }
        }
    }

    public boolean isAFunction() throws WmiNoReadAccessException {
        return this.getChildCount() == 3 && this.getChild(1) instanceof WmiMathOperatorModel && "&ApplyFunction;".equals(((WmiMathOperatorModel)this.getChild(1)).getSemanticLabel()) && this.getChild(2) instanceof WmiMathFencedModel && this.getChild(0) instanceof WmiIdentifierModel;
    }

    private boolean isAFunctionRequiringWrapping() throws WmiNoReadAccessException {
        return this.isAFunction() && (!(this.getParent() instanceof WmiInlineMathModel) || this.getParent().getTag() == WmiModelTag.MATH_FENCED) && this.getDocument().isMutableModel(this);
    }

    private WmiModel getPlaceHolder(int n) throws WmiNoReadAccessException {
        Object object;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        Object object2 = wmiAttributeSet.getAttribute(WmiFontAttributeSet.STYLE_KEY);
        if (object2 == null && (object = WmiModelUtil.findAncestorOfTag((WmiModel)this, WmiModelTag.MATH)) != null) {
            wmiAttributeSet = object.getAttributesForRead();
            object2 = wmiAttributeSet.getAttribute(WmiFontAttributeSet.STYLE_KEY);
        }
        if (object2 instanceof String) {
            wmiAttributeSet = wmiMathDocumentModel.getFontStyle((String)object2);
        }
        if (wmiAttributeSet == null) {
            wmiAttributeSet = this.getAttributesForRead();
            if (n >= 0 && n < this.getChildCount()) {
                WmiCompositeModel wmiCompositeModel;
                object = this.getChild(n);
                while (object instanceof WmiCompositeModel && (wmiCompositeModel = (WmiCompositeModel)object).getChildCount() > 0) {
                    object = wmiCompositeModel.getChild(0);
                }
                if (object != null) {
                    wmiAttributeSet = object.getAttributesForRead();
                }
            }
        }
        wmiAttributeSet = wmiAttributeSet.copyAttributes();
        object = wmiMathDocumentModel.getActiveEditAttributes();
        ((WmiFontAttributeSet)object).setStyle(4096, false);
        if (object != null) {
            wmiAttributeSet.addAttributes((WmiAttributeSet)object);
        }
        return WmiMathWrapperModel.createPlaceHolder(this.getDocument(), wmiAttributeSet);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ROW;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics == null ? IMPLIED_SEMANTICS : wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    public WmiDeleteHandler getDeleteHandler() {
        return this.deleteHandler;
    }

    public static class WmiInlineMathDeleteHandler
    implements WmiDeleteHandler {
        private WmiInlineMathModel model;
        private static HashSet invisibleOperatorLabels = new HashSet();

        public void processDelete(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel wmiModel;
            int n;
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                Object object;
                Object object2;
                int n2 = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                n = 0;
                if (n2 >= 1 && n2 + 1 < this.model.getChildCount()) {
                    wmiModel = this.model.getChild(n2 - 1);
                    object2 = this.model.getChild(n2 + 1);
                    if ((wmiModel instanceof WmiIdentifierModel || wmiModel instanceof WmiNumericModel) && wmiModel.getClass().equals(object2.getClass())) {
                        object = wmiModel.getAttributes();
                        WmiAttributeSet wmiAttributeSet = object2.getAttributes();
                        n = object.equals(wmiAttributeSet) ? 1 : 0;
                    }
                }
                this.model.removeChild(n2);
                if (n != 0) {
                    wmiModel = (WmiTextModel)this.model.getChild(n2 - 1);
                    int n3 = ((WmiTextModel)wmiModel).getLength();
                    object = (WmiTextModel)this.model.getChild(n2);
                    ((WmiTextModel)wmiModel).appendText(((WmiTextModel)object).getText());
                    this.model.removeChild(n2);
                    wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModel, n3));
                }
                if (n2 <= 1 || !(this.model.getChild(n2 - 1) instanceof WmiAbstractMathTokenModel)) continue;
                wmiModel = (WmiAbstractMathTokenModel)this.model.getChild(n2 - 1);
                object2 = ((WmiAbstractMathTokenModel)wmiModel).getSemanticLabel();
                if (!(wmiModel instanceof WmiMathOperatorModel) || !"&ApplyFunction;".equals(object2)) continue;
                this.model.removeChild(n2 - 1);
                int n4 = 0;
                if (this.model.getChild(n2 - 2) instanceof WmiIdentifierModel) {
                    object = this.model.getChild(n2 - 2);
                    n4 = ((WmiIdentifierModel)object).getLength();
                } else if (this.model.getChildCount() >= n2 && this.model.getChild(n2 - 1) instanceof WmiIdentifierModel) {
                    object = this.model.getChild(n2 - 1);
                } else {
                    this.model.addChild(this.createEmptyIdentifier(), n2 - 1);
                    object = this.model.getChild(n2 - 1);
                }
                wmiDeleteManager.setModelToReposition(new WmiModelPosition((WmiModel)object, n4));
            }
            if (this.getVisibleModelCount() == 0) {
                WmiCompositeModel wmiCompositeModel = this.model.getParent();
                if (wmiCompositeModel instanceof WmiMathWrapperModel) {
                    n = this.model.getChildCount();
                    if (n > 0) {
                        this.model.removeChildren(0, n);
                        wmiModel = this.createEmptyIdentifier();
                        this.model.appendChild(wmiModel);
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModel, 0));
                    }
                } else {
                    n = wmiCompositeModel.indexOf(this.model);
                    if (n >= 0) {
                        wmiModel = this.createEmptyIdentifier();
                        wmiCompositeModel.replaceChild(wmiModel, n);
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModel, 0));
                        if (wmiCompositeModel.getClass().equals(class$com$maplesoft$mathdoc$model$math$WmiInlineMathModel == null ? (class$com$maplesoft$mathdoc$model$math$WmiInlineMathModel = WmiInlineMathModel.class$("com.maplesoft.mathdoc.model.math.WmiInlineMathModel")) : class$com$maplesoft$mathdoc$model$math$WmiInlineMathModel)) {
                            wmiDeleteManager.mark(wmiCompositeModel);
                        }
                    }
                }
            }
        }

        private int getVisibleModelCount() throws WmiNoReadAccessException {
            int n = 0;
            int n2 = this.model.getChildCount();
            for (int i = 0; i < n2; ++i) {
                if (WmiModelUtil.isEmptyIdentifierModel(this.model.getChild(i)) || WmiInlineMathDeleteHandler.isInvisibleOperator(this.model.getChild(i))) continue;
                ++n;
            }
            return n;
        }

        private static boolean isInvisibleOperator(WmiModel wmiModel) {
            WmiMathOperatorModel wmiMathOperatorModel;
            String string;
            boolean bl = false;
            if (wmiModel instanceof WmiMathOperatorModel && (string = (wmiMathOperatorModel = (WmiMathOperatorModel)wmiModel).getSemanticLabel()) != null && invisibleOperatorLabels.contains(string)) {
                bl = true;
            }
            return bl;
        }

        private WmiMathTokenModel createEmptyIdentifier() throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathDocumentModel wmiMathDocumentModel = this.model.getDocument();
            WmiFontAttributeSet wmiFontAttributeSet = null;
            WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag((WmiModel)this.model, WmiModelTag.MATH);
            if (wmiCompositeModel != null) {
                wmiFontAttributeSet = (WmiFontAttributeSet)wmiCompositeModel.getAttributes();
            }
            if (wmiFontAttributeSet == null) {
                wmiFontAttributeSet = this.model.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)this.model.getAttributes() : new WmiMathAttributeSet();
            }
            WmiMathContext wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
            return WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "", wmiMathContext);
        }

        public boolean forceDeleteHandling() {
            return false;
        }

        static {
            invisibleOperatorLabels.add("&ApplyFunction;");
            invisibleOperatorLabels.add("&af;");
            invisibleOperatorLabels.add("&InvisibleComma;");
            invisibleOperatorLabels.add("&ic;");
        }
    }
}

