/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import java.awt.Color;

public class WmiMathErrorModel
extends WmiInlineMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathErrorModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        this.setForegroundToRed();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathErrorModel(WmiMathDocumentModel wmiMathDocumentModel, String string) {
        super(wmiMathDocumentModel);
        this.setForegroundToRed();
        this.setSemantics(IMPLIED_SEMANTICS);
        try {
            WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
            WmiMathTextModel wmiMathTextModel = new WmiMathTextModel(wmiMathDocumentModel, string, wmiMathContext);
            this.appendChild(wmiMathTextModel);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
    }

    private void setForegroundToRed() {
        try {
            WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)this.getAttributes();
            wmiFontAttributeSet.addAttribute("foreground", Color.RED);
            this.addAttributes(wmiFontAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ERROR;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }
}

