/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiMathFencedModel
extends WmiInlineMathModel
implements WmiFontAttributeSource {
    public static final String OPEN = "open";
    public static final String CLOSE = "close";
    public static final String SEPARATORS = "separators";
    public static final int POS_BEFORE_OPEN_BRACKET = 0;
    public static final int POS_AFTER_OPEN_BRACKET = 1;
    public static final int POS_BEFORE_CLOSE_BRACKET = 2;
    public static final int POS_AFTER_CLOSE_BRACKET = 3;
    public static final int POS_UNCHANGED = 4;
    protected WmiMathContext savedContext;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    protected WmiMathTokenModel leftModel;
    protected WmiMathTokenModel rightModel;
    protected WmiMathTokenModel[] sepModel;

    public WmiMathFencedModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, WmiMathContext wmiMathContext) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        try {
            this.savedContext = wmiMathContext;
            WmiAttributeSet wmiAttributeSet = this.createCompatibleAttributeSet();
            WmiMathAttributeSet wmiMathAttributeSet = wmiMathContext.createAttributes(5);
            wmiAttributeSet.addAttributes(wmiMathAttributeSet);
            this.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_FENCED;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        super.setAttributes(wmiAttributeSet);
        try {
            WmiMathOperatorModel wmiMathOperatorModel;
            WmiMathOperatorModel wmiMathOperatorModel2 = (WmiMathOperatorModel)this.getModelForLeft();
            if (wmiMathOperatorModel2 != null) {
                wmiMathOperatorModel2.setAttributes(wmiAttributeSet);
                this.updateFenceDelimiter(wmiMathOperatorModel2, wmiAttributeSet.getAttribute(OPEN), "(");
            }
            if ((wmiMathOperatorModel = (WmiMathOperatorModel)this.getModelForRight()) != null) {
                wmiMathOperatorModel.setAttributes(wmiAttributeSet);
                this.updateFenceDelimiter(wmiMathOperatorModel, wmiAttributeSet.getAttribute(CLOSE), ")");
            }
            this.getModelForSeparator(0);
            if (this.sepModel != null) {
                Object object = wmiAttributeSet.getAttribute(SEPARATORS);
                String string = object != null ? object.toString() : null;
                boolean bl = false;
                if (string == null && this.sepModel.length != 1 || string != null && this.sepModel.length != string.length()) {
                    this.sepModel = null;
                    this.getModelForSeparator(0);
                    bl = true;
                }
                if (bl && this.sepModel.length == 1) {
                    this.sepModel[0].setAttributes(wmiAttributeSet);
                    this.updateFenceDelimiter((WmiMathOperatorModel)this.sepModel[0], string, ",");
                } else if (bl && this.sepModel.length > 1) {
                    for (int i = 0; i < this.sepModel.length; ++i) {
                        this.sepModel[i].setAttributes(wmiAttributeSet);
                        String string2 = Character.toString(string.charAt(i));
                        this.updateFenceDelimiter((WmiMathOperatorModel)this.sepModel[i], string2, ",");
                    }
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet, HashMap hashMap) throws WmiNoWriteAccessException {
        super.setAttributes(wmiAttributeSet, hashMap);
        try {
            WmiMathOperatorModel wmiMathOperatorModel;
            WmiMathOperatorModel wmiMathOperatorModel2 = (WmiMathOperatorModel)this.getModelForLeft();
            if (wmiMathOperatorModel2 != null) {
                wmiMathOperatorModel2.setAttributes(wmiAttributeSet);
            }
            if ((wmiMathOperatorModel = (WmiMathOperatorModel)this.getModelForRight()) != null) {
                wmiMathOperatorModel.setAttributes(wmiAttributeSet);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    private void updateFenceDelimiter(WmiMathOperatorModel wmiMathOperatorModel, Object object, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (object == null) {
            object = string;
        }
        try {
            wmiMathOperatorModel.replaceText(object.toString(), 0, wmiMathOperatorModel.getLength());
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    public void addAttribute(Object object, Object object2) throws WmiNoWriteAccessException {
        super.addAttribute(object, object2);
        try {
            WmiMathModel wmiMathModel;
            String string = object.toString();
            if (string != null && string.equals(OPEN)) {
                this.leftModel = null;
            } else {
                wmiMathModel = this.getModelForLeft();
                if (wmiMathModel != null) {
                    wmiMathModel.addAttribute(object, object2);
                }
            }
            if (string != null && string.equals(CLOSE)) {
                this.rightModel = null;
            } else {
                wmiMathModel = this.getModelForRight();
                if (wmiMathModel != null) {
                    wmiMathModel.addAttribute(object, object2);
                }
            }
            if (string != null && string.equals(SEPARATORS)) {
                this.sepModel = null;
            } else {
                this.getModelForSeparator(0);
                if (this.sepModel != null) {
                    for (int i = 0; i < this.sepModel.length; ++i) {
                        this.sepModel[i].addAttribute(object, object2);
                    }
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiFencedAttributeSet wmiFencedAttributeSet = new WmiFencedAttributeSet();
        wmiFencedAttributeSet.setAssociatedModel(this);
        return wmiFencedAttributeSet;
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public WmiMathModel getModelForRight() throws WmiNoReadAccessException {
        WmiMathTokenModel wmiMathTokenModel = this.rightModel;
        if (this.rightModel == null) {
            WmiFencedAttributeSet wmiFencedAttributeSet = (WmiFencedAttributeSet)this.getAttributesForRead();
            this.rightModel = wmiMathTokenModel = this.constructModel(")", wmiFencedAttributeSet.rightFence);
        }
        return wmiMathTokenModel;
    }

    public WmiMathModel getModelForLeft() throws WmiNoReadAccessException {
        WmiMathTokenModel wmiMathTokenModel = this.leftModel;
        if (this.leftModel == null) {
            WmiFencedAttributeSet wmiFencedAttributeSet = (WmiFencedAttributeSet)this.getAttributesForRead();
            this.leftModel = wmiMathTokenModel = this.constructModel("(", wmiFencedAttributeSet.leftFence);
        }
        return wmiMathTokenModel;
    }

    public WmiMathModel getModelForSeparator(int n) throws WmiNoReadAccessException {
        if (this.sepModel == null) {
            WmiFencedAttributeSet wmiFencedAttributeSet = (WmiFencedAttributeSet)this.getAttributesForRead();
            String string = wmiFencedAttributeSet.separator;
            if (string == null) {
                this.sepModel = new WmiMathTokenModel[1];
                this.sepModel[0] = this.constructModel(",", ",");
            } else if (string.length() > 0) {
                int n2;
                ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
                int n3 = 0;
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                while (n3 < string.length()) {
                    n2 = string.charAt(n3);
                    if (n2 == 32) {
                        ++n3;
                        continue;
                    }
                    if (n2 == 38) {
                        int n4 = string.indexOf(";", n3);
                        int n5 = string.indexOf("&", n3 + 1);
                        if (n4 != -1 && n4 > n3 + 1 && (n5 == -1 || n5 > n4)) {
                            bl = true;
                        }
                        if (string.length() > n3 + 1 && string.charAt(n3 + 1) == ' ') {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        arrayList.add(String.valueOf((char)n2));
                    } else {
                        stringBuffer.append((char)n2);
                    }
                    if (n2 == 59 && bl) {
                        arrayList.add(stringBuffer);
                        stringBuffer = new StringBuffer();
                        bl = false;
                    }
                    ++n3;
                }
                this.sepModel = new WmiMathTokenModel[arrayList.size()];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    this.sepModel[n2] = this.constructModel(arrayList.get(n2).toString(), arrayList.get(n2).toString());
                }
            } else {
                this.sepModel = new WmiMathTokenModel[1];
                this.sepModel[0] = this.constructModel("", "");
            }
        }
        return n >= this.sepModel.length ? this.sepModel[this.sepModel.length - 1] : this.sepModel[n];
    }

    private WmiMathTokenModel constructModel(String string, String string2) {
        WmiMathTokenModel wmiMathTokenModel = null;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        String string3 = string2 == null ? string : string2;
        try {
            wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string3, this.savedContext);
            wmiMathTokenModel.setParent(this);
            WmiAttributeSet wmiAttributeSet = wmiMathTokenModel.getAttributes();
            wmiAttributeSet.addAttributes(this.getAttributesForRead());
            wmiMathTokenModel.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        return wmiMathTokenModel;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
        if (this.leftModel != null) {
            this.leftModel.addAttributes(wmiFontAttributeSet);
        }
        if (this.rightModel != null) {
            this.rightModel.addAttributes(wmiFontAttributeSet);
        }
    }

    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiMathFencedDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (this.getChildCount() == 0) {
            this.appendChild(new WmiInlineMathModel(this.getDocument()));
        }
    }

    public WmiModelPosition convertToInlineMath(int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n2;
        Object object;
        int n3;
        WmiModelPosition wmiModelPosition = null;
        int n4 = this.getChildCount();
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        WmiMathModel wmiMathModel = null;
        WmiMathModel wmiMathModel2 = null;
        WmiModel[] wmiModelArray = new WmiModel[n4];
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        if (wmiAttributeSet instanceof WmiFencedAttributeSet) {
            wmiMathModel = this.getModelForLeft();
            wmiMathModel2 = this.getModelForRight();
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                wmiModelArray[n3] = this.getModelForSeparator(n3);
            }
        }
        n3 = 2 * n4 - 1;
        if (wmiMathModel != null) {
            ++n3;
        }
        if (wmiMathModel2 != null) {
            ++n3;
        }
        for (int i = 0; i < n4; ++i) {
            WmiModel wmiModel = this.getChild(i);
            if (wmiModel.getTag() != WmiModelTag.MATH_ROW) continue;
            n3 += ((WmiCompositeModel)wmiModel).getChildCount() - 1;
        }
        WmiModel[] wmiModelArray2 = new WmiModel[n3];
        int n5 = 0;
        if (wmiMathModel != null) {
            String string = ((WmiTextModel)((Object)wmiMathModel)).getText();
            wmiModelArray2[n5++] = new WmiMathOperatorModel(this.getDocument(), string, string, wmiMathContext);
        }
        for (int i = 0; i < n4; ++i) {
            WmiModel wmiModel = this.getChild(i);
            if (wmiModel.getTag() == WmiModelTag.MATH_ROW) {
                object = (WmiCompositeModel)wmiModel;
                n2 = object.getChildCount();
                for (int j = 0; j < n2; ++j) {
                    wmiModelArray2[n5++] = object.getChild(j);
                }
            } else {
                wmiModelArray2[n5++] = this.getChild(i);
            }
            if (i >= n4 - 1) continue;
            object = ((WmiTextModel)wmiModelArray[i]).getText();
            wmiModelArray2[n5++] = new WmiMathOperatorModel(this.getDocument(), (String)object, (String)object, wmiMathContext);
        }
        if (wmiMathModel2 != null) {
            String string = ((WmiTextModel)((Object)wmiMathModel2)).getText();
            wmiModelArray2[n5++] = new WmiMathOperatorModel(this.getDocument(), string, string, wmiMathContext);
        }
        WmiCompositeModel wmiCompositeModel = this.getParent();
        int n6 = wmiCompositeModel.indexOf(this);
        try {
            WmiCompositeModel wmiCompositeModel2;
            int n7;
            if (wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
                wmiCompositeModel.replaceChildren(wmiModelArray2, n6, 1);
            } else {
                object = new WmiInlineMathModel(this.getDocument());
                wmiCompositeModel.replaceChild((WmiModel)object, n6);
                ((WmiAbstractArrayCompositeModel)object).addChildren(wmiModelArray2, 0);
            }
            object = null;
            n2 = 1;
            switch (n) {
                case 0: {
                    object = wmiModelArray2[0];
                    break;
                }
                case 1: {
                    object = wmiModelArray2[0];
                    if (wmiMathModel == null) break;
                    n2 = 0;
                    break;
                }
                case 2: {
                    Object object2 = object = wmiModelArray2.length > 0 ? wmiModelArray2[wmiModelArray2.length - 1] : wmiModelArray2[0];
                    if (wmiMathModel2 != null) break;
                    n2 = 0;
                    break;
                }
                case 3: {
                    object = wmiModelArray2.length > 0 ? wmiModelArray2[wmiModelArray2.length - 1] : wmiModelArray2[0];
                    n2 = 0;
                }
            }
            while (object instanceof WmiCompositeModel && (n7 = (wmiCompositeModel2 = (WmiCompositeModel)object).getChildCount()) > 0) {
                object = wmiCompositeModel2.getChild(n2 != 0 ? 0 : n7 - 1);
            }
            int n8 = 0;
            if (n2 == 0 && object instanceof WmiTextModel) {
                n8 = ((WmiTextModel)object).getLength();
            }
            wmiModelPosition = new WmiModelPosition((WmiModel)object, n8);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return wmiModelPosition;
    }

    public static class WmiMathFencedDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        private static final int ON_THE_LEFT = 1;
        private static final int UNSPECIFIED_DELETE = 0;

        private WmiMathFencedDeleteHandler(WmiMathFencedModel wmiMathFencedModel) {
            this.model = wmiMathFencedModel;
        }

        public void processRestructure(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            boolean bl = false;
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel wmiModel;
                int n = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                WmiDeletePlaceholderModel wmiDeletePlaceholderModel = (WmiDeletePlaceholderModel)this.model.getChild(n);
                WmiModel wmiModel2 = wmiDeletePlaceholderModel.getReplacedModel();
                boolean bl2 = false;
                if (wmiModel2 instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)wmiModel2).getText().equals(",") && WmiModelUtil.isEmptyIdentifierModel(wmiModel = this.model.getChild(n - 1))) {
                    this.model.removeChild(n - 1);
                    bl2 = true;
                }
                if (!bl2) {
                    this.model.removeChild(n);
                }
                wmiModel = (WmiMathFencedModel)this.model;
                WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiModel.getModelForLeft();
                WmiMathOperatorModel wmiMathOperatorModel2 = (WmiMathOperatorModel)wmiModel.getModelForRight();
                if (wmiModel2 == wmiMathOperatorModel) {
                    bl = this.processLeftBracketRemoved(wmiDeleteManager);
                    continue;
                }
                if (wmiModel2 == wmiMathOperatorModel2) {
                    bl = this.processRightBracketRemoved(wmiDeleteManager);
                    continue;
                }
                this.repositionForElementDelete(wmiDeleteManager, n);
            }
            if (!bl && this.model.getChildCount() == 0) {
                this.processFenceRemoved(wmiDeleteManager);
            }
            this.markParentForDeletion(wmiDeleteManager);
        }

        private WmiModel[] createChildrenArray(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
            return this.createChildrenArray(wmiCompositeModel, 0);
        }

        private WmiModel[] createChildrenArray(WmiCompositeModel wmiCompositeModel, int n) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel2;
            int n2;
            int n3 = n2 = wmiCompositeModel.getChildCount();
            if (n == 1) {
                ++n3;
            }
            WmiModel[] wmiModelArray = new WmiModel[n3];
            for (int i = 0; i < n2; ++i) {
                wmiModelArray[i] = wmiCompositeModel.getChild(i);
            }
            if (n == 1 && wmiCompositeModel.getParent() instanceof WmiMathFencedModel && (wmiCompositeModel2 = wmiCompositeModel.getParent()) instanceof WmiMathFencedModel) {
                wmiModelArray[n3 - 1] = ((WmiMathFencedModel)wmiCompositeModel2).getModelForRight();
            }
            return wmiModelArray;
        }

        private WmiModel[] createChildrenListArray(WmiMathOperatorModel wmiMathOperatorModel) throws WmiNoReadAccessException {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)this.model;
            WmiModel[] wmiModelArray = this.createChildrenArray(this.model);
            int n = wmiModelArray.length * 2;
            int n2 = 0;
            if (wmiMathOperatorModel == null) {
                --n;
            }
            WmiModel[] wmiModelArray2 = new WmiModel[n];
            if (wmiMathOperatorModel != null) {
                wmiModelArray2[n2++] = wmiMathOperatorModel;
            }
            int n3 = wmiModelArray.length;
            for (int i = 0; i < n3; ++i) {
                wmiModelArray2[n2++] = wmiModelArray[i];
                if (i >= n3 - 1) continue;
                WmiMathOperatorModel wmiMathOperatorModel2 = (WmiMathOperatorModel)wmiMathFencedModel.getModelForSeparator(i);
                wmiModelArray2[n2++] = wmiMathOperatorModel2;
            }
            return wmiModelArray2;
        }

        private boolean processLeftBracketRemoved(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel wmiMathOperatorModel;
            WmiModel wmiModel;
            WmiCompositeModel wmiCompositeModel = this.model.getParent();
            int n = wmiCompositeModel.indexOf(this.model);
            int n2 = this.model.getChildCount();
            WmiModel[] wmiModelArray = null;
            wmiModelArray = n2 == 1 ? ((wmiModel = (WmiMathModel)this.model.getChild(0)) instanceof WmiInlineMathModel ? this.createChildrenArray((WmiInlineMathModel)wmiModel, 1) : new WmiModel[]{wmiModel}) : this.createChildrenListArray(null);
            if (WmiMathModelUtil.requiresMRow(wmiCompositeModel)) {
                try {
                    wmiModel = new WmiInlineMathModel(wmiCompositeModel.getDocument(), wmiModelArray);
                    wmiCompositeModel.replaceChild(wmiModel, n);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            } else {
                wmiCompositeModel.replaceChildren(wmiModelArray, n, 1);
            }
            if (n > 1 && (wmiModel = wmiCompositeModel.getChild(n - 1)) instanceof WmiMathOperatorModel && (wmiMathOperatorModel = (WmiMathOperatorModel)wmiModel).getSemanticLabel().equals("&ApplyFunction;")) {
                wmiCompositeModel.removeChild(n - 1);
            }
            wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiModelArray[0], 0));
            return true;
        }

        private boolean processRightBracketRemoved(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel wmiModel;
            WmiCompositeModel wmiCompositeModel = this.model.getParent();
            int n = wmiCompositeModel.indexOf(this.model);
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)this.model;
            WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiMathFencedModel.getModelForLeft();
            int n2 = this.model.getChildCount();
            WmiModel[] wmiModelArray = null;
            if (n2 == 1) {
                wmiModel = (WmiMathModel)this.model.getChild(0);
                if (wmiModel instanceof WmiInlineMathModel) {
                    ((WmiInlineMathModel)wmiModel).addChild(wmiMathOperatorModel, 0);
                    wmiModelArray = this.createChildrenArray((WmiInlineMathModel)wmiModel);
                } else {
                    wmiModelArray = new WmiModel[]{wmiMathOperatorModel, wmiModel};
                }
            } else {
                wmiModelArray = this.createChildrenListArray(wmiMathOperatorModel);
            }
            wmiModel = null;
            WmiModelPosition wmiModelPosition = null;
            if (WmiMathModelUtil.requiresMRow(wmiCompositeModel)) {
                try {
                    WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiCompositeModel.getDocument(), wmiModelArray);
                    wmiCompositeModel.replaceChild(wmiInlineMathModel, n);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            } else {
                wmiCompositeModel.replaceChildren(wmiModelArray, n, 1);
            }
            int n3 = wmiModelArray.length;
            wmiModel = wmiModelArray[n3 - 1];
            if (wmiModel instanceof WmiCompositeModel) {
                WmiModelPath wmiModelPath = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)wmiModel);
                wmiModelPosition = wmiModelPath.getModelPosition(this.model.getDocument());
            } else {
                int n4 = 0;
                if (wmiModel instanceof WmiTextModel) {
                    n4 = ((WmiTextModel)wmiModel).getLength();
                }
                wmiModelPosition = new WmiModelPosition(wmiModel, n4);
            }
            if (wmiModelPosition != null) {
                wmiDeleteManager.setModelToReposition(wmiModelPosition);
            }
            return true;
        }

        private void repositionForElementDelete(WmiDeleteManager wmiDeleteManager, int n) throws WmiNoReadAccessException {
            if (this.model.getChildCount() > 0) {
                WmiModelPosition wmiModelPosition = null;
                if (n == 0) {
                    WmiModel wmiModel = this.model.getChild(0);
                    wmiModelPosition = new WmiModelPosition(wmiModel, 0);
                } else {
                    WmiModel wmiModel = this.model.getChild(n - 1);
                    if (wmiModel instanceof WmiCompositeModel) {
                        WmiModelPath wmiModelPath = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)wmiModel);
                        wmiModelPosition = wmiModelPath.getModelPosition(this.model.getDocument());
                    } else if (wmiModel instanceof WmiTextModel) {
                        int n2 = ((WmiTextModel)wmiModel).getLength();
                        wmiModelPosition = new WmiModelPosition(wmiModel, n2);
                    }
                }
                if (wmiModelPosition != null) {
                    wmiDeleteManager.setModelToReposition(wmiModelPosition);
                }
            }
        }

        private void processFenceRemoved(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiCompositeModel wmiCompositeModel = this.model.getParent();
            int n = wmiCompositeModel.indexOf(this.model);
            WmiFontAttributeSet wmiFontAttributeSet = this.model.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)this.model.getAttributes() : new WmiMathAttributeSet();
            WmiMathContext wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(this.model.getDocument(), "", wmiMathContext);
            wmiCompositeModel.replaceChild(wmiMathTokenModel, n);
            wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiMathTokenModel, 0));
        }

        public boolean forceDeleteHandling() {
            return true;
        }

        protected void replaceNonEmptyPlaceholders(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel wmiModel;
            WmiModel wmiModel2;
            if (this.model.getChildCount() == 1 && (wmiModel2 = this.model.getChild(0)) instanceof WmiDeletePlaceholderModel && !WmiModelUtil.isEmptyIdentifierModel(wmiModel = ((WmiDeletePlaceholderModel)wmiModel2).getReplacedModel())) {
                this.replaceWithEmptyIdentifier(wmiDeleteManager, 0);
            }
        }

        private void markParentForDeletion(WmiDeleteManager wmiDeleteManager) throws WmiNoReadAccessException {
            if (this.model.getParent() instanceof WmiInlineMathModel) {
                WmiCompositeModel wmiCompositeModel = this.model.getParent();
                wmiDeleteManager.mark(wmiCompositeModel);
            }
        }
    }

    public static class SeparatorKey
    extends WmiStringAttributeKey {
        public SeparatorKey() {
            super(WmiMathFencedModel.SEPARATORS, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFencedAttributeSet)wmiAttributeSet).separator;
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFencedAttributeSet)wmiAttributeSet).separator = ",".equals(string) ? null : string;
        }
    }

    public static class CloseKey
    extends WmiStringAttributeKey {
        public CloseKey() {
            super(WmiMathFencedModel.CLOSE, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFencedAttributeSet)wmiAttributeSet).rightFence;
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFencedAttributeSet)wmiAttributeSet).rightFence = ")".equals(string) ? null : string;
        }
    }

    public static class OpenKey
    extends WmiStringAttributeKey {
        public OpenKey() {
            super(WmiMathFencedModel.OPEN, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFencedAttributeSet)wmiAttributeSet).leftFence;
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFencedAttributeSet)wmiAttributeSet).leftFence = "(".equals(string) ? null : string;
        }
    }

    public static class WmiFencedAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"open", "close", "separators", "Typesetting:-msemantics"};
        public static final WmiAttributeKey[] FENCED_KEYS = new WmiAttributeKey[]{new OpenKey(), new CloseKey(), new SeparatorKey(), new WmiMathAttributeSet.SemanticsKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_FENCE = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), FENCED_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private String leftFence = null;
        private String rightFence = null;
        private String separator = null;

        public WmiFencedAttributeSet() {
        }

        public WmiFencedAttributeSet(WmiFencedAttributeSet wmiFencedAttributeSet) {
            super(wmiFencedAttributeSet);
            this.rightFence = wmiFencedAttributeSet.rightFence;
            this.leftFence = wmiFencedAttributeSet.leftFence;
            this.separator = wmiFencedAttributeSet.separator;
            this.setSemantics(wmiFencedAttributeSet.getSemantics());
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiFencedAttributeSet(this);
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiFencedAttributeSet) {
                WmiFencedAttributeSet wmiFencedAttributeSet = (WmiFencedAttributeSet)wmiAttributeSet;
                this.rightFence = wmiFencedAttributeSet.rightFence;
                this.leftFence = wmiFencedAttributeSet.leftFence;
                this.separator = wmiFencedAttributeSet.separator;
                this.setSemantics(wmiFencedAttributeSet.getSemantics());
            }
        }

        protected void setAssociatedModel(WmiMathFencedModel wmiMathFencedModel) {
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiFencedAttributeSet) {
                WmiFencedAttributeSet wmiFencedAttributeSet = (WmiFencedAttributeSet)object;
                bl = true;
                if (this.leftFence != null) {
                    bl = this.leftFence.equals(wmiFencedAttributeSet.leftFence);
                }
                if (bl && this.rightFence != null) {
                    bl = this.rightFence.equals(wmiFencedAttributeSet.rightFence);
                }
                if (bl && this.separator != null) {
                    bl = this.separator.equals(wmiFencedAttributeSet.separator);
                }
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            if (this.leftFence != null) {
                n ^= this.leftFence.hashCode();
            }
            if (this.rightFence != null) {
                n ^= this.rightFence.hashCode();
            }
            if (this.separator != null) {
                n ^= this.separator.hashCode();
            }
            return n;
        }

        public String getLeftFence() {
            return this.leftFence;
        }

        public String getRightFence() {
            return this.rightFence;
        }

        public String getSeparator() {
            return this.separator;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_FENCE;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }
    }
}

