/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFloatAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.util.WmiStringParseTools;
import java.util.HashMap;
import java.util.HashSet;

public class WmiMathOperatorModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    private static HashSet normalStyleOperators = new HashSet();
    private static HashSet keywordStyleOperators = new HashSet();
    private static HashSet infixKeywords = new HashSet();
    public static final String FORM = "form";
    public static final String FENCE = "fence";
    public static final String SEPARATOR = "separator";
    public static final String LSPACE = "lspace";
    public static final String RSPACE = "rspace";
    public static final String STRETCHY = "stretchy";
    public static final String SYMMETRIC = "symmetric";
    public static final String MAXSIZE = "maxsize";
    public static final String MINSIZE = "minsize";
    public static final String LARGEOP = "largeop";
    public static final String MOVABLELIMITS = "movablelimits";
    public static final String ACCENT = "accent";
    private static final float ZERO_SPACE_VALUE = 0.0f;
    private static final float VERYVERYTHIN_SPACE_VALUE = 0.0555556f;
    private static final float VERYTHIN_SPACE_VALUE = 0.1111111f;
    private static final float THIN_SPACE_VALUE = 0.1666667f;
    private static final float MEDIUM_SPACE_VALUE = 0.2222222f;
    private static final float THICK_SPACE_VALUE = 0.2777778f;
    private static final float VERYTHICK_SPACE_VALUE = 0.3333333f;
    public static final String PREFIX = "prefix";
    public static final String INFIX = "infix";
    public static final String POSTFIX = "postfix";
    public static final String ZERO_SPACE = "0em";
    public static final String VERYVERYTHIN_SPACE = "veryverythinmathspace";
    public static final String VERYTHIN_SPACE = "verythinmathspace";
    public static final String THIN_SPACE = "thinmathspace";
    public static final String MEDIUM_SPACE = "mediummathspace";
    public static final String THICK_SPACE = "thickmathspace";
    public static final String VERYTHICK_SPACE = "verythickmathspace";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static boolean disableStretchyOps = false;
    private WmiMathSemantics semantics = null;

    private static void createNormalStyleMappings() {
        normalStyleOperators.add("[");
        normalStyleOperators.add("]");
        normalStyleOperators.add("{");
        normalStyleOperators.add("}");
        normalStyleOperators.add("(");
        normalStyleOperators.add(")");
        normalStyleOperators.add("&verbar;");
        normalStyleOperators.add("&verbar;");
    }

    private static void createKeywordStyleMappings() {
        keywordStyleOperators.add("and");
        keywordStyleOperators.add("not");
        keywordStyleOperators.add("or");
        keywordStyleOperators.add("xor");
        keywordStyleOperators.add("&DoubleRightArrow;");
        keywordStyleOperators.add("implies");
        keywordStyleOperators.add("local");
        keywordStyleOperators.add("global");
        keywordStyleOperators.add("description");
        keywordStyleOperators.add("option");
        keywordStyleOperators.add("proc");
        keywordStyleOperators.add("module");
        keywordStyleOperators.add("end");
        keywordStyleOperators.add("if");
        keywordStyleOperators.add("then");
        keywordStyleOperators.add("elif");
        keywordStyleOperators.add("else");
        keywordStyleOperators.add("fi");
        keywordStyleOperators.add("for");
        keywordStyleOperators.add("in");
        keywordStyleOperators.add("from");
        keywordStyleOperators.add("by");
        keywordStyleOperators.add("to");
        keywordStyleOperators.add("while");
        keywordStyleOperators.add("do");
        keywordStyleOperators.add("od");
        keywordStyleOperators.add("end do");
        keywordStyleOperators.add("read");
        keywordStyleOperators.add("save");
        keywordStyleOperators.add("stop");
        keywordStyleOperators.add("error");
        keywordStyleOperators.add("try");
        keywordStyleOperators.add("catch");
        keywordStyleOperators.add("finally");
        keywordStyleOperators.add("return");
        keywordStyleOperators.add("break");
        keywordStyleOperators.add("next");
        keywordStyleOperators.add("moddef");
        keywordStyleOperators.add("export");
        keywordStyleOperators.add("use");
        keywordStyleOperators.add("end if");
        keywordStyleOperators.add("end proc");
        keywordStyleOperators.add("end try");
        keywordStyleOperators.add("end use");
        keywordStyleOperators.add("end module");
        keywordStyleOperators.add("union");
        keywordStyleOperators.add("intersect");
        keywordStyleOperators.add("subset");
        keywordStyleOperators.add("minus");
        keywordStyleOperators.add("in");
        keywordStyleOperators.add("intersect");
        keywordStyleOperators.add("iff");
        keywordStyleOperators.add("nand");
        keywordStyleOperators.add("nor");
        keywordStyleOperators.add("mod");
        keywordStyleOperators.add("union");
        keywordStyleOperators.add("options");
    }

    public WmiMathOperatorModel(WmiMathDocumentModel wmiMathDocumentModel, String string, String string2, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel) {
        this(wmiMathDocumentModel, string, string2, wmiMathContext);
        this.parent = wmiCompositeModel;
    }

    public WmiMathOperatorModel(WmiMathDocumentModel wmiMathDocumentModel, String string, String string2, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel, string2, wmiMathContext);
        this.attributes = this.createCompatibleAttributeSet();
        ((WmiMathOperatorAttributeSet)this.attributes).enablePadding(wmiMathContext.isOperatorPaddingEnabled());
        boolean bl = false;
        try {
            bl = WmiMathOperatorDictionary.installAttributes(this, this.attributes);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        int n = WmiMathOperatorModel.getType(string2);
        WmiMathAttributeSet wmiMathAttributeSet = wmiMathContext.createAttributes(n);
        if (wmiMathAttributeSet != null) {
            ((WmiMathAttributeSet)this.attributes).copyMathAttributes(wmiMathAttributeSet);
        }
        this.attributes = ((WmiMathOperatorAttributeSet)this.attributes).pack();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathOperatorModel(WmiMathDocumentModel wmiMathDocumentModel, String string, String string2, WmiAttributeSet wmiAttributeSet) {
        super(wmiMathDocumentModel, string2);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(wmiAttributeSet);
        this.attributes = ((WmiMathOperatorAttributeSet)this.attributes).pack();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    protected boolean enableMapleSyntaxMapping() {
        return false;
    }

    public void replaceText(String string, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        super.replaceText(string, n, n2);
        try {
            WmiAttributeSet wmiAttributeSet = this.getAttributes();
            WmiMathOperatorDictionary.installAttributes(this, wmiAttributeSet);
            this.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public static int getType(String string) {
        int n = 3;
        if (normalStyleOperators.contains(string)) {
            n = 5;
        } else if (keywordStyleOperators.contains(string)) {
            n = 4;
        }
        return n;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_OPERATOR;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    protected WmiTextModel createSubModel(int n) throws WmiNoReadAccessException {
        return new WmiMathOperatorModel(this.getDocument(), this.getText().substring(n), this.getText().substring(n), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet = new WmiMathOperatorAttributeSet();
        return wmiMathOperatorAttributeSet;
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public boolean isSubselectable() {
        return true;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    protected boolean checkForQuotes() {
        return false;
    }

    public boolean forceSave(Object object, Object object2) {
        boolean bl = false;
        if (object.toString().equals("bold") && object2.toString().equals("false")) {
            try {
                String string = this.getAllText();
                bl = keywordStyleOperators.contains(string);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
        return bl;
    }

    static {
        WmiMathOperatorModel.createNormalStyleMappings();
        WmiMathOperatorModel.createKeywordStyleMappings();
    }

    public static class WmiMathOperatorAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "largeop", "movablelimits", "accent", "font_style_name", "size", "foreground", "background"};
        public static final int FENCE_STYLE = 1;
        public static final int SEPARATOR_STYLE = 2;
        public static final int STRETCHY_STYLE = 4;
        public static final int SYMMETRIC_STYLE = 8;
        public static final int LARGEOP_STYLE = 16;
        public static final int MOVABLE_LIMITS_STYLE = 32;
        public static final int ACCENT_STYLE = 64;
        public static final int FENCE_UNSET_STYLE = 128;
        public static final int SEPARATOR_UNSET_STYLE = 256;
        public static final int STRETCHY_UNSET_STYLE = 512;
        public static final int SYMMETRIC_UNSET_STYLE = 1024;
        public static final int LARGEOP_UNSET_STYLE = 2048;
        public static final int MOVABLE_UNSET_LIMITS_STYLE = 4096;
        public static final int ACCENT_UNSET_STYLE = 8192;
        public static final int PT_PADDING_STYLE = 16384;
        public static final int UNSET_FACTOR = 128;
        public static final WmiAttributeKey[] OPERATOR_KEYS = new WmiAttributeKey[]{new FenceKey(), new SeparatorKey(), new StretchyKey(), new SymmetricKey(), new LargeOpKey(), new MovableLimitsKey(), new AccentKey(), new LSpaceKey(), new RSpaceKey()};
        private static final float SPACE_TOLERANCE = 1.0E-6f;
        public static final WmiAttributeKey[] EXTENDED_KEYS_OPERATOR = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, OPERATOR_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected float lspace = 0.0f;
        protected float rspace = 0.0f;
        protected int operatorStyle = 0;
        protected boolean operatorPadding = true;

        public WmiMathOperatorAttributeSet() {
        }

        public WmiMathOperatorAttributeSet(WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet) {
            super(wmiMathOperatorAttributeSet);
            this.lspace = wmiMathOperatorAttributeSet.lspace;
            this.rspace = wmiMathOperatorAttributeSet.rspace;
            this.operatorStyle = wmiMathOperatorAttributeSet.operatorStyle;
            this.operatorPadding = wmiMathOperatorAttributeSet.operatorPadding;
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathOperatorAttributeSet) {
                WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet = (WmiMathOperatorAttributeSet)wmiAttributeSet;
                this.lspace = wmiMathOperatorAttributeSet.lspace;
                this.rspace = wmiMathOperatorAttributeSet.rspace;
                this.operatorStyle = wmiMathOperatorAttributeSet.operatorStyle;
                this.operatorPadding = wmiMathOperatorAttributeSet.operatorPadding;
            }
        }

        public void enablePadding(boolean bl) {
            this.operatorPadding = bl;
        }

        public void resetDefaultOperatorDictionaryAttributes() {
            this.lspace = 0.0f;
            this.rspace = 0.0f;
            this.operatorStyle = 0;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathOperatorAttributeSet(this);
        }

        public boolean isFence() {
            return this.hasOperatorStyle(1);
        }

        public boolean isSeparator() {
            return this.hasOperatorStyle(2);
        }

        public float getLSpace() {
            return this.operatorPadding ? this.lspace : 0.0f;
        }

        public float getRSpace() {
            return this.operatorPadding ? this.rspace : 0.0f;
        }

        public boolean isStretchy() {
            return this.hasOperatorStyle(4);
        }

        public boolean isSymmetric() {
            return this.hasOperatorStyle(8);
        }

        public boolean isLargeOp() {
            return this.hasOperatorStyle(16);
        }

        public boolean hasMovableLimits() {
            return this.hasOperatorStyle(32);
        }

        public boolean isAccent() {
            return this.hasOperatorStyle(64);
        }

        public boolean hasOperatorStyle(int n) {
            return (this.operatorStyle & n) != 0;
        }

        public void setOperatorStyle(int n, int n2) {
            this.operatorStyle = n2 == 1 ? (this.operatorStyle |= n) : (n2 == 0 ? (this.operatorStyle &= ~n) : (this.operatorStyle |= n * 128));
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathOperatorAttributeSet) {
                WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet = (WmiMathOperatorAttributeSet)object;
                boolean bl2 = bl = wmiMathOperatorAttributeSet.operatorStyle == this.operatorStyle;
                if (Math.abs(this.lspace - wmiMathOperatorAttributeSet.lspace) > 1.0E-6f) {
                    bl = false;
                } else if (Math.abs(this.rspace - wmiMathOperatorAttributeSet.rspace) > 1.0E-6f) {
                    bl = false;
                }
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= this.operatorStyle;
            n ^= (int)(this.lspace * 100000.0f);
            return n ^= (int)(this.rspace * 100000.0f);
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_OPERATOR;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class RSpaceKey
        extends PaddingKey {
            public RSpaceKey() {
                super(WmiMathOperatorModel.RSPACE, 0.2777778f);
            }

            public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathOperatorAttributeSet)wmiAttributeSet).rspace;
            }

            public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
                ((WmiMathOperatorAttributeSet)wmiAttributeSet).rspace = ((WmiMathOperatorAttributeSet)wmiAttributeSet).operatorPadding ? f : 0.0f;
            }
        }

        public static class LSpaceKey
        extends PaddingKey {
            public LSpaceKey() {
                super(WmiMathOperatorModel.LSPACE, 0.2777778f);
            }

            public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathOperatorAttributeSet)wmiAttributeSet).lspace;
            }

            public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
                ((WmiMathOperatorAttributeSet)wmiAttributeSet).lspace = ((WmiMathOperatorAttributeSet)wmiAttributeSet).operatorPadding ? f : 0.0f;
            }
        }

        public static class PaddingKey
        extends WmiFloatAttributeKey {
            public static final int PICAS_TO_PIXELS = 12;
            public static final int INCHES_TO_PIXELS = 72;
            public static final float CENTIMETRES_TO_PIXELS = 28.346457f;
            public static final float MM_TO_PIXELS = 283.46457f;
            public static final float EX_TO_EM = 0.65f;
            public static final float PERCENT_TO_EM = 0.01f;
            static HashMap nameMap = new HashMap();

            protected PaddingKey(String string, float f) {
                super(string, f);
            }

            public Object getValue(WmiAttributeSet wmiAttributeSet) {
                return this.getStringValue(wmiAttributeSet);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                float f = this.getFloatValue(wmiAttributeSet);
                String string = "em";
                if (wmiAttributeSet instanceof WmiMathOperatorAttributeSet && (((WmiMathOperatorAttributeSet)wmiAttributeSet).operatorStyle & 0x4000) != 0) {
                    string = "pt";
                }
                return Float.toString(f) + string;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                if (nameMap.size() == 0) {
                    nameMap.put(WmiMathOperatorModel.VERYVERYTHIN_SPACE, new Float(0.0555556f));
                    nameMap.put(WmiMathOperatorModel.VERYTHIN_SPACE, new Float(0.1111111f));
                    nameMap.put(WmiMathOperatorModel.THIN_SPACE, new Float(0.1666667f));
                    nameMap.put(WmiMathOperatorModel.MEDIUM_SPACE, new Float(0.2222222f));
                    nameMap.put(WmiMathOperatorModel.THICK_SPACE, new Float(0.2777778f));
                    nameMap.put(WmiMathOperatorModel.VERYTHICK_SPACE, new Float(0.3333333f));
                }
                WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet = null;
                if (wmiAttributeSet instanceof WmiMathOperatorAttributeSet) {
                    wmiMathOperatorAttributeSet = (WmiMathOperatorAttributeSet)wmiAttributeSet;
                }
                float f = 0.0f;
                Object v = nameMap.get(string);
                if (v instanceof Float) {
                    f = ((Float)v).floatValue();
                    if (wmiMathOperatorAttributeSet != null) {
                        wmiMathOperatorAttributeSet.operatorStyle &= 0xFFFFBFFF;
                    }
                } else if (string.length() > 2) {
                    int n = string.endsWith("%") ? 1 : 2;
                    try {
                        f = WmiStringParseTools.parseFloat(string, 0, string.length() - n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (string.endsWith("em")) {
                        if (wmiMathOperatorAttributeSet != null) {
                            wmiMathOperatorAttributeSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else if (string.endsWith("ex")) {
                        f *= 0.65f;
                        if (wmiMathOperatorAttributeSet != null) {
                            wmiMathOperatorAttributeSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else if (string.endsWith("%")) {
                        f *= 0.01f;
                        if (wmiMathOperatorAttributeSet != null) {
                            wmiMathOperatorAttributeSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else {
                        if (wmiMathOperatorAttributeSet != null) {
                            wmiMathOperatorAttributeSet.operatorStyle |= 0x4000;
                        }
                        if (string.endsWith("cm")) {
                            f *= 28.346457f;
                        } else if (string.endsWith("mm")) {
                            f *= 283.46457f;
                        } else if (string.endsWith("in")) {
                            f *= 72.0f;
                        } else if (string.endsWith("pc")) {
                            f *= 12.0f;
                        } else if (!string.endsWith("pt") && !string.endsWith("px")) {
                            f = 0.0f;
                        }
                    }
                }
                this.setFloatValue(wmiAttributeSet, f);
            }
        }

        public static class AccentKey
        extends OperatorStyleKey {
            public AccentKey() {
                super(WmiMathOperatorModel.ACCENT, 64);
            }
        }

        public static class MovableLimitsKey
        extends OperatorStyleKey {
            public MovableLimitsKey() {
                super(WmiMathOperatorModel.MOVABLELIMITS, 32);
            }
        }

        public static class LargeOpKey
        extends OperatorStyleKey {
            public LargeOpKey() {
                super(WmiMathOperatorModel.LARGEOP, 16);
            }
        }

        public static class SymmetricKey
        extends OperatorStyleKey {
            public SymmetricKey() {
                super(WmiMathOperatorModel.SYMMETRIC, 8);
            }
        }

        public static class SeparatorKey
        extends OperatorStyleKey {
            public SeparatorKey() {
                super(WmiMathOperatorModel.SEPARATOR, 2);
            }
        }

        public static class StretchyKey
        extends OperatorStyleKey {
            public StretchyKey() {
                super(WmiMathOperatorModel.STRETCHY, 4);
            }
        }

        public static class FenceKey
        extends OperatorStyleKey {
            public FenceKey() {
                super(WmiMathOperatorModel.FENCE, 1);
            }
        }

        public static class OperatorStyleKey
        extends WmiBooleanAttributeKey {
            private int styleBit;
            private static final int FALSE_VALUE = 0;
            private static final int TRUE_VALUE = 1;
            private static final int UNSET_VALUE = 2;
            public static final String UNSET = "unset";

            public OperatorStyleKey(String string, int n) {
                super(string, false);
                this.styleBit = n;
            }

            public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
                return wmiAttributeSet instanceof WmiMathOperatorAttributeSet ? ((WmiMathOperatorAttributeSet)wmiAttributeSet).hasOperatorStyle(this.styleBit) : false;
            }

            public Object getValue(WmiAttributeSet wmiAttributeSet) {
                if (((WmiMathOperatorAttributeSet)wmiAttributeSet).hasOperatorStyle(this.styleBit)) {
                    return "true";
                }
                if (((WmiMathOperatorAttributeSet)wmiAttributeSet).hasOperatorStyle(this.styleBit * 128)) {
                    return UNSET;
                }
                return "false";
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
                if (wmiAttributeSet instanceof WmiMathOperatorAttributeSet) {
                    if (bl) {
                        ((WmiMathOperatorAttributeSet)wmiAttributeSet).setOperatorStyle(this.styleBit, 1);
                    } else {
                        ((WmiMathOperatorAttributeSet)wmiAttributeSet).setOperatorStyle(this.styleBit, 0);
                    }
                }
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, int n) {
                if (wmiAttributeSet instanceof WmiMathOperatorAttributeSet) {
                    ((WmiMathOperatorAttributeSet)wmiAttributeSet).setOperatorStyle(this.styleBit, n);
                }
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                if (string != null) {
                    if (string.compareToIgnoreCase("true") == 0) {
                        this.setBooleanValue(wmiAttributeSet, 1);
                    } else if (string.compareToIgnoreCase("false") == 0) {
                        this.setBooleanValue(wmiAttributeSet, 0);
                    } else if (string.compareToIgnoreCase(UNSET) == 0) {
                        this.setBooleanValue(wmiAttributeSet, 2);
                    } else {
                        this.setBooleanValue(wmiAttributeSet, this.defaultValue);
                    }
                } else {
                    this.setBooleanValue(wmiAttributeSet, this.defaultValue);
                }
            }
        }
    }
}

