/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathPaddedModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    public static final String WIDTH = "width";
    public static final String LSPACE = "lspace";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiMathPaddedModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPaddedModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPaddedModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, new WmiModel[]{wmiModel});
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiMathPaddedModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel, WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
        super(wmiMathDocumentModel);
        this.children = new WmiModel[]{wmiModel};
        this.length = 1;
        this.attributes = wmiMathPaddedAttributeSet;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_PADDED;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathPaddedAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathPaddedAttributeSet();
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public static class WmiMathSpaceDimensionUnit
    extends WmiDimensionUnit {
        protected String dimension = "";
        protected int sign = 0;

        protected WmiMathSpaceDimensionUnit(WmiDimensionUnit wmiDimensionUnit, String string, int n) {
            super(wmiDimensionUnit.getUnitsValue(), wmiDimensionUnit.getUnit(), wmiDimensionUnit.getDefaultUnit());
            this.dimension = string;
            this.sign = n;
        }

        public String getDimension() {
            return this.dimension;
        }

        public int getSign() {
            return this.sign;
        }

        public static WmiMathSpaceDimensionUnit createDimension(String string, String string2, WmiDimensionUnit wmiDimensionUnit) {
            int n = 0;
            if (string.startsWith("+")) {
                n = 1;
                string = string.substring(1);
            } else if (string.startsWith("-")) {
                n = -1;
                string = string.substring(1);
            }
            wmiDimensionUnit = WmiDimensionUnit.createDimension(string, null);
            WmiDimensionUnit wmiDimensionUnit2 = WmiDimensionUnit.createDimension(string, wmiDimensionUnit);
            return new WmiMathSpaceDimensionUnit(wmiDimensionUnit2, string2, n);
        }
    }

    public static class WmiMathPaddedAttributeSet
    extends WmiFontAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"width", "lspace", "height", "depth"};
        private static final WmiMathSpaceDimensionUnit DEFAULT_HEIGHT = WmiMathSpaceDimensionUnit.createDimension("+0ex", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_WIDTH = WmiMathSpaceDimensionUnit.createDimension("+0em", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_DEPTH = WmiMathSpaceDimensionUnit.createDimension("+0ex", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_LSPACE = WmiMathSpaceDimensionUnit.createDimension("+0em", "", null);
        public static final WmiAttributeKey[] PADDED_KEYS = new WmiAttributeKey[]{new HeightKey(), new WidthKey(), new DepthKey(), new LSpaceKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, PADDED_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private WmiMathSpaceDimensionUnit height = DEFAULT_HEIGHT;
        private WmiMathSpaceDimensionUnit width = DEFAULT_WIDTH;
        private WmiMathSpaceDimensionUnit depth = DEFAULT_DEPTH;
        private WmiMathSpaceDimensionUnit lspace = DEFAULT_LSPACE;

        public WmiMathPaddedAttributeSet() {
        }

        public WmiMathPaddedAttributeSet(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
            super(wmiMathPaddedAttributeSet);
            this.width = wmiMathPaddedAttributeSet.width;
            this.height = wmiMathPaddedAttributeSet.height;
            this.depth = wmiMathPaddedAttributeSet.depth;
            this.lspace = wmiMathPaddedAttributeSet.lspace;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathPaddedAttributeSet(this);
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathPaddedAttributeSet) {
                WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet = (WmiMathPaddedAttributeSet)wmiAttributeSet;
                this.width = wmiMathPaddedAttributeSet.width;
                this.height = wmiMathPaddedAttributeSet.height;
                this.depth = wmiMathPaddedAttributeSet.depth;
                this.lspace = wmiMathPaddedAttributeSet.lspace;
            }
        }

        public WmiMathSpaceDimensionUnit getWidth() {
            return this.width;
        }

        public WmiMathSpaceDimensionUnit getHeight() {
            return this.height;
        }

        public WmiMathSpaceDimensionUnit getDepth() {
            return this.depth;
        }

        public WmiMathSpaceDimensionUnit getLSpace() {
            return this.lspace;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathPaddedAttributeSet) {
                WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet = (WmiMathPaddedAttributeSet)object;
                bl &= this.lspace.equals(wmiMathPaddedAttributeSet.lspace);
                bl &= this.height.equals(wmiMathPaddedAttributeSet.height);
                bl &= this.width.equals(wmiMathPaddedAttributeSet.width);
                bl &= this.depth.equals(wmiMathPaddedAttributeSet.depth);
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= this.lspace.hashCode();
            n ^= this.height.hashCode();
            n ^= this.width.hashCode();
            return n ^= this.depth.hashCode();
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class LSpaceKey
        extends DimensionKey {
            public LSpaceKey() {
                super(WmiMathPaddedModel.LSPACE, DEFAULT_LSPACE);
            }

            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
                return wmiMathPaddedAttributeSet.lspace;
            }

            public void setDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathPaddedAttributeSet.lspace = (WmiMathSpaceDimensionUnit)wmiDimensionUnit;
            }
        }

        public static class DepthKey
        extends DimensionKey {
            public DepthKey() {
                super(WmiMathPaddedModel.DEPTH, DEFAULT_DEPTH);
            }

            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
                return wmiMathPaddedAttributeSet.depth;
            }

            public void setDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathPaddedAttributeSet.depth = (WmiMathSpaceDimensionUnit)wmiDimensionUnit;
            }
        }

        public static class WidthKey
        extends DimensionKey {
            public WidthKey() {
                super(WmiMathPaddedModel.WIDTH, DEFAULT_WIDTH);
            }

            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
                return wmiMathPaddedAttributeSet.width;
            }

            public void setDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathPaddedAttributeSet.width = (WmiMathSpaceDimensionUnit)wmiDimensionUnit;
            }
        }

        public static class HeightKey
        extends DimensionKey {
            public HeightKey() {
                super(WmiMathPaddedModel.HEIGHT, DEFAULT_HEIGHT);
            }

            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet) {
                return wmiMathPaddedAttributeSet.height;
            }

            public void setDimension(WmiMathPaddedAttributeSet wmiMathPaddedAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathPaddedAttributeSet.height = (WmiMathSpaceDimensionUnit)wmiDimensionUnit;
            }
        }

        public static abstract class DimensionKey
        extends WmiStringAttributeKey {
            private WmiMathSpaceDimensionUnit defaultDimension;

            public DimensionKey(String string, WmiMathSpaceDimensionUnit wmiMathSpaceDimensionUnit) {
                super(string, null);
                this.defaultDimension = wmiMathSpaceDimensionUnit;
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                Object object = this.getValue(wmiAttributeSet);
                return object != null ? object.toString() : null;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                this.setValue(wmiAttributeSet, string);
            }

            public Object getValue(WmiAttributeSet wmiAttributeSet) {
                return this.getDimension((WmiMathPaddedAttributeSet)wmiAttributeSet);
            }

            public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
                WmiDimensionUnit wmiDimensionUnit = null;
                if (object instanceof WmiDimensionUnit) {
                    wmiDimensionUnit = (WmiDimensionUnit)object;
                } else {
                    String string = object.toString();
                    String string2 = object.toString();
                    String string3 = "";
                    if (string.indexOf(" ") > -1) {
                        int n = string.indexOf(" ");
                        string3 = string.substring(n + 1);
                        string2 = string.substring(0, n);
                    }
                    wmiDimensionUnit = WmiMathSpaceDimensionUnit.createDimension(string2, string3, this.defaultDimension);
                }
                this.setDimension((WmiMathPaddedAttributeSet)wmiAttributeSet, wmiDimensionUnit);
            }

            public abstract WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet var1);

            public abstract void setDimension(WmiMathPaddedAttributeSet var1, WmiDimensionUnit var2);
        }
    }
}

