/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathPhantomModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    public static final String LINEBREAK_CONTEXT = "phantom";
    public static final String CONSTRAINTS = "constraints";
    public static final String BOTH = "both";
    public static final String WIDTH_ONLY = "width-only";
    public static final String HEIGHT_ONLY = "height-only";
    public static final String[] CONSTRAINT_OPTIONS = new String[]{"both", "width-only", "height-only"};
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiMathPhantomModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPhantomModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPhantomModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, new WmiModel[]{wmiModel});
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiMathPhantomModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel, WmiMathPhantomAttributeSet wmiMathPhantomAttributeSet) {
        super(wmiMathDocumentModel);
        this.children = new WmiModel[]{wmiModel};
        this.length = 1;
        this.attributes = wmiMathPhantomAttributeSet;
    }

    public static WmiMathPhantomModel createHeightPhantom(WmiModel wmiModel) {
        WmiMathPhantomAttributeSet wmiMathPhantomAttributeSet = new WmiMathPhantomAttributeSet();
        wmiMathPhantomAttributeSet.addAttribute(CONSTRAINTS, HEIGHT_ONLY);
        WmiMathPhantomModel wmiMathPhantomModel = new WmiMathPhantomModel(wmiModel.getDocument(), wmiModel, wmiMathPhantomAttributeSet);
        return wmiMathPhantomModel;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_PHANTOM;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathPhantomAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathPhantomAttributeSet();
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public static class WmiMathPhantomAttributeSet
    extends WmiFontAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"constraints"};
        public static final WmiAttributeKey[] PHANTOM_KEYS = new WmiAttributeKey[]{new ConstraintsKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, PHANTOM_KEYS);
        public static final int BOTH_INDEX = 0;
        public static final int WIDTH_ONLY_INDEX = 1;
        public static final int HEIGHT_ONLY_INDEX = 2;
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private int constraint = 0;

        public WmiMathPhantomAttributeSet() {
        }

        public WmiMathPhantomAttributeSet(WmiMathPhantomAttributeSet wmiMathPhantomAttributeSet) {
            super(wmiMathPhantomAttributeSet);
            this.constraint = wmiMathPhantomAttributeSet.constraint;
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathPhantomAttributeSet) {
                WmiMathPhantomAttributeSet wmiMathPhantomAttributeSet = (WmiMathPhantomAttributeSet)wmiAttributeSet;
                this.constraint = wmiMathPhantomAttributeSet.constraint;
            }
        }

        public boolean useWidth() {
            return this.constraint != 2;
        }

        public boolean useHeight() {
            return this.constraint != 1;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathPhantomAttributeSet(this);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathPhantomAttributeSet) {
                bl = ((WmiMathPhantomAttributeSet)object).constraint == this.constraint;
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            return n ^= this.constraint;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class ConstraintsKey
        extends WmiEnumeratedAttributeKey {
            protected ConstraintsKey() {
                super(WmiMathPhantomModel.CONSTRAINTS, CONSTRAINT_OPTIONS, 0);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathPhantomAttributeSet)wmiAttributeSet).constraint;
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiMathPhantomAttributeSet)wmiAttributeSet).constraint = n;
            }
        }
    }
}

