/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiFloatAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.util.WmiSearchVisitor;
import java.util.Enumeration;
import java.util.HashMap;

public class WmiMathStyleModel
extends WmiInlineMathModel
implements WmiFontAttributeSource {
    public WmiMathStyleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, WmiMathStyleAttributeSet wmiMathStyleAttributeSet) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        try {
            this.setAttributesNoRecurse(wmiMathStyleAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
    }

    public WmiMathStyleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
    }

    public WmiMathStyleModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_STYLE;
    }

    public void addTemporaryChild(WmiModel wmiModel) {
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
        this.ensureCapacity(1, this);
        if (wmiModel != null) {
            System.arraycopy(wmiModelArray, 0, this.children, 0, 1);
        }
        this.length = 1;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            this.updateChildrenWithAttributes(wmiAttributeSet, false);
            super.setAttributes(wmiAttributeSet);
            ((WmiMathStyleAttributeSet)this.attributes).attributeMap = (HashMap)((WmiMathStyleAttributeSet)wmiAttributeSet).attributeMap.clone();
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    public void setAttributesNoRecurse(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    private void updateChildrenWithAttributes(WmiAttributeSet wmiAttributeSet, boolean bl) {
        WmiGenericAttributeSet wmiGenericAttributeSet = WmiAttributeComparator.subtract(wmiAttributeSet, this.attributes);
        if (wmiGenericAttributeSet != null) {
            try {
                WmiModelUtil.visitModels(this, new WmiApplyStyleVisitor(this, wmiGenericAttributeSet, bl));
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }

    public void addAttribute(Object object, Object object2, boolean bl) throws WmiNoWriteAccessException {
        WmiGenericAttributeSet wmiGenericAttributeSet = new WmiGenericAttributeSet();
        wmiGenericAttributeSet.addAttribute(object, object2);
        this.updateChildrenWithAttributes(wmiGenericAttributeSet, bl);
        super.addAttribute(object, object2);
    }

    public void addAttribute(Object object, Object object2) throws WmiNoWriteAccessException {
        this.addAttribute(object, object2, false);
    }

    public void addAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        this.updateChildrenWithAttributes(wmiAttributeSet, false);
        super.addAttributes(wmiAttributeSet);
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathStyleAttributeSet();
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public static class WmiMathStyleAttributeSet
    extends WmiMathAttributeSet {
        public HashMap attributeMap = new HashMap();
        public static final String BACKGROUND = "background";
        public static final String VERYVERYTHINMATHSPACE = "veryverythinmathspace";
        public static final String VERYTHINMATHSPACE = "verythinmathspace";
        public static final String THINMATHSPACE = "thinmathspace";
        public static final String MEDIUMMATHSPACE = "mediummathspace";
        public static final String THICKMATHSPACE = "thickmathspace";
        public static final String VERYTHICKMATHSPACE = "verythickmathspace";
        public static final String VERYVERYTHICKMATHSPACE = "veryverythickmathspace";
        public static final String SCRIPTLEVEL = "scriptlevel";
        public static final String SCRIPTSIZEMULTIPLIER = "scriptsizemultiplier";
        public static final String SCRIPTMINSIZE = "scriptminsize";
        public static final int DEFAULT_BACKGROUND = 0xFFFFFF;
        public static final String DEFAULT_VERYVERYTHINMATHSPACE = "0.0555556em";
        public static final String DEFAULT_VERYTHINMATHSPACE = "0.111111em";
        public static final String DEFAULT_THINMATHSPACE = "0.166667em";
        public static final String DEFAULT_MEDIUMMATHSPACE = "0.222222em";
        public static final String DEFAULT_THICKMATHSPACE = "0.277778em";
        public static final String DEFAULT_VERYTHICKMATHSPACE = "0.333333em";
        public static final String DEFAULT_VERYVERYTHICKMATHSPACE = "0.388889em";
        public static final String DEFAULT_SCRIPTLEVEL = "0";
        public static final float DEFAULT_SCRIPTSIZEMULTIPLIER = 0.71f;
        public static final WmiDimensionUnit DEFAULT_SCRIPTMINSIZE = WmiDimensionUnit.createDimension("8pt", null);
        public static final String[] ATTRIBUTES = new String[]{"background", "veryverythinmathspace", "verythinmathspace", "thinmathspace", "mediummathspace", "thickmathspace", "verythickmathspace", "veryverythickmathspace", "scriptlevel", "scriptsizemultiplier", "scriptminsize"};
        public static final WmiAttributeKey[] STYLE_KEYS = new WmiAttributeKey[]{new BackgroundKey(), new VeryVeryThinMathSpaceKey(), new VeryThinMathSpaceKey(), new ThinMathSpaceKey(), new MediumMathSpaceKey(), new ThickMathSpaceKey(), new VeryThickMathSpaceKey(), new VeryVeryThickMathSpaceKey(), new ScriptLevelKey(), new ScriptSizeMultiplierKey(), new ScriptMinSizeKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, STYLE_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private int background = 0xFFFFFF;
        private String veryverythinmathspace = "0.0555556em";
        private String verythinmathspace = "0.111111em";
        private String thinmathspace = "0.166667em";
        private String mediummathspace = "0.222222em";
        private String thickmathspace = "0.277778em";
        private String verythickmathspace = "0.333333em";
        private String veryverythickmathspace = "0.388889em";
        private String scriptlevel = "0";
        private float scriptsizemultiplier = 0.71f;
        private WmiDimensionUnit scriptminsize = DEFAULT_SCRIPTMINSIZE;

        public WmiMathStyleAttributeSet() {
        }

        public WmiMathStyleAttributeSet(WmiMathStyleAttributeSet wmiMathStyleAttributeSet) {
            super(wmiMathStyleAttributeSet);
            this.background = wmiMathStyleAttributeSet.background;
            this.veryverythinmathspace = wmiMathStyleAttributeSet.veryverythinmathspace;
            this.verythinmathspace = wmiMathStyleAttributeSet.verythinmathspace;
            this.thinmathspace = wmiMathStyleAttributeSet.thinmathspace;
            this.mediummathspace = wmiMathStyleAttributeSet.mediummathspace;
            this.thickmathspace = wmiMathStyleAttributeSet.thickmathspace;
            this.verythickmathspace = wmiMathStyleAttributeSet.verythickmathspace;
            this.veryverythickmathspace = wmiMathStyleAttributeSet.veryverythickmathspace;
            this.scriptlevel = wmiMathStyleAttributeSet.scriptlevel;
            this.scriptsizemultiplier = wmiMathStyleAttributeSet.scriptsizemultiplier;
            this.scriptminsize = wmiMathStyleAttributeSet.scriptminsize;
            this.attributeMap = wmiMathStyleAttributeSet.attributeMap;
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathStyleAttributeSet) {
                WmiMathStyleAttributeSet wmiMathStyleAttributeSet = (WmiMathStyleAttributeSet)wmiAttributeSet;
                this.background = wmiMathStyleAttributeSet.background;
                this.veryverythinmathspace = wmiMathStyleAttributeSet.veryverythinmathspace;
                this.verythinmathspace = wmiMathStyleAttributeSet.verythinmathspace;
                this.thinmathspace = wmiMathStyleAttributeSet.thinmathspace;
                this.mediummathspace = wmiMathStyleAttributeSet.mediummathspace;
                this.thickmathspace = wmiMathStyleAttributeSet.thickmathspace;
                this.verythickmathspace = wmiMathStyleAttributeSet.verythickmathspace;
                this.veryverythickmathspace = wmiMathStyleAttributeSet.veryverythickmathspace;
                this.scriptlevel = wmiMathStyleAttributeSet.scriptlevel;
                this.scriptsizemultiplier = wmiMathStyleAttributeSet.scriptsizemultiplier;
                this.scriptminsize = wmiMathStyleAttributeSet.scriptminsize;
                this.attributeMap = wmiMathStyleAttributeSet.attributeMap;
            }
        }

        public void setBackground(int n) {
            this.background = n;
            this.setExtendedStyle(32);
        }

        public int getBackground() {
            return this.background;
        }

        public void setVeryVeryThinMathSpace(String string) {
            this.veryverythinmathspace = string;
        }

        public String getVeryVeryThinMathSpace() {
            return this.veryverythinmathspace;
        }

        public void setVeryThinMathSpace(String string) {
            this.verythinmathspace = string;
        }

        public String getVeryThinMathSpace() {
            return this.verythinmathspace;
        }

        public void setThinMathSpace(String string) {
            this.thinmathspace = string;
        }

        public String getThinMathSpace() {
            return this.thinmathspace;
        }

        public void setMediumMathSpace(String string) {
            this.mediummathspace = string;
        }

        public String getMediumMathSpace() {
            return this.mediummathspace;
        }

        public void setThickMathSpace(String string) {
            this.thickmathspace = string;
        }

        public String getThickMathSpace() {
            return this.thickmathspace;
        }

        public void setVeryThickMathSpace(String string) {
            this.verythickmathspace = string;
        }

        public String getVeryThickMathSpace() {
            return this.verythickmathspace;
        }

        public void setVeryVeryThickMathSpace(String string) {
            this.veryverythickmathspace = string;
        }

        public String getVeryVeryThickMathSpace() {
            return this.veryverythickmathspace;
        }

        public void setScriptLevel(String string) {
            this.scriptlevel = string;
        }

        public String getScriptLevel() {
            return this.scriptlevel;
        }

        public void setScriptSizeMultiplier(float f) {
            this.scriptsizemultiplier = f;
        }

        public float getScriptSizeMultiplier() {
            return this.scriptsizemultiplier;
        }

        public void setScriptMinSize(String string) {
            this.scriptminsize = WmiDimensionUnit.createDimension(string, null);
        }

        public WmiDimensionUnit getScriptMinSize() {
            return this.scriptminsize;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathStyleAttributeSet(this);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathStyleAttributeSet) {
                WmiMathStyleAttributeSet wmiMathStyleAttributeSet = (WmiMathStyleAttributeSet)object;
                bl = wmiMathStyleAttributeSet.background == this.background;
                bl &= this.veryverythinmathspace == wmiMathStyleAttributeSet.veryverythinmathspace;
                bl &= this.verythinmathspace == wmiMathStyleAttributeSet.verythinmathspace;
                bl &= this.thinmathspace == wmiMathStyleAttributeSet.thinmathspace;
                bl &= this.mediummathspace == wmiMathStyleAttributeSet.mediummathspace;
                bl &= this.thickmathspace == wmiMathStyleAttributeSet.thickmathspace;
                bl &= this.verythickmathspace == wmiMathStyleAttributeSet.verythickmathspace;
                bl &= this.veryverythickmathspace == wmiMathStyleAttributeSet.veryverythickmathspace;
                bl &= this.scriptlevel == wmiMathStyleAttributeSet.scriptlevel;
                bl &= this.scriptsizemultiplier == wmiMathStyleAttributeSet.scriptsizemultiplier;
                bl &= this.scriptminsize == wmiMathStyleAttributeSet.scriptminsize;
                bl &= this.attributeMap.equals(wmiMathStyleAttributeSet.attributeMap);
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= this.background;
            n ^= this.veryverythinmathspace.hashCode();
            n ^= this.verythinmathspace.hashCode();
            n ^= this.thinmathspace.hashCode();
            n ^= this.mediummathspace.hashCode();
            n ^= this.thickmathspace.hashCode();
            n ^= this.verythickmathspace.hashCode();
            n ^= this.veryverythickmathspace.hashCode();
            n ^= this.scriptlevel.hashCode();
            n ^= new Float(this.scriptsizemultiplier).hashCode();
            return n ^= this.scriptminsize.hashCode();
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public void addAttribute(Object object, Object object2) {
            this.attributeMap.put(object, object2);
            super.addAttribute(object, object2);
        }

        public static class ScriptMinSizeKey
        extends WmiStringAttributeKey {
            public ScriptMinSizeKey() {
                super(WmiMathStyleAttributeSet.SCRIPTMINSIZE, DEFAULT_SCRIPTMINSIZE.toString());
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptminsize.toString();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptminsize = WmiDimensionUnit.createDimension(string, null);
            }
        }

        public static class ScriptSizeMultiplierKey
        extends WmiFloatAttributeKey {
            public ScriptSizeMultiplierKey() {
                super(WmiMathStyleAttributeSet.SCRIPTSIZEMULTIPLIER, 0.71f);
            }

            public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptsizemultiplier;
            }

            public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptsizemultiplier = f;
            }
        }

        public static class ScriptLevelKey
        extends WmiStringAttributeKey {
            public ScriptLevelKey() {
                super(WmiMathStyleAttributeSet.SCRIPTLEVEL, "");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptlevel;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).scriptlevel = string;
            }
        }

        public static class VeryVeryThickMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryVeryThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYVERYTHICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYVERYTHICKMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).veryverythickmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).veryverythickmathspace = string;
            }
        }

        public static class VeryThickMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYTHICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYTHICKMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).verythickmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).verythickmathspace = string;
            }
        }

        public static class ThickMathSpaceKey
        extends WmiStringAttributeKey {
            public ThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.THICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_THICKMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).thickmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).thickmathspace = string;
            }
        }

        public static class MediumMathSpaceKey
        extends WmiStringAttributeKey {
            public MediumMathSpaceKey() {
                super(WmiMathStyleAttributeSet.MEDIUMMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_MEDIUMMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).mediummathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).mediummathspace = string;
            }
        }

        public static class ThinMathSpaceKey
        extends WmiStringAttributeKey {
            public ThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.THINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_THINMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).thinmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).thinmathspace = string;
            }
        }

        public static class VeryThinMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYTHINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYTHINMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).verythinmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).verythinmathspace = string;
            }
        }

        public static class VeryVeryThinMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryVeryThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYVERYTHINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYVERYTHINMATHSPACE);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).veryverythinmathspace;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).veryverythinmathspace = string;
            }
        }

        public static class BackgroundKey
        extends WmiColorAttributeKey {
            public BackgroundKey() {
                super(WmiMathStyleAttributeSet.BACKGROUND, 0xFFFFFF);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathStyleAttributeSet)wmiAttributeSet).getBackground();
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiMathStyleAttributeSet)wmiAttributeSet).setBackground(n);
            }
        }
    }

    public static class WmiApplyStyleVisitor
    implements WmiSearchVisitor {
        private WmiMathStyleModel parentModel;
        private WmiAttributeSet changes;
        private boolean fromBuild;

        public WmiApplyStyleVisitor(WmiMathStyleModel wmiMathStyleModel, WmiAttributeSet wmiAttributeSet, boolean bl) {
            this.parentModel = wmiMathStyleModel;
            this.changes = wmiAttributeSet;
            this.fromBuild = bl;
        }

        public int visitMatch(Object object) {
            int n;
            block15: {
                Object object2;
                Object object3;
                HashMap hashMap = null;
                if (this.changes instanceof WmiMathStyleAttributeSet) {
                    hashMap = ((WmiMathStyleAttributeSet)this.changes).attributeMap;
                } else {
                    hashMap = new HashMap();
                    Enumeration enumeration = this.changes.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        object3 = enumeration.nextElement();
                        object2 = this.changes.getAttribute(object3);
                        hashMap.put(object3, object2);
                    }
                }
                n = 2;
                try {
                    if (this.fromBuild && object != this.parentModel && object instanceof WmiMathStyleModel) {
                        n = 1;
                        break block15;
                    }
                    if (!(object instanceof WmiMathModel)) break block15;
                    if (object != this.parentModel) {
                        try {
                            object3 = ((WmiModel)object).getAttributes();
                            if (object3 != null) {
                                object2 = object3.getAttribute("Typesetting:-msemantics");
                                boolean bl = true;
                                boolean bl2 = bl = !(object2 instanceof String) || ((String)object2).indexOf("atomic") <= -1;
                                if (bl) {
                                    object3.addAttributes(this.changes);
                                    if (object instanceof WmiAbstractMathTokenModel) {
                                        ((WmiAbstractMathTokenModel)object).setAttributes((WmiAttributeSet)object3, true, hashMap);
                                    } else if (object instanceof WmiAbstractArrayCompositeMathModel) {
                                        ((WmiAbstractArrayCompositeMathModel)object).setAttributes((WmiAttributeSet)object3, hashMap);
                                    } else {
                                        ((WmiMathModel)object).setAttributes((WmiAttributeSet)object3);
                                    }
                                }
                            }
                        }
                        catch (WmiNoReadAccessException wmiNoReadAccessException) {
                            WmiErrorLog.log(wmiNoReadAccessException);
                        }
                    }
                    n = 0;
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
            }
            return n;
        }
    }
}

