/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public abstract class WmiCentralGlyphBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNCTION_ARGUMENT_DAG_INDEX = 0;
    private static final int EVAL_ARGUMENT_DAG_INDEX = 1;
    private static final int LHS_DAG_INDEX = 0;
    private static final int RHS_DAG_INDEX = 1;
    private static final int FROM_DAG_INDEX = 0;
    private static final int TO_DAG_INDEX = 1;
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiCentralGlyphBuilder() {
        this(false);
    }

    public WmiCentralGlyphBuilder(boolean bl) {
        this.isInert = bl;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
        WmiMathSpaceModel wmiMathSpaceModel = new WmiMathSpaceModel(wmiMathDocumentModel);
        wmiMathSpaceModel.addAttribute("width", "5");
        if (dag.getLength() == 1) {
            object = this.buildCentralOperator(wmiMathDocumentModel, wmiMathContext);
            WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(0), wmiMathContext);
            wmiAbstractArrayCompositeModel.appendChild((WmiModel)object);
            wmiAbstractArrayCompositeModel.appendChild(wmiMathSpaceModel);
            wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
        } else {
            object = this.buildUnderOver(wmiMathDocumentModel, dag, wmiMathContext);
            Dag dag2 = dag.getChild(0);
            WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            wmiMathModel = this.addBracketsIfRequired(dag2, wmiMathModel, wmiMathContext);
            wmiAbstractArrayCompositeModel.appendChild((WmiModel)object);
            wmiAbstractArrayCompositeModel.appendChild(wmiMathSpaceModel);
            wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
        }
        object = this.getSemantics();
        if (object != null) {
            wmiInlineMathModel.setSemantics((WmiMathSemantics)object);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel addBracketsIfRequired(Dag dag, WmiMathModel wmiMathModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (WmiPrecedenceRules.areBracketsRequired(dag, this.getPrecedence(), 1)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        return wmiMathModel;
    }

    protected int getPrecedence() {
        return 20;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        Dag dag2;
        boolean bl = super.shouldBeUsed(dag, wmiMathContext);
        if (bl && (dag2 = dag.getChild(1)).getLength() > 0 && dag2.getLength() < 3) {
            if (dag2.getLength() == 1) {
                bl = true;
            } else {
                Dag dag3 = dag2.getChild(1);
                int n = dag3.getType();
                if (n == 20) {
                    Dag dag4 = dag3.getChild(1);
                    if (dag4.getType() == 35) {
                        bl = dag4.getChild(0).getType() <= 19 && dag4.getChild(1).getType() <= 19;
                    }
                } else {
                    bl = n == 8;
                }
            }
        }
        return bl;
    }

    protected WmiMathModel buildCentralOperator(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, this.getOperatorString(), wmiMathContext);
        if (this.isInert) {
            this.inertize((WmiMathOperatorModel)wmiMathTokenModel);
        }
        return wmiMathTokenModel;
    }

    protected WmiMathModel buildUnderOver(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiAbstractArrayCompositeMathModel wmiAbstractArrayCompositeMathModel = null;
        WmiMathModel wmiMathModel = this.buildCentralOperator(wmiMathDocumentModel, wmiMathContext);
        Dag dag2 = dag.getChild(1);
        if (dag2.getType() == 20) {
            Dag dag3 = dag2.getChild(0);
            Dag dag4 = dag2.getChild(1);
            if (dag4.getType() == 35) {
                WmiMathModel wmiMathModel2 = this.buildUnder(wmiMathDocumentModel, dag3, dag4.getChild(0), wmiMathContext);
                WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag4.getChild(1), wmiMathContext);
                wmiAbstractArrayCompositeMathModel = new WmiUnderOverModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathModel3, wmiMathContext);
            } else {
                WmiMathModel wmiMathModel4 = this.buildUnder(wmiMathDocumentModel, dag3, dag4, wmiMathContext);
                wmiAbstractArrayCompositeMathModel = new WmiUnderModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel4, wmiMathContext);
            }
        } else if (dag2.getType() == 8) {
            WmiMathModel wmiMathModel5 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            wmiAbstractArrayCompositeMathModel = new WmiUnderModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel5, wmiMathContext);
        }
        return wmiAbstractArrayCompositeMathModel;
    }

    public WmiMathModel buildUnder(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
        wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "=", wmiMathContext));
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        wmiAbstractArrayCompositeModel.appendChild(wmiMathModel2);
        return wmiInlineMathModel;
    }

    protected abstract String getOperatorString();

    protected abstract WmiMathSemantics getSemantics();

    private static class ProductOperatorSemantics
    extends LargeOperatorSemantics {
        private ProductOperatorSemantics() {
        }

        protected Dag getFunctionName() {
            return WmiSemanticDagUtil.PRODUCT_FUNC_NAME;
        }
    }

    public static class SumOperatorSemantics
    extends LargeOperatorSemantics {
        protected Dag getFunctionName() {
            return WmiSemanticDagUtil.SUM_FUNC_NAME;
        }
    }

    private static abstract class LargeOperatorSemantics
    implements WmiMathSemantics {
        private static final int LARGE_OP_OPERATOR_INDEX = 0;
        private static final int LARGE_OP_ARGUMENT_INDEX = 2;
        private static final int OVERUNDER_EQUALITY_INDEX = 1;
        private static final int OVERUNDER_UPPER_RANGE_INDEX = 2;
        private static final int EQUALITY_IDENTIFIER_INDEX = 0;
        private static final int EQUALITY_VALUE_INDEX = 2;
        private static final int UNDER_IDENTIFIER_INDEX = 1;

        private LargeOperatorSemantics() {
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                int n = 0;
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(n + 0);
                while (wmiMathModel2 instanceof WmiMathSpaceModel || WmiModelUtil.isEmptyIdentifierModel(wmiMathModel2)) {
                    wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(++n + 0);
                }
                int n2 = n;
                wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(n2 + 2);
                while (wmiMathModel2 instanceof WmiMathSpaceModel || WmiModelUtil.isEmptyIdentifierModel(wmiMathModel2)) {
                    wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(++n2 + 2);
                }
                WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(0 + n);
                WmiMathModel wmiMathModel4 = (WmiMathModel)wmiCompositeModel.getChild(2 + n2);
                if (wmiMathModel3 != null && wmiMathModel4 != null) {
                    Dag dag2 = wmiMathModel4.toDag();
                    Dag dag3 = null;
                    WmiModelTag wmiModelTag = wmiMathModel3.getTag();
                    if (wmiModelTag != WmiModelTag.MATH_OPERATOR) {
                        if (wmiModelTag == WmiModelTag.MATH_UNDER) {
                            dag3 = this.createVarOrExprDag(wmiMathModel3);
                        } else if (wmiModelTag == WmiModelTag.MATH_UNDER_OVER) {
                            dag3 = this.createRangeDag(wmiMathModel3);
                        }
                    }
                    Dag dag4 = this.getFunctionName();
                    dag = dag3 != null ? WmiSemanticDagUtil.createFunction(dag4, dag2, dag3) : WmiSemanticDagUtil.createFunction(dag4, dag2);
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }

        private Dag createVarOrExprDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(1);
            if (wmiMathModel2 != null) {
                if (wmiMathModel2.isComposite()) {
                    WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)((Object)wmiMathModel2);
                    WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel2.getChild(0);
                    WmiMathModel wmiMathModel4 = (WmiMathModel)wmiCompositeModel2.getChild(2);
                    if (wmiMathModel3 != null && wmiMathModel4 != null) {
                        dag = WmiSemanticDagUtil.createEquation(wmiMathModel3.toDag(), wmiMathModel4.toDag());
                    }
                } else {
                    dag = wmiMathModel2.toDag();
                }
            }
            return dag;
        }

        private Dag createRangeDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiCompositeModel.getChild(1);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel2.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel2.getChild(2);
            WmiMathModel wmiMathModel4 = (WmiMathModel)wmiCompositeModel.getChild(2);
            Dag dag = wmiMathModel2.toDag();
            Dag[] dagArray = new Dag[]{wmiMathModel3.toDag(), wmiMathModel4.toDag()};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            Dag dag2 = Dag.createDag(35, dagArray, null, false);
            return WmiSemanticDagUtil.createEquation(dag, dag2);
        }

        protected abstract Dag getFunctionName();
    }

    public static class ProductBuilder
    extends WmiCentralGlyphBuilder {
        public static final String PRODUCT_PI_OPERATOR = "&Product;";
        private static final WmiMathSemantics PRODUCT_SEMANTICS = new ProductOperatorSemantics();

        public ProductBuilder() {
        }

        public ProductBuilder(boolean bl) {
            super(bl);
        }

        public String getOperatorString() {
            return PRODUCT_PI_OPERATOR;
        }

        protected WmiMathSemantics getSemantics() {
            return PRODUCT_SEMANTICS;
        }

        protected int getPrecedence() {
            return 4;
        }
    }

    public static class SumBuilder
    extends WmiCentralGlyphBuilder {
        public static final String SUM_SIGMA_OPERATOR = "&Sum;";
        private static final WmiMathSemantics SUM_SEMANTICS = new SumOperatorSemantics();

        public SumBuilder() {
        }

        public SumBuilder(boolean bl) {
            super(bl);
        }

        public String getOperatorString() {
            return SUM_SIGMA_OPERATOR;
        }

        protected WmiMathSemantics getSemantics() {
            return SUM_SEMANTICS;
        }

        protected int getPrecedence() {
            return 6;
        }
    }
}

