/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiInfixNotationBuilder;

public class WmiCompositionBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int BASE_INDEX = 0;
    private static final int POWER_INDEX = 1;
    private static final WmiMathSemantics COMP_SEMANTICS = new WmiCompositionSemantics();

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel wmiMathModel = null;
        if (!wmiMathContext.useProcRules()) {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            if (WmiPrecedenceRules.areBracketsRequired(dag2, 1, 0)) {
                wmiMathModel2 = WmiMathFactory.addBrackets(wmiMathModel2, wmiMathContext);
            }
            WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext);
            wmiMathModel3 = WmiMathFactory.addBrackets(wmiMathModel3, wmiMathContext);
            wmiMathModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModel2, wmiMathModel3, wmiMathContext);
            wmiMathModel.setSemantics(COMP_SEMANTICS);
        } else {
            WmiInfixNotationBuilder wmiInfixNotationBuilder = new WmiInfixNotationBuilder(string, 2, 2, 2, false, 1);
            wmiMathModel = wmiInfixNotationBuilder.createSpecialFunctionModel(wmiMathDocumentModel, string, dag, wmiMathContext);
        }
        return wmiMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = dag.getLength() > 1 && dag.getChild(1) != null;
        Dag dag2 = dag.getChild(1);
        int n = dag2.getLength();
        return bl && dag2 != null && n == 2;
    }

    public static class WmiCompositionSemantics
    implements WmiMathSemantics {
        private static final int COMP_FUNCTION_INDEX = 0;
        private static final int COMP_APPLICATION_INDEX = 1;

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
                WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
                if (wmiMathModel2 != null && wmiMathModel3 != null) {
                    dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.COMPOSITION_FUNC_NAME, wmiMathModel2.toDag(), wmiMathModel3.toDag());
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }
    }
}

