/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiRtableBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String BROWSE_RTABLE_ACTION_TYPE = "browsertable";
    public static final String RTABLE_ADDRESS_ACTION = "rtableaddress";
    public static final String RTABLE_ID_ATTR_KEY = "rtableid";
    private static final int DIMENSION_COUNT_POS = 6;
    private static final int LOWER_RANGE_POS = 0;
    private static final int UPPER_RANGE_POS = 1;
    private static final int FUNC_DAG_INDEX = 1;
    private static final int NAME_DAG_INDEX = 2;
    private static final int TYPE_DAG_INDEX_IN_TABLEREF = 1;
    private static final int EXP_SEQ_INDEX = 1;
    private static final int BASIS_LIST_INDEX_IN_EXP_SEQ = 1;
    private static final int RTABLE_ID_INDEX = 0;
    private static final int DATA_TYPE_INDEX = 1;
    private static final int ARRAY_TYPE_INDEX = 2;
    private static final int STORAGE_TYPE_INDEX = 3;
    private static final int ORDER_TYPE_INDEX = 4;
    private static final int RTABLE_SIZE = 4;
    private static final String DATA_TYPE_KEY = "Data Type: ";
    private static final String STORAGE_TYPE_KEY = "Storage: ";
    private static final String ORDER_TYPE_KEY = "Order: ";
    private static final WmiMathSemantics RTABLE_SEMANTICS = new WmiRTableWrapperSemantics();
    private static final WmiMathSemantics COLLAPSED_RTABLE_SEMANTICS = new WmiCollapsedRtableSemantics();
    private static final WmiMathSemantics MATRIX_SEMANTICS = new WmiMatrixSemantics();
    private static final WmiMathSemantics ROW_VECTOR_SEMANTICS = new WmiRowVectorSemantics();
    private static final WmiMathSemantics COLUMN_VECTOR_SEMANTICS = new WmiColumnVectorSemantics();
    private static final WmiMathSemantics ARRAY_MATRIX_SEMANTICS = new WmiArrayMatrixSemantics();
    private static final WmiMathSemantics ARRAY_VECTOR_SEMANTICS = new WmiArrayVectorSemantics();
    private static final WmiMathSemantics BASIS_VECTOR_SEMANTICS = new WmiImpliedSemantics();
    private static final String MATRIX_NAME = "Matrix";
    private static final String ARRAY_NAME = "Array";
    private static final String MATRIX_NAME_IN_DAG = "MATRIX";
    private static final String ROW_NAME = "row";
    private static final String COLUMN_NAME = "column";
    private static final String VECTOR_NAME = "Vector";
    private static final String VECTOR_NAME_IN_DAG = "VECTOR";
    private static final int INDEX_OF_INLINE = 1;
    private static final int INDEX_OF_TABLE_IN_INLINE = 0;
    private static final int INDEX_OF_DATA_IN_TABLE_CELL = 0;

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        Object object;
        Object object2;
        boolean bl = this.isSummaryForm(dag);
        Dag dag2 = dag.getChild(1);
        WmiMathModel wmiMathModel = null;
        if (!bl) {
            wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            if (dag.getLength() >= 3) {
                object2 = dag.getChild(2);
                if (((Dag)object2).getLength() == 0) {
                    object = ((Dag)object2).getData();
                    if (MATRIX_NAME.equals(object)) {
                        this.setSemantics(wmiMathModel, MATRIX_SEMANTICS, MATRIX_NAME);
                    } else if (ARRAY_NAME.equals(object)) {
                        String string2 = dag2.getChild(0).getData();
                        if (MATRIX_NAME_IN_DAG.equals(string2)) {
                            this.setSemantics(wmiMathModel, ARRAY_MATRIX_SEMANTICS, MATRIX_NAME);
                        } else if (VECTOR_NAME_IN_DAG.equals(string2)) {
                            this.setSemantics(wmiMathModel, ARRAY_VECTOR_SEMANTICS, VECTOR_NAME);
                        }
                    }
                } else {
                    object = dag2.getChild(1);
                    boolean bl2 = ((Dag)object).getLength() == 2;
                    Dag dag3 = ((Dag)object2).getChild(1);
                    String string3 = dag3.getChild(0).getData();
                    if (ROW_NAME.equals(string3)) {
                        if (bl2) {
                            this.setSemantics(wmiMathModel, BASIS_VECTOR_SEMANTICS, VECTOR_NAME);
                        } else {
                            this.setSemantics(wmiMathModel, ROW_VECTOR_SEMANTICS, "RowVector");
                        }
                    } else if (bl2) {
                        this.setSemantics(wmiMathModel, BASIS_VECTOR_SEMANTICS, VECTOR_NAME);
                    } else {
                        this.setSemantics(wmiMathModel, COLUMN_VECTOR_SEMANTICS, "ColVector");
                    }
                }
            } else {
                this.setSemantics(wmiMathModel, COLUMN_VECTOR_SEMANTICS, "ColVector");
            }
        } else {
            object2 = new WmiModel[4];
            object = new WmiMathTableModel(wmiMathDocumentModel);
            object2[0] = this.createArraySizeRow(wmiMathDocumentModel, dag, wmiMathContext, "", 2);
            object2[1] = this.createKeyValueRow(wmiMathDocumentModel, dag, wmiMathContext, DATA_TYPE_KEY, 1);
            object2[2] = this.createKeyValueRow(wmiMathDocumentModel, dag, wmiMathContext, STORAGE_TYPE_KEY, 3);
            object2[3] = this.createKeyValueRow(wmiMathDocumentModel, dag, wmiMathContext, ORDER_TYPE_KEY, 4);
            try {
                ((WmiAbstractArrayCompositeModel)object).replaceChildren((WmiModel[])object2, 0, 0);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            wmiMathModel = WmiMathFactory.addBrackets((WmiMathModel)object, "[", "]", wmiMathContext);
            this.setReadOnly(wmiMathModel);
            wmiMathModel.setSemantics(COLLAPSED_RTABLE_SEMANTICS);
        }
        wmiMathModel = new WmiMathActionModel(wmiMathDocumentModel, wmiMathModel);
        wmiMathModel.addAttribute("actiontype", bl ? BROWSE_RTABLE_ACTION_TYPE : RTABLE_ADDRESS_ACTION);
        object2 = dag.getChild(0);
        object = ((Dag)object2).getData();
        wmiMathModel.addAttribute(RTABLE_ID_ATTR_KEY, object);
        if (wmiMathModel != null) {
            wmiMathModel.setSemantics(RTABLE_SEMANTICS);
        }
        return wmiMathModel;
    }

    private void setSemantics(WmiMathModel wmiMathModel, WmiMathSemantics wmiMathSemantics, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        wmiMathModel.setSemantics(wmiMathSemantics);
        WmiAttributeSet wmiAttributeSet = wmiMathModel.getAttributes();
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            wmiAttributeSet.addAttribute("Typesetting:-msemantics", string);
            wmiMathModel.setAttributes(wmiAttributeSet);
        }
    }

    private boolean isSummaryForm(Dag dag) {
        return dag.getLength() > 3;
    }

    private void setReadOnly(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        wmiModel.addAttribute(WmiFontAttributeSet.READ_ONLY_KEY, Boolean.TRUE);
        if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                this.setReadOnly(wmiCompositeModel.getChild(i));
            }
        }
    }

    private WmiModel createArraySizeRow(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, String string, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        boolean bl = false;
        Dag dag2 = dag.getChild(6);
        int n2 = Integer.parseInt(DagBuilder.lPrint(dag2));
        StringBuffer stringBuffer = new StringBuffer(" ");
        boolean bl2 = ARRAY_NAME.equals(dag.getChild(n).getData());
        if (n2 == 1) {
            Dag dag3 = dag.getChild(7);
            stringBuffer.append(DagBuilder.lPrint(dag3));
        } else {
            for (int i = 1; i <= n2; ++i) {
                Dag dag4 = dag.getChild(6 + i);
                if (dag4.getType() == 35) {
                    Dag dag5 = dag4.getChild(0);
                    Dag dag6 = dag4.getChild(1);
                    if (bl2) {
                        stringBuffer.append(DagBuilder.lPrint(dag5));
                        stringBuffer.append("..");
                    }
                    stringBuffer.append(DagBuilder.lPrint(dag6));
                    if (i >= n2) continue;
                    stringBuffer.append(" x ");
                    continue;
                }
                bl = true;
                break;
            }
        }
        stringBuffer.append(" ");
        return this.createKeyValueRow(wmiMathDocumentModel, dag, wmiMathContext, stringBuffer.toString(), n);
    }

    private WmiModel createKeyValueRow(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, String string, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiModel[] wmiModelArray = new WmiModel[]{WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, string, wmiMathContext), WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(n), wmiMathContext)};
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiInlineMathModel);
        return new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel, wmiMathTableDataModel);
    }

    public static String getRtableId(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = wmiModel;
        while (wmiModel2 instanceof WmiTransferModel && ((WmiTransferModel)wmiModel2).getChildCount() != 0) {
            wmiModel2 = ((WmiTransferModel)wmiModel2).getChild(0);
        }
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel2, WmiModelTag.MATH_ACTION);
        String string = "0";
        if (wmiCompositeModel != null) {
            WmiAttributeSet wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
            string = (String)wmiAttributeSet.getAttribute(RTABLE_ID_ATTR_KEY);
        }
        return string;
    }

    public static boolean getCellDags(Dag[] dagArray, WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = true;
        if (wmiModel != null && wmiModel.isComposite()) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            int n = wmiCompositeModel.getChildCount();
            Dag[] dagArray2 = new Dag[n];
            for (int i = 0; i < n; ++i) {
                WmiModel wmiModel2 = wmiCompositeModel.getChild(i);
                if (wmiModel2 != null && wmiModel2.isComposite()) {
                    WmiMathModel wmiMathModel = (WmiMathModel)((WmiCompositeModel)wmiModel2).getChild(0);
                    if (wmiMathModel != null) {
                        dagArray[i] = wmiMathModel.toDag();
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static class WmiCollapsedRtableSemantics
    implements WmiMathSemantics {
        private static final int INDEX_OF_TABLE = 1;
        private static final int INDEX_OF_SIZE_AND_TYPE_ROW = 0;
        private static final int INDEX_OF_TYPE_IN_INLINE = 1;
        private static final int INDEX_OF_SIZE_IN_INLINE = 0;
        private static final int INDEX_OF_DATA_TYPE_ROW = 1;
        private static final int INDEX_OF_DATA_TYPE_IN_INLINE = 1;
        private static final int INDEX_OF_STORAGE_ROW = 2;
        private static final int INDEX_OF_STORAGE_IN_INLINE = 1;
        private static final int INDEX_OF_ORDER_ROW = 3;
        private static final int INDEX_OF_ORDER_IN_INLINE = 1;
        private static final int INDEX_OF_TYPE_IN_SUBSCRIPT = 0;
        private static final int INDEX_OF_SUBTYPE_IN_SUBSCRIPT = 1;
        private static final int ARG_LENGTH_BEFORE_RANGES = 7;
        private static final int ID_IN_DAG = 0;
        private static final int DATA_TYPE_IN_DAG = 1;
        private static final int TYPE_IN_DAG = 2;
        private static final int STORAGE_IN_DAG = 3;
        private static final int ORDER_IN_DAG = 4;
        private static final int LIST_IN_DAG = 5;
        private static final int DIMENTION_IN_DAG = 6;

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            String string;
            WmiCompositeModel wmiCompositeModel;
            WmiModel wmiModel;
            WmiModel wmiModel2;
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite() && (wmiModel2 = ((WmiCompositeModel)((Object)wmiMathModel)).getChild(1)) != null && wmiModel2.isComposite() && (wmiModel = this.getModelForRowAndIdentifier(0, 0, wmiCompositeModel = (WmiCompositeModel)wmiModel2)) instanceof WmiTextModel && (string = ((WmiTextModel)wmiModel).getText()) != null) {
                int n;
                int n2;
                String[] stringArray = string.split("x");
                int n3 = stringArray.length;
                Dag[] dagArray = new Dag[7 + n3];
                String string2 = WmiRtableBuilder.getRtableId(wmiMathModel);
                dagArray[0] = WmiSemanticDagUtil.createIntpos(string2);
                WmiModel wmiModel3 = this.getModelForRowAndIdentifier(0, 1, wmiCompositeModel);
                dagArray[2] = null;
                if (wmiModel3 instanceof WmiTextModel) {
                    String string3 = ((WmiTextModel)wmiModel3).getText();
                    dagArray[2] = WmiSemanticDagUtil.createName(string3);
                } else if (wmiModel3 instanceof WmiCompositeModel) {
                    dagArray[2] = this.getArgWithSubType((WmiCompositeModel)wmiModel3);
                }
                dagArray[1] = this.getNameDagForRowAndIdentifier(1, 1, wmiCompositeModel);
                dagArray[3] = this.getNameDagForRowAndIdentifier(2, 1, wmiCompositeModel);
                dagArray[4] = this.getNameDagForRowAndIdentifier(3, 1, wmiCompositeModel);
                dagArray[5] = Dag.createDag(30, null, null, false);
                dagArray[6] = WmiSemanticDagUtil.createIntpos(Integer.toString(n3));
                for (n2 = 0; n2 < n3; ++n2) {
                    n = stringArray[n2].indexOf(46);
                    String string4 = null;
                    String string5 = null;
                    if (n == -1) {
                        string4 = "1";
                        string5 = stringArray[n2];
                    } else {
                        string4 = stringArray[n2].substring(0, n);
                        string5 = stringArray[n2].substring(n + 2);
                    }
                    Dag[] dagArray2 = new Dag[]{"1".equals(string4) ? DagConstants.ONE : WmiSemanticDagUtil.createIntpos(string4), WmiSemanticDagUtil.createIntpos(string5)};
                    dagArray[7 + n2] = Dag.createDag(35, dagArray2, null, false);
                }
                n2 = 1;
                for (n = 1; n < 7; ++n) {
                    if (dagArray[n] != null) continue;
                    n2 = 0;
                }
                if (n2 != 0) {
                    dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, dagArray);
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }

        private Dag getArgWithSubType(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiModel wmiModel = wmiCompositeModel.getChild(0);
            if (wmiModel instanceof WmiTextModel) {
                WmiModel wmiModel2;
                String string = ((WmiTextModel)wmiModel).getText();
                WmiModel wmiModel3 = wmiCompositeModel.getChild(1);
                if (wmiModel3 != null && wmiModel3.isComposite() && (wmiModel2 = ((WmiCompositeModel)wmiModel3).getChild(0)) instanceof WmiTextModel) {
                    String string2 = ((WmiTextModel)wmiModel2).getText();
                    Dag[] dagArray = new Dag[]{WmiSemanticDagUtil.createName(string2)};
                    Dag[] dagArray2 = new Dag[]{WmiSemanticDagUtil.createName(string), Dag.createDag(29, dagArray, null, false)};
                    dag = Dag.createDag(10, dagArray2, null, false);
                }
            }
            return dag;
        }

        private Dag getNameDagForRowAndIdentifier(int n, int n2, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiModel wmiModel = this.getModelForRowAndIdentifier(n, n2, wmiCompositeModel);
            if (wmiModel instanceof WmiTextModel) {
                String string = ((WmiTextModel)wmiModel).getText();
                dag = WmiSemanticDagUtil.createName(string);
            }
            return dag;
        }

        private WmiModel getModelForRowAndIdentifier(int n, int n2, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
            WmiModel wmiModel;
            WmiModel wmiModel2;
            WmiModel wmiModel3 = null;
            WmiModel wmiModel4 = wmiCompositeModel.getChild(n);
            if (wmiModel4 != null && wmiModel4.isComposite() && (wmiModel2 = ((WmiCompositeModel)wmiModel4).getChild(0)) != null && wmiModel2.isComposite() && (wmiModel = ((WmiCompositeModel)wmiModel2).getChild(0)) != null && wmiModel.isComposite()) {
                wmiModel3 = ((WmiCompositeModel)wmiModel).getChild(n2);
            }
            return wmiModel3;
        }
    }

    public static class WmiRTableWrapperSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            dag = ((WmiMathModel)wmiCompositeModel.getChild(0)).toDag();
            return dag;
        }
    }

    public static abstract class WmiTableSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiModel wmiModel;
            Dag dag = null;
            boolean bl = true;
            if (wmiMathModel != null && wmiMathModel.isComposite() && (wmiModel = ((WmiCompositeModel)((Object)wmiMathModel)).getChild(1)) != null && wmiModel.isComposite()) {
                WmiModel wmiModel2;
                int n = 0;
                if (WmiModelUtil.isEmptyIdentifierModel(((WmiCompositeModel)wmiModel).getChild(n))) {
                    ++n;
                }
                if ((wmiModel2 = ((WmiCompositeModel)wmiModel).getChild(n)) != null && wmiModel2.isComposite()) {
                    Object object;
                    Object object2;
                    WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel2;
                    int n2 = wmiCompositeModel.getChildCount();
                    Dag[] dagArray = new Dag[n2];
                    for (int i = 0; i < n2; ++i) {
                        object2 = wmiCompositeModel.getChild(i);
                        if (object2 != null && object2.isComposite()) {
                            object = (WmiCompositeModel)object2;
                            int n3 = object.getChildCount();
                            Dag[] dagArray2 = new Dag[n3];
                            if (!WmiRtableBuilder.getCellDags(dagArray2, (WmiModel)object)) {
                                bl = false;
                            }
                            dagArray[i] = WmiSemanticDagUtil.createList(dagArray2);
                            continue;
                        }
                        bl = false;
                    }
                    Dag dag2 = WmiSemanticDagUtil.createList(dagArray);
                    object2 = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.MATRIX_FUNC_NAME, dag2);
                    object = WmiRtableBuilder.getRtableId(wmiMathModel);
                    Dag dag3 = WmiSemanticDagUtil.createIntpos((String)object);
                    dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, dag3, (Dag)object2, this.getFunctionType());
                    dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
                }
            }
            if (!bl) {
                dag = null;
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }

        protected abstract Dag getFunctionType();
    }

    public static class WmiMatrixSemantics
    extends WmiTableSemantics {
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.MATRIX_NAME, false);
        }
    }

    public static class WmiArrayMatrixSemantics
    extends WmiTableSemantics {
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.ARRAY_NAME, false);
        }
    }

    public static class WmiColumnVectorSemantics
    extends WmiTableSemantics {
        protected Dag getFunctionType() {
            Dag[] dagArray = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.COLUMN_NAME, false)};
            Dag dag = Dag.createDag(29, dagArray, null, false);
            Dag[] dagArray2 = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.VECTOR_NAME, false), dag};
            return Dag.createDag(10, dagArray2, null, false);
        }
    }

    public static abstract class WmiVectorSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiModel wmiModel;
            Dag dag = null;
            boolean bl = true;
            if (wmiMathModel != null && wmiMathModel.isComposite() && (wmiModel = ((WmiCompositeModel)((Object)wmiMathModel)).getChild(1)) != null && wmiModel.isComposite()) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                int n = wmiCompositeModel.getChildCount();
                Dag[] dagArray = new Dag[n];
                WmiModel wmiModel2 = wmiCompositeModel.getChild(0);
                if (wmiModel2 != null && wmiModel2.isComposite()) {
                    WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiModel2;
                    int n2 = wmiCompositeModel2.getChildCount();
                    Dag[] dagArray2 = new Dag[n2];
                    if (!WmiRtableBuilder.getCellDags(dagArray2, wmiCompositeModel2)) {
                        bl = false;
                    }
                    Dag dag2 = WmiSemanticDagUtil.createList(dagArray2);
                    Dag dag3 = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.VECTOR_FUNC_NAME, dag2);
                    String string = WmiRtableBuilder.getRtableId(wmiMathModel);
                    Dag dag4 = Dag.createDag(2, null, string, false);
                    dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, dag4, dag3, this.getFunctionType());
                }
            }
            if (!bl) {
                dag = null;
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }

        protected abstract Dag getFunctionType();
    }

    public static class WmiRowVectorSemantics
    extends WmiVectorSemantics {
        protected Dag getFunctionType() {
            Dag[] dagArray = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.ROW_NAME, false)};
            Dag dag = Dag.createDag(29, dagArray, null, false);
            Dag[] dagArray2 = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.VECTOR_NAME, false), dag};
            return Dag.createDag(10, dagArray2, null, false);
        }
    }

    public static class WmiArrayVectorSemantics
    extends WmiVectorSemantics {
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.ARRAY_NAME, false);
        }
    }
}

