/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAmbiguousModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathErrorModel;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiPrintslashSemantics;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class WmiTypesettingBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String TYPESETTING_LEADER = "Typesetting:-";
    public static final int TYPESETTING_LEAD_LENGTH = "Typesetting:-".length();
    private static final HashMap TAG_BUILDERS = new HashMap();
    private static final WmiTypesetBuilder DEFAULT_BUILDER = new WmiDefaultTagBuilder();
    private boolean quoteHack = false;

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel wmiMathModel = (WmiMathModel)this.buildModelFromTypeset(wmiMathDocumentModel, string, dag, wmiMathContext);
        return wmiMathModel;
    }

    private WmiModel buildModelFromTypeset(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        Object object;
        wmiMathContext.incrementTypesettingCounter();
        String string2 = string.startsWith(TYPESETTING_LEADER) ? string.substring(TYPESETTING_LEAD_LENGTH) : string;
        WmiTypesetBuilder wmiTypesetBuilder = (WmiTypesetBuilder)TAG_BUILDERS.get(string2);
        wmiTypesetBuilder = wmiTypesetBuilder == null ? DEFAULT_BUILDER : wmiTypesetBuilder;
        WmiFontAttributeSet wmiFontAttributeSet = wmiMathContext.getStyle();
        if (wmiFontAttributeSet != null) {
            object = wmiFontAttributeSet.getFontStyleName();
            this.quoteHack = "2D Output".equals(object);
        } else {
            this.quoteHack = false;
        }
        object = wmiTypesetBuilder.build(wmiMathDocumentModel, dag, wmiMathContext, this);
        wmiMathContext.decrementTypesettingCounter();
        return object;
    }

    static {
        TAG_BUILDERS.put("math", new WmiMathTagBuilder());
        TAG_BUILDERS.put("mfrac", new WmiMFracTagBuilder());
        TAG_BUILDERS.put("mi", new WmiMiTagBuilder());
        TAG_BUILDERS.put("mmultiscripts", new WmiMMultiscriptTagBuilder());
        TAG_BUILDERS.put("mscripts", new WmiMScriptTagBuilder());
        TAG_BUILDERS.put("mn", new WmiMnTagBuilder());
        TAG_BUILDERS.put("mo", new WmiMoTagBuilder());
        TAG_BUILDERS.put("mover", new WmiMOverTagBuilder());
        TAG_BUILDERS.put("mambiguous", new WmiMAmbiguousTagBuilder());
        TAG_BUILDERS.put("maction", new WmiMActionTagBuilder());
        TAG_BUILDERS.put("mroot", new WmiMRootTagBuilder());
        TAG_BUILDERS.put("mrow", new WmiMRowTagBuilder());
        TAG_BUILDERS.put("mspace", new WmiMSpaceTagBuilder());
        TAG_BUILDERS.put("msqrt", new WmiMSqrtTagBuilder());
        TAG_BUILDERS.put("ms", new WmiMsTagBuilder());
        TAG_BUILDERS.put("mstyle", new WmiMStyleTagBuilder());
        TAG_BUILDERS.put("msub", new WmiMSubTagBuilder());
        TAG_BUILDERS.put("msubsup", new WmiMSubSupTagBuilder());
        TAG_BUILDERS.put("msup", new WmiMSupTagBuilder());
        TAG_BUILDERS.put("mtext", new WmiMTextTagBuilder());
        TAG_BUILDERS.put("merror", new WmiMErrorTagBuilder());
        TAG_BUILDERS.put("munder", new WmiMUnderTagBuilder());
        TAG_BUILDERS.put("mpadded", new WmiMPaddedTagBuilder());
        TAG_BUILDERS.put("mphantom", new WmiMPhantomTagBuilder());
        TAG_BUILDERS.put("munderover", new WmiMUnderOverTagBuilder());
        TAG_BUILDERS.put("mprescripts", new WmiMPrescriptsTagBuilder());
        TAG_BUILDERS.put("none", new WmiNoneTagBuilder());
        TAG_BUILDERS.put("mfenced", new WmiMFencedTagBuilder());
        TAG_BUILDERS.put("mtable", new WmiMTableTagBuilder());
        TAG_BUILDERS.put("mtr", new WmiMTableRowTagBuilder());
        TAG_BUILDERS.put("mlabeledtr", new WmiMTableLabeledRowTagBuilder());
        TAG_BUILDERS.put("mtd", new WmiMTableDataTagBuilder());
        TAG_BUILDERS.put("mprintslash", new WmiMPrintslashBuilder());
        TAG_BUILDERS.put("mparsed", new WmiMParsedBuilder());
        TAG_BUILDERS.put("mverbatim", new WmiMVerbatimBuilder());
    }

    protected static class WmiMVerbatimBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMVerbatimBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Object object;
            Dag dag2 = dag.getChild(0);
            if (DagUtil.isString(dag2)) {
                object = dag2.getData();
                try {
                    dag2 = DagBuilder.createDag((String)object);
                    if (dag2 != null) {
                        dag2 = DagBuilder.normalize(dag2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object = WmiMathFactory.createMathModel(wmiMathDocumentModel, dag2, wmiMathContext);
            return object;
        }
    }

    protected static class WmiMPrintslashBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMPrintslashBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Dag dag2 = dag.getChild(0);
            dag2 = dag2.getLength() > 1 ? DagUtil.createExpSeqDag(dag2.getChildrenAsArray()) : dag2.getChild(0);
            WmiMathModel wmiMathModel = WmiMathFactory.createMathModel(wmiMathDocumentModel, dag2, wmiMathContext);
            Dag dag3 = dag.getChild(1);
            if (dag3.getLength() > 0) {
                dag3 = dag3.getLength() > 1 ? DagUtil.createExpSeqDag(dag3.getChildrenAsArray()) : dag3.getChild(0);
            }
            WmiPrintslashSemantics wmiPrintslashSemantics = new WmiPrintslashSemantics(dag3);
            wmiMathModel.setSemantics(wmiPrintslashSemantics);
            return wmiMathModel;
        }
    }

    protected static class WmiMParsedBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMParsedBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            WmiModel wmiModel = this.buildForChildFunction(wmiMathDocumentModel, dag2, wmiMathContext, wmiTypesettingBuilder, 0);
            WmiAssignedSemantics wmiAssignedSemantics = new WmiAssignedSemantics(dag3);
            ((WmiMathModel)wmiModel).setSemantics(wmiAssignedSemantics);
            return wmiModel;
        }
    }

    protected static class WmiMTableDataTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableDataTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiModelArray[0]);
        }
    }

    protected static class WmiMTableLabeledRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableLabeledRowTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableLabeledRowModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMTableRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableRowTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMTableTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiDefaultTagBuilder
    implements WmiTypesetBuilder {
        protected WmiDefaultTagBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "?", wmiMathContext);
        }
    }

    protected static class WmiMPrescriptsTagBuilder
    implements WmiTypesetBuilder {
        protected WmiMPrescriptsTagBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel.WmiMathPrescriptModel(wmiMathDocumentModel);
        }
    }

    protected static class WmiNoneTagBuilder
    implements WmiTypesetBuilder {
        protected WmiNoneTagBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel.WmiMathNoneModel(wmiMathDocumentModel);
        }
    }

    protected static class WmiMScriptTagBuilder
    extends WmiGenericTagBuilder {
        private static final int CENTER_IDX = 0;
        private static final int SUBSCRIPT_IDX = 1;
        private static final int SUPERSCRIPT_IDX = 2;
        private static final int UNDER_IDX = 3;
        private static final int OVER_IDX = 4;
        private static final int PRESUB_IDX = 5;
        private static final int PRESUP_IDX = 6;

        protected WmiMScriptTagBuilder() {
        }

        public int getRequiredArguments() {
            return 7;
        }

        public void modifyContextForIndex(int n, WmiMathContext wmiMathContext, int n2) {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            WmiModel wmiModel = null;
            boolean bl = !(wmiModelArray[4] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean bl2 = !(wmiModelArray[3] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean bl3 = !(wmiModelArray[2] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean bl4 = !(wmiModelArray[1] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean bl5 = !(wmiModelArray[5] instanceof WmiMathMultiscriptModel.WmiMathNoneModel) || !(wmiModelArray[6] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            WmiModel wmiModel2 = null;
            wmiModel2 = bl && bl2 ? new WmiUnderOverModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[3], wmiModelArray[4], wmiMathContext) : (bl ? new WmiOverModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[4], wmiMathContext) : (bl2 ? new WmiUnderModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[3], wmiMathContext) : wmiModelArray[0]));
            if (bl5) {
                WmiModel[] wmiModelArray2 = new WmiModel[]{wmiModel2, wmiModelArray[1], wmiModelArray[2], new WmiMathMultiscriptModel.WmiMathPrescriptModel(wmiMathDocumentModel), wmiModelArray[5], wmiModelArray[6]};
                wmiModel = new WmiMathMultiscriptModel(wmiMathDocumentModel, wmiModelArray2);
            } else {
                wmiModel = bl3 && bl4 ? new WmiSubSupModel(wmiMathDocumentModel, wmiModel2, wmiModelArray[1], wmiModelArray[2], wmiMathContext) : (bl3 ? new WmiSuperscriptModel(wmiMathDocumentModel, wmiModel2, wmiModelArray[2], wmiMathContext) : (bl4 ? new WmiSubscriptModel(wmiMathDocumentModel, wmiModel2, wmiModelArray[1], wmiMathContext) : wmiModel2));
            }
            return wmiModel;
        }
    }

    protected static class WmiMSpaceTagBuilder
    extends WmiGenericTagBuilder {
        protected WmiMSpaceTagBuilder() {
        }

        public int getRequiredArguments() {
            return 0;
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathSpaceModel(wmiMathDocumentModel);
        }
    }

    protected static class WmiMSqrtTagBuilder
    extends WmiGenericTagBuilder {
        protected WmiMSqrtTagBuilder() {
        }

        public int getRequiredArguments() {
            return 1;
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiRootModel.WmiSquareRootModel(wmiMathDocumentModel, wmiModelArray[0], wmiMathContext);
        }
    }

    protected static class WmiMMultiscriptTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMMultiscriptTagBuilder() {
        }

        public void modifyContextForIndex(int n, WmiMathContext wmiMathContext, int n2) {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMAmbiguousTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMAmbiguousTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathAmbiguousModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMRowTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMStyleTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMStyleTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathStyleModel(wmiMathDocumentModel, wmiModelArray, new WmiMathStyleModel.WmiMathStyleAttributeSet());
        }

        protected void addAttribute(WmiModel wmiModel, Dag dag) throws WmiNoWriteAccessException {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            String string = dag2.getData();
            String string2 = dag3.getData();
            string2 = this.conditionValues(string, string2);
            ((WmiMathStyleModel)wmiModel).addAttribute(string, string2, true);
        }
    }

    protected static class WmiMPhantomTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMPhantomTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathPhantomModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMPaddedTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMPaddedTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathPaddedModel(wmiMathDocumentModel, wmiModelArray);
        }
    }

    protected static class WmiMFencedTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMFencedTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
        }
    }

    protected static class WmiMSubSupTagBuilder
    extends WmiThreeArgumentScriptTagBuilder {
        protected WmiMSubSupTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiSubSupModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiModelArray[2], wmiMathContext);
        }
    }

    protected static class WmiMUnderOverTagBuilder
    extends WmiThreeArgumentScriptTagBuilder {
        protected WmiMUnderOverTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiUnderOverModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiModelArray[2], wmiMathContext);
        }
    }

    protected static class WmiMRootTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiMRootTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiRootModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMSupTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMSupTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiSuperscriptModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMUnderTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMUnderTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiUnderModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMOverTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMOverTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiOverModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMSubTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMSubTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiSubscriptModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMFracTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiMFracTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            return new WmiFractionModel(wmiMathDocumentModel, wmiModelArray[0], wmiModelArray[1], wmiMathContext);
        }
    }

    protected static class WmiMTextTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTextTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathTextModel(wmiMathDocumentModel, string, wmiMathContext);
        }
    }

    protected static class WmiMErrorTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMErrorTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathErrorModel(wmiMathDocumentModel, string);
        }
    }

    protected static class WmiMsTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMsTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathStringModel(wmiMathDocumentModel, string, wmiMathContext);
        }
    }

    protected static class WmiMoTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMoTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        }
    }

    protected static class WmiMnTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMnTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, string, wmiMathContext);
        }
    }

    protected static class WmiMiTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMiTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            if (string.startsWith("`") && string.endsWith("`") && wmiTypesettingBuilder.quoteHack) {
                string = string.substring(1, string.length() - 1);
            }
            if (string.length() == 1 && MathTokenizer.containsOperator(string) && !string.startsWith("`")) {
                string = "`" + string + "`";
            }
            return WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, string, wmiMathContext);
        }
    }

    protected static class WmiMActionTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMActionTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathActionModel(wmiMathDocumentModel, wmiModelArray);
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            WmiModel wmiModel = null;
            String string = null;
            for (int i = 0; i < dag.getLength(); ++i) {
                Dag dag2 = dag.getChild(i);
                if (!DagUtil.isEquation(dag2) || !"actiontype".toString().equals(dag2.getChild(0).getData())) continue;
                string = dag2.getChild(1).getData();
            }
            if (WmiMathActionModel.specialActions.hasBuilder(string)) {
                WmiMathActionModel.WmiSpecialActionBuilder wmiSpecialActionBuilder = WmiMathActionModel.specialActions.getBuilder(string);
                wmiModel = wmiSpecialActionBuilder.buildModel(dag.getChildrenAsArray(), wmiMathDocumentModel);
            } else {
                wmiModel = super.build(wmiMathDocumentModel, dag, wmiMathContext, wmiTypesettingBuilder);
            }
            return wmiModel;
        }
    }

    protected static class WmiMathTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMathTagBuilder() {
        }

        public WmiModel assembleModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, String string, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiNoWriteAccessException {
            WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
            try {
                wmiMathWrapperModel.addChildren(wmiModelArray, 0);
                WmiFontAttributeSet wmiFontAttributeSet = wmiMathContext.getStyle();
                wmiMathWrapperModel.setAttributes(wmiFontAttributeSet);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            return wmiMathWrapperModel;
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            Dag dag2;
            Object object;
            int n = this.getArgumentLength(dag);
            int n2 = dag.getLength();
            int n3 = this.getRequiredArguments();
            if (n < n3) {
                throw new IllegalArgumentException("Insufficient arguments in typeset builder - " + this.getClass() + "- found: " + n + " -Required: " + n3);
            }
            WmiModel wmiModel = null;
            StringBuffer stringBuffer = new StringBuffer();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n4 = n3 > 0 ? n3 : n;
            WmiModel[] wmiModelArray = new WmiModel[n4];
            for (int i = n; i < n2; ++i) {
                object = dag.getChild(i);
                int n5 = ((Dag)object).getType();
                if (n5 != 20) continue;
                linkedList.add(object);
            }
            WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
            object = linkedList.iterator();
            while (object.hasNext()) {
                Dag dag3 = (Dag)object.next();
                dag2 = dag3.getChild(0);
                Dag dag4 = dag3.getChild(1);
                String string = dag2.getData();
                String string2 = dag4.getData();
                string2 = this.conditionValues(string, string2);
                string = this.conditionKeyNames(string);
                wmiFontAttributeSet.addAttribute(string, string2);
            }
            wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
            for (int i = 0; i < n2; ++i) {
                dag2 = dag.getChild(i);
                int n6 = dag2.getType();
                if (n6 == 18) {
                    --n3;
                    this.modifyContextForIndex(i, wmiMathContext, 0);
                    if (i < wmiModelArray.length) {
                        wmiModelArray[i] = this.buildForChildFunction(wmiMathDocumentModel, dag2, wmiMathContext, wmiTypesettingBuilder, i);
                    } else if (!DagUtil.isFunctionNamed(dag2, "Typesetting:-mi") || dag2.getChild(1).getChild(0).getData().length() != 0) {
                        wmiModelArray[wmiModelArray.length - 1] = new WmiMathErrorModel(wmiMathDocumentModel, "Error loading this structure.");
                        wmiMathContext.recordRecoverableError(new ArrayIndexOutOfBoundsException("Builder  for " + this + " had too many arguments."));
                    }
                    this.modifyContextForIndex(i, wmiMathContext, 1);
                    continue;
                }
                if (n6 == 7 || n6 == 8) {
                    stringBuffer.append(dag2.getData());
                    if (wmiModel != null || --n3 > 0) continue;
                    wmiModelArray = this.trimNullsFromChildren(wmiModelArray);
                    wmiModel = this.assembleModel(wmiMathDocumentModel, wmiModelArray, stringBuffer.toString(), wmiMathContext, wmiTypesettingBuilder);
                    continue;
                }
                --n3;
            }
            if (wmiModel == null) {
                wmiModelArray = this.trimNullsFromChildren(wmiModelArray);
                wmiModel = this.assembleModel(wmiMathDocumentModel, wmiModelArray, stringBuffer.toString(), wmiMathContext, wmiTypesettingBuilder);
            }
            return wmiModel;
        }
    }

    protected static abstract class WmiOneArgumentTagBuilder
    extends WmiGenericTagBuilder {
        private static final int ONE_CHILD = 1;
        protected static final int FIRST_CHILD = 0;

        protected WmiOneArgumentTagBuilder() {
        }

        public int getRequiredArguments() {
            return 1;
        }
    }

    protected static abstract class WmiThreeArgumentScriptTagBuilder
    extends WmiGenericTagBuilder {
        private static final int THREE_CHILDREN = 3;
        protected static final int FIRST_CHILD = 0;
        protected static final int SECOND_CHILD = 1;
        protected static final int THIRD_CHILD = 2;

        protected WmiThreeArgumentScriptTagBuilder() {
        }

        public int getRequiredArguments() {
            return 3;
        }

        protected void modifyContextForIndex(int n, WmiMathContext wmiMathContext, int n2) {
        }
    }

    protected static abstract class WmiSecondScriptTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiSecondScriptTagBuilder() {
        }

        protected void modifyContextForIndex(int n, WmiMathContext wmiMathContext, int n2) {
        }
    }

    protected static abstract class WmiTwoArgumentTagBuilder
    extends WmiGenericTagBuilder {
        private static final int TWO_CHILDREN = 2;
        protected static final int FIRST_CHILD = 0;
        protected static final int SECOND_CHILD = 1;

        protected WmiTwoArgumentTagBuilder() {
        }

        public int getRequiredArguments() {
            return 2;
        }
    }

    protected static abstract class WmiUnlimitedArgumentTagBuilder
    extends WmiGenericTagBuilder {
        public static final int UNLIMITED_ARGUMENTS = -1;

        protected WmiUnlimitedArgumentTagBuilder() {
        }

        public int getRequiredArguments() {
            return -1;
        }
    }

    protected static abstract class WmiGenericTagBuilder
    extends WmiAbstractTagBuilder {
        public static final String LOAD_ERROR_TEXT = "Error loading this structure.";
        protected static final int PRE_BUILD = 0;
        protected static final int POST_BUILD = 1;

        protected WmiGenericTagBuilder() {
        }

        public WmiModel build(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            boolean bl;
            int n;
            WmiAttributeSet wmiAttributeSet;
            int n2;
            Object object;
            int n3 = this.getArgumentLength(dag);
            int n4 = dag.getLength();
            int n5 = this.getRequiredArguments();
            if (n3 < n5) {
                throw new IllegalArgumentException("Insufficient arguments in typeset builder - " + this.getClass() + "- found: " + n3 + " -Required: " + n5);
            }
            WmiModel wmiModel = null;
            StringBuffer stringBuffer = new StringBuffer();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n6 = n5 > 0 ? n5 : n3;
            WmiModel[] wmiModelArray = new WmiModel[n6];
            for (int i = 0; i < n4; ++i) {
                object = dag.getChild(i);
                n2 = ((Dag)object).getType();
                if (n2 == 18) {
                    --n5;
                    this.modifyContextForIndex(i, wmiMathContext, 0);
                    if (i < wmiModelArray.length) {
                        wmiModelArray[i] = this.buildForChildFunction(wmiMathDocumentModel, (Dag)object, wmiMathContext, wmiTypesettingBuilder, i);
                    } else if (!DagUtil.isFunctionNamed((Dag)object, "Typesetting:-mi") || ((Dag)object).getChild(1).getChild(0).getData().length() != 0) {
                        wmiModelArray[wmiModelArray.length - 1] = new WmiMathErrorModel(wmiMathDocumentModel, LOAD_ERROR_TEXT);
                        wmiMathContext.recordRecoverableError(new ArrayIndexOutOfBoundsException("Builder  for " + this + " had too many arguments."));
                    }
                    this.modifyContextForIndex(i, wmiMathContext, 1);
                    continue;
                }
                if (n2 == 7 || n2 == 8) {
                    stringBuffer.append(((Dag)object).getData());
                    if (wmiModel != null || --n5 > 0) continue;
                    wmiModelArray = this.trimNullsFromChildren(wmiModelArray);
                    wmiModel = this.assembleModel(wmiMathDocumentModel, wmiModelArray, stringBuffer.toString(), wmiMathContext, wmiTypesettingBuilder);
                    continue;
                }
                if (n2 == 20) {
                    if (wmiModel == null && n5 <= 0) {
                        wmiModelArray = this.trimNullsFromChildren(wmiModelArray);
                        wmiModel = this.assembleModel(wmiMathDocumentModel, wmiModelArray, stringBuffer.toString(), wmiMathContext, wmiTypesettingBuilder);
                    }
                    if (wmiModel == null) {
                        linkedList.add(object);
                        continue;
                    }
                    this.addAttribute(wmiModel, (Dag)object);
                    continue;
                }
                --n5;
            }
            if (wmiModel == null) {
                wmiModelArray = this.trimNullsFromChildren(wmiModelArray);
                wmiModel = this.assembleModel(wmiMathDocumentModel, wmiModelArray, stringBuffer.toString(), wmiMathContext, wmiTypesettingBuilder);
            }
            if (wmiModel != null && linkedList.size() > 0) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object = (Dag)iterator.next();
                    this.addAttribute(wmiModel, (Dag)object);
                }
            }
            if ((wmiAttributeSet = wmiModel.getAttributesForRead()) instanceof WmiFontAttributeSet && (n2 = ((WmiFontAttributeSet)(object = (WmiFontAttributeSet)wmiAttributeSet)).getForeground()) == (n = ((WmiFontAttributeSet)object).getBackground()) && (bl = ((WmiFontAttributeSet)object).isOpaque())) {
                object = (WmiFontAttributeSet)wmiModel.getAttributes();
                ((WmiFontAttributeSet)object).setStyle(32, false);
                wmiModel.setAttributes((WmiAttributeSet)object);
            }
            return wmiModel;
        }

        protected int getArgumentLength(Dag dag) {
            int n = dag.getLength();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!DagUtil.isFunction(dag.getChild(i)) && !DagUtil.isString(dag.getChild(i)) && !DagUtil.isName(dag.getChild(i))) continue;
                ++n2;
            }
            return n2;
        }

        protected void addAttribute(WmiModel wmiModel, Dag dag) throws WmiNoWriteAccessException {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            String string = dag2.getData();
            String string2 = dag3.getData();
            string2 = this.conditionValues(string, string2);
            string = this.conditionKeyNames(string);
            wmiModel.addAttribute(string, string2);
        }

        protected String conditionKeyNames(String string) {
            String string2 = string;
            if (string.equals("color")) {
                string2 = "foreground";
            }
            return string2;
        }

        private boolean isHex(char c) {
            if (Character.isDigit(c = Character.toUpperCase(c))) {
                return true;
            }
            return Character.isLetter(c) && (c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F');
        }

        protected String conditionValues(String string, String string2) {
            String string3;
            int n;
            int n2;
            Object object;
            CharSequence charSequence;
            if (string.equals("rtableid")) {
                return string2;
            }
            if (string2.startsWith("java.awt.Color")) {
                charSequence = new StringBuffer("[");
                string2 = string2.substring(15);
                string2 = string2.substring(0, string2.length() - 1);
                object = new StringTokenizer(string2, ",");
                n2 = 0;
                n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object).nextToken();
                    string3 = string3.substring(2);
                    ((StringBuffer)charSequence).append(string3);
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        ((StringBuffer)charSequence).append(",");
                    } else {
                        ((StringBuffer)charSequence).append("]");
                    }
                    int n3 = Integer.parseInt(string3);
                    n2 += (n3 <<= (n += 8));
                }
                string2 = ((StringBuffer)charSequence).toString();
            }
            if (((String)(charSequence = WmiMathAttributeSet.getColour(string2))).length() == 0) {
                boolean bl = true;
                n2 = 0;
                for (n = string2.length() - 1; n >= 0 && bl && n2 < 6; --n) {
                    if (this.isHex(string2.charAt(n))) {
                        ++n2;
                        continue;
                    }
                    bl = false;
                }
                if (n2 == 6 && bl) {
                    charSequence = "0x" + string2.substring(string2.length() - 6).toUpperCase();
                }
            }
            if (((String)charSequence).length() > 0) {
                object = new StringBuffer("[");
                String string4 = ((String)charSequence).substring(2, 4);
                String string5 = ((String)charSequence).substring(4, 6);
                string3 = ((String)charSequence).substring(6, 8);
                ((StringBuffer)object).append(Integer.toString(Integer.parseInt(string4, 16)));
                ((StringBuffer)object).append(",");
                ((StringBuffer)object).append(Integer.toString(Integer.parseInt(string5, 16)));
                ((StringBuffer)object).append(",");
                ((StringBuffer)object).append(Integer.toString(Integer.parseInt(string3, 16)));
                ((StringBuffer)object).append("]");
                string2 = ((StringBuffer)object).toString();
            }
            return string2;
        }

        protected WmiModel[] trimNullsFromChildren(WmiModel[] wmiModelArray) {
            WmiModel[] wmiModelArray2 = wmiModelArray;
            int n = wmiModelArray.length;
            int n2 = wmiModelArray.length - 1;
            while (n2 >= 0 && wmiModelArray[n2] == null) {
                n = n2--;
            }
            if (n != wmiModelArray.length) {
                wmiModelArray2 = new WmiModel[n];
                System.arraycopy(wmiModelArray, 0, wmiModelArray2, 0, n);
            }
            return wmiModelArray2;
        }

        protected void modifyContextForIndex(int n, WmiMathContext wmiMathContext, int n2) {
        }

        protected abstract int getRequiredArguments();

        protected abstract WmiModel assembleModel(WmiMathDocumentModel var1, WmiModel[] var2, String var3, WmiMathContext var4, WmiTypesettingBuilder var5) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException;
    }

    protected static abstract class WmiAbstractTagBuilder
    implements WmiTypesetBuilder {
        protected WmiAbstractTagBuilder() {
        }

        public WmiModel buildForChildFunction(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext, WmiTypesettingBuilder wmiTypesettingBuilder, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            WmiModel wmiModel = null;
            if (dag.getType() == 18) {
                Dag dag2 = dag.getChild(0);
                String string = dag2.getData();
                Dag dag3 = dag.getChild(1);
                wmiModel = wmiTypesettingBuilder.buildModelFromTypeset(wmiMathDocumentModel, string, dag3, wmiMathContext);
            }
            return wmiModel;
        }
    }

    protected static interface WmiTypesetBuilder {
        public WmiModel build(WmiMathDocumentModel var1, Dag var2, WmiMathContext var3, WmiTypesettingBuilder var4) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException;
    }
}

