/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform.mac;

import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.platform.mac.WmiMacNativeUIProxy;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.StringTools;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;

public class WmiMacNativeToolbar
extends WmiMacNativeUIProxy {
    public static final int TOOLBAR_TEXT_ONLY = 1;
    public static final int TOOLBAR_ICON_ONLY = 2;
    public static final int TOOLBAR_TEXT_AND_ICON = 3;
    public static final int TOOLBAR_SMALL_ICONS = 4;
    public static final String TOOLBAR_SPACE_ID = "__space";
    public static final String TOOLBAR_FLEXIBLE_SPACE_ID = "__flex_space";
    public static final String TOOLBAR_CUSTOMIZE_ID = "__customize";
    private String id;
    private String[] items;

    public WmiMacNativeToolbar(String string, Component component, String[] stringArray, boolean bl, int n, ToolbarListener toolbarListener) {
        super(component);
        this.id = string;
        this.items = stringArray;
        this.buildToolbar();
        this.addListener(toolbarListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildToolbar() {
        int n = this.items.length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        byte[][] byArrayArray = new byte[n][];
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.createNativeToolbar(this.id, this.items, stringArray, stringArray2, byArrayArray);
                return;
            }
            String string = this.items[n2];
            if (!string.equals("-")) {
                WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(string);
                if (wmiCommandProxy == null) {
                    System.err.println("command not found:" + string);
                } else {
                    int n3;
                    try {
                        String string2 = wmiCommandProxy.getResource(2);
                        String string3 = wmiCommandProxy.getResourceDirectory() + '/' + WmiToolBarButton.getIconName(string2, 2, -1, true);
                        InputStream inputStream = ResourceLoader.getResourceAsStream(string3);
                        for (n3 = 0; inputStream.available() > 0 && n3 < byArray.length; n3 += inputStream.read(byArray, n3, inputStream.available())) {
                        }
                        if (n3 < byArray.length) {
                            // empty if block
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (n3 > 0) {
                        byArrayArray[n2] = new byte[n3];
                        System.arraycopy(byArray, 0, byArrayArray[n2], 0, n3);
                    }
                    stringArray[n2] = wmiCommandProxy.getResource(11);
                    if (stringArray[n2] == null) {
                        stringArray[n2] = wmiCommandProxy.getResource(0);
                    }
                    if (stringArray[n2] != null) {
                        stringArray[n2] = StringTools.removeTilde(stringArray[n2]);
                        if (stringArray[n2].endsWith("...")) {
                            stringArray[n2] = stringArray[n2].substring(0, stringArray[n2].length() - 3);
                        }
                    } else {
                        stringArray[n2] = string;
                    }
                    stringArray2[n2] = wmiCommandProxy.getResource(1);
                }
            }
            ++n2;
        }
    }

    private native void createNativeToolbar(String var1, String[] var2, String[] var3, String[] var4, byte[][] var5);

    private native void addListener(ToolbarListener var1);

    public native void setTooltipsEnabled(boolean var1);

    public native void setEnabled(String var1, boolean var2);

    public native void setDisplayState(int var1);

    public native int getDisplayState();

    public native void setVisible(boolean var1);

    public native boolean isVisible();

    public native void setConfiguration(String[] var1);

    public native String[] getConfiguration();

    public static interface ToolbarListener {
        public void actionPerformed(String var1);
    }
}

