/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class WmiArrayCompositeView
extends WmiGenericView
implements WmiCompositeView,
WmiPositionedView {
    private static final float GROWTH_FACTOR = 1.5f;
    private static final int DEFAULT_INDENT = 2;
    protected static final int SEARCH_VERTICAL = 1;
    protected static final int SEARCH_HORIZONTAL = 2;
    protected static final int SEARCH_BOTH = 3;
    protected WmiView[] children;
    protected int length = 0;
    private int baseIndex = 0;

    public WmiArrayCompositeView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public WmiArrayCompositeView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, WmiCompositeView wmiCompositeView) {
        super(wmiModel, wmiMathDocumentView, wmiCompositeView);
    }

    public void appendView(WmiView wmiView) {
        this.ensureCapacity(this.length + 1);
        this.children[this.length++] = wmiView;
        if (wmiView != null) {
            wmiView.setParentView(this);
        }
    }

    public void removeChild(int n) {
        WmiView[] wmiViewArray = new WmiView[this.children.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (i == n) continue;
            wmiViewArray[n2] = this.children[i];
            ++n2;
        }
        --this.length;
        this.children = wmiViewArray;
    }

    public void insertView(WmiView wmiView, int n) {
        if ((n += this.baseIndex) < this.length) {
            this.ensureCapacity(this.length + 1);
            System.arraycopy(this.children, n, this.children, n + 1, this.length - n);
            ++this.length;
            this.children[n] = wmiView;
            wmiView.setParentView(this);
        } else {
            this.appendView(wmiView);
        }
    }

    public void insertViews(WmiView[] wmiViewArray, int n, int n2) {
        this.ensureCapacity(this.length + n);
        if (this.length > n2) {
            System.arraycopy(this.children, n2, this.children, n2 + n, this.length - n2);
        }
        for (int i = 0; i < n; ++i) {
            wmiViewArray[i].setParentView(this);
        }
        System.arraycopy(wmiViewArray, 0, this.children, n2, n);
        this.length += n;
    }

    public int indexOf(WmiView wmiView) {
        int n = -1;
        if (this.children != null) {
            for (int i = this.baseIndex; i < this.children.length; ++i) {
                if (this.children[i] != wmiView) continue;
                n = i;
                break;
            }
        }
        return n - this.baseIndex;
    }

    public WmiView getChild(int n) {
        WmiView wmiView = null;
        if (this.children != null && (n += this.baseIndex) >= this.baseIndex && n < this.length) {
            wmiView = this.children[n];
        }
        return wmiView;
    }

    public int getChildCount() {
        return this.length - this.baseIndex;
    }

    public void replaceChild(WmiView wmiView, int n) {
        this.children[n += this.baseIndex] = wmiView;
    }

    public void layoutView() throws WmiNoReadAccessException {
        this.validateChildren();
        super.layoutView();
    }

    public void updateView() throws WmiNoReadAccessException {
        try {
            WmiModel wmiModel = this.getModel();
            if (wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                if (this.length == 0) {
                    this.initializeView(wmiCompositeModel);
                } else if (wmiCompositeModel.getChildCount() == 1 && this.length == 1) {
                    this.singleChildUpdate(wmiCompositeModel);
                } else {
                    this.compoundUpdate(wmiCompositeModel);
                }
                int n = 0;
                while (n < this.length) {
                    if (this.children[n] == null) {
                        if (n < this.length - 1) {
                            System.arraycopy(this.children, n + 1, this.children, n, this.length - n - 1);
                        }
                        --this.length;
                        continue;
                    }
                    ++n;
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.updateView();
    }

    public static boolean hasUniqueViewObserver(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        int n = 0;
        if (wmiModel != null) {
            for (WmiModelObserver wmiModelObserver = wmiModel.getObserver(); wmiModelObserver != null; wmiModelObserver = wmiModelObserver.getNextObserver()) {
                if (!(wmiModelObserver instanceof WmiView) || ((WmiView)((Object)wmiModelObserver)).getDocumentView() != wmiMathDocumentView) continue;
                ++n;
            }
        }
        return n == 1;
    }

    public String debugPrint(int n) throws WmiNoReadAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getDebugName();
        stringBuffer.append("\n");
        stringBuffer.append(this.createIndent(n));
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(" x = ");
        stringBuffer.append(this.getHorizontalOffset());
        stringBuffer.append(" y = ");
        stringBuffer.append(this.getVerticalOffset());
        stringBuffer.append(" width = ");
        stringBuffer.append(this.width);
        stringBuffer.append(" height = ");
        stringBuffer.append(this.height);
        if (this.length == 0) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            for (int i = this.baseIndex; i < this.length; ++i) {
                WmiView wmiView = this.children[i];
                if (wmiView != null) {
                    stringBuffer.append(wmiView.debugPrint(n + 2));
                    continue;
                }
                stringBuffer.append("<NULL/>");
            }
            stringBuffer.append("\n");
            stringBuffer.append(this.createIndent(n));
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public WmiView copyView() {
        WmiArrayCompositeView wmiArrayCompositeView = (WmiArrayCompositeView)super.copyView();
        int n = this.length - this.baseIndex;
        wmiArrayCompositeView.children = new WmiView[n];
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.children[i + this.baseIndex];
            wmiArrayCompositeView.children[i] = wmiView = wmiView.copyView();
            wmiView.setParentView(wmiArrayCompositeView);
        }
        wmiArrayCompositeView.length = n;
        wmiArrayCompositeView.addNavigationLinks();
        return wmiArrayCompositeView;
    }

    public WmiView splitView(int n, int n2) {
        WmiArrayCompositeView wmiArrayCompositeView = null;
        try {
            wmiArrayCompositeView = (WmiArrayCompositeView)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        WmiView[] wmiViewArray = new WmiView[n];
        System.arraycopy(this.children, this.baseIndex, wmiViewArray, 0, n);
        Arrays.fill(this.children, this.baseIndex, this.baseIndex + n + n2, null);
        this.baseIndex += n + n2;
        wmiArrayCompositeView.length = n;
        wmiArrayCompositeView.children = wmiViewArray;
        wmiArrayCompositeView.locations = null;
        wmiArrayCompositeView.neighbors = null;
        wmiArrayCompositeView.baseIndex = 0;
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = wmiArrayCompositeView.children[i];
            wmiView.setParentView(wmiArrayCompositeView);
        }
        this.markInvalid(1);
        wmiArrayCompositeView.markInvalid(1);
        return wmiArrayCompositeView;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        wmiRenderPath.push(this.getHorizontalOffset(), this.getVerticalOffset());
        this.drawChildren(graphics, wmiRenderPath, rectangle);
        wmiRenderPath.pop();
    }

    protected void drawChildren(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        for (int i = 0; i < this.length; ++i) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.children[i];
            if (wmiPositionedView != null) {
                wmiPositionedView.draw(graphics, wmiRenderPath, rectangle);
            }
            wmiRenderPath.next();
        }
    }

    public WmiPositionedView getChildView(Point point) {
        WmiPositionedView wmiPositionedView = null;
        for (int i = 0; i < this.length; ++i) {
            Rectangle rectangle;
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView) || (rectangle = ((WmiPositionedView)wmiView).getBounds()) == null || !rectangle.contains(point)) continue;
            wmiPositionedView = (WmiPositionedView)wmiView;
            break;
        }
        return wmiPositionedView;
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, 3);
    }

    protected int getChildError(Point point, WmiPositionedView wmiPositionedView, int n, boolean[] blArray) {
        int n2 = 0;
        Rectangle rectangle = wmiPositionedView.getBounds();
        int n3 = 0;
        int n4 = 0;
        if (rectangle.x > point.x) {
            n4 = rectangle.x - point.x;
            if (n == 2 || n == 3) {
                blArray[0] = true;
            }
        } else if (rectangle.x + rectangle.width < point.x) {
            n4 = point.x - rectangle.x - rectangle.width;
        }
        if (rectangle.y > point.y) {
            n3 = rectangle.y - point.y;
            if (n == 1 || n == 3) {
                blArray[1] = true;
            }
        } else if (rectangle.y + rectangle.height < point.y) {
            n3 = point.y - rectangle.y - rectangle.height;
        }
        if (n == 3) {
            n2 = n4 * n4 + n3 * n3;
        } else if (n == 2) {
            n2 = Math.abs(n4);
        } else if (n == 1) {
            n2 = Math.abs(n3);
        }
        return n2;
    }

    protected WmiPositionedView getNearestChildView(Point point, int n) {
        WmiPositionedView wmiPositionedView = null;
        WmiPositionedView wmiPositionedView2 = null;
        int n2 = Integer.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.length; ++i) {
            Rectangle rectangle;
            int n3 = 0;
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView) || !((WmiPositionedView)wmiView).isNavagableView() || (rectangle = ((WmiPositionedView)wmiView).getBounds()) == null) continue;
            if (rectangle.contains(point)) {
                wmiPositionedView = (WmiPositionedView)wmiView;
                break;
            }
            boolean[] blArray = new boolean[2];
            blArray[1] = false;
            blArray[0] = false;
            n3 = this.getChildError(point, (WmiPositionedView)wmiView, n, blArray);
            bl = blArray[0];
            bl2 = blArray[1];
            if (n3 < n2) {
                n2 = n3;
                wmiPositionedView2 = (WmiPositionedView)wmiView;
                continue;
            }
            if (n3 != n2 || (bl || bl2) && wmiPositionedView2 != null) continue;
            wmiPositionedView2 = (WmiPositionedView)wmiView;
        }
        if (wmiPositionedView == null) {
            wmiPositionedView = wmiPositionedView2;
        }
        return wmiPositionedView;
    }

    public void drawStub(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
    }

    protected void validateChildren() throws WmiNoReadAccessException {
        for (int i = 0; i < this.length; ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView) || wmiView.isLayoutValid()) continue;
            ((WmiPositionedView)wmiView).layoutView();
            ((WmiPositionedView)wmiView).checkRepaint();
        }
    }

    public void resetPaintFlags() {
        super.resetPaintFlags();
        for (int i = 0; i < this.length; ++i) {
            WmiPositionedView wmiPositionedView;
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView) || !(wmiPositionedView = (WmiPositionedView)wmiView).getCheckRepaint() && !wmiPositionedView.getForceRepaint()) continue;
            wmiPositionedView.resetPaintFlags();
        }
    }

    protected void initializeView(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        this.length = wmiCompositeModel.getChildCount();
        WmiView[] wmiViewArray = new WmiView[this.length];
        WmiViewFactory wmiViewFactory = this.getViewFactory();
        if (wmiViewFactory != null) {
            for (int i = 0; i < this.length; ++i) {
                WmiModel wmiModel = wmiCompositeModel.getChild(i);
                if (wmiModel == null || !wmiModel.isVisible()) continue;
                wmiViewArray[i] = wmiViewFactory.createView(wmiCompositeModel.getChild(i), this);
            }
        } else {
            WmiErrorLog.log(new Exception("Unable to locate view factory"));
        }
        this.children = wmiViewArray;
    }

    protected void ensureCapacity(int n) {
        if (this.children == null) {
            this.children = new WmiView[n];
        } else if (this.children.length < n) {
            int n2 = (int)(1.5f * (float)this.children.length) + 1;
            if (n2 < n) {
                n2 = n;
            }
            WmiView[] wmiViewArray = new WmiView[n2];
            System.arraycopy(this.children, 0, wmiViewArray, 0, this.length);
            this.children = wmiViewArray;
        }
    }

    private void singleChildUpdate(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        WmiViewFactory wmiViewFactory;
        WmiModel wmiModel = wmiCompositeModel.getChild(0);
        WmiView wmiView = this.children[0];
        if (wmiView == null) {
            return;
        }
        WmiModel wmiModel2 = wmiView.getModel();
        if (wmiModel2 != null && !wmiModel2.isVisible()) {
            wmiView.release();
            this.children[0] = null;
            return;
        }
        if (!(wmiModel2 == wmiModel && WmiArrayCompositeView.hasUniqueViewObserver(wmiModel, this.getDocumentView()) || (wmiViewFactory = this.getViewFactory()) == null)) {
            wmiView.release();
            this.children[0] = wmiViewFactory.createView(wmiModel, this);
        }
    }

    private void compoundUpdate(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        int n;
        int n2;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        int n3 = this.length;
        int n4 = wmiCompositeModel.getChildCount();
        WmiView[] wmiViewArray = new WmiView[n4];
        int[] nArray = new int[n3];
        int n5 = 0;
        WmiViewFactory wmiViewFactory = this.getViewFactory();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            WmiModel wmiModel = wmiCompositeModel.getChild(n2);
            if (wmiModel == null) continue;
            for (n = n5; n < n3; ++n) {
                int n6 = nArray[n];
                WmiView wmiView = this.children[n6];
                if (wmiView == null || wmiView.getModel() != wmiModel || !WmiArrayCompositeView.hasUniqueViewObserver(wmiModel, wmiMathDocumentView)) continue;
                wmiViewArray[n2] = wmiView;
                if (n != n5) {
                    nArray[n] = nArray[n5];
                    nArray[n5] = n6;
                }
                ++n5;
                break;
            }
            if (wmiModel.isVisible()) {
                if (wmiViewArray[n2] != null || wmiViewFactory == null) continue;
                wmiViewArray[n2] = wmiViewFactory.createView(wmiModel, this);
                continue;
            }
            if (wmiViewArray[n2] == null) continue;
            wmiViewArray[n2].release();
            wmiViewArray[n2] = null;
        }
        for (n = n5; n < n3; ++n) {
            this.children[nArray[n]].release();
        }
        this.length = n4;
        this.children = wmiViewArray;
    }

    protected WmiViewFactory getViewFactory() {
        WmiViewFactory wmiViewFactory = null;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        if (wmiMathDocumentView != null) {
            wmiViewFactory = wmiMathDocumentView.getViewFactory();
        }
        return wmiViewFactory;
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean bl) {
        if (bl && this.children != null) {
            for (int i = 0; i < this.length; ++i) {
                WmiView wmiView = this.children[i];
                if (wmiView == null) continue;
                wmiView.release();
                this.children[i] = null;
            }
        }
        this.children = null;
        this.length = 0;
        super.release();
    }

    public boolean mergeFragmentsOnUpdate() {
        return false;
    }
}

