/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;

public class WmiCaret
implements WmiPositionMarker {
    private static final int TIMER_UNINITIALIZED = -1;
    private static final int DEFAULT_TIMER_DELAY = 600;
    private static int timerDelay = -1;
    protected WmiMathDocumentView docView;
    protected WmiScrollableContainerView container;
    private int left = 0;
    private int right = 0;
    private int top = 0;
    private int bottom = 0;
    private boolean visible = false;
    private boolean blinkOn = true;
    private WmiPositionedView caretView = null;
    private WmiModel caretModel = null;
    private int offset = 0;
    private long blinkTime = 0L;
    private static Timer timer = new Timer();

    public WmiCaret(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
        this.container = this.docView;
        if (timerDelay == -1 && (timerDelay = UIManager.getInt("TextPane.caretBlinkRate")) == 0) {
            timerDelay = 600;
        }
    }

    public static void resetTimer() {
        timer = new Timer();
    }

    public static void cancelTimer() {
        timer.cancel();
    }

    protected void repaint() {
        if (this.container != null && this.bottom > 0) {
            Point point = WmiViewUtil.offsetForContainer(this.container);
            Point point2 = this.container.getContainerOffset();
            int n = this.left + point2.x;
            int n2 = this.top + point.y + point2.y;
            int n3 = this.right - this.left + 1;
            int n4 = this.bottom - this.top + 1;
            this.docView.repaint(n, n2, n3, n4);
        }
    }

    public void updateCaretBounds(WmiScrollableContainerView wmiScrollableContainerView, int n, int n2, int n3, int n4) {
        boolean bl = this.visible;
        WmiScrollableContainerView wmiScrollableContainerView2 = this.container = wmiScrollableContainerView != null ? wmiScrollableContainerView : this.docView;
        if (bl) {
            this.hide();
        }
        this.left = n;
        this.right = n3;
        this.top = n2;
        this.bottom = n4;
        if (bl) {
            this.show();
        }
    }

    protected void drawCaret(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        Point point = WmiViewUtil.offsetForContainer(this.container);
        graphics.drawLine(this.getRight() + point.x, this.getTop() + point.y, this.getLeft() + point.x, this.getBottom() + point.y);
        graphics.setColor(color);
    }

    protected int getBottom() {
        return this.bottom;
    }

    protected int getLeft() {
        return this.left;
    }

    protected int getRight() {
        return this.right;
    }

    protected int getTop() {
        return this.top;
    }

    public void updateView(WmiPositionedView wmiPositionedView, int n) throws WmiNoReadAccessException {
        Object object;
        WmiModel wmiModel = null;
        int n2 = this.offset;
        if (this.caretView != null) {
            wmiModel = this.caretView.getModel();
        }
        this.caretView = wmiPositionedView;
        WmiModel wmiModel2 = this.caretModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        if (n == -1) {
            n = wmiPositionedView instanceof WmiCompositeView ? ((WmiCompositeView)((Object)wmiPositionedView)).getChildCount() : (wmiPositionedView instanceof WmiTraversableView ? ((WmiTraversableView)wmiPositionedView).getTraversableCount() : 0);
        }
        this.offset = n;
        if (wmiPositionedView != null && (object = wmiPositionedView.getModel()) != null && (object != wmiModel || this.offset != n2)) {
            WmiCompositeModel wmiCompositeModel;
            int n3;
            WmiMathDocumentModel wmiMathDocumentModel = object.getDocument();
            while (object instanceof WmiCompositeModel && (n3 = (wmiCompositeModel = (WmiCompositeModel)object).getChildCount()) > 0) {
                object = this.offset == 0 ? wmiCompositeModel.getChild(0) : wmiCompositeModel.getChild(n3 - 1);
            }
            wmiMathDocumentModel.getActiveEditAttributes().addAttributes(object.getAttributes());
        }
        if ((object = WmiViewUtil.findEnclosingContainer(this.caretView)) != null && this.docView != null) {
            this.docView.setActiveContainer((WmiScrollableContainerView)object);
        }
        this.docView.notifyMarkerPositionChanged();
    }

    public Rectangle getBounds() {
        Point point = WmiViewUtil.offsetForContainer(this.container);
        return new Rectangle(this.left + point.x, this.top + point.y, this.right - this.left, this.bottom - this.top);
    }

    public WmiViewPath getViewPath() {
        WmiViewPath wmiViewPath = null;
        if (this.visible && this.caretView != null) {
            wmiViewPath = new WmiViewPath(this.caretView);
            if (this.offset > 0 && this.caretView instanceof WmiCompositeView) {
                wmiViewPath.push(-1);
            } else {
                wmiViewPath.push(this.offset);
            }
        }
        return wmiViewPath;
    }

    public WmiModelPosition getModelPosition() {
        WmiModelPosition wmiModelPosition = null;
        if (this.caretView != null && this.caretModel != null) {
            int n = this.offset;
            if (this.caretView instanceof WmiTextView) {
                n += ((WmiTextView)this.caretView).getStartOffset();
            }
            wmiModelPosition = new WmiModelPosition(this.caretModel, n);
        }
        return wmiModelPosition;
    }

    public void hide() {
        this.blinkOn = false;
        this.visible = false;
        this.docView.setFocusedView(null);
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics graphics) {
        if (this.visible) {
            long l;
            if (this.blinkOn) {
                this.drawCaret(graphics);
            }
            if (this.blinkTime < (l = System.currentTimeMillis())) {
                this.blinkOn = !this.blinkOn;
                this.blinkTime = l + (long)timerDelay;
            }
            timer.schedule((TimerTask)new CaretRepainter(), timerDelay);
        }
    }

    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.container, new Rectangle(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1));
    }

    public void scrollToTop() {
        WmiDocumentScroller.scrollToTop(this.container, new Rectangle(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1));
    }

    public void updateMarkerPosition(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        WmiView wmiView;
        this.offset = n;
        if (wmiModel instanceof WmiTextModel) {
            int n2 = ((WmiTextModel)wmiModel).getLength();
            if (n < 0) {
                this.offset = n2;
            }
            while (this.offset > n2) {
                int n3;
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                int n4 = n3 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
                if (n3 >= 0 && n3 < wmiCompositeModel.getChildCount() - 1) {
                    WmiModel wmiModel2 = wmiCompositeModel.getChild(n3 + 1);
                    if (wmiModel2 instanceof WmiTextModel) {
                        this.offset -= n2;
                        wmiModel = wmiModel2;
                        n2 = ((WmiTextModel)wmiModel).getLength();
                        continue;
                    }
                    this.offset = n2;
                    continue;
                }
                this.offset = n2;
            }
        }
        if ((wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, this.offset)) instanceof WmiPositionedView) {
            if (wmiView instanceof WmiTextView) {
                this.offset = this.offset >= 0 ? (this.offset -= ((WmiTextView)wmiView).getStartOffset()) : ((WmiTextView)wmiView).getLength();
            }
            ((WmiPositionedView)wmiView).setPositionMarker(this.offset);
        } else {
            this.docView.setPositionMarker(null);
        }
    }

    public void resync() throws WmiNoReadAccessException {
        if (this.caretView != null && this.caretModel != null) {
            int n = this.offset;
            if (this.caretView instanceof WmiTextView) {
                n += ((WmiTextView)this.caretView).getStartOffset();
            }
            this.updateMarkerPosition(this.caretModel, n);
        } else {
            this.caretView = null;
            this.caretModel = null;
        }
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        Object object = this.docView.getTreeLock();
        synchronized (object) {
            Timer timer = WmiCaret.timer;
            synchronized (timer) {
                this.blinkOn = true;
                this.visible = true;
                if (this.caretView != null) {
                    this.docView.setFocusedView(this.caretView);
                }
                this.repaint();
                this.blinkTime = System.currentTimeMillis() + (long)timerDelay;
                WmiCaret.timer.schedule((TimerTask)new CaretRepainter(), timerDelay);
            }
        }
    }

    public WmiPositionedView getView() {
        return this.caretView;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isReadOnly() throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.docView != null && this.caretModel != null) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.docView.getModel();
            bl = !wmiMathDocumentModel.isMutableModel(this.caretModel);
        }
        return bl;
    }

    public class CaretRepainter
    extends TimerTask {
        public void run() {
            WmiCaret.this.repaint();
        }
    }
}

