/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;

public class WmiMathExportParagraphView
extends WmiParagraphView {
    public static final int DOTS_PER_INCH = 72;
    public static final int LEFT_INDENT_SIZE = 3;
    private static final int PADDING_ABOVE = 3;
    private static final int PADDING_BELOW = 3;
    private static final int PADDING_RIGHT = 5;
    private static final int PADDING_LEFT = 5;
    private int m_lineBreakWidth;

    public WmiMathExportParagraphView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, int n) {
        super(wmiModel, wmiMathDocumentView);
        this.m_lineBreakWidth = n;
        try {
            if (wmiMathDocumentView != null) {
                this.setParentView(wmiMathDocumentView);
                this.updateView();
                this.forceRepaint();
            }
            this.layoutView();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public WmiMathExportParagraphView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.m_lineBreakWidth = wmiMathDocumentView.getBreakWidth();
    }

    public int getLinebreakWidth() {
        return this.m_lineBreakWidth;
    }

    public int getWidth() {
        int n = 0;
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView)) continue;
            n = Math.max(n, ((WmiPositionedView)wmiView).getWidth());
        }
        return n;
    }

    public int getLeftIndent() {
        return 3;
    }

    public int getSpaceAbove() {
        return 3;
    }

    public int getSpaceBelow() {
        return 3;
    }

    public int getLeftMargin() {
        return 5;
    }

    public int getRightMargin() {
        return 5;
    }
}

