/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.util.LinkedList;

public class WmiPostDeletePositionUpdateHandler
extends WmiDefaultPositionUpdateHandler {
    public static final int FORWARD_BIAS = 1;
    public static final int REVERSE_BIAS = -1;
    public static final int DEFAULT_BIAS = -1;
    private LinkedList forwardSearchPath;
    private LinkedList reverseSearchPath;
    private int bias = -1;

    public WmiPostDeletePositionUpdateHandler(WmiMathDocumentView wmiMathDocumentView, WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException {
        this(wmiMathDocumentView, wmiModelPosition, -1);
    }

    public WmiPostDeletePositionUpdateHandler(WmiMathDocumentView wmiMathDocumentView, WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException {
        super(wmiMathDocumentView, wmiModelPosition);
        WmiModel wmiModel = wmiModelPosition.getModel();
        this.forwardSearchPath = this.createSearchPath(wmiModel, 1);
        this.reverseSearchPath = this.createSearchPath(wmiModel, -1);
        this.bias = n;
    }

    private LinkedList createSearchPath(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        LinkedList<SearchNode> linkedList = new LinkedList<SearchNode>();
        linkedList.add(new SearchNode(wmiModel));
        while (wmiModel != null) {
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            if (wmiCompositeModel != null) {
                int n2;
                SearchNode searchNode = new SearchNode(wmiCompositeModel);
                linkedList.add(searchNode);
                int n3 = wmiCompositeModel.indexOf(wmiModel);
                if (n > 0) {
                    n2 = wmiCompositeModel.getChildCount();
                    for (int i = n3 + 1; i < n2; ++i) {
                        searchNode.addChild(wmiCompositeModel.getChild(i));
                    }
                } else {
                    for (n2 = n3 - 1; n2 >= 0; --n2) {
                        searchNode.addChild(wmiCompositeModel.getChild(n2));
                    }
                }
            }
            wmiCompositeModel = (wmiModel = wmiCompositeModel) != null ? wmiModel.getParent() : null;
        }
        return linkedList;
    }

    public void updatePosition() throws WmiNoReadAccessException {
        this.adjustPosition();
        super.updatePosition();
    }

    private void adjustPosition() throws WmiNoReadAccessException {
        this.adjustPosition(true);
    }

    private void adjustPosition(boolean bl) throws WmiNoReadAccessException {
        WmiModelPosition wmiModelPosition = this.getPosition();
        int n = wmiModelPosition.getOffset();
        LinkedList linkedList = this.bias > 0 ? this.forwardSearchPath : this.reverseSearchPath;
        int n2 = linkedList.size();
        boolean bl2 = false;
        block0: for (int i = 0; i < n2 && !bl2; ++i) {
            SearchNode searchNode = (SearchNode)linkedList.get(i);
            WmiModel wmiModel = searchNode.parent;
            if (!this.isLiveModel(wmiModel) || !wmiModel.isVisible()) continue;
            LinkedList linkedList2 = searchNode.children;
            if (linkedList2 != null) {
                int n3 = linkedList2.size();
                for (int j = 0; j < n3; ++j) {
                    WmiModel wmiModel2 = (WmiModel)linkedList2.get(j);
                    if (!this.isLiveModel(wmiModel2) || !wmiModel2.isVisible() || (wmiModel2 = this.getTraversableModel(wmiModel2)) == null) continue;
                    wmiModelPosition = new WmiModelPosition(wmiModel2, this.bias > 0 ? 0 : -1);
                    bl2 = true;
                    continue block0;
                }
                continue;
            }
            if (i != 0) continue;
            wmiModelPosition = new WmiModelPosition(wmiModel, n);
            bl2 = true;
            break;
        }
        if (bl2) {
            this.setPosition(wmiModelPosition);
        } else if (bl) {
            this.bias = -this.bias;
            this.adjustPosition(false);
        } else {
            this.setPosition(new WmiModelPosition(this.docView.getModel(), 0));
        }
    }

    private WmiModel getTraversableModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        int n;
        WmiView wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, 0);
        block0: while (!(wmiView instanceof WmiTraversableView) && wmiModel instanceof WmiCompositeModel && (n = (wmiCompositeModel = (WmiCompositeModel)wmiModel).getChildCount()) != 0) {
            int n2;
            if (this.bias > 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    wmiModel = wmiCompositeModel.getChild(n2);
                    if (wmiModel == null || !wmiModel.isVisible()) continue;
                    wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, 0);
                    continue block0;
                }
                continue;
            }
            for (n2 = n - 1; n2 >= 0; --n2) {
                wmiModel = wmiCompositeModel.getChild(n2);
                if (wmiModel == null || !wmiModel.isVisible()) continue;
                wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, 0);
                continue block0;
            }
        }
        return wmiModel;
    }

    private boolean isLiveModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel;
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel2 = wmiMathDocumentModel = wmiModel != null ? wmiModel.getDocument() : null;
        while (wmiModel != null && wmiModel != wmiMathDocumentModel) {
            int n;
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n2 = n = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
            if (n < 0) {
                bl = false;
                break;
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return bl;
    }

    private class SearchNode {
        private WmiModel parent;
        private LinkedList children;

        private SearchNode(WmiModel wmiModel) {
            this.parent = wmiModel;
        }

        private void addChild(WmiModel wmiModel) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            this.children.add(wmiModel);
        }
    }
}

