/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiRenderPath {
    private static final int DEFAULT_ARRAY_SIZE = 10;
    private WmiSelection selection = null;
    private WmiViewPath activePath = new WmiViewPath();
    private int[] xOffset = new int[10];
    private int[] yOffset = new int[10];
    private int xShift = 0;
    private int yShift = 0;
    private int depth = 1;
    private boolean drawStringsWithGlyphVectors = true;
    private boolean cloneGCForClip = false;
    private boolean isDrawingToScreen = true;
    private WmiScrollableContainerView container = null;
    private Point containerOffset = new Point(0, 0);

    public WmiRenderPath(WmiMathDocumentView wmiMathDocumentView) {
        this.xOffset[0] = 0;
        this.yOffset[0] = 0;
        if (wmiMathDocumentView != null) {
            this.selection = wmiMathDocumentView.getSelection();
        }
    }

    public void push(int n, int n2) {
        this.activePath.push(0);
        this.xOffset = this.ensureCapacity(this.xOffset, this.depth + 1);
        this.yOffset = this.ensureCapacity(this.yOffset, this.depth + 1);
        this.xOffset[this.depth] = this.xOffset[this.depth - 1] + n;
        this.yOffset[this.depth] = this.yOffset[this.depth - 1] + n2;
        ++this.depth;
    }

    public void pop() {
        this.activePath.pop();
        --this.depth;
    }

    public void next() {
        this.activePath.next();
    }

    public void applyShift(int n, int n2) {
        this.xShift += n;
        this.yShift += n2;
    }

    public int getHorizontalShift() {
        return this.xShift;
    }

    public int getVerticalShift() {
        return this.yShift;
    }

    public void translateOrigin(int n, int n2) {
        int n3 = this.depth - 1;
        this.xOffset[n3] = this.xOffset[n3] + n;
        int n4 = this.depth - 1;
        this.yOffset[n4] = this.yOffset[n4] + n2;
    }

    public boolean isSelected(int n, int n2) {
        boolean bl = false;
        int n3 = this.getLeftSelectionBoundary();
        if (n3 >= 0) {
            int n4;
            int n5 = 0;
            if (n3 <= n) {
                ++n5;
            }
            if ((n4 = this.getRightSelectionBoundary()) >= n + n2) {
                ++n5;
            }
            bl = n5 == 2;
        }
        return bl;
    }

    public void setSelection(WmiSelection wmiSelection) {
        this.selection = wmiSelection;
    }

    public WmiSelection getSelection() {
        return this.selection;
    }

    public WmiViewPath getActivePath() {
        return this.activePath;
    }

    public int getHorizontalOffset() {
        return this.xOffset[this.depth - 1] + this.containerOffset.x;
    }

    public int getVerticalOffset() {
        return this.yOffset[this.depth - 1] + this.containerOffset.y;
    }

    private int[] ensureCapacity(int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[n];
        } else if (nArray.length < n) {
            int n2 = 2 * nArray.length;
            if (n2 < n) {
                n2 = n;
            }
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        return nArray;
    }

    public String toString() {
        return "pos:(" + Integer.toString(this.xOffset[this.depth - 1]) + ", " + Integer.toString(this.yOffset[this.depth - 1]) + ")  " + this.activePath + " (" + this.selection + ")";
    }

    public int getLeftSelectionBoundary() {
        return this.getLeftSelectionBoundary(0);
    }

    public int getLeftSelectionBoundary(int n) {
        WmiHighlightPainter wmiHighlightPainter;
        int n2 = -1;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter != null) {
            n2 = wmiHighlightPainter.getLeftBoundary(this.yOffset[this.depth - 1] + n);
        }
        return n2;
    }

    public int getRightSelectionBoundary() {
        return this.getRightSelectionBoundary(0);
    }

    public int getRightSelectionBoundary(int n) {
        WmiHighlightPainter wmiHighlightPainter;
        int n2 = -1;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter != null) {
            n2 = wmiHighlightPainter.getRightBoundary(this.yOffset[this.depth - 1] + n);
        }
        return n2;
    }

    public boolean isMidpointSelected(WmiPositionedView wmiPositionedView) {
        int n;
        int n2 = wmiPositionedView.getHeight() / 2;
        int n3 = this.getLeftSelectionBoundary(n2);
        int n4 = this.getRightSelectionBoundary(n2);
        return n4 > (n = wmiPositionedView.getHorizontalOffset() + this.getHorizontalOffset() + wmiPositionedView.getWidth() / 2) && n3 < n;
    }

    public boolean isPointInSelection(int n, int n2) {
        WmiHighlightPainter wmiHighlightPainter;
        boolean bl = false;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter != null) {
            wmiHighlightPainter.isInsideHighlight(new Point(n, n2));
        }
        return bl;
    }

    public Rectangle getSelectionBoundary() {
        WmiHighlightPainter wmiHighlightPainter;
        Rectangle rectangle = null;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter != null) {
            rectangle = wmiHighlightPainter.getBounds();
        }
        return rectangle;
    }

    public Rectangle getLeftMarginBoundary() {
        WmiHighlightPainter wmiHighlightPainter;
        Rectangle rectangle = null;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter instanceof WmiSelectionHighlighter) {
            rectangle = ((WmiSelectionHighlighter)wmiHighlightPainter).computeLeftMarginBounds();
        }
        return rectangle;
    }

    public boolean drawStringsWithGlyphVectors() {
        return this.drawStringsWithGlyphVectors;
    }

    public void drawStringsWithGlyphVectors(boolean bl) {
        this.drawStringsWithGlyphVectors = bl;
    }

    public void setScreenDraw(boolean bl) {
        this.isDrawingToScreen = bl;
    }

    public boolean isScreenDraw() {
        return this.isDrawingToScreen;
    }

    public void setCloneGCForClip(boolean bl) {
        this.cloneGCForClip = bl;
    }

    public boolean cloneGCForClip() {
        return this.cloneGCForClip;
    }

    public WmiScrollableContainerView getContainer() {
        return this.container;
    }

    public void setContainer(WmiScrollableContainerView wmiScrollableContainerView) {
        this.container = wmiScrollableContainerView;
        if (wmiScrollableContainerView != null && !wmiScrollableContainerView.isDocumentView()) {
            this.containerOffset = WmiViewUtil.getAbsoluteOffset(wmiScrollableContainerView);
        }
    }

    public void copyDrawingFlags(WmiRenderPath wmiRenderPath) {
        if (wmiRenderPath != null) {
            this.cloneGCForClip = wmiRenderPath.cloneGCForClip;
            this.drawStringsWithGlyphVectors = wmiRenderPath.drawStringsWithGlyphVectors;
            this.isDrawingToScreen = wmiRenderPath.isDrawingToScreen;
        }
    }
}

