/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class WmiResizeDecorator
extends WmiBoundsMarker {
    protected static final int HOTSPOT_NONE = 0;
    protected static final int HOTSPOT_NW = 1;
    protected static final int HOTSPOT_N = 2;
    protected static final int HOTSPOT_NE = 3;
    protected static final int HOTSPOT_W = 4;
    protected static final int HOTSPOT_E = 5;
    protected static final int HOTSPOT_SW = 6;
    protected static final int HOTSPOT_S = 7;
    protected static final int HOTSPOT_SE = 8;
    private static final int MINIMUM_DIMENSION = 20;
    private Rectangle startBounds = null;
    private Point startPoint = null;
    private Object parentAlignment = null;
    private boolean moveUp = false;
    private boolean moveDown = false;
    private boolean moveLeft = false;
    private boolean moveRight = false;

    protected WmiResizeDecorator(WmiMathDocumentView wmiMathDocumentView) {
        super(wmiMathDocumentView);
    }

    public Dimension onMouseDragged(MouseEvent mouseEvent) {
        WmiPositionedView wmiPositionedView = this.getView();
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        int n = point.x + mouseEvent.getX();
        int n2 = point.y + mouseEvent.getY();
        Rectangle rectangle = this.startBounds != null ? this.startBounds : this.getBounds();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.startBounds != null) {
            int n5 = n - this.startPoint.x;
            int n6 = n2 - this.startPoint.y;
            if (this.moveUp) {
                n4 -= n6;
            } else if (this.moveDown) {
                n4 += n6;
            }
            if (this.moveLeft || this.moveRight) {
                if ("centred".equals(this.parentAlignment)) {
                    n5 *= 2;
                }
                if (this.moveLeft) {
                    n3 -= n5;
                } else if (this.moveRight) {
                    n3 += n5;
                }
            }
            n3 = Math.max(n3, 20);
            n4 = Math.max(n4, 20);
            if (mouseEvent.isShiftDown()) {
                Dimension dimension = WmiResizeDecorator.constrainResize(this.startBounds, n3, n4, this.moveLeft || this.moveRight);
                n3 = dimension.width;
                n4 = dimension.height;
            }
        }
        return new Dimension(n3, n4);
    }

    public Cursor onMouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return this.getCursorForPoint(n, n2);
    }

    public Cursor getCursorForPoint(int n, int n2) {
        int n3 = 0;
        Rectangle rectangle = this.getBounds();
        int n4 = this.selectedHotspot(n, n2, rectangle);
        switch (n4) {
            case 1: {
                n3 = 6;
                break;
            }
            case 2: 
            case 7: {
                n3 = 8;
                break;
            }
            case 3: {
                n3 = 7;
                break;
            }
            case 4: 
            case 5: {
                n3 = 11;
                break;
            }
            case 6: {
                n3 = 4;
                break;
            }
            case 8: {
                n3 = 5;
            }
        }
        if (n3 == 0) {
            return null;
        }
        return Cursor.getPredefinedCursor(n3);
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        Rectangle rectangle = this.getBounds();
        int n3 = this.selectedHotspot(n, n2, rectangle);
        if (n3 > 0) {
            this.moveLeft = n3 == 1 || n3 == 4 || n3 == 6;
            this.moveRight = n3 == 3 || n3 == 5 || n3 == 8;
            this.moveUp = n3 == 1 || n3 == 2 || n3 == 3;
            this.moveDown = n3 == 6 || n3 == 7 || n3 == 8;
            WmiPositionedView wmiPositionedView = this.getView();
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            this.startBounds = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            this.startPoint = new Point(point.x + n, point.y + n2);
            this.parentAlignment = this.getAlignment();
            bl = true;
        }
        return bl;
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.startBounds = null;
        this.startPoint = null;
        this.parentAlignment = null;
    }

    public void hide() {
        WmiPositionedView wmiPositionedView = this.getView();
        if (wmiPositionedView instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)wmiPositionedView).setMarker(null);
        }
        super.hide();
    }

    public void show() {
        super.show();
        WmiPositionedView wmiPositionedView = this.getView();
        if (wmiPositionedView instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)wmiPositionedView).setMarker(this);
        }
    }

    protected abstract int selectedHotspot(int var1, int var2, Rectangle var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAlignment() {
        WmiModel wmiModel;
        WmiParagraphView wmiParagraphView = (WmiParagraphView)WmiViewUtil.findAncestorOfClass(this.getView(), WmiParagraphView.class);
        Object object = null;
        if (wmiParagraphView != null && WmiModelLock.readLock(wmiModel = this.getView().getModel(), true)) {
            try {
                object = wmiParagraphView.getAttribute("alignment");
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        return object;
    }

    private static Dimension constrainResize(Rectangle rectangle, int n, int n2, boolean bl) {
        float f = (float)rectangle.width / (float)rectangle.height;
        if (bl) {
            n2 = (int)((float)n / f);
        } else {
            n = (int)((float)n2 * f);
        }
        return new Dimension(n, n2);
    }
}

