/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTableRowAttributeSet;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTableCellView;
import com.maplesoft.mathdoc.view.WmiTableView;
import java.awt.Point;

public class WmiTableRowView
extends WmiArrayCompositeView {
    private int row = -1;
    private boolean separator = true;

    public WmiTableRowView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            Object object;
            int n = this.getChildCount();
            this.width = 0;
            this.height = 0;
            WmiTableView wmiTableView = (WmiTableView)this.getParentView();
            WmiModel wmiModel = this.getModel();
            WmiAttributeSet wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
            Object object2 = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("align") : null;
            int n2 = this.getAlignmentIndex(object2);
            Object object3 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("separator") : null;
            if (object instanceof Boolean) {
                this.separator = object.equals(Boolean.TRUE);
            } else if (object != null) {
                this.separator = object.toString().compareToIgnoreCase("true") == 0;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                WmiTableCellView wmiTableCellView = wmiTableView.getActiveCell(n5);
                while (wmiTableCellView != null && wmiTableCellView.getRowIndex() + wmiTableCellView.getRowSpan() > this.row) {
                    this.width += wmiTableCellView.getWidth();
                    wmiTableCellView = wmiTableView.getActiveCell(n5 += wmiTableCellView.getColumnSpan());
                }
                WmiTableCellView wmiTableCellView2 = (WmiTableCellView)this.getChild(i);
                wmiTableCellView2.setColumn(n5);
                wmiTableCellView2.setRow(this.row);
                wmiTableCellView2.layoutView();
                if (wmiTableCellView2.getRowSpan() > 1) {
                    wmiTableView.setActiveCell(n5, wmiTableCellView2);
                } else {
                    wmiTableView.setActiveCell(n5, null);
                }
                n5 += wmiTableCellView2.getColumnSpan();
                wmiTableCellView2.setHorizontalOffset(this.width);
                this.width += wmiTableCellView2.getWidth();
                if (wmiTableCellView2.getRowSpan() != 1) continue;
                if (wmiTableCellView2.getHeight() > this.height) {
                    this.height = wmiTableCellView2.getHeight();
                }
                if (wmiTableCellView2.getBaseline() > n3) {
                    n3 = wmiTableCellView2.getBaseline();
                }
                if (wmiTableCellView2.getHeight() - wmiTableCellView2.getBaseline() <= n4) continue;
                n4 = wmiTableCellView2.getHeight() - wmiTableCellView2.getBaseline();
            }
            switch (n2) {
                case 0: {
                    this.alignTop();
                    break;
                }
                case 1: {
                    this.alignCenter();
                    break;
                }
                case 2: {
                    this.alignBottom();
                    break;
                }
                default: {
                    this.alignBaseline(n3, n4);
                }
            }
            this.addNavigationLinks();
            super.layoutView();
        } else {
            this.updatePendingRows();
        }
    }

    private void updatePendingRows() {
        int n = this.getChildCount();
        WmiTableView wmiTableView = (WmiTableView)this.getParentView();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            WmiTableCellView wmiTableCellView = wmiTableView.getActiveCell(n2);
            while (wmiTableCellView != null && wmiTableCellView.getRowIndex() + wmiTableCellView.getRowSpan() > this.row) {
                this.width += wmiTableCellView.getWidth();
                wmiTableCellView = wmiTableView.getActiveCell(n2 += wmiTableCellView.getColumnSpan());
            }
            WmiTableCellView wmiTableCellView2 = (WmiTableCellView)this.getChild(i);
            if (wmiTableCellView2.getRowSpan() > 1) {
                wmiTableView.setActiveCell(n2, wmiTableCellView2);
            } else {
                wmiTableView.setActiveCell(n2, null);
            }
            n2 += wmiTableCellView2.getColumnSpan();
        }
    }

    private void alignTop() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.getChild(i);
            wmiTableCellView.setVerticalOffset(0);
        }
    }

    private void alignCenter() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.getChild(i);
            wmiTableCellView.setVerticalOffset((this.height - wmiTableCellView.getHeight()) / 2);
        }
    }

    private void alignBottom() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.getChild(i);
            wmiTableCellView.setVerticalOffset(this.height - wmiTableCellView.getHeight());
        }
    }

    private void alignBaseline(int n, int n2) {
        int n3 = this.getChildCount();
        for (int i = 0; i < n3; ++i) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.getChild(i);
            int n4 = n - wmiTableCellView.getBaseline();
            int n5 = wmiTableCellView.getHeight() - wmiTableCellView.getBaseline() + n;
            wmiTableCellView.setVerticalOffset(n4);
            if (n5 <= this.height) continue;
            this.height = n5;
        }
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setRow(int n) {
        if (n != this.row) {
            this.row = n;
            this.markInvalid(1);
        }
    }

    public void addNavigationLinks() {
        for (int i = 0; i < this.length - 1; ++i) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(i);
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(i + 1);
            if (wmiPositionedView != null) {
                wmiPositionedView.setNextView(wmiPositionedView2, 3);
            }
            if (wmiPositionedView2 == null) continue;
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
        }
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, 2);
    }

    public int getRow() {
        return this.row;
    }

    protected int getAlignmentIndex(Object object) {
        int n = 0;
        if (object != null) {
            String string = object.toString();
            for (int i = 0; i < 4; ++i) {
                if (!string.equals(WmiTableRowAttributeSet.ALIGNMENT_VALUES[i])) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public boolean drawSeparator() {
        return this.separator;
    }
}

