/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiMathCaret
extends WmiCaret {
    private int uprightBottom = 0;
    private int uprightTop = 0;
    private Rectangle caretRect = new Rectangle(0, 0, 0, 0);
    private static boolean DRAW_CLIP_BOUNDS = false;

    public WmiMathCaret(WmiMathDocumentView wmiMathDocumentView) {
        super(wmiMathDocumentView);
    }

    protected void drawCaret(Graphics graphics) {
        int n;
        Point point;
        Color color = graphics.getColor();
        Rectangle rectangle = graphics.getClipBounds();
        WmiPositionedView wmiPositionedView = this.getView();
        Point point2 = WmiViewUtil.offsetForContainer(this.container);
        Point point3 = WmiViewUtil.getAbsoluteOffset(this.container);
        Rectangle rectangle2 = this.container.getBounds();
        int n2 = point3.x;
        int n3 = point3.y;
        int n4 = rectangle2.width;
        int n5 = rectangle2.height;
        if (!this.container.isDocumentView()) {
            graphics.setClip(n2, n3, n4, n5);
        }
        if ((point = this.container.getContainerOffset()) != null) {
            point2.x += point.x;
            point2.y += point.y;
        }
        int n6 = this.uprightTop + point2.x;
        int n7 = this.getTop() + point2.y;
        int n8 = this.uprightBottom + point2.x;
        int n9 = this.getBottom() + point2.y;
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n6, n7, n8, n9);
        int n10 = Math.min(n6, n8);
        int n11 = Math.max(n6, n8);
        if (wmiPositionedView != null) {
            graphics.setColor(Color.LIGHT_GRAY);
            Point point4 = WmiViewUtil.getRelativeOffset(wmiPositionedView, this.container);
            n = point4.x + point2.x;
            int n12 = n + wmiPositionedView.getWidth();
            n12 = n12 > n8 && n8 > n ? n8 : n12;
            graphics.drawLine(n, n9, n12, n9);
            n10 = Math.min(n10, n);
            n11 = Math.max(n11, n12);
        }
        int n13 = n11 - n10 + 1;
        n = n9 - n7 + 1;
        this.caretRect.setBounds(n10, n7, n13, n);
        graphics.setColor(color);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setUprightPosition(int n, int n2) {
        this.uprightBottom = n;
        this.uprightTop = n2;
    }

    public int getUprightPosition() {
        return this.uprightTop;
    }

    protected void repaint() {
        if ((this.caretRect.width == 0 || this.caretRect.height == 0) && this.container != null) {
            int n;
            Point point;
            Point point2 = WmiViewUtil.offsetForContainer(this.container);
            if (point2 == null) {
                point2 = new Point(0, 0);
            }
            if ((point = this.container.getContainerOffset()) != null) {
                point2.x += point.x;
                point2.y += point.y;
            }
            int n2 = this.uprightTop + point2.x;
            int n3 = this.getTop() + point2.y;
            int n4 = this.uprightBottom + point2.x;
            int n5 = this.getBottom() + point2.y;
            int n6 = Math.min(n2, n4);
            int n7 = Math.max(n2, n4);
            WmiPositionedView wmiPositionedView = this.getView();
            if (wmiPositionedView != null) {
                Point point3 = WmiViewUtil.getRelativeOffset(wmiPositionedView, this.container);
                n = point3.x + point2.x;
                int n8 = n + wmiPositionedView.getWidth();
                n8 = n8 > n4 && n4 > n ? n4 : n8;
                n6 = Math.min(n6, n);
                n7 = Math.max(n7, n8);
            }
            int n9 = n7 - n6 + 1;
            n = n5 - n3 + 1;
            this.caretRect.setBounds(n6, n3, n9, n);
        }
        this.docView.repaint(this.caretRect.x, this.caretRect.y, this.caretRect.width, this.caretRect.height);
    }

    public static void setBoundaryCaret(WmiTraversableView wmiTraversableView, int n) {
        try {
            WmiMathDocumentView wmiMathDocumentView;
            if (n == -1) {
                n = wmiTraversableView.getTraversableCount() - 1;
            }
            if ((wmiMathDocumentView = wmiTraversableView.getDocumentView()) != null) {
                WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(wmiTraversableView);
                Point point = WmiViewUtil.containerRelativeOffset(wmiTraversableView, wmiScrollableContainerView);
                int n2 = 0;
                if (n != 0) {
                    n2 = wmiTraversableView.getWidth();
                }
                WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                boolean bl = false;
                if (!(wmiCaret instanceof WmiMathCaret)) {
                    wmiCaret = new WmiMathCaret(wmiMathDocumentView);
                    bl = true;
                }
                wmiCaret.updateCaretBounds(wmiScrollableContainerView, point.x, point.y, point.x + wmiTraversableView.getWidth(), point.y + wmiTraversableView.getHeight());
                ((WmiMathCaret)wmiCaret).setUprightPosition(point.x + n2, point.x + n2);
                wmiCaret.updateView(wmiTraversableView, n);
                if (bl) {
                    wmiMathDocumentView.setPositionMarker(wmiCaret);
                }
                wmiCaret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public int getUprightBottom() {
        return this.uprightBottom;
    }

    public void setUprightBottom(int n) {
        this.uprightBottom = n;
    }

    public int getUprightTop() {
        return this.uprightTop;
    }

    public void setUprightTop(int n) {
        this.uprightTop = n;
    }

    public void updateCaretBounds(WmiScrollableContainerView wmiScrollableContainerView, int n, int n2, int n3, int n4) {
        super.updateCaretBounds(wmiScrollableContainerView, n, n2, n3, n4);
        this.caretRect = new Rectangle(0, 0, 0, 0);
    }
}

