/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathEncloseModel;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashSet;

public class WmiMathEncloseView
extends WmiMathInlineView {
    private static final String WIDTH_PADDING = "0.4em";
    private static final String HEIGHT_PADDING = "0.5ex";
    private int widthPadding = 0;
    private int heightPadding = 0;
    private HashSet notationList = new HashSet();

    public WmiMathEncloseView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.applyMathRules(true);
        this.lockOperatorSize(false);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        super.draw(graphics, wmiRenderPath, rectangle);
        if (this.notationList.contains("left")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, this.height);
        }
        if (this.notationList.contains("right")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, this.height);
        }
        if (this.notationList.contains("top")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, wmiRenderPath.getVerticalOffset() + 2);
        }
        if (this.notationList.contains("bottom")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + this.height, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, wmiRenderPath.getVerticalOffset() + this.height);
        }
        if (this.notationList.contains("updiagonalstrike")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + this.height - 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + 2);
        }
        if (this.notationList.contains("downdiagonalstrike")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + this.height - 2);
        }
        if (this.notationList.contains("verticalstrike")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width / 2, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width / 2, wmiRenderPath.getVerticalOffset() + this.height - 2);
        }
        if (this.notationList.contains("horizontalstrike")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + this.height / 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + this.height / 2);
        }
        if (this.notationList.contains("box")) {
            graphics.drawRect(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, this.width - 2, wmiRenderPath.getVerticalOffset() + this.height - 4);
        }
        if (this.notationList.contains("roundedbox")) {
            graphics.drawRoundRect(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, this.width - 2, this.height - 4, 6, 6);
        }
        if (this.notationList.contains("circle")) {
            graphics.drawOval(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset(), 0, Math.max(this.width, this.height) - 2, Math.max(this.width, this.height) - 2);
        }
        if (this.notationList.contains("longdiv")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + 2);
            graphics.drawArc(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() - 3, wmiRenderPath.getVerticalOffset() + 2, 4, this.height - 2, 90, -180);
        }
        if (this.notationList.contains("actuarial")) {
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + 2);
            graphics.drawLine(wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + 2, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, wmiRenderPath.getVerticalOffset() + this.height);
        }
        if (this.notationList.contains("radical")) {
            // empty if block
        }
    }

    public void layoutView() throws WmiNoReadAccessException {
        String string = ((WmiMathEncloseModel.WmiMathEncloseAttributeSet)this.getModel().getAttributesForRead()).getNotation();
        if (string != null) {
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.notationList.add(stringArray[i]);
            }
        }
        super.layoutView();
        if (this.notationList.contains("box") || this.notationList.contains("roundedbox") || this.notationList.contains("circle")) {
            this.widthPadding = WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(WIDTH_PADDING, null), (WmiFontAttributeSet)this.getModel().getAttributesForRead(), this.getDocumentView().isPrintView());
            this.heightPadding = WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(HEIGHT_PADDING, null), (WmiFontAttributeSet)this.getModel().getAttributesForRead(), this.getDocumentView().isPrintView());
        } else if (this.notationList.contains("longdiv")) {
            this.widthPadding = 0;
            this.heightPadding = 0;
        } else if (this.notationList.contains("actuarial")) {
            this.widthPadding = 3;
            this.heightPadding = 2;
        } else if (this.notationList.contains("left") || this.notationList.contains("right")) {
            this.widthPadding = 3;
            this.heightPadding = 0;
        } else if (this.notationList.contains("top") || this.notationList.contains("bottom")) {
            this.widthPadding = 0;
            this.heightPadding = 2;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiGenericView wmiGenericView = (WmiGenericView)this.getChild(i);
            wmiGenericView.setHorizontalOffset(wmiGenericView.getHorizontalOffset() + this.widthPadding);
            wmiGenericView.setBaseline(wmiGenericView.getBaseline() + this.heightPadding);
        }
        this.width += this.widthPadding * 2;
        this.height += this.heightPadding * 2;
    }
}

