/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathAlignGroupView;
import com.maplesoft.mathdoc.view.math.WmiMathTableRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableView;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class WmiMathTableCellView
extends WmiParagraphView {
    private static final int CHILD_INDEX = 0;
    private static final boolean DISPLAY_TABLE_BOX = false;
    private Integer verticalAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private Integer horizontalAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private int rowSpan;
    private int columnSpan;
    private int cellBreakWidth;
    private int rowIndex;
    private int columnIndex;
    private ArrayList alignGroupAlignments = new ArrayList();

    public WmiMathTableCellView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        this.layoutView(true);
    }

    public int getLinebreakWidth() {
        return this.cellBreakWidth;
    }

    public void layoutWithAlignment() throws WmiNoReadAccessException {
        WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getParentView();
        WmiMathTableView wmiMathTableView = (WmiMathTableView)wmiMathTableRowView.getParentView();
        ArrayList arrayList = wmiMathTableView.maxAlignGroupWidths[this.columnIndex];
        WmiInlineView wmiInlineView = (WmiInlineView)this.getChild(0);
        int n = 0;
        int n2 = 0;
        WmiMathAlignGroupView wmiMathAlignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findFirstDescendantOfTag(wmiInlineView, WmiModelTag.MATH_ALIGN_GROUP);
        while (wmiMathAlignGroupView != null) {
            int n3;
            ArrayList arrayList2 = wmiMathTableView.alignGroupWidths[this.rowIndex][this.columnIndex];
            ((WmiPositionedView)((Object)wmiMathAlignGroupView.getParentView())).setHorizontalOffset(0);
            int n4 = (Integer)arrayList.get(n2 * 2);
            int n5 = (Integer)arrayList.get(n2 * 2 + 1);
            int n6 = n4 - (Integer)arrayList2.get(n2 * 2);
            WmiCompositeView wmiCompositeView = wmiMathAlignGroupView.getParentView().getParentView();
            if (wmiCompositeView instanceof WmiPositionedView) {
                ((WmiPositionedView)((Object)wmiCompositeView)).setHorizontalOffset(0);
            }
            WmiPositionedView wmiPositionedView = (WmiPositionedView)WmiViewUtil.findNextSibling(wmiMathAlignGroupView);
            wmiPositionedView.setHorizontalOffset(n + n6);
            n6 += wmiPositionedView.getWidth();
            for (int i = n3 = wmiCompositeView.indexOf(wmiMathAlignGroupView.getParentView()) + 1; i < wmiCompositeView.getChildCount() && WmiViewUtil.findFirstDescendantOfTag(wmiPositionedView = (WmiPositionedView)wmiCompositeView.getChild(i), WmiModelTag.MATH_ALIGN_GROUP) == null; ++i) {
                wmiPositionedView.setHorizontalOffset(n + n6);
                n6 += wmiPositionedView.getWidth();
            }
            n += n4 + n5;
            ++n2;
            wmiMathAlignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(wmiInlineView, wmiMathAlignGroupView, WmiModelTag.MATH_ALIGN_GROUP);
        }
    }

    public void layoutView(boolean bl) throws WmiNoReadAccessException {
        this.layoutView(bl, false);
    }

    public void layoutView(boolean bl, boolean bl2) throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            int n;
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)this.getModel().getAttributesForRead();
            this.getRowAlignment(wmiMathTableDataAttributeSet);
            this.getColumnAlignment(wmiMathTableDataAttributeSet);
            this.getRowSpan(wmiMathTableDataAttributeSet);
            this.getColumnSpan(wmiMathTableDataAttributeSet);
            this.getAlignGroupAlignments(wmiMathTableDataAttributeSet);
            WmiMathTableView wmiMathTableView = this.getTableView();
            int n2 = 0;
            if (wmiMathTableView != null) {
                for (n = this.columnIndex; n < this.columnIndex + this.columnSpan; ++n) {
                    n2 += wmiMathTableView.getMaximumColumnWidth(n);
                }
            } else {
                n2 = Integer.MAX_VALUE;
            }
            this.cellBreakWidth = n2 > 0 && bl ? n2 : Integer.MAX_VALUE;
            super.layoutView();
            this.width = 0;
            n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(i);
                if (wmiPositionedView.getWidth() <= this.width) continue;
                this.width = wmiPositionedView.getWidth();
            }
            this.adjustAlignment(this.width);
            if (n == 1 && bl2 && this.findAlignmentElement() != null) {
                this.layoutWithAlignment();
                this.width = wmiMathTableView.getMaximumColumnWidth(this.columnIndex);
            }
            if (wmiMathTableView != null) {
                wmiMathTableView.cellHeights[this.rowIndex][this.columnIndex] = this.height;
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    private WmiView findAlignmentElement() {
        return WmiViewUtil.findFirstDescendantOfTag(this, WmiModelTag.MATH_ALIGN_GROUP);
    }

    private WmiMathTableView getTableView() {
        WmiCompositeView wmiCompositeView = this.getParentView();
        WmiCompositeView wmiCompositeView2 = wmiCompositeView != null ? wmiCompositeView.getParentView() : null;
        return wmiCompositeView2 instanceof WmiMathTableView ? (WmiMathTableView)wmiCompositeView2 : null;
    }

    private WmiMathTableRowView getRowView() {
        WmiCompositeView wmiCompositeView = this.getParentView();
        return wmiCompositeView instanceof WmiMathTableRowView ? (WmiMathTableRowView)wmiCompositeView : null;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        WmiMathTableRowView wmiMathTableRowView = this.getRowView();
        WmiMathTableView wmiMathTableView = this.getTableView();
        if (wmiMathTableView != null && wmiMathTableView.drawOverlappedLabel() && wmiMathTableRowView != null && !wmiMathTableRowView.isLabelRow() && (wmiMathTableView.getSide() == WmiMathTableView.LEFT_OVERLAP_SIDE && wmiMathTableRowView.indexOf(this) == 0 || wmiMathTableView.getSide() == WmiMathTableView.RIGHT_OVERLAP_SIDE && wmiMathTableRowView.indexOf(this) == wmiMathTableRowView.getChildCount() - 1)) {
            return;
        }
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public void setLinebreakWidth(int n) {
        this.cellBreakWidth = n;
    }

    public Integer getVerticalAlignment() {
        return this.verticalAlignment;
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
        String string;
        String string2 = string = wmiMathTableDataAttributeSet.getRowAlign() != null ? wmiMathTableDataAttributeSet.getRowAlign() : "";
        if (string.equals("top")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_TOP;
        } else if (string.equals("bottom")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_BOTTOM;
        } else if (string.equals("center") || string.equals("baseline")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
        } else if (string.equals("axis")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_AXIS;
        }
    }

    public Integer getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
        WmiMathTableView wmiMathTableView;
        String string = wmiMathTableDataAttributeSet.getColumnAlign() != null ? wmiMathTableDataAttributeSet.getColumnAlign() : "";
        WmiMathTableRowView wmiMathTableRowView = this.getRowView();
        if (string.equals("left")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_LEFT;
        } else if (string.equals("right")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_RIGHT;
        } else if (string.equals("center")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
        } else if (wmiMathTableRowView != null && wmiMathTableRowView.isLabelRow() && (wmiMathTableView = this.getTableView()) != null) {
            this.horizontalAlignment = wmiMathTableView.getSide() == WmiMathTableView.LEFT_OVERLAP_SIDE ? WmiMathTableView.ALIGN_STYLE_LEFT : WmiMathTableView.ALIGN_STYLE_RIGHT;
        }
    }

    private void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
        String string = wmiMathTableDataAttributeSet.getGroupAlign() != null ? wmiMathTableDataAttributeSet.getGroupAlign() : "";
        String[] stringArray = string.split(" ");
        for (int i = 0; i <= this.getChildCount(); ++i) {
            if (i >= stringArray.length || stringArray[i].trim().equals("")) continue;
            String[] stringArray2 = stringArray[i].split(" ");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("left")) {
                    this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_LEFT);
                    continue;
                }
                if (stringArray2[j].equals("right")) {
                    this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_RIGHT);
                    continue;
                }
                if (stringArray2[j].equals("center")) {
                    this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_CENTER);
                    continue;
                }
                this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_DECIMALPOINT);
            }
        }
    }

    public ArrayList getAlignmentGroupAlignments() {
        return this.alignGroupAlignments;
    }

    public void setCellIndex(int n, int n2) {
        if (n != this.rowIndex || n2 != this.columnIndex) {
            this.rowIndex = n;
            this.columnIndex = n2;
            this.markInvalid(1);
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void adjustVerticalAlignment(WmiMathTableView wmiMathTableView, WmiMathTableRowView wmiMathTableRowView) {
        boolean bl = false;
        int n = wmiMathTableView.indexOf(wmiMathTableRowView);
        int n2 = wmiMathTableView.getMaximumRowHeight(n);
        int n3 = wmiMathTableView.getColumnIndex(n, wmiMathTableRowView.indexOf(this));
        if (++n < wmiMathTableView.getChildCount()) {
            while (n < wmiMathTableView.getChildCount() && wmiMathTableView.getCellHeight(n, n3) == 0) {
                bl = true;
                n2 += wmiMathTableView.getMaximumRowHeight(n);
                n2 += wmiMathTableView.getRowSpacing(n - 1);
                ++n;
            }
        }
        if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_TOP) {
            this.setVerticalOffset(0);
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_BOTTOM) {
            if (bl) {
                this.setVerticalOffset(n2 - this.getHeight());
            } else {
                this.setVerticalOffset(wmiMathTableRowView.getMaxHeight() - this.getHeight());
            }
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_CENTER && !bl) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            if (wmiPositionedView.getBaseline() < wmiMathTableRowView.getMaxBaseline()) {
                this.setVerticalOffset(wmiMathTableRowView.getMaxBaseline() - this.getHeight());
            }
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_AXIS || bl) {
            if (bl) {
                this.setVerticalOffset((n2 - this.getHeight()) / 2);
            } else {
                this.setVerticalOffset((wmiMathTableRowView.getMaxHeight() - this.getHeight()) / 2);
            }
        }
    }

    private void getRowSpan(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
        this.rowSpan = wmiMathTableDataAttributeSet.getRowSpan() != null ? wmiMathTableDataAttributeSet.getRowSpan() : 1;
    }

    public int getRowSpan() {
        if (this.rowSpan > 0) {
            return this.rowSpan;
        }
        try {
            WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = (WmiMathTableModel.WmiMathTableDataModel)this.getModel();
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)wmiMathTableDataModel.getAttributesForRead();
            this.getRowSpan(wmiMathTableDataAttributeSet);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return this.rowSpan;
    }

    private void getColumnSpan(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
        this.columnSpan = wmiMathTableDataAttributeSet.getColumnSpan() != null ? wmiMathTableDataAttributeSet.getColumnSpan() : 1;
    }

    public int getColumnSpan() {
        if (this.columnSpan > 0) {
            return this.columnSpan;
        }
        try {
            WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = (WmiMathTableModel.WmiMathTableDataModel)this.getModel();
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)wmiMathTableDataModel.getAttributesForRead();
            this.getColumnSpan(wmiMathTableDataAttributeSet);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return this.columnSpan;
    }
}

