/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;
import java.util.ArrayList;

public class WmiMultiscriptView
extends WmiTraversableCompositeMathView {
    private static final int BASE_INDEX = 0;
    private static final int SUB_SUP_OR_PRE_INDEX = 1;
    private static final int PRE_SUPERSCRIPTS_INDEX = 0;
    private static final int PRE_SUBSCRIPTS_INDEX = 1;
    private static final int POST_SUPERSCRIPTS_INDEX = 2;
    private static final int POST_SUBSCRIPTS_INDEX = 3;
    private ArrayList[] positions = new ArrayList[4];
    private int hoffset = 0;
    private int greatestSubscriptHeight = 0;
    private boolean allScriptsFilled = false;

    public WmiMultiscriptView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            this.hoffset = 0;
            this.greatestSubscriptHeight = 0;
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = new ArrayList();
            }
            WmiFontMetrics wmiFontMetrics = WmiViewUtil.getFontMetrics(this);
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            if (!wmiPositionedView.isLayoutValid()) {
                wmiPositionedView.layoutView();
            }
            this.populatePositionArrays();
            int n = Math.max(this.getLargestBaseline(this.positions[0]), this.getLargestBaseline(this.positions[2]));
            int n2 = Math.max(this.getLargestVOffs(this, wmiPositionedView, this.positions[0], wmiFontMetrics), this.getLargestVOffs(this, wmiPositionedView, this.positions[2], wmiFontMetrics));
            int n3 = Math.max(this.getLargestSubscriptOffset(wmiPositionedView, wmiFontMetrics, this.positions[1]), this.getLargestSubscriptOffset(wmiPositionedView, wmiFontMetrics, this.positions[3]));
            wmiPositionedView.setVerticalOffset(n2);
            this.layoutSideOfMultiscript(this.positions[1], this.positions[0], true, n3 += n2, n);
            wmiPositionedView.setHorizontalOffset(this.hoffset);
            this.hoffset += wmiPositionedView.getWidth();
            if (this.positions[2] != null && this.positions[2].size() > 0) {
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.positions[2].get(0);
                if (wmiPositionedView2 instanceof WmiTextView) {
                    this.hoffset += ((WmiTextView)wmiPositionedView2).computePreKernAdjustment();
                }
                if (wmiPositionedView instanceof WmiTextView) {
                    this.hoffset += ((WmiTextView)wmiPositionedView).computePostKernAdjustment();
                }
            }
            this.layoutSideOfMultiscript(this.positions[3], this.positions[2], false, n3, n);
            this.width = this.hoffset;
            this.baseline = n2 + wmiPositionedView.getBaseline();
            this.height = n3 + this.greatestSubscriptHeight;
            this.addNavigationLinks();
        }
    }

    private int getLargestVOffs(WmiView wmiView, WmiPositionedView wmiPositionedView, ArrayList arrayList, WmiFontMetrics wmiFontMetrics) throws WmiNoReadAccessException {
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = WmiSuperscriptView.getBaseVOffset(wmiView, wmiPositionedView, (WmiPositionedView)arrayList.get(i), wmiFontMetrics);
            n = n > n3 ? n : n3;
        }
        return n;
    }

    private void populatePositionArrays() throws WmiNoReadAccessException {
        int n = this.getChildCount();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 1; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (wmiView instanceof WmiPositionedView && !wmiView.isLayoutValid()) {
                ((WmiPositionedView)wmiView).layoutView();
            }
            if (wmiView instanceof WmiPrescriptMarkerView) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (bl) {
                if (bl2) {
                    this.positions[1].add(wmiView);
                } else {
                    this.positions[0].add(wmiView);
                }
            } else if (bl2) {
                this.positions[3].add(wmiView);
            } else {
                this.positions[2].add(wmiView);
            }
            bl2 = !bl2;
        }
    }

    private void layoutSideOfMultiscript(ArrayList arrayList, ArrayList arrayList2, boolean bl, int n, int n2) {
        int n3 = Math.min(arrayList.size(), arrayList2.size());
        int n4 = bl ? -1 : 1;
        int n5 = bl ? n3 - 1 : 0;
        WmiPositionedView wmiPositionedView = null;
        WmiPositionedView wmiPositionedView2 = null;
        for (int i = n5; i > -1 && i < n3; i += n4) {
            wmiPositionedView = (WmiPositionedView)arrayList.get(i);
            wmiPositionedView2 = (WmiPositionedView)arrayList2.get(i);
            wmiPositionedView.setHorizontalOffset(this.hoffset);
            wmiPositionedView.setVerticalOffset(n);
            this.greatestSubscriptHeight = Math.max(wmiPositionedView.getHeight(), this.greatestSubscriptHeight);
            wmiPositionedView2.setHorizontalOffset(this.hoffset);
            wmiPositionedView2.setVerticalOffset(n2 - wmiPositionedView2.getBaseline());
            this.hoffset += Math.max(wmiPositionedView.getWidth(), wmiPositionedView2.getWidth());
        }
        if (bl && wmiPositionedView != null) {
            WmiPositionedView wmiPositionedView3 = (WmiPositionedView)this.getChild(0);
            if (wmiPositionedView instanceof WmiTextView) {
                this.hoffset += ((WmiTextView)wmiPositionedView).computePostKernAdjustment();
            }
            if (wmiPositionedView3 instanceof WmiTextView) {
                this.hoffset += ((WmiTextView)wmiPositionedView3).computePreKernAdjustment();
            }
        }
    }

    private int getLargestBaseline(ArrayList arrayList) {
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = ((WmiPositionedView)arrayList.get(i)).getBaseline();
            n = n > n3 ? n : n3;
        }
        return n;
    }

    private int getLargestSubscriptOffset(WmiPositionedView wmiPositionedView, WmiFontMetrics wmiFontMetrics, ArrayList arrayList) throws WmiNoReadAccessException {
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)arrayList.get(i);
            int n3 = WmiSubscriptView.getSubscriptVOffset(this, wmiPositionedView, wmiPositionedView2, wmiFontMetrics);
            n = n > n3 ? n : n3;
        }
        return n;
    }

    public void addNavigationLinks() {
        WmiMScriptNavLinkBuilder wmiMScriptNavLinkBuilder = new WmiMScriptNavLinkBuilder(this);
        wmiMScriptNavLinkBuilder.createNavigationLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMainEntryPoint(WmiPositionedView wmiPositionedView, int n) {
        boolean bl = WmiModelLock.readLock(wmiPositionedView.getModel(), false);
        try {
            if (wmiPositionedView instanceof WmiTextView && ((WmiTextView)wmiPositionedView).getLength() == 0) {
                this.setNextView(null, n);
            } else {
                this.setNextView(wmiPositionedView, n);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            this.setNextView(null, n);
        }
        finally {
            if (bl) {
                WmiModelLock.readUnlock(wmiPositionedView.getModel());
            }
        }
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            return this.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    public WmiPositionedView getNextView(int n) {
        if (this.allScriptsFilled) {
            WmiPositionedView wmiPositionedView;
            WmiCaret wmiCaret = this.getDocumentView().getCaret();
            WmiPositionedView wmiPositionedView2 = wmiCaret.getView();
            int n2 = wmiCaret.getOffset();
            if ((wmiPositionedView2 != this && n == 0 || n == 1) && ((wmiPositionedView = (WmiPositionedView)this.getChild(0)) == wmiPositionedView2 || WmiViewUtil.isViewAncestorOfView(wmiPositionedView, wmiPositionedView2))) {
                int n3;
                int n4 = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)wmiPositionedView).x;
                int n5 = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)wmiPositionedView2).x;
                if (wmiPositionedView2 instanceof WmiTextView) {
                    n5 += ((WmiTextView)wmiPositionedView2).getHorizontalOffset(n2);
                }
                if ((n3 = n5 - n4) <= wmiPositionedView.getWidth() / 2) {
                    if (n == 1) {
                        return (WmiPositionedView)this.getChild(4);
                    }
                    if (n == 0) {
                        return (WmiPositionedView)this.getChild(5);
                    }
                } else {
                    if (n == 1) {
                        return (WmiPositionedView)this.getChild(1);
                    }
                    if (n == 0) {
                        return (WmiPositionedView)this.getChild(2);
                    }
                }
            }
        }
        return super.getNextView(n);
    }

    private static class WmiMScriptNavLinkBuilder {
        private WmiMultiscriptView mscript;

        private WmiMScriptNavLinkBuilder(WmiMultiscriptView wmiMultiscriptView) {
            this.mscript = wmiMultiscriptView;
        }

        private void createNavigationLinks() {
            boolean bl = false;
            int n = this.getPrescriptMarkverViewIndex();
            int n2 = this.mscript.getChildCount();
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.mscript.getChild(0);
            WmiPositionedView[] wmiPositionedViewArray = new WmiPositionedView[]{};
            WmiPositionedView[] wmiPositionedViewArray2 = new WmiPositionedView[]{};
            if (n < 0) {
                wmiPositionedViewArray = this.createSubChildren(1, n2 - 1);
            } else {
                wmiPositionedViewArray = this.createSubChildren(1, n - 1);
                wmiPositionedViewArray2 = this.createSubChildren(n + 1, n2 - n - 1);
            }
            WmiPositionedView[] wmiPositionedViewArray3 = this.getTopBottomArray(wmiPositionedViewArray, true);
            WmiPositionedView[] wmiPositionedViewArray4 = this.getTopBottomArray(wmiPositionedViewArray, false);
            WmiPositionedView[] wmiPositionedViewArray5 = this.getTopBottomArray(wmiPositionedViewArray2, true);
            WmiPositionedView[] wmiPositionedViewArray6 = this.getTopBottomArray(wmiPositionedViewArray2, false);
            if (wmiPositionedViewArray.length > 0) {
                this.buildPostNavigationLinks(wmiPositionedView, wmiPositionedViewArray3, wmiPositionedViewArray4);
                wmiPositionedView.setNextView(this.getNextAppropriateView(wmiPositionedViewArray3, wmiPositionedViewArray4, -1, true), 3);
            } else {
                wmiPositionedView.setNextView(null, 3);
            }
            if (wmiPositionedViewArray2.length > 0) {
                this.buildPreNavigationLinks(wmiPositionedView, wmiPositionedViewArray5, wmiPositionedViewArray6);
                wmiPositionedView.setNextView(this.getNextAppropriateView(wmiPositionedViewArray5, wmiPositionedViewArray6, -1, true), 2);
            } else {
                wmiPositionedView.setNextView(null, 2);
            }
            if (wmiPositionedViewArray.length > 0 && wmiPositionedViewArray2.length > 0) {
                if (wmiPositionedViewArray5[0].isNavagableView() && wmiPositionedViewArray3[0].isNavagableView()) {
                    wmiPositionedView.setNextView(null, 0);
                } else if (wmiPositionedViewArray5[0].isNavagableView()) {
                    wmiPositionedView.setNextView(wmiPositionedViewArray5[0], 0);
                } else if (wmiPositionedViewArray3[0].isNavagableView()) {
                    wmiPositionedView.setNextView(wmiPositionedViewArray3[0], 0);
                } else {
                    wmiPositionedView.setNextView(null, 0);
                }
                if (wmiPositionedViewArray6[0].isNavagableView() && wmiPositionedViewArray4[0].isNavagableView()) {
                    wmiPositionedView.setNextView(null, 0);
                } else if (wmiPositionedViewArray6[0].isNavagableView()) {
                    wmiPositionedView.setNextView(wmiPositionedViewArray6[0], 0);
                } else if (wmiPositionedViewArray4[0].isNavagableView()) {
                    wmiPositionedView.setNextView(wmiPositionedViewArray4[0], 0);
                } else {
                    wmiPositionedView.setNextView(null, 0);
                }
            } else if (wmiPositionedViewArray.length > 0) {
                wmiPositionedView.setNextView(wmiPositionedViewArray3[0], 0);
                wmiPositionedView.setNextView(wmiPositionedViewArray4[0], 1);
            } else if (wmiPositionedViewArray2.length > 0) {
                wmiPositionedView.setNextView(wmiPositionedViewArray5[0], 0);
                wmiPositionedView.setNextView(wmiPositionedViewArray6[0], 1);
            } else {
                wmiPositionedView.setNextView(null, 0);
                wmiPositionedView.setNextView(null, 1);
            }
            this.mscript.setNextView(this.getEntryPoint(wmiPositionedView, wmiPositionedViewArray5, wmiPositionedViewArray6), -4);
            this.mscript.setNextView(this.getEntryPoint(wmiPositionedView, wmiPositionedViewArray3, wmiPositionedViewArray4), -3);
            if (this.hasNavagableView(wmiPositionedViewArray5) && this.hasNavagableView(wmiPositionedViewArray3)) {
                this.mscript.setNextView(null, -2);
            } else {
                this.mscript.setNextView(wmiPositionedView, -2);
            }
            if (this.hasNavagableView(wmiPositionedViewArray6) && this.hasNavagableView(wmiPositionedViewArray4)) {
                this.mscript.setNextView(null, -2);
            } else {
                this.mscript.setNextView(wmiPositionedView, -2);
            }
        }

        private void buildPostNavigationLinks(WmiPositionedView wmiPositionedView, WmiPositionedView[] wmiPositionedViewArray, WmiPositionedView[] wmiPositionedViewArray2) {
            if (wmiPositionedViewArray.length == wmiPositionedViewArray2.length) {
                boolean bl = false;
                for (int i = 0; i < wmiPositionedViewArray.length; ++i) {
                    wmiPositionedViewArray[i].setNextView(wmiPositionedViewArray2[i], 1);
                    wmiPositionedViewArray2[i].setNextView(wmiPositionedViewArray[i], 0);
                    wmiPositionedViewArray[i].setNextView(this.getNextAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, true), 3);
                    wmiPositionedViewArray2[i].setNextView(this.getNextAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, false), 3);
                    if (!bl && (wmiPositionedViewArray[i].isNavagableView() || wmiPositionedViewArray2[i].isNavagableView())) {
                        wmiPositionedViewArray[i].setNextView(wmiPositionedView, 2);
                        wmiPositionedViewArray2[i].setNextView(wmiPositionedView, 2);
                        bl = true;
                        continue;
                    }
                    wmiPositionedViewArray[i].setNextView(this.getPreviousAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, true), 2);
                    wmiPositionedViewArray2[i].setNextView(this.getPreviousAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, false), 2);
                }
            }
        }

        private void buildPreNavigationLinks(WmiPositionedView wmiPositionedView, WmiPositionedView[] wmiPositionedViewArray, WmiPositionedView[] wmiPositionedViewArray2) {
            if (wmiPositionedViewArray.length == wmiPositionedViewArray2.length) {
                boolean bl = false;
                for (int i = 0; i < wmiPositionedViewArray.length; ++i) {
                    wmiPositionedViewArray[i].setNextView(wmiPositionedViewArray2[i], 1);
                    wmiPositionedViewArray2[i].setNextView(wmiPositionedViewArray[i], 0);
                    wmiPositionedViewArray[i].setNextView(this.getNextAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, true), 2);
                    wmiPositionedViewArray2[i].setNextView(this.getNextAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, false), 2);
                    if (!bl && (wmiPositionedViewArray[i].isNavagableView() || wmiPositionedViewArray2[i].isNavagableView())) {
                        wmiPositionedViewArray[i].setNextView(wmiPositionedView, 3);
                        wmiPositionedViewArray2[i].setNextView(wmiPositionedView, 3);
                        bl = true;
                        continue;
                    }
                    wmiPositionedViewArray[i].setNextView(this.getPreviousAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, true), 3);
                    wmiPositionedViewArray2[i].setNextView(this.getPreviousAppropriateView(wmiPositionedViewArray, wmiPositionedViewArray2, i, false), 3);
                }
            }
        }

        private WmiPositionedView getNextAppropriateView(WmiPositionedView[] wmiPositionedViewArray, WmiPositionedView[] wmiPositionedViewArray2, int n, boolean bl) {
            int n2;
            WmiPositionedView wmiPositionedView = null;
            if (wmiPositionedViewArray.length != wmiPositionedViewArray2.length) {
                return wmiPositionedView;
            }
            for (int i = n2 = n + 1; i < wmiPositionedViewArray.length; ++i) {
                WmiPositionedView wmiPositionedView2 = wmiPositionedViewArray[i];
                WmiPositionedView wmiPositionedView3 = wmiPositionedViewArray2[i];
                if (bl) {
                    if (wmiPositionedView2.isNavagableView()) {
                        wmiPositionedView = wmiPositionedView2;
                        break;
                    }
                    if (!wmiPositionedView3.isNavagableView()) continue;
                    wmiPositionedView = wmiPositionedView3;
                    break;
                }
                if (wmiPositionedView3.isNavagableView()) {
                    wmiPositionedView = wmiPositionedView3;
                    break;
                }
                if (!wmiPositionedView2.isNavagableView()) continue;
                wmiPositionedView = wmiPositionedView2;
                break;
            }
            return wmiPositionedView;
        }

        private boolean hasNavagableView(WmiPositionedView[] wmiPositionedViewArray) {
            for (int i = 0; i < wmiPositionedViewArray.length; ++i) {
                if (!wmiPositionedViewArray[i].isNavagableView()) continue;
                return true;
            }
            return false;
        }

        private WmiPositionedView getEntryPoint(WmiPositionedView wmiPositionedView, WmiPositionedView[] wmiPositionedViewArray, WmiPositionedView[] wmiPositionedViewArray2) {
            int n;
            WmiPositionedView wmiPositionedView2 = wmiPositionedView;
            if (wmiPositionedViewArray.length != wmiPositionedViewArray2.length) {
                return wmiPositionedView2;
            }
            for (int i = n = wmiPositionedViewArray.length - 1; i >= 0; --i) {
                WmiPositionedView wmiPositionedView3 = wmiPositionedViewArray[i];
                WmiPositionedView wmiPositionedView4 = wmiPositionedViewArray2[i];
                if (wmiPositionedView3.isNavagableView()) {
                    wmiPositionedView2 = wmiPositionedView3;
                    break;
                }
                if (!wmiPositionedView4.isNavagableView()) continue;
                wmiPositionedView2 = wmiPositionedView4;
                break;
            }
            return wmiPositionedView2;
        }

        private int getPrescriptMarkverViewIndex() {
            for (int i = 0; i < this.mscript.children.length; ++i) {
                if (!(this.mscript.children[i] instanceof WmiPrescriptMarkerView)) continue;
                return i;
            }
            return -1;
        }

        private WmiPositionedView getPreviousAppropriateView(WmiPositionedView[] wmiPositionedViewArray, WmiPositionedView[] wmiPositionedViewArray2, int n, boolean bl) {
            int n2;
            WmiPositionedView wmiPositionedView = null;
            if (wmiPositionedViewArray.length != wmiPositionedViewArray2.length) {
                return wmiPositionedView;
            }
            for (int i = n2 = n - 1; i >= 0; --i) {
                WmiPositionedView wmiPositionedView2 = wmiPositionedViewArray[i];
                WmiPositionedView wmiPositionedView3 = wmiPositionedViewArray2[i];
                if (bl) {
                    if (wmiPositionedView2.isNavagableView()) {
                        wmiPositionedView = wmiPositionedView2;
                        break;
                    }
                    if (!wmiPositionedView3.isNavagableView()) continue;
                    wmiPositionedView = wmiPositionedView3;
                    break;
                }
                if (wmiPositionedView3.isNavagableView()) {
                    wmiPositionedView = wmiPositionedView3;
                    break;
                }
                if (!wmiPositionedView2.isNavagableView()) continue;
                wmiPositionedView = wmiPositionedView2;
                break;
            }
            return wmiPositionedView;
        }

        private WmiPositionedView[] createSubChildren(int n, int n2) {
            WmiPositionedView[] wmiPositionedViewArray = new WmiPositionedView[n2];
            for (int i = 0; i < n2; ++i) {
                wmiPositionedViewArray[i] = (WmiPositionedView)this.mscript.children[n + i];
            }
            return wmiPositionedViewArray;
        }

        private WmiPositionedView[] getTopBottomArray(WmiPositionedView[] wmiPositionedViewArray, boolean bl) {
            WmiPositionedView[] wmiPositionedViewArray2 = new WmiPositionedView[wmiPositionedViewArray.length / 2];
            int n = bl ? 1 : 0;
            int n2 = 0;
            while (n2 < wmiPositionedViewArray2.length) {
                wmiPositionedViewArray2[n2] = wmiPositionedViewArray[n];
                ++n2;
                n += 2;
            }
            return wmiPositionedViewArray2;
        }
    }

    public static class WmiNoneMarkerView
    extends WmiGenericView {
        public WmiNoneMarkerView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
        }

        public boolean isNavagableView() {
            return false;
        }
    }

    public static class WmiPrescriptMarkerView
    extends WmiGenericView {
        public WmiPrescriptMarkerView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
        }

        public boolean isNavagableView() {
            return false;
        }
    }
}

