/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiSquareRootRenderer;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class WmiRootView
extends WmiTraversableCompositeMathView {
    protected static final boolean SQUARE_ROOT_UNDERLINE_ENABLED = true;
    public static final int RADICAND_INDEX = 0;
    public static final int NTH_INDEX = 1;
    public static final int SURD_MODEL_SIZE = 2;
    private static final WmiSquareRootRenderer renderer = new WmiSquareRootRenderer();
    private WmiSquareRootSignView rootSignView = null;

    public WmiRootView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            boolean bl = this.getChildCount() > 1;
            WmiModel wmiModel = this.getModel();
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            wmiPositionedView.layoutView();
            this.rootSignView = new WmiSquareRootSignView(this.getModel(), this.getDocumentView());
            this.rootSignView.layoutView();
            WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiModel.getAttributesForRead();
            boolean bl2 = this.getDocumentView().isPrintView();
            int n = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(wmiFontAttributeSet, n, bl2);
            int n2 = wmiPositionedView.getWidth();
            int n3 = wmiPositionedView.getHeight();
            this.rootSignView.createGlyph(font, n3, n2);
            int n4 = this.rootSignView.getLeadWidth();
            int n5 = this.rootSignView.getHeight();
            int n6 = this.rootSignView.getWidth();
            int n7 = 0;
            int n8 = 0;
            if (bl) {
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
                wmiPositionedView2.layoutView();
                int n9 = wmiPositionedView2.getWidth();
                int n10 = wmiPositionedView2.getHeight();
                n7 = Math.round((float)n9 - 0.4f * (float)n4);
                if (n7 < 0) {
                    wmiPositionedView2.setHorizontalOffset(-n7);
                    n7 = 0;
                } else {
                    wmiPositionedView2.setHorizontalOffset(0);
                }
                n8 = Math.round((float)n10 - 0.5f * (float)n5);
                if (n8 < 0) {
                    wmiPositionedView2.setVerticalOffset(-n8);
                    n8 = 0;
                } else {
                    wmiPositionedView2.setVerticalOffset(0);
                }
            }
            this.rootSignView.setHorizontalOffset(n7);
            this.rootSignView.setVerticalOffset(n8);
            wmiPositionedView.setHorizontalOffset(n7 + n4 + (n6 - n4 - n2) / 2);
            wmiPositionedView.setVerticalOffset(n8 + n5 - n3);
            this.height = n8 + n5;
            this.width = n7 + n6;
            this.baseline = wmiPositionedView.getBaseline() + wmiPositionedView.getVerticalOffset();
            this.addNavigationLinks();
            super.layoutView();
        }
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int n = this.getZoomFactor();
        boolean bl = false;
        WmiModel wmiModel = this.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        while (wmiCompositeModel instanceof WmiMathModel) {
            bl = ((WmiMathModel)((Object)wmiCompositeModel)).useScriptSize(wmiModel);
            if (bl) {
                n = Math.round((float)n * 0.8f);
                break;
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return n;
    }

    public void addNavigationLinks() {
        WmiPositionedView wmiPositionedView;
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView3 = wmiPositionedView = this.getChildCount() > 1 ? (WmiPositionedView)this.getChild(1) : null;
        if (wmiPositionedView != null) {
            wmiPositionedView.setNextView(wmiPositionedView2, 3);
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(wmiPositionedView, -4);
            this.setNextView(wmiPositionedView2, -3);
        } else {
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(wmiPositionedView2, -4);
            this.setNextView(wmiPositionedView2, -3);
        }
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return super.getNearestChildView(point);
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            return this.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        if (this.rootSignView != null) {
            wmiRenderPath.push(this.getHorizontalOffset(), this.getVerticalOffset());
            this.rootSignView.draw(graphics, wmiRenderPath, rectangle);
            wmiRenderPath.pop();
        }
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        if (n3 > 0) {
            if (!wmiParagraphView.isStartOfLine(this) && this.getWidth() < n2) {
                WmiCompositeView wmiCompositeView = this.getParentView();
                int n5 = wmiCompositeView.indexOf(this);
                if (n5 >= 0) {
                    wmiParagraphView.split(wmiCompositeView, n5, 0);
                    n4 = 2;
                }
            } else {
                WmiSuperscriptView wmiSuperscriptView = this.convertToPower();
                if (wmiSuperscriptView != null) {
                    n4 = 1;
                }
            }
        }
        return n4;
    }

    private WmiSuperscriptView convertToPower() throws WmiNoReadAccessException {
        WmiSuperscriptView wmiSuperscriptView = null;
        WmiModel wmiModel = this.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
        WmiAttributeSet wmiAttributeSet = wmiCompositeModel != null ? wmiCompositeModel.getAttributesForRead() : null;
        String string = wmiAttributeSet != null ? (String)wmiAttributeSet.getAttribute("font_style_name") : null;
        WmiMathContext wmiMathContext = new WmiMathContext(wmiMathDocumentModel.getFontStyle(string));
        WmiCompositeView wmiCompositeView = this.getParentView();
        int n = wmiCompositeView.indexOf(this);
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        if (WmiRootView.areBracketsRequired(wmiPositionedView.getModel())) {
            wmiPositionedView = WmiRootView.addBrackets(wmiPositionedView);
        }
        WmiInlineView wmiInlineView = null;
        boolean bl = this.getChildCount() == 2;
        WmiMathModel wmiMathModel = bl ? (WmiMathModel)this.getChild(1).getModel() : WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "2", wmiMathContext);
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "1", wmiMathContext);
        WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "/", wmiMathContext);
        WmiModel[] wmiModelArray = new WmiMathModel[]{wmiMathTokenModel, wmiMathTokenModel2, wmiMathModel};
        WmiInlineMathModel wmiInlineMathModel = WmiInlineMathModel.createLinebreakingMathRow(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
        try {
            wmiMathTokenModel.setParent(wmiInlineMathModel);
            if (!bl) {
                wmiMathModel.setParent(wmiInlineMathModel);
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        wmiInlineView = new WmiInlineView(wmiInlineMathModel, wmiMathDocumentView);
        wmiInlineView.appendView(new WmiMathTextView(wmiMathTokenModel, wmiMathDocumentView));
        wmiInlineView.appendView(new WmiMathTextView(wmiMathTokenModel2, wmiMathDocumentView));
        if (bl) {
            wmiInlineView.appendView(this.getChild(1));
        } else {
            wmiInlineView.appendView(new WmiMathTextView(wmiMathModel, wmiMathDocumentView));
        }
        WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel);
        try {
            wmiInlineMathModel.setParent(wmiSuperscriptModel);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        wmiSuperscriptView = new WmiSuperscriptView(wmiSuperscriptModel, wmiMathDocumentView);
        wmiSuperscriptView.appendView(wmiPositionedView);
        wmiSuperscriptView.appendView(wmiInlineView);
        wmiSuperscriptView.layoutView();
        wmiCompositeView.replaceChild(wmiSuperscriptView, n);
        wmiSuperscriptView.setParentView(wmiCompositeView);
        return wmiSuperscriptView;
    }

    public static boolean areBracketsRequired(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModel instanceof WmiCompositeModel) {
            if (wmiModel.getTag() == WmiModelTag.MATH_ROW) {
                int n = ((WmiCompositeModel)wmiModel).getChildCount();
                if (n == 1) {
                    bl = WmiRootView.areBracketsRequired(((WmiCompositeModel)wmiModel).getChild(0));
                } else if (n > 1) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public static class WmiSquareRootSignView
    extends WmiGenericView
    implements WmiPositionedView {
        private static final float HEIGHT_SCALE_FACTOR = 4.0f;
        private static final float WIDTH_SCALE_FACTOR = 0.5f;
        private static final float ROOT_TOP_WIDTH_SCALE = 0.055f;
        private WmiFontAttributeSet attributes = null;
        private Color drawColor = null;
        private WmiGlyphRenderer.RenderedGlyph glyph;
        private Rectangle2D.Float topLine;
        private int vPadding;

        public WmiSquareRootSignView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
        }

        protected int getLeadWidth() {
            int n = 0;
            if (this.glyph != null) {
                Rectangle2D.Float float_ = this.glyph.getBounds();
                n = Math.round(float_.width);
            }
            return n;
        }

        protected void createGlyph(Font font, int n, int n2) {
            float f = 0.055f * font.getSize2D();
            if (f < 1.0f) {
                f = 1.0f;
            }
            this.vPadding = (int)Math.ceil(4.0f * f);
            this.glyph = renderer.createGlyph(font, n);
            Rectangle2D.Float float_ = this.glyph.getBounds();
            this.topLine = new Rectangle2D.Float(float_.width, this.vPadding, n2 += Math.round(0.5f * font.getSize2D()), f);
            this.setWidth(Math.round((float)n2 + float_.width));
            this.setHeight(n + this.vPadding);
        }

        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        public void addTraversableLinks() {
        }

        public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
            if (graphics != null) {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                Stroke stroke = graphics2D.getStroke();
                int n2 = wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset();
                int n3 = wmiRenderPath.getVerticalOffset() + this.getVerticalOffset();
                Color color = this.drawColor;
                WmiSelection wmiSelection = wmiRenderPath.getSelection();
                WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
                Rectangle[] rectangleArray = wmiHighlightPainter != null ? wmiHighlightPainter.intersect(this.x + n2 + wmiRenderPath.getHorizontalShift(), this.y + n3 + wmiRenderPath.getVerticalShift(), this.width, this.height) : null;
                Color color2 = graphics.getColor();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n4 = 0;
                Color color3 = Color.WHITE;
                if (this.attributes != null) {
                    bl = this.attributes.hasStyle(32);
                    bl2 = this.attributes.hasStyle(4);
                    bl3 = this.attributes.hasStyle(256);
                    n4 = this.attributes.hasStyle(512);
                    if (bl) {
                        color3 = new Color(this.attributes.getBackground());
                    }
                }
                if (bl) {
                    graphics2D.setColor(color3);
                    graphics2D.fillRect(n2, n3, this.width, this.height);
                    if (rectangleArray != null) {
                        graphics.setColor(this.getDocumentView().getColor(4));
                        for (int i = 0; i < rectangleArray.length; ++i) {
                            graphics.fillRect(rectangleArray[i].x - wmiRenderPath.getHorizontalShift(), rectangleArray[i].y - wmiRenderPath.getVerticalShift(), rectangleArray[i].width, rectangleArray[i].height);
                        }
                    }
                }
                graphics.setColor(color);
                this.glyph.draw((Graphics2D)graphics, n2, n3 + this.vPadding);
                graphics.translate(n2, n3);
                ((Graphics2D)graphics).fill(this.topLine);
                graphics.translate(-n2, -n3);
                WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
                int n5 = n = bl2 || bl3 ? 1 : 0;
                if (RuntimePlatform.isMac()) {
                    n |= n4;
                }
                if (n != 0) {
                    if (bl3) {
                        graphics2D.setStroke(WmiTextView.COMPOSED_STROKE);
                        graphics.setColor(Color.GRAY);
                    } else if (n4 != 0) {
                        graphics2D.setStroke(WmiTextView.CONVERTED_STROKE);
                        graphics.setColor(Color.BLUE.brighter());
                    }
                    graphics.drawLine(n2, n3 + this.height + 1, n2 + this.width, n3 + this.height + 1);
                }
                if (rectangleArray != null && wmiMathDocumentView != null) {
                    graphics.setColor(wmiMathDocumentView.getColor(3));
                    for (n = 0; n < rectangleArray.length; ++n) {
                        Rectangle rectangle2 = graphics.getClipBounds();
                        graphics.clipRect(rectangleArray[n].x - wmiRenderPath.getHorizontalShift(), rectangleArray[n].y - wmiRenderPath.getVerticalShift(), rectangleArray[n].width, rectangleArray[n].height);
                        this.glyph.draw((Graphics2D)graphics, n2, n3 + this.vPadding);
                        graphics.translate(n2, n3);
                        ((Graphics2D)graphics).fill(this.topLine);
                        graphics.translate(-n2, -n3);
                        graphics.setClip(rectangle2);
                    }
                }
                graphics2D.setColor(color2);
                graphics2D.setStroke(stroke);
            }
        }

        public void layoutView() throws WmiNoReadAccessException {
            super.layoutView();
            try {
                WmiModel wmiModel = this.getModel();
                if (wmiModel != null) {
                    WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
                    if (wmiAttributeSet instanceof WmiFontAttributeSet) {
                        this.attributes = (WmiFontAttributeSet)wmiAttributeSet;
                        this.drawColor = new Color(this.attributes.getForeground());
                    } else {
                        this.drawColor = Color.BLACK;
                    }
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }
}

