/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.linebreaker;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathIdentifierView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiForceBreakSet;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiSpecialFunctionLineBreaker;

public abstract class WmiCentralGlyphLineBreaker
extends WmiSpecialFunctionLineBreaker {
    private static int UNDER_OVER = 0;
    private static int FUNCTION = 2;
    private static final int UNDER_INDEX = 1;
    private static final int OVER_INDEX = 2;
    private static final int INLINE_NORMAL_LENGTH = 3;

    public void linebreak(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n, boolean bl) throws WmiNoReadAccessException {
        if (this.keepOnLine(wmiLinebrokenView, wmiView, wmiForceBreakSet, n)) {
            this.addChild(wmiLinebrokenView, wmiView);
        } else if (wmiView instanceof WmiInlineView) {
            WmiInlineView wmiInlineView = (WmiInlineView)wmiView;
            WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList wmiSpecialFunctionList = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
            if (wmiInlineView.getChildCount() == 3 && wmiInlineView.getChild(UNDER_OVER) instanceof WmiUnderOverView && wmiInlineView.getChild(FUNCTION) instanceof WmiPositionedView) {
                WmiUnderOverView wmiUnderOverView = (WmiUnderOverView)wmiInlineView.getChild(UNDER_OVER);
                WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiInlineView.getChild(FUNCTION);
                wmiSpecialFunctionList = this.keepOnLine(wmiLinebrokenView, wmiUnderOverView, wmiForceBreakSet, n) ? this.buildPreserveOverUnder(wmiUnderOverView, wmiPositionedView) : this.buildFlatViewList(wmiUnderOverView, wmiPositionedView);
            }
            if (wmiSpecialFunctionList.size() > 0) {
                this.addViewsToTarget(wmiSpecialFunctionList, wmiLinebrokenView, wmiForceBreakSet, n, bl);
            } else {
                this.addChild(wmiLinebrokenView, wmiView);
            }
        }
    }

    private WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList buildPreserveOverUnder(WmiUnderOverView wmiUnderOverView, WmiPositionedView wmiPositionedView) {
        WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList wmiSpecialFunctionList = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
        wmiSpecialFunctionList.add(wmiUnderOverView, false);
        wmiSpecialFunctionList.add(wmiPositionedView, false);
        return wmiSpecialFunctionList;
    }

    private WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList buildFlatViewList(WmiUnderOverView wmiUnderOverView, WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList wmiSpecialFunctionList = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)wmiUnderOverView.getChild(1);
        WmiPositionedView wmiPositionedView3 = (WmiPositionedView)wmiUnderOverView.getChild(2);
        int n = Math.max(Math.max(wmiPositionedView2.getHeight(), wmiPositionedView3.getHeight()), wmiPositionedView.getHeight());
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiUnderOverView.getModel(), WmiModelTag.MATH);
        WmiMathContext wmiMathContext = null;
        if (wmiCompositeModel != null && wmiCompositeModel.getAttributes() instanceof WmiFontAttributeSet) {
            wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiCompositeModel.getAttributes());
        }
        WmiMathTextView wmiMathTextView = null;
        if (wmiMathContext == null) {
            wmiMathTextView = this.constructMathOperatorView(this.getOperatorText(), 0, wmiPositionedView3);
        } else {
            WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiCompositeModel.getDocument(), this.getOperatorText(), this.getOperatorText(), wmiMathContext, false);
            wmiMathTextView = new WmiMathIdentifierView(wmiIdentifierModel, wmiPositionedView2.getDocumentView());
        }
        wmiSpecialFunctionList.add(wmiMathTextView, true);
        wmiMathTextView = this.constructMathOperatorView("(", n, wmiPositionedView);
        wmiSpecialFunctionList.add(wmiMathTextView, true);
        wmiSpecialFunctionList.add(wmiPositionedView, false);
        wmiMathTextView = this.constructMathOperatorView(",", 0, wmiPositionedView3);
        wmiSpecialFunctionList.add(wmiMathTextView, true);
        wmiSpecialFunctionList.add(wmiPositionedView2, false);
        wmiMathTextView = this.constructMathOperatorView("..", 0, wmiPositionedView3);
        wmiSpecialFunctionList.add(wmiMathTextView, true);
        wmiSpecialFunctionList.add(wmiPositionedView3, false);
        wmiMathTextView = this.constructMathOperatorView(")", n, wmiPositionedView);
        wmiSpecialFunctionList.add(wmiMathTextView, true);
        return wmiSpecialFunctionList;
    }

    public static class WmiProductLineBreaker
    extends WmiCentralGlyphLineBreaker {
        private static String OPERATOR_TEXT = "Product";

        protected String getOperatorText() {
            return OPERATOR_TEXT;
        }
    }

    public static class WmiSumLineBreaker
    extends WmiCentralGlyphLineBreaker {
        private static String OPERATOR_TEXT = "Sum";

        protected String getOperatorText() {
            return OPERATOR_TEXT;
        }
    }
}

