/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public class WmiAngleBracketRenderer
extends WmiGlyphRenderer {
    public static final char LEFT_ANGLE_BRACKET_CHAR = '\u2329';
    public static final char RIGHT_ANGLE_BRACKET_CHAR = '\u232a';
    public static final char LEFT_DOUBLE_ANGLE_BRACKET_CHAR = '\u300a';
    public static final char RIGHT_DOUBLE_ANGLE_BRACKET_CHAR = '\u300b';
    private static final float[][] LEFT_ANGLE_OUTLINE = new float[][]{{0.2337796f, 0.9897013f}, {0.2028836f, 1.0f}, {0.0f, 0.49948502f}, {0.2028836f, 0.0f}, {0.2337796f, 0.010298651f}, {0.06591143f, 0.49948502f}, new float[0]};
    private static final int[] LEFT_ANGLE_MORPH_RULES = new int[]{3, 3, 22, 1, 1, 22, 0};
    private static final float[][] DOUBLE_LEFT_ANGLE_OUTLINE = new float[][]{{0.4407827f, 0.9897013f}, {0.4098867f, 1.0f}, {0.2070031f, 0.49948502f}, {0.4098867f, 0.0f}, {0.4407827f, 0.010298651f}, {0.2729145f, 0.49948502f}, new float[0], {0.2337796f, 0.9897013f}, {0.2028836f, 1.0f}, {0.0f, 0.49948502f}, {0.2028836f, 0.0f}, {0.2337796f, 0.010298651f}, {0.06591143f, 0.49948502f}, new float[0]};
    private static final int[] DOUBLE_LEFT_ANGLE_MORPH_RULES = new int[]{3, 3, 22, 1, 1, 22, 22, 3, 3, 22, 1, 1, 22, 0};
    float[][] outline;
    int[] morphRules;
    boolean rightBracket = false;

    public WmiAngleBracketRenderer(char c) {
        switch (c) {
            case '\u2329': 
            case '\u232a': {
                this.outline = LEFT_ANGLE_OUTLINE;
                this.morphRules = LEFT_ANGLE_MORPH_RULES;
                break;
            }
            case '\u300a': 
            case '\u300b': {
                this.outline = DOUBLE_LEFT_ANGLE_OUTLINE;
                this.morphRules = DOUBLE_LEFT_ANGLE_MORPH_RULES;
                break;
            }
        }
        switch (c) {
            case '\u232a': 
            case '\u300b': {
                this.rightBracket = true;
                break;
            }
        }
    }

    protected float[][] getGlyphOutline() {
        return this.outline;
    }

    protected int[] getStretchRules() {
        return this.morphRules;
    }

    protected boolean isBracket() {
        return true;
    }

    protected void morphGlyph(float[][] fArray, Font font, int n) {
        float f = font.getSize2D();
        this.stretchScale(fArray, f, n, this.getStretchRules());
        if (this.rightBracket) {
            this.horizontalReflection(fArray);
        }
    }

    public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return !this.rightBracket;
    }

    public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return this.rightBracket;
    }
}

