/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WmiGlyphBuilder
extends JDialog {
    private static final String[] QUAD_TYPE_TABLE = new String[]{"MOVE_UP", "MOVE_FIXED_UP", "MOVE_DOWN_UP", "ERROR", "MOVE_UP_FIXED", "FIXED_POS", "MOVE_DOWN_FIXED", "ERROR", "MOVE_UP_DOWN", "MOVE_FIXED_DOWN", "MOVE_DOWN"};
    private static final String[] HORIZ_QUAD_TYPE_TABLE = new String[]{"MOVE_LEFT", "MOVE_FIXED_LEFT", "MOVE_RIGHT_LEFT", "ERROR", "MOVE_LEFT_FIXED", "FIXED_POS", "MOVE_RIGHT_FIXED", "ERROR", "MOVE_LEFT_RIGHT", "MOVE_FIXED_RIGHT", "MOVE_RIGHT"};
    JTextField fontField;
    JTextField glyphField;
    JTextField stretchUpField;
    JTextField stretchDownField;
    JTextField stretchLeftField;
    JTextField stretchRightField;
    GlyphRenderPane renderer;
    JButton loadButton;
    JButton updateButton;
    JButton codeButton;
    Rectangle2D.Float bounds;
    ArrayList glyphOutline = new ArrayList();

    public WmiGlyphBuilder() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel3.setLayout(new FlowLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        jPanel2.add(new JLabel("font"));
        this.fontField = new JTextField(30);
        this.fontField.setText("ESSTIXSix");
        jPanel2.add(this.fontField);
        jPanel2.add(new JLabel("Character"));
        this.glyphField = new JTextField(5);
        this.glyphField.setText("E");
        jPanel2.add(this.glyphField);
        this.loadButton = new JButton("Load");
        jPanel2.add(this.loadButton);
        jPanel3.add(new JLabel("Stretch up "));
        this.stretchUpField = new JTextField(6);
        this.stretchUpField.setText("0");
        jPanel3.add(this.stretchUpField);
        jPanel3.add(new JLabel("Stretch down "));
        this.stretchDownField = new JTextField(6);
        this.stretchDownField.setText("1");
        jPanel3.add(this.stretchDownField);
        jPanel3.add(new JLabel("Stretch left "));
        this.stretchLeftField = new JTextField(6);
        this.stretchLeftField.setText("0");
        jPanel3.add(this.stretchLeftField);
        jPanel3.add(new JLabel("Stretch right "));
        this.stretchRightField = new JTextField(6);
        this.stretchRightField.setText("1");
        jPanel3.add(this.stretchRightField);
        this.updateButton = new JButton("Update");
        jPanel3.add(this.updateButton);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiGlyphBuilder.this.loadGlyph(WmiGlyphBuilder.this.fontField.getText(), WmiGlyphBuilder.this.glyphField.getText());
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiGlyphBuilder.this.repaint();
            }
        });
        this.codeButton = new JButton("Generate Code");
        this.codeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiGlyphBuilder.this.generateCode();
            }
        });
        jPanel3.add(this.codeButton);
        container.add((Component)jPanel, "North");
        this.renderer = new GlyphRenderPane();
        container.add((Component)this.renderer, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        this.show();
    }

    public void loadGlyph(String string, String string2) {
        Font font = new Font(string, 0, 1);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string2);
        Shape shape = glyphVector.getGlyphOutline(0);
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        float[] fArray = new float[6];
        this.glyphOutline.clear();
        while (!pathIterator.isDone()) {
            float[] fArray2;
            Arrays.fill(fArray, 0.0f);
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: 
                case 1: {
                    fArray2 = new float[2];
                    System.arraycopy(fArray, 0, fArray2, 0, 2);
                    break;
                }
                case 2: {
                    fArray2 = new float[4];
                    System.arraycopy(fArray, 0, fArray2, 0, 4);
                    break;
                }
                case 3: {
                    fArray2 = new float[6];
                    System.arraycopy(fArray, 0, fArray2, 0, 6);
                    break;
                }
                default: {
                    fArray2 = new float[]{};
                }
            }
            this.glyphOutline.add(fArray2);
            pathIterator.next();
        }
        this.updateBounds();
    }

    public void updateBounds() {
        boolean bl = false;
        int n = this.glyphOutline.size();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < n; ++i) {
            float[] fArray = (float[])this.glyphOutline.get(i);
            int n2 = fArray.length;
            for (int j = 0; j < n2; j += 2) {
                float f5 = fArray[j];
                float f6 = fArray[j + 1];
                if (bl) {
                    if (f5 < f) {
                        f = f5;
                    } else if (f5 > f2) {
                        f2 = f5;
                    }
                    if (f6 < f3) {
                        f3 = f6;
                        continue;
                    }
                    if (!(f6 > f4)) continue;
                    f4 = f6;
                    continue;
                }
                f = f2 = f5;
                f3 = f4 = f6;
                bl = true;
            }
        }
        this.bounds = new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        System.out.println("xmin = " + f);
        System.out.println("xmax = " + f2);
        System.out.println("ymin = " + f3);
        System.out.println("ymax = " + f4);
        this.repaint();
    }

    public void generateCode() {
        if (this.bounds != null && this.glyphOutline.size() > 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("private static final float[][] OUTLINE = {\n");
            float f = this.bounds.height > this.bounds.width ? 1.0f / this.bounds.height : 1.0f / this.bounds.width;
            float f2 = this.bounds.x;
            float f3 = this.bounds.y;
            float f4 = Float.parseFloat(this.stretchUpField.getText());
            float f5 = Float.parseFloat(this.stretchDownField.getText());
            float f6 = Float.parseFloat(this.stretchLeftField.getText());
            float f7 = Float.parseFloat(this.stretchRightField.getText());
            int n2 = this.glyphOutline.size();
            String[] stringArray = new String[n2];
            block5: for (n = 0; n < n2; ++n) {
                float[] fArray = (float[])this.glyphOutline.get(n);
                int n3 = fArray.length;
                int n4 = 0;
                switch (n3) {
                    case 2: {
                        float f8 = f * (fArray[0] - f2);
                        float f9 = f * (fArray[1] - f3);
                        stringBuffer.append("    {");
                        stringBuffer.append(f8);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f9);
                        if (n < n2 - 1) {
                            stringBuffer.append("f}, //");
                        } else {
                            stringBuffer.append("f} //");
                        }
                        stringBuffer.append(n);
                        stringBuffer.append("\n");
                        if (f4 > 0.0f) {
                            if (f9 < f4) {
                                stringArray[n] = "MOVE_UP";
                                continue block5;
                            }
                            if (f9 > f5) {
                                stringArray[n] = "MOVE_DOWN";
                                continue block5;
                            }
                            stringArray[n] = "FIXED_POS";
                            continue block5;
                        }
                        if (f8 < f6) {
                            stringArray[n] = "MOVE_LEFT";
                            continue block5;
                        }
                        if (f8 > f7) {
                            stringArray[n] = "MOVE_RIGHT";
                            continue block5;
                        }
                        stringArray[n] = "FIXED_POS";
                        continue block5;
                    }
                    case 4: {
                        float f8 = f * (fArray[0] - f2);
                        float f9 = f * (fArray[1] - f3);
                        float f10 = f * (fArray[2] - f2);
                        float f11 = f * (fArray[3] - f3);
                        stringBuffer.append("    {");
                        stringBuffer.append(f8);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f9);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f10);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f11);
                        if (n < n2 - 1) {
                            stringBuffer.append("f}, //");
                        } else {
                            stringBuffer.append("f} //");
                        }
                        stringBuffer.append(n);
                        stringBuffer.append("\n");
                        if (f4 > 0.0f) {
                            if (f9 > f5) {
                                n4 += 2;
                            } else if (f9 > f4) {
                                ++n4;
                            }
                            if (f11 > f5) {
                                n4 += 8;
                            } else if (f11 > f4) {
                                n4 += 4;
                            }
                            stringArray[n] = QUAD_TYPE_TABLE[n4];
                            continue block5;
                        }
                        if (f8 > f7) {
                            n4 += 2;
                        } else if (f8 > f6) {
                            ++n4;
                        }
                        if (f10 > f7) {
                            n4 += 8;
                        } else if (f10 > f6) {
                            n4 += 4;
                        }
                        stringArray[n] = HORIZ_QUAD_TYPE_TABLE[n4];
                        continue block5;
                    }
                    case 6: {
                        stringBuffer.append("    {");
                        float f8 = f * (fArray[0] - f2);
                        float f9 = f * (fArray[1] - f3);
                        float f10 = f * (fArray[2] - f2);
                        float f11 = f * (fArray[3] - f3);
                        float f12 = f * (fArray[4] - f2);
                        float f13 = f * (fArray[5] - f3);
                        stringBuffer.append(f8);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f9);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f10);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f11);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f12);
                        stringBuffer.append("f, ");
                        stringBuffer.append(f13);
                        if (n < n2 - 1) {
                            stringBuffer.append("f}, //");
                        } else {
                            stringBuffer.append("f} //");
                        }
                        this.pack();
                        this.show();
                        stringBuffer.append(n);
                        stringBuffer.append("\n");
                        stringArray[n] = "ERROR";
                        continue block5;
                    }
                    default: {
                        if (n < n2 - 1) {
                            stringBuffer.append("    {}, //");
                        } else {
                            stringBuffer.append("    {} //");
                        }
                        stringBuffer.append(n);
                        stringBuffer.append("\n");
                        stringArray[n] = "FIXED_POS";
                    }
                }
            }
            stringBuffer.append("};\n\nprivate static final int[] MORPH_RULES = {\n");
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].length() <= 0) continue;
                stringBuffer.append("    ");
                stringBuffer.append(stringArray[n]);
                if (n < n2 - 1) {
                    stringBuffer.append(", // ");
                } else {
                    stringBuffer.append(" //");
                }
                stringBuffer.append(n);
                stringBuffer.append("\n");
            }
            stringBuffer.append("};\n");
            new CodeDialog(stringBuffer.toString());
        }
    }

    public static void main(String[] stringArray) {
        new WmiGlyphBuilder();
    }

    public class GlyphRenderPane
    extends JPanel {
        private static final int WINDOW_SIZE = 500;
        private static final int DRAW_SIZE = 450;

        public GlyphRenderPane() {
            this.setBackground(Color.WHITE);
            Dimension dimension = new Dimension(500, 500);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics.getColor();
            if (WmiGlyphBuilder.this.bounds != null && WmiGlyphBuilder.this.glyphOutline.size() > 0) {
                float f = WmiGlyphBuilder.this.bounds.height > WmiGlyphBuilder.this.bounds.width ? WmiGlyphBuilder.this.bounds.height : WmiGlyphBuilder.this.bounds.width;
                float f2 = 450.0f / f;
                float f3 = 0.5f * (500.0f - f2 * WmiGlyphBuilder.this.bounds.width);
                float f4 = 0.5f * (500.0f - f2 * WmiGlyphBuilder.this.bounds.height);
                float f5 = WmiGlyphBuilder.this.bounds.x;
                float f6 = WmiGlyphBuilder.this.bounds.y;
                graphics.setColor(Color.GREEN);
                float f7 = Float.parseFloat(WmiGlyphBuilder.this.stretchUpField.getText());
                float f8 = Float.parseFloat(WmiGlyphBuilder.this.stretchDownField.getText());
                float f9 = Float.parseFloat(WmiGlyphBuilder.this.stretchLeftField.getText());
                float f10 = Float.parseFloat(WmiGlyphBuilder.this.stretchRightField.getText());
                float f11 = f2 * f * f7 + f4;
                float f12 = f2 * f * f8 + f4;
                float f13 = f2 * f * f9 + f3;
                float f14 = f2 * f * f10 + f3;
                graphics2D.draw(new Line2D.Float(0.0f, f11, 500.0f, f11));
                graphics2D.draw(new Line2D.Float(0.0f, f12, 500.0f, f12));
                graphics2D.draw(new Line2D.Float(f13, 0.0f, f13, 500.0f));
                graphics2D.draw(new Line2D.Float(f14, 0.0f, f14, 500.0f));
                graphics.setColor(Color.BLUE);
                GeneralPath generalPath = new GeneralPath();
                GeneralPath generalPath2 = new GeneralPath();
                boolean bl = true;
                int n = WmiGlyphBuilder.this.glyphOutline.size();
                block5: for (int i = 0; i < n; ++i) {
                    float[] fArray = (float[])WmiGlyphBuilder.this.glyphOutline.get(i);
                    int n2 = fArray.length;
                    switch (n2) {
                        case 2: {
                            float f15;
                            float f16;
                            if (bl) {
                                f16 = f3 + f2 * (fArray[0] - f5);
                                f15 = f4 + f2 * (fArray[1] - f6);
                                generalPath.moveTo(f16, f15);
                                generalPath2.moveTo(f16, f15);
                                this.drawRect(graphics2D, f16, f15, true, i);
                                bl = false;
                                continue block5;
                            }
                            f16 = f3 + f2 * (fArray[0] - f5);
                            f15 = f4 + f2 * (fArray[1] - f6);
                            generalPath.lineTo(f16, f15);
                            generalPath2.lineTo(f16, f15);
                            this.drawRect(graphics2D, f16, f15, true, i);
                            continue block5;
                        }
                        case 4: {
                            float f16 = f3 + f2 * (fArray[0] - f5);
                            float f15 = f4 + f2 * (fArray[1] - f6);
                            float f17 = f3 + f2 * (fArray[2] - f5);
                            float f18 = f4 + f2 * (fArray[3] - f6);
                            generalPath.quadTo(f16, f15, f17, f18);
                            generalPath2.lineTo(f16, f15);
                            generalPath2.lineTo(f17, f18);
                            this.drawRect(graphics2D, f16, f15, false, i);
                            this.drawRect(graphics2D, f17, f18, true, i);
                            continue block5;
                        }
                        case 6: {
                            float f16 = f3 + f2 * (fArray[0] - f5);
                            float f15 = f4 + f2 * (fArray[1] - f6);
                            float f17 = f3 + f2 * (fArray[2] - f5);
                            float f18 = f4 + f2 * (fArray[3] - f6);
                            float f19 = f3 + f2 * (fArray[4] - f5);
                            float f20 = f4 + f2 * (fArray[5] - f6);
                            generalPath.curveTo(f16, f15, f17, f18, f19, f20);
                            generalPath2.lineTo(f16, f15);
                            generalPath2.lineTo(f17, f18);
                            generalPath2.lineTo(f19, f20);
                            this.drawRect(graphics2D, f16, f15, false, i);
                            this.drawRect(graphics2D, f17, f18, false, i);
                            this.drawRect(graphics2D, f19, f20, true, i);
                            continue block5;
                        }
                        default: {
                            generalPath.closePath();
                            generalPath2.closePath();
                            bl = true;
                        }
                    }
                }
                ((Graphics2D)graphics).draw(generalPath2);
                graphics.setColor(Color.BLACK);
                ((Graphics2D)graphics).draw(generalPath);
                graphics.setColor(color);
            }
        }

        private void drawRect(Graphics2D graphics2D, float f, float f2, boolean bl, int n) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(f - 2.0f, f2 - 2.0f, 4.0f, 4.0f);
            if (bl) {
                graphics2D.fill(float_);
            } else {
                graphics2D.draw(float_);
            }
            graphics2D.drawString(Integer.toString(n), f + 4.0f, f2 + 4.0f);
        }
    }

    public class CodeDialog
    extends JDialog {
        public CodeDialog(String string) {
            Container container = this.getContentPane();
            JScrollPane jScrollPane = new JScrollPane();
            container.add(jScrollPane);
            JTextArea jTextArea = new JTextArea(100, 80);
            jTextArea.setText(string);
            jScrollPane.getViewport().add(jTextArea);
            this.pack();
            this.show();
        }
    }
}

