/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyRenderer;
import java.awt.Font;

public class WmiHorizontalStretchyArrowRenderer
extends WmiHorizontalStretchyRenderer {
    public static final char LEFT_ARROW_CHAR = '\u2190';
    public static final char RIGHT_ARROW_CHAR = '\u2192';
    public static final char LEFT_RIGHT_ARROW_CHAR = '\u2194';
    public static final char RIGHT_HARPOON_UP_CHAR = '\u21c0';
    public static final char RIGHT_HARPOON_DOWN_CHAR = '\u21c1';
    public static final char LEFT_HARPOON_UP_CHAR = '\u21bc';
    public static final char LEFT_HARPOON_DOWN_CHAR = '\u21bd';
    public static final char HORIZONTAL_BAR_CHAR = '\u0305';
    public static final char EQUILIBRIUM_CHAR = '\u21cc';
    public static final char REVERSE_EQUILIBRIUM_CHAR = '\u21cb';
    public static final char DOUBLE_RIGHT_ARROW_CHAR = '\u21d2';
    public static final char DOUBLE_LEFT_ARROW_CHAR = '\u21d0';
    public static final char TRIPLE_RIGHT_ARROW_CHAR = '\u21db';
    public static final char TRIPLE_LEFT_ARROW_CHAR = '\u21da';
    public static final char RIGHT_NOT_ARROW_CHAR = '\u219b';
    public static final char LEFT_NOT_ARROW_CHAR = '\u219a';
    public static final char LEFT_LEFT_ARROW_CHAR = '\u21c7';
    public static final char RIGHT_RIGHT_ARROW_CHAR = '\u21c9';
    public static final char LEFT_ARROW_RIGHT_ARROW_CHAR = '\u21c6';
    public static final char RIGHT_ARROW_LEFT_ARROW_CHAR = '\u21c4';
    public static final char DOUBLE_LEFT_RIGHT_ARROW_CHAR = '\u21d4';
    public static final char NOT_LEFT_ARROW_CHAR = '\u21cd';
    public static final char NOT_RIGHT_ARROW_CHAR = '\u21cf';
    public static final char NOT_LEFT_RIGHT_ARROW_CHAR = '\u21ce';
    public static final char RIGHT_TEE_ARROW_CHAR = '\u21a6';
    public static final char MAP_CHAR = '\u2905';
    public static final char LARR_CHAR = '\u219e';
    public static final char RARR_CHAR = '\u21a0';
    public static final char LARRTL_CHAR = '\u21a2';
    public static final char RARRTL_CHAR = '\u21a3';
    public static final char ZIGRARR_CHAR = '\u21dd';
    public static final char HARRW_CHAR = '\u21ad';
    private static final float DESCENT_SCALE_ADJUST = 0.8f;
    private static final int MINIMUM_ARROW_WIDTH = 35;
    private static final int FONT_SCALE_FACTOR = 24;
    private static final int MINIMUM_WIDTH = 20;
    private static final float[][] RIGHT_ARROW_OUTLINE = new float[][]{{1.0f, 0.21744189f}, {0.9465117f, 0.23953493f, 0.8744186f, 0.3f}, {0.811628f, 0.35348842f, 0.76744187f, 0.4069768f}, {0.7267442f, 0.4069768f}, {0.7732559f, 0.30697677f, 0.8337209f, 0.23372096f}, {0.0f, 0.23372096f}, {0.0f, 0.17325585f}, {0.8337209f, 0.17325585f}, {0.7732559f, 0.10000001f, 0.7267442f, 0.0f}, {0.76744187f, 0.0f}, {0.811628f, 0.053488377f, 0.8744186f, 0.106976755f}, {0.9465117f, 0.16744187f, 1.0f, 0.18953492f}, new float[0]};
    private static final int[] RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9};
    private static final float[][] RIGHT_VECTOR_OUTLINE = new float[][]{{1.0f, 0.23139535f}, {0.0f, 0.23139535f}, {0.0f, 0.17093025f}, {0.8313953f, 0.17093025f}, {0.7627907f, 0.091860466f, 0.7232558f, 0.0f}, {0.7651163f, 0.0f}, {0.8906977f, 0.1383721f, 1.0f, 0.18837209f}, new float[0]};
    private static final int[] RIGHT_VECTOR_MORPH_RULES = new int[]{9, 8, 8, 9, 9, 9, 9, 9};
    private static final float[][] DOUBLE_ENDED_ARROW_OUTLINE = new float[][]{{1.0f, 0.21744189f}, {0.9465117f, 0.23953493f, 0.8744186f, 0.3f}, {0.811628f, 0.3523256f, 0.76744187f, 0.4069768f}, {0.7267442f, 0.4069768f}, {0.7732559f, 0.30697677f, 0.8337209f, 0.23372096f}, {0.16627908f, 0.23372096f}, {0.2267442f, 0.30697677f, 0.27325583f, 0.4069768f}, {0.23255815f, 0.4069768f}, {0.18837209f, 0.3523256f, 0.1255814f, 0.3f}, {0.053488377f, 0.23953493f, 0.0f, 0.21744189f}, {0.0f, 0.18953492f}, {0.054651175f, 0.16744187f, 0.1255814f, 0.106976755f}, {0.18837209f, 0.054651175f, 0.23255815f, 0.0f}, {0.27325583f, 0.0f}, {0.2267442f, 0.10000001f, 0.16627908f, 0.17325585f}, {0.8337209f, 0.17325585f}, {0.7732559f, 0.10000001f, 0.7267442f, 0.0f}, {0.76744187f, 0.0f}, {0.811628f, 0.054651175f, 0.8744186f, 0.106976755f}, {0.9453489f, 0.16744187f, 1.0f, 0.18953492f}, new float[0]};
    private static final int[] DOUBLE_ENDED_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9};
    private static final float[][] CONJUGATE_OUTLINE = new float[][]{{0.99999994f, 0.058787856f}, {0.0f, 0.058787856f}, {0.0f, 0.0f}, {0.99999994f, 0.0f}, new float[0]};
    private static final int[] CONJUGATE_MORPH_RULES = new int[]{9, 8, 8, 9, 0};
    private static final float[][] EQUILIBRIUM_OUTLINE = new float[][]{{0.99999994f, 0.23181817f}, {0.0f, 0.23181817f}, {0.0f, 0.18787879f}, {0.10909091f, 0.13787879f, 0.23484848f, 0.0f}, {0.27575758f, 0.0f}, {0.23636363f, 0.090909086f, 0.1681818f, 0.17121212f}, {0.99999994f, 0.17121212f}, {0.99999994f, 0.23181817f}, new float[0], {0.99999994f, 0.52575755f}, {0.8909091f, 0.57575756f, 0.7651515f, 0.71363634f}, {0.72272724f, 0.71363634f}, {0.7621212f, 0.6227273f, 0.83181816f, 0.5424242f}, {0.0f, 0.5424242f}, {0.0f, 0.48333332f}, {0.99999994f, 0.48333332f}, {0.99999994f, 0.52575755f}, new float[0]};
    private static final float[][] DOUBLE_RIGHT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.25757575f}, {0.8242424f, 0.3121212f, 0.74545455f, 0.45454544f}, {0.6651515f, 0.45454544f}, {0.6909091f, 0.40454546f, 0.730303f, 0.3590909f}, {0.0f, 0.3590909f}, {0.0f, 0.29848483f}, {0.79393935f, 0.29848483f}, {0.8272727f, 0.2712121f, 0.8924242f, 0.22878787f}, {0.8363636f, 0.18939394f, 0.79393935f, 0.1560606f}, {0.0f, 0.1560606f}, {0.0f, 0.095454544f}, {0.730303f, 0.095454544f}, {0.6909091f, 0.05151515f, 0.6651515f, 0.0f}, {0.74545455f, 0.0f}, {0.82575756f, 0.14393939f, 0.99999994f, 0.19848484f}, {0.99999994f, 0.25757575f}, new float[0]};
    private static final int[] DOUBLE_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 8, 8, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 0};
    private static final int[] EQUILIBRIUM_MORPH_RULES = new int[]{9, 8, 8, 8, 8, 8, 9, 9, 0, 9, 9, 9, 9, 8, 8, 9, 9, 0};
    private static final float[][] TRIPLE_RIGHT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.35151514f}, {0.9166666f, 0.38636363f, 0.8045454f, 0.48030302f}, {0.71060604f, 0.55757576f, 0.6318182f, 0.6439394f}, {0.5530303f, 0.6439394f}, {0.58181816f, 0.6075757f, 0.6333333f, 0.5530303f}, {0.0f, 0.5530303f}, {0.0f, 0.49242422f}, {0.70151514f, 0.49242422f}, {0.79696965f, 0.40757576f, 0.8772727f, 0.35151514f}, {0.0f, 0.35151514f}, {0.0f, 0.29090908f}, {0.8727273f, 0.29090908f}, {0.8121212f, 0.24545453f, 0.69848484f, 0.14848484f}, {0.0f, 0.14848484f}, {0.0f, 0.087878786f}, {0.6318182f, 0.087878786f}, {0.58181816f, 0.034848485f, 0.5530303f, 0.0f}, {0.6318182f, 0.0f}, {0.7090909f, 0.08484848f, 0.8045454f, 0.1621212f}, {0.9166666f, 0.2560606f, 0.99999994f, 0.29090908f}, {0.99999994f, 0.35151514f}, new float[0]};
    private static final int[] TRIPLE_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 9, 9, 8, 8, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] RIGHT_NOT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.27575758f}, {0.9469697f, 0.29696968f, 0.8742424f, 0.35757574f}, {0.8121212f, 0.41060606f, 0.76666665f, 0.4651515f}, {0.7272727f, 0.4651515f}, {0.77272725f, 0.3651515f, 0.8333333f, 0.29242423f}, {0.4181818f, 0.29242423f}, {0.31060606f, 0.52272725f}, {0.24545453f, 0.52272725f}, {0.35151514f, 0.29242423f}, {0.0f, 0.29242423f}, {0.0f, 0.23181817f}, {0.38030303f, 0.23181817f}, {0.48787877f, 0.0f}, {0.55454546f, 0.0f}, {0.4469697f, 0.23181817f}, {0.8333333f, 0.23181817f}, {0.77272725f, 0.15757576f, 0.7272727f, 0.057575755f}, {0.76666665f, 0.057575755f}, {0.8121212f, 0.11212121f, 0.8742424f, 0.1651515f}, {0.94545454f, 0.22575757f, 0.99999994f, 0.24696968f}, {0.99999994f, 0.27575758f}, new float[0]};
    private static final int[] RIGHT_NOT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] RIGHT_RIGHT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.9469697f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.81060606f, 0.35454544f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.0f, 0.23484848f}, {0.0f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.0530303f, 0.8742424f, 0.10757575f}, {0.9469697f, 0.16969696f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0], {0.99999994f, 0.7090909f}, {0.9469697f, 0.730303f, 0.8742424f, 0.79090905f}, {0.81060606f, 0.8454545f, 0.76666665f, 0.8984848f}, {0.7272727f, 0.8984848f}, {0.77272725f, 0.7984848f, 0.8333333f, 0.72575754f}, {0.0f, 0.72575754f}, {0.0f, 0.6651515f}, {0.8333333f, 0.6651515f}, {0.77272725f, 0.59090906f, 0.7272727f, 0.49090907f}, {0.76666665f, 0.49090907f}, {0.8121212f, 0.5454545f, 0.8742424f, 0.5984848f}, {0.9469697f, 0.660606f, 0.99999994f, 0.68030304f}, {0.99999994f, 0.7090909f}, new float[0]};
    private static final int[] RIGHT_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 0, 9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] LEFT_ARROW_RIGHT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.23333332f}, {0.1651515f, 0.23333332f}, {0.22575757f, 0.30757576f, 0.27272725f, 0.40757576f}, {0.23181817f, 0.40757576f}, {0.18787879f, 0.3530303f, 0.12575758f, 0.29999998f}, {0.0530303f, 0.23787878f, 0.0f, 0.21818182f}, {0.0f, 0.18939394f}, {0.05151515f, 0.1681818f, 0.12575758f, 0.10757575f}, {0.18939394f, 0.0530303f, 0.23181817f, 0.0f}, {0.27272725f, 0.0f}, {0.22575757f, 0.099999994f, 0.1651515f, 0.17272727f}, {0.99999994f, 0.17272727f}, {0.99999994f, 0.23333332f}, new float[0], {0.99999994f, 0.56666666f}, {0.9469697f, 0.58787876f, 0.8742424f, 0.65f}, {0.8121212f, 0.7030303f, 0.76666665f, 0.7560606f}, {0.7272727f, 0.7560606f}, {0.77272725f, 0.6560606f, 0.8333333f, 0.5833333f}, {0.0f, 0.5833333f}, {0.0f, 0.52272725f}, {0.8333333f, 0.52272725f}, {0.77272725f, 0.44848484f, 0.7272727f, 0.34848484f}, {0.76666665f, 0.34848484f}, {0.81060606f, 0.40303028f, 0.8742424f, 0.4560606f}, {0.9469697f, 0.5181818f, 0.99999994f, 0.5393939f}, {0.99999994f, 0.56666666f}, new float[0]};
    private static final int[] LEFT_ARROW_RIGHT_ARROW_MORPH_RULES = new int[]{9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 0, 9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] DOUBLE_LEFT_RIGHT_ARROW_OUTLINE = new float[][]{{1.0f, 0.2556391f}, {0.8255639f, 0.30977443f, 0.7458647f, 0.45112783f}, {0.6661654f, 0.45112783f}, {0.6932331f, 0.40150377f, 0.7308271f, 0.35639098f}, {0.26766917f, 0.35639098f}, {0.30676693f, 0.40150377f, 0.33233082f, 0.45112783f}, {0.25263157f, 0.45112783f}, {0.17293233f, 0.30977443f, 0.0f, 0.2556391f}, {0.0f, 0.19699249f}, {0.17293233f, 0.14285715f, 0.25263157f, 0.0f}, {0.33233082f, 0.0f}, {0.30676693f, 0.05263158f, 0.26766917f, 0.094736844f}, {0.7308271f, 0.094736844f}, {0.6932331f, 0.05263158f, 0.6661654f, 0.0f}, {0.7458647f, 0.0f}, {0.8255639f, 0.14285715f, 1.0f, 0.19699249f}, {1.0f, 0.2556391f}, new float[0], {0.8932331f, 0.22706766f}, {0.8345865f, 0.18646617f, 0.7954887f, 0.15488721f}, {0.20451128f, 0.15488721f}, {0.16541353f, 0.18646617f, 0.10676692f, 0.22706766f}, {0.16541353f, 0.2661654f, 0.20451128f, 0.2962406f}, {0.7954887f, 0.2962406f}, {0.8345865f, 0.2661654f, 0.8932331f, 0.22706766f}, new float[0]};
    private static final int[] DOUBLE_LEFT_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 0, 9, 9, 8, 8, 8, 9, 9, 0};
    private static final float[][] NOT_RIGHT_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.330303f}, {0.8242424f, 0.38484848f, 0.74545455f, 0.5272727f}, {0.6651515f, 0.5272727f}, {0.6909091f, 0.47727272f, 0.730303f, 0.43181816f}, {0.3712121f, 0.43181816f}, {0.29999998f, 0.6015151f}, {0.23484848f, 0.6015151f}, {0.30606058f, 0.43181816f}, {0.0f, 0.43181816f}, {0.0f, 0.3712121f}, {0.330303f, 0.3712121f}, {0.39090908f, 0.22878787f}, {0.0f, 0.22878787f}, {0.0f, 0.1681818f}, {0.41666666f, 0.1681818f}, {0.48787877f, 0.0f}, {0.55454546f, 0.0f}, {0.48333332f, 0.1681818f}, {0.730303f, 0.1681818f}, {0.6909091f, 0.12424242f, 0.6651515f, 0.07272727f}, {0.74545455f, 0.07272727f}, {0.82575756f, 0.21666665f, 0.99999994f, 0.2712121f}, {0.99999994f, 0.330303f}, new float[0], {0.8924242f, 0.30151513f}, {0.8363636f, 0.2621212f, 0.79393935f, 0.22878787f}, {0.45757574f, 0.22878787f}, {0.39696968f, 0.3712121f}, {0.79393935f, 0.3712121f}, {0.82878786f, 0.3439394f, 0.8924242f, 0.30151513f}, new float[0]};
    private static final int[] NOT_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 0, 0, 0, 0, 9, 9, 9, 9, 9, 0, 9, 9, 0, 0, 9, 9, 0};
    private static final float[][] NOT_LEFT_RIGHT_ARROW_OUTLINE = new float[][]{{1.0f, 0.32781956f}, {0.8255639f, 0.38195488f, 0.7458647f, 0.5233083f}, {0.6661654f, 0.5233083f}, {0.6917293f, 0.47368422f, 0.7308271f, 0.42857143f}, {0.5007519f, 0.42857143f}, {0.45864663f, 0.5969925f}, {0.3924812f, 0.5969925f}, {0.43458647f, 0.42857143f}, {0.26766917f, 0.42857143f}, {0.3082707f, 0.47368422f, 0.33233082f, 0.5233083f}, {0.25263157f, 0.5233083f}, {0.17443609f, 0.38195488f, 0.0f, 0.32781956f}, {0.0f, 0.26917294f}, {0.17293233f, 0.2150376f, 0.25263157f, 0.07218045f}, {0.33233082f, 0.07218045f}, {0.3082707f, 0.12330827f, 0.26766917f, 0.1669173f}, {0.49924812f, 0.1669173f}, {0.5413534f, 0.0f}, {0.606015f, 0.0f}, {0.56541353f, 0.1669173f}, {0.7308271f, 0.1669173f}, {0.6917293f, 0.12330827f, 0.6661654f, 0.07218045f}, {0.7458647f, 0.07218045f}, {0.8255639f, 0.2150376f, 1.0f, 0.26917294f}, {1.0f, 0.32781956f}, new float[0], {0.8932331f, 0.29924813f}, {0.8360902f, 0.26015037f, 0.7954887f, 0.22706766f}, {0.55037594f, 0.22706766f}, {0.51578945f, 0.36842105f}, {0.7954887f, 0.36842105f}, {0.8300752f, 0.3413534f, 0.8932331f, 0.29924813f}, new float[0], {0.48421052f, 0.22706766f}, {0.20451128f, 0.22706766f}, {0.16390978f, 0.26015037f, 0.10676692f, 0.29924813f}, {0.16992481f, 0.3413534f, 0.20451128f, 0.36842105f}, {0.44962406f, 0.36842105f}, {0.48421052f, 0.22706766f}, new float[0]};
    private static final int[] NOT_LEFT_RIGHT_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 9, 9, 9, 9, 9, 0, 9, 9, 0, 0, 9, 9, 0, 0, 8, 8, 8, 0, 0, 0};
    private static final float[][] RIGHT_TEE_ARROW_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.9469697f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.05909091f, 0.23484848f}, {0.05909091f, 0.40757576f}, {0.0f, 0.40757576f}, {0.0f, 0.0f}, {0.05909091f, 0.0f}, {0.05909091f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.94545454f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] RIGHT_TEE_ARROW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] MAP_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.94545454f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.73787874f, 0.23484848f}, {0.630303f, 0.29545453f, 0.53787875f, 0.40757576f}, {0.49696967f, 0.40757576f}, {0.54393935f, 0.30757576f, 0.6045454f, 0.23484848f}, {0.05909091f, 0.23484848f}, {0.05909091f, 0.40757576f}, {0.0f, 0.40757576f}, {0.0f, 0.0f}, {0.05909091f, 0.0f}, {0.05909091f, 0.17424242f}, {0.6045454f, 0.17424242f}, {0.54393935f, 0.099999994f, 0.49696967f, 0.0f}, {0.53787875f, 0.0f}, {0.630303f, 0.11212121f, 0.73787874f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.94545454f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] MAP_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] RARR_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.9469697f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.73787874f, 0.23484848f}, {0.630303f, 0.29545453f, 0.53787875f, 0.40757576f}, {0.49696967f, 0.40757576f}, {0.54393935f, 0.30757576f, 0.6045454f, 0.23484848f}, {0.0f, 0.23484848f}, {0.0f, 0.17424242f}, {0.6045454f, 0.17424242f}, {0.54393935f, 0.099999994f, 0.49696967f, 0.0f}, {0.53787875f, 0.0f}, {0.630303f, 0.11212121f, 0.73787874f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.9469697f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] RARR_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] RARRTL_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.94545454f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.23636363f, 0.23484848f}, {0.14696969f, 0.28484848f, 0.03939394f, 0.40757576f}, {0.0f, 0.40757576f}, {0.049999997f, 0.29696968f, 0.13484848f, 0.20454545f}, {0.049999997f, 0.11060606f, 0.0f, 0.0f}, {0.03939394f, 0.0f}, {0.14696969f, 0.12424242f, 0.23636363f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.94545454f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] RARRTL_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] HARRW_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.94545454f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.6439394f, 0.23484848f}, {0.580303f, 0.17575757f}, {0.44848484f, 0.29242423f}, {0.39090908f, 0.29242423f}, {0.32575756f, 0.23484848f}, {0.1651515f, 0.23484848f}, {0.22575757f, 0.30757576f, 0.27272725f, 0.40757576f}, {0.23181817f, 0.40757576f}, {0.18636364f, 0.3530303f, 0.12575758f, 0.29999998f}, {0.054545455f, 0.23939393f, 0.0f, 0.21818182f}, {0.0f, 0.18939394f}, {0.054545455f, 0.1681818f, 0.12575758f, 0.10757575f}, {0.18636364f, 0.054545455f, 0.23181817f, 0.0f}, {0.27272725f, 0.0f}, {0.22575757f, 0.099999994f, 0.1651515f, 0.17424242f}, {0.3560606f, 0.17424242f}, {0.41969696f, 0.23181817f}, {0.55151516f, 0.11515151f}, {0.60909086f, 0.11515151f}, {0.6727272f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.94545454f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] HARRW_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 0};
    private static final float[][] ZIGRARR_OUTLINE = new float[][]{{0.99999994f, 0.21818182f}, {0.94545454f, 0.23939393f, 0.8742424f, 0.29999998f}, {0.8121212f, 0.3530303f, 0.76666665f, 0.40757576f}, {0.7272727f, 0.40757576f}, {0.77272725f, 0.30757576f, 0.8333333f, 0.23484848f}, {0.54090905f, 0.23484848f}, {0.47727272f, 0.16969696f}, {0.3560606f, 0.29242423f}, {0.29696968f, 0.29242423f}, {0.17575757f, 0.16969696f}, {0.11060605f, 0.23484848f}, {0.0f, 0.23484848f}, {0.0f, 0.17424242f}, {0.08697282f, 0.17424242f}, {0.14545454f, 0.11515151f}, {0.20454545f, 0.11515151f}, {0.32575756f, 0.23787878f}, {0.44848484f, 0.11515151f}, {0.5060606f, 0.11515151f}, {0.5651515f, 0.17424242f}, {0.8333333f, 0.17424242f}, {0.77272725f, 0.099999994f, 0.7272727f, 0.0f}, {0.76666665f, 0.0f}, {0.8121212f, 0.054545455f, 0.8742424f, 0.10757575f}, {0.94545454f, 0.1681818f, 0.99999994f, 0.18939394f}, {0.99999994f, 0.21818182f}, new float[0]};
    private static final int[] ZIGRARR_MORPH_RULES = new int[]{9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 0};
    private char stretchyChar;
    private boolean minimumWidth = false;
    private boolean horizontalReflection = false;
    private boolean verticalReflection = false;

    public WmiHorizontalStretchyArrowRenderer(char c) {
        switch (c) {
            case '\u2190': 
            case '\u2192': {
                this.outline = RIGHT_ARROW_OUTLINE;
                this.morphRules = RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21bc': 
            case '\u21bd': 
            case '\u21c0': 
            case '\u21c1': {
                this.outline = RIGHT_VECTOR_OUTLINE;
                this.morphRules = RIGHT_VECTOR_MORPH_RULES;
                break;
            }
            case '\u2194': {
                this.outline = DOUBLE_ENDED_ARROW_OUTLINE;
                this.morphRules = DOUBLE_ENDED_ARROW_MORPH_RULES;
                break;
            }
            case '\u0305': {
                this.outline = CONJUGATE_OUTLINE;
                this.morphRules = CONJUGATE_MORPH_RULES;
                break;
            }
            case '\u21cb': 
            case '\u21cc': {
                this.outline = EQUILIBRIUM_OUTLINE;
                this.morphRules = EQUILIBRIUM_MORPH_RULES;
                break;
            }
            case '\u21d0': 
            case '\u21d2': {
                this.outline = DOUBLE_RIGHT_ARROW_OUTLINE;
                this.morphRules = DOUBLE_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21da': 
            case '\u21db': {
                this.outline = TRIPLE_RIGHT_ARROW_OUTLINE;
                this.morphRules = TRIPLE_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u219a': 
            case '\u219b': {
                this.outline = RIGHT_NOT_ARROW_OUTLINE;
                this.morphRules = RIGHT_NOT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21c7': 
            case '\u21c9': {
                this.outline = RIGHT_RIGHT_ARROW_OUTLINE;
                this.morphRules = RIGHT_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21c4': 
            case '\u21c6': {
                this.outline = LEFT_ARROW_RIGHT_ARROW_OUTLINE;
                this.morphRules = LEFT_ARROW_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21d4': {
                this.outline = DOUBLE_LEFT_RIGHT_ARROW_OUTLINE;
                this.morphRules = DOUBLE_LEFT_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21cd': 
            case '\u21cf': {
                this.outline = NOT_RIGHT_ARROW_OUTLINE;
                this.morphRules = NOT_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21a2': 
            case '\u21a3': {
                this.outline = RARRTL_OUTLINE;
                this.morphRules = RARRTL_MORPH_RULES;
                break;
            }
            case '\u21ce': {
                this.outline = NOT_LEFT_RIGHT_ARROW_OUTLINE;
                this.morphRules = NOT_LEFT_RIGHT_ARROW_MORPH_RULES;
                break;
            }
            case '\u21a6': {
                this.outline = RIGHT_TEE_ARROW_OUTLINE;
                this.morphRules = RIGHT_TEE_ARROW_MORPH_RULES;
                break;
            }
            case '\u2905': {
                this.outline = MAP_OUTLINE;
                this.morphRules = MAP_MORPH_RULES;
                break;
            }
            case '\u219e': 
            case '\u21a0': {
                this.outline = RARR_OUTLINE;
                this.morphRules = RARR_MORPH_RULES;
                break;
            }
            case '\u21ad': {
                this.outline = HARRW_OUTLINE;
                this.morphRules = HARRW_MORPH_RULES;
                break;
            }
            case '\u21dd': {
                this.outline = ZIGRARR_OUTLINE;
                this.morphRules = ZIGRARR_MORPH_RULES;
                break;
            }
        }
        switch (c) {
            case '\u2190': 
            case '\u219a': 
            case '\u219e': 
            case '\u21a2': 
            case '\u21bc': 
            case '\u21c4': 
            case '\u21c7': 
            case '\u21cb': 
            case '\u21cd': 
            case '\u21d0': 
            case '\u21da': {
                this.horizontalReflection = true;
                break;
            }
            case '\u21bd': {
                this.horizontalReflection = true;
                this.verticalReflection = true;
                break;
            }
            case '\u21c1': {
                this.verticalReflection = true;
                break;
            }
        }
    }

    protected void morphGlyph(float[][] fArray, Font font, int n) {
        super.morphGlyph(fArray, font, n);
        if (this.horizontalReflection) {
            this.horizontalReflection(fArray);
        }
        if (this.verticalReflection) {
            this.verticalReflection(fArray);
        }
    }

    private int calculateBaseWidth(WmiMathOperatorView wmiMathOperatorView, WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiCompositeView wmiCompositeView = wmiMathOperatorView.getParentView();
        int n = 0;
        if (wmiCompositeView instanceof WmiMathInlineView) {
            for (int i = 0; i < wmiCompositeView.getChildCount(); ++i) {
                if (wmiCompositeView.getChild(i) == wmiMathOperatorView) continue;
                n += ((WmiPositionedView)wmiCompositeView.getChild(i)).getWidth();
            }
        }
        return Math.max(35 * wmiMathOperatorView.getFont().getSize() / 24, wmiPositionedView.getWidth() - n - wmiMathOperatorView.getLeftPadding() - wmiMathOperatorView.getRightPadding());
    }

    public void minimizeStretchyOperator(WmiMathOperatorView wmiMathOperatorView) {
        wmiMathOperatorView.setWidth(20);
    }

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        return super.applyRenderer(wmiMathOperatorView) && this.outline != null;
    }
}

